/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionWithSmartcastBuilder;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007H\u0002\u001a$\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"removeSmartCastTypeForAttemptToFitVisibility", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "dispatchReceiverValue", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getBackingFieldIfApplicable", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isVisible", "", "Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "declaration", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "resolve"})
public final class VisibilityUtilsKt {
    public static final boolean isVisible(@NotNull FirVisibilityChecker $this$isVisible, @NotNull FirMemberDeclaration declaration, @NotNull CallInfo callInfo, @Nullable ReceiverValue dispatchReceiverValue2) {
        Intrinsics.checkNotNullParameter((Object)$this$isVisible, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
        if (declaration instanceof FirCallableDeclaration && (ClassMembersKt.isIntersectionOverride((FirCallableDeclaration)declaration) || ClassMembersKt.isSubstitutionOverride((FirCallableDeclaration)declaration))) {
            FirCallableDeclaration $this$originalIfFakeOverride$iv = (FirCallableDeclaration)declaration;
            boolean $i$f$originalIfFakeOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = $this$originalIfFakeOverride$iv;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            if (firCallableDeclaration == null) {
                FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv = $this$originalIfFakeOverride$iv;
                boolean $i$f$getBaseForIntersectionOverride = false;
                firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv) : null;
            }
            Intrinsics.checkNotNull((Object)firCallableDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
            return VisibilityUtilsKt.isVisible($this$isVisible, firCallableDeclaration, callInfo, dispatchReceiverValue2);
        }
        FirFile useSiteFile = callInfo.getContainingFile();
        List<FirDeclaration> containingDeclarations2 = callInfo.getContainingDeclarations();
        FirSession session2 = callInfo.getSession();
        return FirVisibilityChecker.isVisible$default($this$isVisible, declaration, session2, useSiteFile, containingDeclarations2, dispatchReceiverValue2, callInfo.getCallSite() instanceof FirVariableAssignment, false, null, 192, null);
    }

    public static final boolean isVisible(@NotNull FirVisibilityChecker $this$isVisible, @NotNull FirMemberDeclaration declaration, @NotNull Candidate candidate2) {
        FirBackingField backingField2;
        Intrinsics.checkNotNullParameter((Object)$this$isVisible, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        CallInfo callInfo = candidate2.getCallInfo();
        if (!VisibilityUtilsKt.isVisible($this$isVisible, declaration, callInfo, candidate2.getDispatchReceiverValue())) {
            ReceiverValue receiverValue = VisibilityUtilsKt.removeSmartCastTypeForAttemptToFitVisibility(candidate2.getDispatchReceiverValue(), candidate2.getCallInfo().getSession());
            if (receiverValue == null) {
                return false;
            }
            ReceiverValue dispatchReceiverWithoutSmartCastType = receiverValue;
            if (!VisibilityUtilsKt.isVisible($this$isVisible, declaration, callInfo, dispatchReceiverWithoutSmartCastType)) {
                return false;
            }
            candidate2.setDispatchReceiverValue(dispatchReceiverWithoutSmartCastType);
        }
        if ((backingField2 = VisibilityUtilsKt.getBackingFieldIfApplicable(declaration)) != null) {
            candidate2.setHasVisibleBackingField(FirVisibilityChecker.isVisible$default($this$isVisible, backingField2, callInfo.getSession(), callInfo.getContainingFile(), callInfo.getContainingDeclarations(), candidate2.getDispatchReceiverValue(), candidate2.getCallInfo().getCallSite() instanceof FirVariableAssignment, false, null, 192, null));
        }
        return true;
    }

    private static final ReceiverValue removeSmartCastTypeForAttemptToFitVisibility(ReceiverValue dispatchReceiverValue2, FirSession session2) {
        FirQualifiedAccessExpression firQualifiedAccessExpression;
        FirExpressionWithSmartcast firExpressionWithSmartcast;
        block8: {
            block7: {
                FirExpressionWithSmartcast firExpressionWithSmartcast2;
                ReceiverValue receiverValue = dispatchReceiverValue2;
                FirExpression firExpression2 = receiverValue != null ? receiverValue.getReceiverExpression() : null;
                firExpressionWithSmartcast = firExpression2 instanceof FirExpressionWithSmartcast ? (FirExpressionWithSmartcast)firExpression2 : null;
                if (firExpressionWithSmartcast == null) break block7;
                FirExpressionWithSmartcast it = firExpressionWithSmartcast2 = firExpressionWithSmartcast;
                boolean bl = false;
                firExpressionWithSmartcast = it.isStable() ? firExpressionWithSmartcast2 : null;
                if (firExpressionWithSmartcast != null) break block8;
            }
            return null;
        }
        FirExpressionWithSmartcast expressionWithSmartcastIfStable = firExpressionWithSmartcast;
        if (ConeBuiltinTypeUtilsKt.isNullableNothing(dispatchReceiverValue2.getType())) {
            return null;
        }
        ConeKotlinType originalTypeNotNullable = TypeUtilsKt.makeConeTypeDefinitelyNotNullOrNotNull$default(FirTypeUtilsKt.getConeType(expressionWithSmartcastIfStable.getOriginalType()), TypeComponentsKt.getTypeContext(session2), false, 2, null);
        if (Intrinsics.areEqual((Object)originalTypeNotNullable, (Object)dispatchReceiverValue2.getType())) {
            return null;
        }
        ConeInferenceContext $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u242 = TypeComponentsKt.getTypeContext(session2);
        boolean bl = false;
        if ($this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u242.isNullableType(FirTypeUtilsKt.getConeType(expressionWithSmartcastIfStable.getOriginalType())) && !$this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u242.isNullableType(dispatchReceiverValue2.getType())) {
            FirExpressionWithSmartcastBuilder firExpressionWithSmartcastBuilder;
            boolean $i$f$buildExpressionWithSmartcast = false;
            FirExpressionWithSmartcastBuilder $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u242_u24lambda_u241 = firExpressionWithSmartcastBuilder = new FirExpressionWithSmartcastBuilder();
            boolean bl2 = false;
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u242_u24lambda_u241.setOriginalExpression((FirExpression)expressionWithSmartcastIfStable.getOriginalExpression());
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u242_u24lambda_u241.setSmartcastType(CopyUtilsKt.resolvedTypeFromPrototype(expressionWithSmartcastIfStable.getOriginalExpression().getTypeRef(), originalTypeNotNullable));
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u242_u24lambda_u241.setTypesFromSmartCast(CollectionsKt.listOf((Object)originalTypeNotNullable));
            $this$removeSmartCastTypeForAttemptToFitVisibility_u24lambda_u242_u24lambda_u241.setSmartcastStability(expressionWithSmartcastIfStable.getSmartcastStability());
            firQualifiedAccessExpression = firExpressionWithSmartcastBuilder.build();
        } else {
            firQualifiedAccessExpression = expressionWithSmartcastIfStable.getOriginalExpression();
        }
        FirQualifiedAccessExpression expressionForReceiver = firQualifiedAccessExpression;
        return new ExpressionReceiverValue(expressionForReceiver);
    }

    private static final FirBackingField getBackingFieldIfApplicable(FirMemberDeclaration $this$getBackingFieldIfApplicable) {
        FirVariable firVariable = $this$getBackingFieldIfApplicable instanceof FirProperty ? (FirProperty)$this$getBackingFieldIfApplicable : null;
        if (firVariable == null || (firVariable = DeclarationAttributesKt.getExplicitBackingField(firVariable)) == null) {
            return null;
        }
        FirVariable field2 = firVariable;
        FirMemberDeclaration $this$visibility$iv = field2;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        return ((Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.PrivateToThis.INSTANCE) ? true : Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Private.INSTANCE)) ? true : Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE)) ? field2 : null;
    }
}

