/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.impl.base.util.LibraryUtils;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtBinaryModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtLibraryModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleProviderBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtSdkModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtSourceModuleBuilder;
import org.jetbrains.kotlin.analyzer.common.CommonPlatformAnalyzerServices;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.resolve.konan.platform.NativePlatformAnalyzerServices;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a1\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0007\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0086\b\u001a\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0000\u00a8\u0006\u001c"}, d2={"buildKtModuleProviderByCompilerConfiguration", "Lorg/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider;", "compilerConfig", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectSourceFilePaths", "", "root", "Ljava/nio/file/Path;", "result", "", "", "getPsiFilesFromPaths", "T", "Lcom/intellij/psi/PsiFileSystemItem;", "paths", "", "getSourceFilePaths", "", "includeDirectoryRoot", "", "getAnalyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "analysis-api-standalone"})
public final class KtModuleUtilsKt {
    @NotNull
    public static final PlatformDependentAnalyzerServices getAnalyzerServices(@NotNull TargetPlatform $this$getAnalyzerServices) {
        PlatformDependentAnalyzerServices platformDependentAnalyzerServices;
        Intrinsics.checkNotNullParameter((Object)$this$getAnalyzerServices, (String)"<this>");
        if (JvmPlatformKt.isJvm($this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = JvmPlatformAnalyzerServices.INSTANCE;
        } else if (JsPlatformKt.isJs($this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = JsPlatformAnalyzerServices.INSTANCE;
        } else if (NativePlatformKt.isNative($this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = NativePlatformAnalyzerServices.INSTANCE;
        } else if (TargetPlatformKt.isCommon($this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = CommonPlatformAnalyzerServices.INSTANCE;
        } else {
            throw new IllegalStateException(("Unknown target platform: " + $this$getAnalyzerServices).toString());
        }
        return platformDependentAnalyzerServices;
    }

    @NotNull
    public static final Set<String> getSourceFilePaths(@NotNull CompilerConfiguration compilerConfig, boolean includeDirectoryRoot) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Set $this$getSourceFilePaths_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = JvmContentRootsKt.getJavaSourceRoots(compilerConfig);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String srcRoot = (String)element$iv;
            boolean bl2 = false;
            Path path2 = Paths.get(srcRoot, new String[0]);
            if (Files.isDirectory(path2, new LinkOption[0])) {
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                KtModuleUtilsKt.collectSourceFilePaths(path2, $this$getSourceFilePaths_u24lambda_u241);
                if (!includeDirectoryRoot) continue;
                $this$getSourceFilePaths_u24lambda_u241.add(srcRoot);
                continue;
            }
            $this$getSourceFilePaths_u24lambda_u241.add(srcRoot);
        }
        return SetsKt.build((Set)set);
    }

    public static /* synthetic */ Set getSourceFilePaths$default(CompilerConfiguration compilerConfiguration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KtModuleUtilsKt.getSourceFilePaths(compilerConfiguration, bl);
    }

    private static final void collectSourceFilePaths(Path root, Set<String> result2) {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(result2){
            final /* synthetic */ Set<String> $result;
            {
                this.$result = $result;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                return Files.isReadable(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!Files.isRegularFile(file2, new LinkOption[0]) || !Files.isReadable(file2)) {
                    return FileVisitResult.CONTINUE;
                }
                String ext = com.google.common.io.Files.getFileExtension((String)((Object)file2.getFileName()).toString());
                if (Intrinsics.areEqual((Object)ext, (Object)"kt") || Intrinsics.areEqual((Object)ext, (Object)"java")) {
                    this.$result.add(((Object)file2).toString());
                }
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult visitFileFailed(@NotNull Path file2, @Nullable IOException exc) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final /* synthetic */ <T extends PsiFileSystemItem> List<T> getPsiFilesFromPaths(Project project, Collection<String> paths) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        boolean $i$f$getPsiFilesFromPaths = false;
        VirtualFileSystem fs = StandardFileSystems.local();
        PsiManager psiManager2 = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(project)");
        PsiManager psiManager3 = psiManager2;
        List $this$getPsiFilesFromPaths_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (String path2 : paths) {
            PsiFileSystemItem it;
            PsiFileSystemItem psiFileSystemItem;
            PsiFileSystemItem psiFileSystemItem2;
            VirtualFile vFile;
            if (fs.findFileByPath(path2) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)vFile, (String)"fs.findFileByPath(path) ?: continue");
            if (vFile.isDirectory()) {
                PsiDirectory psiDirectory = psiManager3.findDirectory(vFile);
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                psiFileSystemItem2 = (PsiFileSystemItem)psiDirectory;
            } else {
                PsiFile psiFile = psiManager3.findFile(vFile);
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                psiFileSystemItem2 = psiFileSystemItem = (PsiFileSystemItem)psiFile;
            }
            if (psiFileSystemItem == null) continue;
            boolean bl2 = false;
            Boolean.valueOf($this$getPsiFilesFromPaths_u24lambda_u243.add(it));
        }
        return CollectionsKt.build((List)list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ProjectStructureProvider buildKtModuleProviderByCompilerConfiguration(@NotNull CompilerConfiguration compilerConfig, @NotNull Project project, @NotNull List<? extends KtFile> ktFiles) {
        void paths$iv;
        List list2;
        Iterable $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247;
        KtLibraryModuleBuilder $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u246_u24lambda_u245;
        void var28_38;
        void $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412;
        KtLibraryModuleBuilder ktLibraryModuleBuilder;
        boolean $i$f$buildKtLibraryModule;
        Path root;
        File it;
        KtSourceModuleBuilder ktSourceModuleBuilder;
        KtModuleProviderBuilder ktModuleProviderBuilder;
        Intrinsics.checkNotNullParameter((Object)compilerConfig, (String)"compilerConfig");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        boolean $i$f$buildProjectStructureProvider = false;
        KtModuleProviderBuilder $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413 = ktModuleProviderBuilder = new KtModuleProviderBuilder();
        boolean bl = false;
        boolean $i$f$buildKtSourceModule = false;
        KtSourceModuleBuilder ktSourceModuleBuilder2 = ktSourceModuleBuilder = new KtSourceModuleBuilder();
        KtModuleProviderBuilder ktModuleProviderBuilder2 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413;
        boolean bl2 = false;
        TargetPlatform platform = new TargetPlatform(SetsKt.setOf((Object)new JdkPlatform(JvmTarget.DEFAULT)));
        String string2 = compilerConfig.get(CommonConfigurationKeys.MODULE_NAME);
        if (string2 == null) {
            string2 = "<no module name provided>";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"compilerConfig.get(Commo\u2026no module name provided>\"");
        String moduleName = string2;
        List libraryRoots = CollectionsKt.plus((Collection)JvmContentRootsKt.getJvmModularRoots(compilerConfig), (Iterable)JvmContentRootsKt.getJvmClasspathRoots(compilerConfig));
        Iterable $this$partition$iv = libraryRoots;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (File)element$iv;
            boolean bl3 = false;
            if (it.isDirectory()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List directories2 = (List)pair.component1();
        List jars = (List)pair.component2();
        Iterable $this$forEach$iv = directories2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl4 = false;
            root = it.toPath();
            $i$f$buildKtLibraryModule = false;
            KtLibraryModuleBuilder ktLibraryModuleBuilder2 = ktLibraryModuleBuilder = new KtLibraryModuleBuilder();
            var28_38 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412;
            boolean bl5 = false;
            GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(project)");
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u246_u24lambda_u245.setContentScope(globalSearchScope);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u246_u24lambda_u245.setPlatform(platform);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u246_u24lambda_u245.setProject(project);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u246_u24lambda_u245.setBinaryRoots(CollectionsKt.listOf((Object)root));
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u246_u24lambda_u245.setLibraryName(moduleName + '-' + StringsKt.replace$default((String)((Object)root).toString(), (String)"/", (String)"-", (boolean)false, (int)4, null));
            var28_38.addRegularDependency(ktLibraryModuleBuilder.build());
        }
        $this$forEach$iv = jars;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl6 = false;
            root = it.toPath();
            $i$f$buildKtLibraryModule = false;
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u246_u24lambda_u245 = ktLibraryModuleBuilder = new KtLibraryModuleBuilder();
            var28_38 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412;
            boolean bl7 = false;
            GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(project)");
            ((KtModuleBuilder)((Object)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247)).setContentScope(globalSearchScope);
            ((KtModuleBuilder)((Object)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247)).setPlatform(platform);
            ((KtModuleBuilder)((Object)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247)).setProject(project);
            ((KtBinaryModuleBuilder)((Object)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247)).setBinaryRoots(CollectionsKt.listOf((Object)root));
            String string3 = com.google.common.io.Files.getNameWithoutExtension((String)((Object)root).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameWithoutExtension(root.toString())");
            ((KtLibraryModuleBuilder)((Object)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247)).setLibraryName(string3);
            ((KtLibraryModuleBuilder)((Object)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247)).setBuiltinsContainingStdlib(StringsKt.startsWith$default((String)((KtLibraryModuleBuilder)((Object)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247)).getLibraryName(), (String)"kotlin-stdlib", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)((KtLibraryModuleBuilder)((Object)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247)).getLibraryName(), (CharSequence)"common", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)((KtLibraryModuleBuilder)((Object)$this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247)).getLibraryName(), (CharSequence)"jdk", (boolean)false, (int)2, null));
            var28_38.addRegularDependency(ktLibraryModuleBuilder.build());
        }
        File file2 = compilerConfig.get(JVMConfigurationKeys.JDK_HOME);
        if (file2 != null) {
            void $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
            Collection collection;
            KtSdkModuleBuilder $this$mapTo$iv$iv;
            File jdkHome2 = file2;
            boolean bl8 = false;
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance()");
            VirtualFileManager vfm = virtualFileManager;
            Path jdkHomePath = jdkHome2.toPath();
            VirtualFile jdkHomeVirtualFile = vfm.findFileByNioPath(jdkHomePath);
            Intrinsics.checkNotNullExpressionValue((Object)jdkHomePath, (String)"jdkHomePath");
            Iterable $this$map$iv = LibraryUtils.INSTANCE.findClassesFromJdkHome(jdkHomePath);
            boolean $i$f$map = false;
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u248_u24lambda_u247 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it2;
                Object item$iv$iv = iterator2.next();
                String string4 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl9 = false;
                collection.add(Paths.get(URLUtil.extractPath((String)it2), new String[0]));
            }
            List binaryRoots = (List)destination$iv$iv;
            boolean $i$f$buildKtSdkModule = false;
            $this$mapTo$iv$iv = $i$f$map = new KtSdkModuleBuilder();
            collection = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412;
            boolean bl10 = false;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)jdkHomeVirtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(project, jdkHomeVirtualFile)");
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setContentScope(globalSearchScope);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setPlatform(platform);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setProject(project);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setBinaryRoots(binaryRoots);
            $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410.setSdkName("JDK for " + moduleName);
            ((KtModuleBuilder)((Object)collection)).addRegularDependency($i$f$map.build());
        }
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412.setContentScope(TopDownAnalyzerFacadeForJVM.INSTANCE.newModuleSearchScope(project, (Collection<? extends KtFile>)ktFiles));
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412.setPlatform(platform);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412.setProject(project);
        $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412.setModuleName(moduleName);
        $this$forEach$iv = KtModuleUtilsKt.getSourceFilePaths(compilerConfig, true);
        void var36_50 = $this$buildKtModuleProviderByCompilerConfiguration_u24lambda_u2413_u24lambda_u2412;
        boolean $i$f$getPsiFilesFromPaths = false;
        VirtualFileSystem fs$iv = StandardFileSystems.local();
        PsiManager psiManager2 = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(project)");
        PsiManager psiManager$iv = psiManager2;
        List $this$getPsiFilesFromPaths_u24lambda_u243$iv = list2 = CollectionsKt.createListBuilder();
        boolean bl11 = false;
        for (String path$iv : paths$iv) {
            PsiFileSystemItem it$iv;
            PsiFileSystemItem psiFileSystemItem$iv;
            PsiFileSystemItem psiFileSystemItem;
            VirtualFile vFile$iv;
            if (fs$iv.findFileByPath(path$iv) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)vFile$iv, (String)"fs.findFileByPath(path) ?: continue");
            if (vFile$iv.isDirectory()) {
                PsiDirectory psiDirectory = psiManager$iv.findDirectory(vFile$iv);
                if (!(psiDirectory instanceof PsiFileSystemItem)) {
                    psiDirectory = null;
                }
                psiFileSystemItem = (PsiFileSystemItem)psiDirectory;
            } else {
                PsiFile psiFile = psiManager$iv.findFile(vFile$iv);
                if (!(psiFile instanceof PsiFileSystemItem)) {
                    psiFile = null;
                }
                psiFileSystemItem = psiFileSystemItem$iv = (PsiFileSystemItem)psiFile;
            }
            if (psiFileSystemItem$iv == null) continue;
            boolean bl12 = false;
            $this$getPsiFilesFromPaths_u24lambda_u243$iv.add(it$iv);
        }
        var36_50.addSourceRoots(CollectionsKt.build((List)list2));
        ktModuleProviderBuilder2.addModule(ktSourceModuleBuilder.build());
        return ktModuleProviderBuilder.build();
    }
}

