/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKeyDescriptor;", "Lcom/intellij/util/io/KeyDescriptor;", "Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "storeFullFqNames", "", "(Z)V", "getHashCode", "", "value", "isEqual", "val1", "val2", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "kotlin-build-common"})
public final class LookupSymbolKeyDescriptor
implements KeyDescriptor<LookupSymbolKey> {
    private final boolean storeFullFqNames;

    public LookupSymbolKeyDescriptor(boolean storeFullFqNames) {
        this.storeFullFqNames = storeFullFqNames;
    }

    public /* synthetic */ LookupSymbolKeyDescriptor(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public LookupSymbolKey read(@NotNull DataInput input) {
        LookupSymbolKey lookupSymbolKey;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte byteValue = input.readByte();
        switch (byteValue) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected byte value for storeFullFqNames: " + byteValue).toString());
            }
        }
        boolean storeFullFqNames = bl;
        if (storeFullFqNames) {
            String name2 = input.readUTF();
            String scope2 = input.readUTF();
            int n = name2.hashCode();
            int n2 = scope2.hashCode();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
            Intrinsics.checkNotNullExpressionValue((Object)scope2, (String)"scope");
            lookupSymbolKey = new LookupSymbolKey(n, n2, name2, scope2);
        } else {
            int nameHash = input.readInt();
            int scopeHash = input.readInt();
            lookupSymbolKey = new LookupSymbolKey(nameHash, scopeHash, "", "");
        }
        return lookupSymbolKey;
    }

    public void save(@NotNull DataOutput output, @NotNull LookupSymbolKey value2) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        output.writeByte(this.storeFullFqNames ? 0 : 1);
        if (this.storeFullFqNames) {
            output.writeUTF(value2.getName());
            output.writeUTF(value2.getScope());
        } else {
            output.writeInt(value2.getNameHash());
            output.writeInt(value2.getScopeHash());
        }
    }

    public int getHashCode(@NotNull LookupSymbolKey value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return value2.hashCode();
    }

    public boolean isEqual(@NotNull LookupSymbolKey val1, @NotNull LookupSymbolKey val2) {
        Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
        Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
        return Intrinsics.areEqual((Object)val1, (Object)val2);
    }

    public LookupSymbolKeyDescriptor() {
        this(false, 1, null);
    }
}

