/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KtCompileTimeConstantProvider;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.InvalidFirElementTypeExceptionKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirCompileTimeConstantProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtCompileTimeConstantProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "evaluate", "Lorg/jetbrains/kotlin/analysis/api/base/KtConstantValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "mode", "Lorg/jetbrains/kotlin/analysis/api/components/KtConstantEvaluationMode;", "evaluateFir", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "sourcePsi", "analysis-api-fir"})
public final class KtFirCompileTimeConstantProvider
extends KtCompileTimeConstantProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirCompileTimeConstantProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public KtConstantValue evaluate(@NotNull KtExpression expression2, @NotNull KtConstantEvaluationMode mode) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        return this.evaluateFir(LowLevelFirApiFacadeKt.getOrBuildFir(expression2, this.getFirResolveSession()), expression2, mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KtConstantValue evaluateFir(FirElement fir, KtExpression sourcePsi, KtConstantEvaluationMode mode) {
        KtConstantValue ktConstantValue;
        if (fir instanceof FirPropertyAccessExpression || fir instanceof FirExpression || fir instanceof FirNamedReference) {
            try {
                ktConstantValue = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue(fir, mode);
            }
            catch (ArithmeticException e) {
                String string2 = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"e.localizedMessage");
                ktConstantValue = new KtConstantValue.KtErrorConstantValue(string2, sourcePsi);
            }
        } else {
            if (fir instanceof FirWhenBranch) {
                return null;
            }
            if (fir instanceof FirVariableAssignment) {
                KtSourceElement ktSourceElement = ((FirVariableAssignment)fir).getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredIncrementOrDecrement.INSTANCE)) {
                    return null;
                }
            }
            InvalidFirElementTypeExceptionKt.throwUnexpectedFirElementError(fir, sourcePsi, new KClass[0]);
            throw null;
        }
        KtConstantValue ktConstantValue2 = ktConstantValue;
        return ktConstantValue2;
    }
}

