/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProviderKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0000H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KtPackage;", "Lcom/intellij/psi/impl/file/PsiPackageImpl;", "manager", "Lcom/intellij/psi/PsiManager;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/psi/PsiManager;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/search/GlobalSearchScope;)V", "copy", "isValid", "", "analysis-api-fir"})
public final class KtPackage
extends PsiPackageImpl {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final GlobalSearchScope scope;

    public KtPackage(@NotNull PsiManager manager, @NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        String string2 = fqName2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.asString()");
        super(manager, StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null));
        this.fqName = fqName2;
        this.scope = scope2;
    }

    @NotNull
    public KtPackage copy() {
        PsiManager psiManager2 = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"manager");
        return new KtPackage(psiManager2, this.fqName, this.scope);
    }

    public boolean isValid() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return KotlinPackageProviderKt.createPackageProvider(project, this.scope).doKotlinPackageExists(this.fqName);
    }
}

