/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import java.lang.ref.SoftReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.project.structure.LLFirModuleDataKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactory;
import org.jetbrains.kotlin.analysis.providers.KtModuleStateTracker;
import org.jetbrains.kotlin.analysis.utils.trackers.CompositeModificationTracker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001b\u001a\u00020\u001cR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/FirSessionWithModificationTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "firSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;)V", "firSessionSoftReference", "Ljava/lang/ref/SoftReference;", "getFirSessionSoftReference", "()Ljava/lang/ref/SoftReference;", "isInvalidated", "", "isValid", "()Z", "ktModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "getKtModule", "()Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "timeStamp", "", "validityTracker", "Lorg/jetbrains/kotlin/analysis/providers/KtModuleStateTracker;", "getValidityTracker", "()Lorg/jetbrains/kotlin/analysis/providers/KtModuleStateTracker;", "invalidate", "", "low-level-api-fir"})
final class FirSessionWithModificationTracker {
    @NotNull
    private final SoftReference<LLFirSession> firSessionSoftReference;
    @NotNull
    private final KtModule ktModule;
    @NotNull
    private final KtModuleStateTracker validityTracker;
    @NotNull
    private final ModificationTracker modificationTracker;
    private final long timeStamp;
    private volatile boolean isInvalidated;

    public FirSessionWithModificationTracker(@NotNull Project project, @NotNull LLFirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)firSession, (String)"firSession");
        this.firSessionSoftReference = new SoftReference<LLFirSession>(firSession);
        this.ktModule = LLFirModuleDataKt.getLlFirModuleData(firSession).getKtModule();
        KotlinModificationTrackerFactory trackerFactory = KotlinModificationTrackerFactory.Companion.getService(project);
        this.validityTracker = trackerFactory.createModuleStateTracker(this.ktModule);
        ModificationTracker outOfBlockTracker = this.ktModule instanceof KtSourceModule ? trackerFactory.createModuleWithoutDependenciesOutOfBlockModificationTracker((KtSourceModule)this.ktModule) : null;
        Object[] objectArray = new ModificationTracker[]{outOfBlockTracker, new ModificationTracker(){

            public long getModificationCount() {
                return this.getValidityTracker().getRootModificationCount();
            }
        }};
        this.modificationTracker = CompositeModificationTracker.Companion.create(CollectionsKt.listOfNotNull((Object[])objectArray));
        this.timeStamp = this.modificationTracker.getModificationCount();
    }

    @NotNull
    public final SoftReference<LLFirSession> getFirSessionSoftReference() {
        return this.firSessionSoftReference;
    }

    @NotNull
    public final KtModule getKtModule() {
        return this.ktModule;
    }

    @NotNull
    public final KtModuleStateTracker getValidityTracker() {
        return this.validityTracker;
    }

    public final void invalidate() {
        this.isInvalidated = true;
    }

    public final boolean isValid() {
        return this.validityTracker.isValid() && !this.isInvalidated && this.modificationTracker.getModificationCount() == this.timeStamp;
    }
}

