/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.metadata;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/metadata/DynamicTypeDeserializer;", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "()V", "id", "", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "flexibleId", "lowerBound", "Lorg/jetbrains/kotlin/types/SimpleType;", "upperBound", "ir.serialization.common"})
public final class DynamicTypeDeserializer
implements FlexibleTypeDeserializer {
    @NotNull
    public static final DynamicTypeDeserializer INSTANCE = new DynamicTypeDeserializer();
    @NotNull
    public static final String id = "kotlin.DynamicType";

    private DynamicTypeDeserializer() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public KotlinType create(@NotNull ProtoBuf.Type proto, @NotNull String flexibleId, @NotNull SimpleType lowerBound2, @NotNull SimpleType upperBound2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)flexibleId, (String)"flexibleId");
        Intrinsics.checkNotNullParameter((Object)lowerBound2, (String)"lowerBound");
        Intrinsics.checkNotNullParameter((Object)upperBound2, (String)"upperBound");
        if (!Intrinsics.areEqual((Object)flexibleId, (Object)id)) {
            String[] stringArray = new String[]{flexibleId, lowerBound2.toString(), upperBound2.toString()};
            return ErrorUtils.createErrorType(ErrorTypeKind.UNEXPECTED_FLEXIBLE_TYPE_ID, stringArray);
        }
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(lowerBound2).getNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"lowerBound.builtIns.nothingType");
        if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(lowerBound2, simpleType2)) {
            SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(upperBound2).getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"upperBound.builtIns.nullableAnyType");
            if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(upperBound2, simpleType3)) {
                kotlinType = DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(lowerBound2));
                return kotlinType;
            }
        }
        String[] stringArray = new String[]{lowerBound2.toString(), upperBound2.toString()};
        kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ILLEGAL_TYPE_RANGE_FOR_DYNAMIC, stringArray);
        return kotlinType;
    }
}

