/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J+\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\r0\u0014H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "collectReachable", "", "T", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "from", "(Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;Ljava/lang/Object;)Ljava/util/List;", "isEdgeInCycle", "", "edge", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "ExpansiveEdge", "Graph", "GraphBuilder", "frontend"})
@SourceDebugExtension(value={"SMAP\nNonExpansiveInheritanceRestrictionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonExpansiveInheritanceRestrictionChecker.kt\norg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n766#2:169\n857#2,2:170\n1360#2:172\n1446#2,5:173\n1747#2,3:178\n1549#2:181\n1620#2,3:182\n1549#2:185\n1620#2,3:186\n*S KotlinDebug\n*F\n+ 1 NonExpansiveInheritanceRestrictionChecker.kt\norg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker\n*L\n44#1:169\n44#1:170,2\n47#1:172\n47#1:173,5\n57#1:178,3\n59#1:181\n59#1:182,3\n59#1:185\n59#1:186,3\n*E\n"})
public final class NonExpansiveInheritanceRestrictionChecker {
    @NotNull
    public static final NonExpansiveInheritanceRestrictionChecker INSTANCE = new NonExpansiveInheritanceRestrictionChecker();

    private NonExpansiveInheritanceRestrictionChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void check(@NotNull KtClass declaration, @NotNull ClassDescriptor classDescriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        List problemNodes;
        block12: {
            void $this$flatMapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)classDescriptor2, (String)"classDescriptor");
            Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
            TypeConstructor typeConstructor2 = classDescriptor2.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"classDescriptor.typeConstructor");
            TypeConstructor typeConstructor3 = typeConstructor2;
            if (typeConstructor3.getParameters().isEmpty()) {
                return;
            }
            GraphBuilder builder2 = new GraphBuilder(typeConstructor3);
            Graph<TypeParameterDescriptor> graph = builder2.build();
            Iterable $this$filter$iv = graph.getExpansiveEdges();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ExpansiveEdge it = (ExpansiveEdge)element$iv$iv;
                boolean bl2 = false;
                if (!INSTANCE.isEdgeInCycle(graph, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List edgesInCycles = (List)destination$iv$iv;
            if (edgesInCycles.isEmpty()) {
                return;
            }
            Iterable $this$flatMap$iv = edgesInCycles;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ExpansiveEdge it = (ExpansiveEdge)element$iv$iv;
                boolean bl3 = false;
                Object[] objectArray = new TypeParameterDescriptor[]{it.getFrom(), it.getTo()};
                Iterable list$iv$iv = SetsKt.setOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            problemNodes = (List)destination$iv$iv2;
            for (TypeParameterDescriptor typeParameter2 : typeConstructor3.getParameters()) {
                if (!problemNodes.contains(typeParameter2)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)typeParameter2, (String)"typeParameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameter2);
                if (psiElement == null) {
                    psiElement = declaration;
                }
                PsiElement element = psiElement;
                diagnosticHolder.report(Errors.EXPANSIVE_INHERITANCE.on(element));
                return;
            }
            Iterable $this$any$iv = problemNodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv2;
                    boolean bl4 = false;
                    if (!(!Intrinsics.areEqual((Object)it.getSource(), (Object)SourceElement.NO_SOURCE))) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $this$map$iv = problemNodes;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeParameterDescriptor bl3 = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(it.getContainingDeclaration());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DeclarationDescriptor it = (DeclarationDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(DescriptorUtilsKt.getFqNameUnsafe(it).asString());
        }
        SortedSet typeFqNames = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
        diagnosticHolder.report(Errors.EXPANSIVE_INHERITANCE_IN_JAVA.on(declaration, CollectionsKt.joinToString$default((Iterable)typeFqNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
    }

    private final <T> boolean isEdgeInCycle(Graph<T> $this$isEdgeInCycle, ExpansiveEdge<? extends T> edge) {
        return this.collectReachable($this$isEdgeInCycle, edge.getTo()).contains(edge.getFrom());
    }

    private final <T> List<T> collectReachable(Graph<T> $this$collectReachable, T from2) {
        DFS.NodeHandlerWithListResult handler2 = new DFS.NodeHandlerWithListResult<T, T>(){

            public void afterChildren(@Nullable T current) {
                ((LinkedList)this.result).add(current);
            }
        };
        DFS.Neighbors neighbors2 = new DFS.Neighbors<T>($this$collectReachable){
            final /* synthetic */ Graph<T> $this_collectReachable;
            {
                this.$this_collectReachable = $receiver;
            }

            @NotNull
            public Iterable<T> getNeighbors(T current) {
                return this.$this_collectReachable.getNeighbors(current);
            }
        };
        DFS.dfs(CollectionsKt.listOf(from2), neighbors2, handler2);
        Object object = handler2.result();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"handler.result()");
        return (List)object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$GraphBuilder;", "", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)V", "edgeLists", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "", "Lkotlin/collections/HashMap;", "expansiveEdges", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "Lkotlin/collections/HashSet;", "processedTypeConstructors", "getTypeConstructor", "()Lorg/jetbrains/kotlin/types/TypeConstructor;", "addEdge", "", "from", "to", "expansive", "", "build", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "doBuildGraph", "frontend"})
    @SourceDebugExtension(value={"SMAP\nNonExpansiveInheritanceRestrictionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonExpansiveInheritanceRestrictionChecker.kt\norg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$GraphBuilder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n361#2,7:169\n1864#3,2:176\n1603#3,9:178\n1855#3:187\n1856#3:189\n1612#3:190\n1866#3:191\n1#4:188\n*S KotlinDebug\n*F\n+ 1 NonExpansiveInheritanceRestrictionChecker.kt\norg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$GraphBuilder\n*L\n78#1:169,7\n101#1:176,2\n123#1:178,9\n123#1:187\n123#1:189\n123#1:190\n101#1:191\n123#1:188\n*E\n"})
    private static final class GraphBuilder {
        @NotNull
        private final TypeConstructor typeConstructor;
        @NotNull
        private final HashSet<TypeConstructor> processedTypeConstructors;
        @NotNull
        private final HashSet<ExpansiveEdge<TypeParameterDescriptor>> expansiveEdges;
        @NotNull
        private final HashMap<TypeParameterDescriptor, Set<TypeParameterDescriptor>> edgeLists;

        public GraphBuilder(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
            this.typeConstructor = typeConstructor2;
            this.processedTypeConstructors = new HashSet();
            this.expansiveEdges = new HashSet();
            this.edgeLists = new HashMap();
        }

        @NotNull
        public final TypeConstructor getTypeConstructor() {
            return this.typeConstructor;
        }

        @NotNull
        public final Graph<TypeParameterDescriptor> build() {
            this.doBuildGraph(this.typeConstructor);
            return new Graph<TypeParameterDescriptor>(this){
                @NotNull
                private final HashSet<ExpansiveEdge<TypeParameterDescriptor>> expansiveEdges;
                final /* synthetic */ GraphBuilder this$0;
                {
                    this.this$0 = $receiver;
                    this.expansiveEdges = GraphBuilder.access$getExpansiveEdges$p($receiver);
                }

                @NotNull
                public Collection<TypeParameterDescriptor> getNeighbors(@NotNull TypeParameterDescriptor node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Set set = (Set)GraphBuilder.access$getEdgeLists$p(this.this$0).get(node);
                    return set == null ? (Collection)CollectionsKt.emptyList() : (Collection)set;
                }

                @NotNull
                public HashSet<ExpansiveEdge<TypeParameterDescriptor>> getExpansiveEdges() {
                    return this.expansiveEdges;
                }
            };
        }

        private final void addEdge(TypeParameterDescriptor from2, TypeParameterDescriptor to, boolean expansive) {
            Object object;
            Map $this$getOrPut$iv = this.edgeLists;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(from2);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(from2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(to);
            if (expansive) {
                this.expansiveEdges.add(new ExpansiveEdge<TypeParameterDescriptor>(from2, to));
            }
        }

        static /* synthetic */ void addEdge$default(GraphBuilder graphBuilder, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            graphBuilder.addEdge(typeParameterDescriptor, typeParameterDescriptor2, bl);
        }

        /*
         * WARNING - void declaration
         */
        private final void doBuildGraph(TypeConstructor typeConstructor2) {
            if (typeConstructor2.getParameters().isEmpty()) {
                return;
            }
            List<TypeParameterDescriptor> list2 = typeConstructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"typeConstructor.parameters");
            List<TypeParameterDescriptor> typeParameters2 = list2;
            Collection<KotlinType> collection = typeConstructor2.getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"typeConstructor.supertypes");
            for (KotlinType constituentType : TypeUtilsKt.constituentTypes(collection)) {
                TypeConstructor constituentTypeConstructor = constituentType.getConstructor();
                if (!this.processedTypeConstructors.contains(constituentTypeConstructor)) {
                    this.processedTypeConstructors.add(constituentTypeConstructor);
                    this.doBuildGraph(constituentTypeConstructor);
                }
                if (constituentTypeConstructor.getParameters().size() != constituentType.getArguments().size()) continue;
                Iterable $this$forEachIndexed$iv = constituentType.getArguments();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void $this$mapNotNullTo$iv$iv;
                    void typeProjection;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    TypeProjection typeProjection2 = (TypeProjection)item$iv;
                    int i2 = n;
                    boolean bl = false;
                    if (typeProjection.getProjectionKind() == Variance.INVARIANT) {
                        Collection<KotlinType> constituents = TypeUtilsKt.constituentTypes(SetsKt.setOf((Object)typeProjection.getType()));
                        for (TypeParameterDescriptor typeParameter2 : typeParameters2) {
                            if (!constituents.contains(typeParameter2.getDefaultType()) && !constituents.contains(typeParameter2.getDefaultType().makeNullableAsSpecified(true))) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)typeParameter2, (String)"typeParameter");
                            TypeParameterDescriptor typeParameterDescriptor = constituentTypeConstructor.getParameters().get(i2);
                            Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"constituentTypeConstructor.parameters[i]");
                            this.addEdge(typeParameter2, typeParameterDescriptor, !TypeUtils.isTypeParameter(typeProjection.getType()));
                        }
                        continue;
                    }
                    TypeParameterDescriptor originalTypeParameter = constituentTypeConstructor.getParameters().get(i2);
                    HashSet<KotlinType> bounds = new HashSet<KotlinType>();
                    TypeSubstitutor substitutor2 = TypeConstructorSubstitution.Companion.create(constituentType).buildSubstitutor();
                    List<KotlinType> list3 = originalTypeParameter.getUpperBounds();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"originalTypeParameter.upperBounds");
                    Iterable $this$mapNotNull$iv = list3;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        KotlinType it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl2 = false;
                        KotlinType it = (KotlinType)element$iv$iv;
                        boolean bl3 = false;
                        if (substitutor2.substitute(it, Variance.INVARIANT) == null) continue;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List adaptedUpperBounds = (List)destination$iv$iv;
                    bounds.addAll(adaptedUpperBounds);
                    if (!typeProjection.isStarProjection()) {
                        bounds.add(typeProjection.getType());
                    }
                    Collection<KotlinType> boundClosure2 = TypeUtilsKt.boundClosure((Collection<? extends KotlinType>)bounds);
                    Collection<KotlinType> constituentTypes = TypeUtilsKt.constituentTypes(boundClosure2);
                    for (TypeParameterDescriptor typeParameter3 : typeParameters2) {
                        if (!constituentTypes.contains(typeParameter3.getDefaultType()) && !constituentTypes.contains(typeParameter3.getDefaultType().makeNullableAsSpecified(true))) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)typeParameter3, (String)"typeParameter");
                        Intrinsics.checkNotNullExpressionValue((Object)originalTypeParameter, (String)"originalTypeParameter");
                        this.addEdge(typeParameter3, originalTypeParameter, true);
                    }
                }
            }
        }

        public static final /* synthetic */ HashSet access$getExpansiveEdges$p(GraphBuilder $this) {
            return $this.expansiveEdges;
        }

        public static final /* synthetic */ HashMap access$getEdgeLists$p(GraphBuilder $this) {
            return $this.edgeLists;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\bb\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000bR\u001e\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "T", "", "expansiveEdges", "", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "getExpansiveEdges", "()Ljava/util/Set;", "getNeighbors", "", "node", "(Ljava/lang/Object;)Ljava/util/Collection;", "frontend"})
    private static interface Graph<T> {
        @NotNull
        public Collection<T> getNeighbors(T var1);

        @NotNull
        public Set<ExpansiveEdge<T>> getExpansiveEdges();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J(\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "T", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getFrom", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTo", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    private static final class ExpansiveEdge<T> {
        private final T from;
        private final T to;

        public ExpansiveEdge(T from2, T to) {
            this.from = from2;
            this.to = to;
        }

        public final T getFrom() {
            return this.from;
        }

        public final T getTo() {
            return this.to;
        }

        public final T component1() {
            return this.from;
        }

        public final T component2() {
            return this.to;
        }

        @NotNull
        public final ExpansiveEdge<T> copy(T from2, T to) {
            return new ExpansiveEdge<T>(from2, to);
        }

        public static /* synthetic */ ExpansiveEdge copy$default(ExpansiveEdge expansiveEdge, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = expansiveEdge.from;
            }
            if ((n & 2) != 0) {
                object2 = expansiveEdge.to;
            }
            return expansiveEdge.copy(object, object2);
        }

        @NotNull
        public String toString() {
            return "ExpansiveEdge(from=" + this.from + ", to=" + this.to + ')';
        }

        public int hashCode() {
            int result2 = this.from == null ? 0 : this.from.hashCode();
            result2 = result2 * 31 + (this.to == null ? 0 : this.to.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpansiveEdge)) {
                return false;
            }
            ExpansiveEdge expansiveEdge = (ExpansiveEdge)other;
            if (!Intrinsics.areEqual(this.from, expansiveEdge.from)) {
                return false;
            }
            return Intrinsics.areEqual(this.to, expansiveEdge.to);
        }
    }
}

