/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ServiceLoader;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.DumbTerminal;
import org.jline.terminal.impl.ExecPty;
import org.jline.terminal.impl.ExternalTerminal;
import org.jline.terminal.impl.PosixPtyTerminal;
import org.jline.terminal.impl.PosixSysTerminal;
import org.jline.terminal.spi.JansiSupport;
import org.jline.terminal.spi.JnaSupport;
import org.jline.terminal.spi.Pty;
import org.jline.utils.Log;
import org.jline.utils.OSUtils;

public final class TerminalBuilder {
    public static final String PROP_ENCODING = "org.jline.terminal.encoding";
    public static final String PROP_TYPE = "org.jline.terminal.type";
    public static final String PROP_JNA = "org.jline.terminal.jna";
    public static final String PROP_JANSI = "org.jline.terminal.jansi";
    public static final String PROP_EXEC = "org.jline.terminal.exec";
    public static final String PROP_DUMB = "org.jline.terminal.dumb";
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private String encoding;
    private Boolean system;
    private Boolean jna;
    private Boolean jansi;
    private Boolean exec;
    private Boolean dumb;
    private Attributes attributes;
    private Size size;
    private boolean nativeSignals = false;
    private Terminal.SignalHandler signalHandler = Terminal.SignalHandler.SIG_DFL;

    public static Terminal terminal() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public TerminalBuilder name(String name2) {
        this.name = name2;
        return this;
    }

    public TerminalBuilder streams(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        return this;
    }

    public TerminalBuilder system(boolean system2) {
        this.system = system2;
        return this;
    }

    public TerminalBuilder jna(boolean jna) {
        this.jna = jna;
        return this;
    }

    public TerminalBuilder jansi(boolean jansi) {
        this.jansi = jansi;
        return this;
    }

    public TerminalBuilder exec(boolean exec) {
        this.exec = exec;
        return this;
    }

    public TerminalBuilder dumb(boolean dumb) {
        this.dumb = dumb;
        return this;
    }

    public TerminalBuilder type(String type2) {
        this.type = type2;
        return this;
    }

    public TerminalBuilder encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public TerminalBuilder attributes(Attributes attributes2) {
        this.attributes = attributes2;
        return this;
    }

    public TerminalBuilder size(Size size) {
        this.size = size;
        return this;
    }

    public TerminalBuilder nativeSignals(boolean nativeSignals) {
        this.nativeSignals = nativeSignals;
        return this;
    }

    public TerminalBuilder signalHandler(Terminal.SignalHandler signalHandler) {
        this.signalHandler = signalHandler;
        return this;
    }

    public Terminal build() throws IOException {
        Terminal terminal = this.doBuild();
        Log.debug(() -> "Using terminal " + terminal.getClass().getSimpleName());
        if (terminal instanceof AbstractPosixTerminal) {
            Log.debug(() -> "Using pty " + ((AbstractPosixTerminal)terminal).getPty().getClass().getSimpleName());
        }
        return terminal;
    }

    private Terminal doBuild() throws IOException {
        Boolean dumb;
        Boolean exec;
        Boolean jansi;
        Boolean jna;
        String type2;
        String encoding;
        String name2 = this.name;
        if (name2 == null) {
            name2 = "JLine terminal";
        }
        if ((encoding = this.encoding) == null) {
            encoding = System.getProperty(PROP_ENCODING);
        }
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        if ((type2 = this.type) == null) {
            type2 = System.getProperty(PROP_TYPE);
        }
        if (type2 == null) {
            type2 = System.getenv("TERM");
        }
        if ((jna = this.jna) == null) {
            jna = TerminalBuilder.getBoolean(PROP_JNA, true);
        }
        if ((jansi = this.jansi) == null) {
            jansi = TerminalBuilder.getBoolean(PROP_JANSI, true);
        }
        if ((exec = this.exec) == null) {
            exec = TerminalBuilder.getBoolean(PROP_EXEC, true);
        }
        if ((dumb = this.dumb) == null) {
            dumb = TerminalBuilder.getBoolean(PROP_DUMB, null);
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && this.in == null && this.out == null) {
            if (this.attributes != null || this.size != null) {
                Log.warn("Attributes and size fields are ignored when creating a system terminal");
            }
            IllegalStateException exception = new IllegalStateException("Unable to create a system terminal");
            if (OSUtils.IS_CYGWIN || OSUtils.IS_MINGW) {
                if (exec.booleanValue()) {
                    try {
                        Pty pty = ExecPty.current();
                        if ("xterm".equals(type2) && this.type == null && System.getProperty(PROP_TYPE) == null) {
                            type2 = "xterm-256color";
                        }
                        return new PosixSysTerminal(name2, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (IOException e) {
                        Log.debug("Error creating EXEC based terminal: ", e.getMessage(), e);
                        exception.addSuppressed(e);
                    }
                }
            } else if (OSUtils.IS_WINDOWS) {
                if (jna.booleanValue()) {
                    try {
                        return this.load(JnaSupport.class).winSysTerminal(name2, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (jansi.booleanValue()) {
                    try {
                        return this.load(JansiSupport.class).winSysTerminal(name2, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
            } else {
                if (jna.booleanValue()) {
                    try {
                        Pty pty = this.load(JnaSupport.class).current();
                        return new PosixSysTerminal(name2, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (jansi.booleanValue()) {
                    try {
                        Pty pty = this.load(JansiSupport.class).current();
                        return new PosixSysTerminal(name2, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (exec.booleanValue()) {
                    try {
                        Pty pty = ExecPty.current();
                        return new PosixSysTerminal(name2, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating EXEC based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
            }
            if (dumb == null || dumb.booleanValue()) {
                if (dumb == null) {
                    if (Log.isDebugEnabled()) {
                        Log.warn("Creating a dumb terminal", exception);
                    } else {
                        Log.warn("Unable to create a system terminal, creating a dumb terminal (enable debug logging for more information)");
                    }
                }
                return new DumbTerminal(name2, type2 != null ? type2 : "dumb", new FileInputStream(FileDescriptor.in), new FileOutputStream(FileDescriptor.out), encoding, this.signalHandler);
            }
            throw exception;
        }
        if (jna.booleanValue()) {
            try {
                Pty pty = this.load(JnaSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name2, type2, pty, this.in, this.out, encoding, this.signalHandler);
            }
            catch (Throwable t) {
                Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
            }
        }
        if (jansi.booleanValue()) {
            try {
                Pty pty = this.load(JansiSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name2, type2, pty, this.in, this.out, encoding, this.signalHandler);
            }
            catch (Throwable t) {
                Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
            }
        }
        ExternalTerminal terminal = new ExternalTerminal(name2, type2, this.in, this.out, encoding, this.signalHandler);
        if (this.attributes != null) {
            terminal.setAttributes(this.attributes);
        }
        if (this.size != null) {
            terminal.setSize(this.size);
        }
        return terminal;
    }

    private static Boolean getBoolean(String name2, Boolean def) {
        try {
            String str = System.getProperty(name2);
            if (str != null) {
                return Boolean.parseBoolean(str);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return def;
    }

    private <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }
}

