/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.symbols.pointers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.descriptors.Fe10AnalysisContext;
import org.jetbrains.kotlin.analysis.api.descriptors.KaFe10Session;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.descriptorBased.KaFe10DescEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.impl.base.symbols.pointers.KaBaseCachedSymbolPointer;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0015J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/symbols/pointers/KaFe10DescEnumEntrySymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseCachedSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "entryName", "Lorg/jetbrains/kotlin/name/Name;", "originalSymbol", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/analysis/api/symbols/KaEnumEntrySymbol;)V", "restoreIfNotCached", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "pointsToTheSameSymbolAs", "", "other", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "analysis-api-fe10"})
public final class KaFe10DescEnumEntrySymbolPointer
extends KaBaseCachedSymbolPointer<KaEnumEntrySymbol> {
    @NotNull
    private final ClassId classId;
    @NotNull
    private final Name entryName;

    public KaFe10DescEnumEntrySymbolPointer(@NotNull ClassId classId, @NotNull Name entryName, @Nullable KaEnumEntrySymbol originalSymbol) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        super((KaSymbol)originalSymbol);
        this.classId = classId;
        this.entryName = entryName;
    }

    @Override
    @KaImplementationDetail
    @Nullable
    protected KaEnumEntrySymbol restoreIfNotCached(@NotNull KaSession analysisSession) {
        MemberScope memberScope2;
        ClassifierDescriptor entryDescriptor;
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        if (!(analysisSession instanceof KaFe10Session)) {
            throw new IllegalStateException("Check failed.");
        }
        Fe10AnalysisContext analysisContext = ((KaFe10Session)analysisSession).getAnalysisContext();
        ModuleDescriptor moduleDescriptor = analysisContext.getResolveSession().getModuleDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"<get-moduleDescriptor>(...)");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, this.classId);
        ClassifierDescriptor classifierDescriptor = entryDescriptor = classDescriptor != null && (memberScope2 = classDescriptor.getUnsubstitutedMemberScope()) != null ? memberScope2.getContributedClassifier(this.entryName, NoLookupLocation.FROM_IDE) : null;
        if (entryDescriptor instanceof ClassDescriptor && ((ClassDescriptor)entryDescriptor).getKind() == ClassKind.ENUM_ENTRY) {
            return new KaFe10DescEnumEntrySymbol((ClassDescriptor)entryDescriptor, analysisContext);
        }
        return null;
    }

    @Override
    public boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this == other || other instanceof KaFe10DescEnumEntrySymbolPointer && Intrinsics.areEqual((Object)((KaFe10DescEnumEntrySymbolPointer)other).classId, (Object)this.classId) && Intrinsics.areEqual((Object)((KaFe10DescEnumEntrySymbolPointer)other).entryName, (Object)this.entryName);
    }
}

