/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptDependencyModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableSoftValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableWeakValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.ValueReferenceCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.LLFirBuiltinsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirAbstractSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirCommonSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirDanglingFileSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJvmSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirNativeSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirWasmSessionFactory;
import org.jetbrains.kotlin.platform.JsPlatform;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.WasmPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatform;

@LLFirInternals
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J\u0018\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0015\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0017H\u0002JK\u0010\u0018\u001a\u00020\t\"\b\b\u0000\u0010\u0019*\u00020\b2\u0006\u0010\u0011\u001a\u0002H\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\t0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tH\u0002J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bJ(\u0010\"\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\b2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0013J\u0006\u0010%\u001a\u00020\u001fJ\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\bJ\u0019\u0010(\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\bH\u0082\u0010J\u0006\u0010)\u001a\u00020\u001fJ\u0006\u0010*\u001a\u00020\u001fJ \u0010+\u001a\u00020\u001f2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J \u0010,\u001a\u00020\u001f2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0002J5\u0010-\u001a\u00020\u001f2\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u001cH\u0082\bJ\u0010\u00102\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\bH\u0002J\b\u00105\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010/\u001a\u00020\u0013*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "sourceCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/SessionStorage;", "binaryCache", "danglingFileSessionCache", "unstableDanglingFileSessionCache", "createWeakValueCache", "createSoftValueCache", "getSession", "module", "preferBinary", "", "getSessionNoCaching", "getSessionNoCaching$low_level_api_fir", "getDanglingFileCachedSession", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileModule;", "getCachedSession", "T", "storage", "factory", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "checkSessionValidity", "", "session", "removeSession", "removeSessionFrom", "removeAllSessions", "includeLibraryModules", "removeUnstableDanglingFileSessions", "removeContextualDanglingFileSessions", "contextModule", "hasContextModule", "removeAllDanglingFileSessions", "removeAllScriptSessions", "removeAllScriptSessionsFrom", "removeAllSessionsFrom", "removeAllMatchingSessionsFrom", "shouldBeRemoved", "supportsIsolatedSessionCreation", "getSupportsIsolatedSessionCreation", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Z", "createSession", "createPlatformAwareSessionFactory", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirAbstractSessionFactory;", "dispose", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n+ 2 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n214#1:298\n215#1,4:300\n219#1:305\n214#1:306\n215#1,4:308\n219#1:313\n214#1:314\n215#1,4:316\n219#1:321\n214#1:322\n215#1,4:324\n219#1:329\n37#2,2:293\n37#2,2:295\n1#3:297\n1869#4:299\n1870#4:304\n1869#4:307\n1870#4:312\n1869#4:315\n1870#4:320\n1869#4:323\n1870#4:328\n1869#4,2:330\n1740#4,3:332\n1740#4,3:335\n1740#4,3:338\n1740#4,3:341\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n*L\n161#1:298\n161#1:300,4\n161#1:305\n175#1:306\n175#1:308,4\n175#1:313\n178#1:314\n178#1:316,4\n178#1:321\n204#1:322\n204#1:324,4\n204#1:329\n92#1:293,2\n109#1:295,2\n161#1:299\n161#1:304\n175#1:307\n175#1:312\n178#1:315\n178#1:320\n204#1:323\n204#1:328\n214#1:330,2\n255#1:332,3\n256#1:335,3\n257#1:338,3\n258#1:341,3\n*E\n"})
public final class LLFirSessionCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CleanableValueReferenceCache<KaModule, LLFirSession> sourceCache;
    @NotNull
    private final CleanableValueReferenceCache<KaModule, LLFirSession> binaryCache;
    @NotNull
    private final CleanableValueReferenceCache<KaModule, LLFirSession> danglingFileSessionCache;
    @NotNull
    private final CleanableValueReferenceCache<KaModule, LLFirSession> unstableDanglingFileSessionCache;

    public LLFirSessionCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sourceCache = this.createWeakValueCache();
        this.binaryCache = this.createSoftValueCache();
        this.danglingFileSessionCache = this.createWeakValueCache();
        this.unstableDanglingFileSessionCache = this.createWeakValueCache();
    }

    private final CleanableValueReferenceCache<KaModule, LLFirSession> createWeakValueCache() {
        return new CleanableWeakValueReferenceCache(LLFirSessionCache::createWeakValueCache$lambda$0);
    }

    private final CleanableValueReferenceCache<KaModule, LLFirSession> createSoftValueCache() {
        return new CleanableSoftValueReferenceCache(LLFirSessionCache::createSoftValueCache$lambda$1);
    }

    @NotNull
    public final LLFirSession getSession(@NotNull KaModule module2, boolean preferBinary) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        if (module2 instanceof KaBuiltinsModule && preferBinary) {
            return LLFirBuiltinsSessionFactory.Companion.getInstance(this.project).getBuiltinsSession(module2.getTargetPlatform());
        }
        if (module2 instanceof KaLibraryModule && (preferBinary || ((KaLibraryModule)module2).isSdk())) {
            return this.getCachedSession(module2, this.binaryCache, arg_0 -> LLFirSessionCache.getSession$lambda$2(this, module2, arg_0));
        }
        if (module2 instanceof KaDanglingFileModule) {
            return this.getDanglingFileCachedSession((KaDanglingFileModule)module2);
        }
        return this.getCachedSession(module2, this.sourceCache, (Function1)new Function1<KaModule, LLFirSession>((Object)this){

            public final LLFirSession invoke(KaModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
            }
        });
    }

    public static /* synthetic */ LLFirSession getSession$default(LLFirSessionCache lLFirSessionCache, KaModule kaModule, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lLFirSessionCache.getSession(kaModule, bl);
    }

    @NotNull
    public final LLFirSession getSessionNoCaching$low_level_api_fir(@NotNull KaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.createSession(module2);
    }

    private final LLFirSession getDanglingFileCachedSession(KaDanglingFileModule module2) {
        if (KaModuleKt.isStable(module2)) {
            return this.getCachedSession((KaModule)module2, this.danglingFileSessionCache, (Function1)new Function1<KaModule, LLFirSession>((Object)this){

                public final LLFirSession invoke(KaModule p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
                }
            });
        }
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        LLFirSession session2 = this.unstableDanglingFileSessionCache.compute(module2, (Function2<KaModule, LLFirSession, LLFirSession>)((Function2)(arg_0, arg_1) -> LLFirSessionCache.getDanglingFileCachedSession$lambda$3(module2, this, arg_0, arg_1)));
        if (session2 == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.checkSessionValidity(session2);
        return session2;
    }

    private final <T extends KaModule> LLFirSession getCachedSession(T module2, CleanableValueReferenceCache<KaModule, LLFirSession> storage, Function1<? super T, ? extends LLFirSession> factory2) {
        LLFirSession lLFirSession;
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        if (this.getSupportsIsolatedSessionCreation(module2)) {
            lLFirSession = storage.computeIfAbsent(module2, (Function1<KaModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$4(factory2, module2, arg_0)));
        } else {
            lLFirSession = storage.get(module2);
            if (lLFirSession == null) {
                LLFirSessionCache $this$getCachedSession_u24lambda_u246 = this;
                boolean bl = false;
                LLFirSession newSession = (LLFirSession)factory2.invoke(module2);
                lLFirSession = storage.computeIfAbsent(module2, (Function1<KaModule, LLFirSession>)((Function1)arg_0 -> LLFirSessionCache.getCachedSession$lambda$6$lambda$5(newSession, arg_0)));
            }
        }
        LLFirSession session2 = lLFirSession;
        this.checkSessionValidity(session2);
        return session2;
    }

    private final void checkSessionValidity(LLFirSession session2) {
        if (!session2.isValid()) {
            boolean bl = false;
            String string2 = "A session acquired via `getSession` should always be valid. Module: " + session2.getKtModule();
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final boolean removeSession(@NotNull KaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean didSourceSessionExist = this.removeSessionFrom(module2, this.sourceCache);
        boolean didBinarySessionExist = module2 instanceof KaLibraryModule && this.removeSessionFrom(module2, this.binaryCache);
        boolean didDanglingFileSessionExist = module2 instanceof KaDanglingFileModule && this.removeSessionFrom(module2, this.danglingFileSessionCache);
        boolean didUnstableDanglingFileSessionExist = module2 instanceof KaDanglingFileModule && this.removeSessionFrom(module2, this.unstableDanglingFileSessionCache);
        return didSourceSessionExist || didBinarySessionExist || didDanglingFileSessionExist || didUnstableDanglingFileSessionExist;
    }

    private final boolean removeSessionFrom(KaModule module2, CleanableValueReferenceCache<KaModule, LLFirSession> storage) {
        return storage.remove(module2) != null;
    }

    public final void removeAllSessions(boolean includeLibraryModules) {
        if (includeLibraryModules) {
            this.removeAllSessionsFrom(this.sourceCache);
            this.removeAllSessionsFrom(this.binaryCache);
        } else {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableValueReferenceCache<KaModule, LLFirSession> storage$iv = this.sourceCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KaModule module$iv = (KaModule)element$iv$iv;
                boolean bl = false;
                KaModule it = module$iv;
                boolean bl2 = false;
                if (!(!(it instanceof KaLibraryModule) && !(it instanceof KaLibrarySourceModule))) continue;
                storage$iv.remove(module$iv);
            }
        }
        this.removeAllDanglingFileSessions();
    }

    public final void removeUnstableDanglingFileSessions() {
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeContextualDanglingFileSessions(@NotNull KaModule contextModule) {
        Intrinsics.checkNotNullParameter((Object)contextModule, (String)"contextModule");
        this.removeUnstableDanglingFileSessions();
        if (contextModule instanceof KaDanglingFileModule) {
            LLFirSessionCache lLFirSessionCache = this;
            CleanableValueReferenceCache<KaModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KaModule module$iv = (KaModule)element$iv$iv;
                boolean bl = false;
                KaModule it = module$iv;
                boolean bl2 = false;
                if (!(it instanceof KaDanglingFileModule && this.hasContextModule((KaDanglingFileModule)it, contextModule))) continue;
                storage$iv.remove(module$iv);
            }
        } else {
            LLFirSessionCache this_$iv = this;
            CleanableValueReferenceCache<KaModule, LLFirSession> storage$iv = this.danglingFileSessionCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$forEach$iv$iv = storage$iv.getKeys();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                KaModule module$iv = (KaModule)element$iv$iv;
                boolean bl = false;
                KaModule it = module$iv;
                boolean bl3 = false;
                if (!(it instanceof KaDanglingFileModule && ((KaDanglingFileModule)it).isCodeFragment())) continue;
                storage$iv.remove(module$iv);
            }
        }
    }

    private final boolean hasContextModule(KaDanglingFileModule module2, KaModule contextModule) {
        boolean bl;
        block2: {
            LLFirSessionCache lLFirSessionCache = this;
            while (true) {
                KaModule candidate2;
                if (Intrinsics.areEqual((Object)(candidate2 = module2.getContextModule()), (Object)contextModule)) {
                    bl = true;
                    break block2;
                }
                if (!(candidate2 instanceof KaDanglingFileModule)) break;
                LLFirSessionCache lLFirSessionCache2 = lLFirSessionCache;
                KaDanglingFileModule kaDanglingFileModule = (KaDanglingFileModule)candidate2;
                KaModule kaModule = contextModule;
                lLFirSessionCache = lLFirSessionCache2;
                module2 = kaDanglingFileModule;
                contextModule = kaModule;
            }
            bl = false;
        }
        return bl;
    }

    public final void removeAllDanglingFileSessions() {
        this.removeAllSessionsFrom(this.danglingFileSessionCache);
        this.removeAllSessionsFrom(this.unstableDanglingFileSessionCache);
    }

    public final void removeAllScriptSessions() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeAllScriptSessionsFrom(this.sourceCache);
        this.removeAllScriptSessionsFrom(this.binaryCache);
    }

    private final void removeAllScriptSessionsFrom(CleanableValueReferenceCache<KaModule, LLFirSession> storage) {
        LLFirSessionCache this_$iv = this;
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv$iv = storage.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            KaModule module$iv = (KaModule)element$iv$iv;
            boolean bl = false;
            KaModule it = module$iv;
            boolean bl2 = false;
            if (!(it instanceof KaScriptModule || it instanceof KaScriptDependencyModule)) continue;
            storage.remove(module$iv);
        }
    }

    private final void removeAllSessionsFrom(CleanableValueReferenceCache<KaModule, LLFirSession> storage) {
        storage.clear();
    }

    private final void removeAllMatchingSessionsFrom(CleanableValueReferenceCache<KaModule, LLFirSession> storage, Function1<? super KaModule, Boolean> shouldBeRemoved) {
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$forEach$iv = storage.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KaModule module2 = (KaModule)element$iv;
            boolean bl = false;
            if (!((Boolean)shouldBeRemoved.invoke((Object)module2)).booleanValue()) continue;
            storage.remove(module2);
        }
    }

    private final boolean getSupportsIsolatedSessionCreation(KaModule $this$supportsIsolatedSessionCreation) {
        return !($this$supportsIsolatedSessionCreation instanceof KaDanglingFileModule);
    }

    private final LLFirSession createSession(KaModule module2) {
        LLFirSession lLFirSession;
        LLFirAbstractSessionFactory sessionFactory = this.createPlatformAwareSessionFactory(module2);
        KaModule kaModule = module2;
        if (kaModule instanceof KaSourceModule) {
            lLFirSession = sessionFactory.createSourcesSession((KaSourceModule)module2);
        } else if (kaModule instanceof KaBuiltinsModule) {
            lLFirSession = sessionFactory.createLibrarySession(module2);
        } else if (kaModule instanceof KaLibraryModule) {
            lLFirSession = ((KaLibraryModule)module2).isSdk() ? (LLFirSession)sessionFactory.createBinaryLibrarySession((KaLibraryModule)module2) : (LLFirSession)sessionFactory.createLibrarySession(module2);
        } else if (kaModule instanceof KaLibrarySourceModule) {
            lLFirSession = sessionFactory.createLibrarySession(module2);
        } else if (kaModule instanceof KaScriptModule) {
            lLFirSession = sessionFactory.createScriptSession((KaScriptModule)module2);
        } else if (kaModule instanceof KaDanglingFileModule) {
            LLFirSession contextSession = this.getSession(((KaDanglingFileModule)module2).getContextModule(), false);
            lLFirSession = sessionFactory.createDanglingFileSession((KaDanglingFileModule)module2, contextSession);
        } else if (kaModule instanceof KaNotUnderContentRootModule) {
            lLFirSession = sessionFactory.createNotUnderContentRootResolvableSession((KaNotUnderContentRootModule)module2);
        } else {
            throw new IllegalStateException(("Unexpected module kind: " + Reflection.getOrCreateKotlinClass(module2.getClass()).getSimpleName()).toString());
        }
        return lLFirSession;
    }

    private final LLFirAbstractSessionFactory createPlatformAwareSessionFactory(KaModule module2) {
        LLFirAbstractSessionFactory lLFirAbstractSessionFactory;
        SimplePlatform it;
        boolean bl;
        boolean $i$f$all;
        Iterable $this$all$iv;
        TargetPlatform targetPlatform;
        block18: {
            targetPlatform = module2.getTargetPlatform();
            $this$all$iv = targetPlatform;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (SimplePlatform)element$iv;
                    boolean bl2 = false;
                    if (it instanceof JvmPlatform) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            lLFirAbstractSessionFactory = new LLFirJvmSessionFactory(this.project);
        } else {
            boolean bl3;
            block19: {
                $this$all$iv = targetPlatform;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (SimplePlatform)element$iv;
                        boolean bl4 = false;
                        if (it instanceof JsPlatform) continue;
                        bl3 = false;
                        break block19;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                lLFirAbstractSessionFactory = new LLFirJsSessionFactory(this.project);
            } else {
                boolean bl5;
                block20: {
                    $this$all$iv = targetPlatform;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (SimplePlatform)element$iv;
                            boolean bl6 = false;
                            if (it instanceof WasmPlatform) continue;
                            bl5 = false;
                            break block20;
                        }
                        bl5 = true;
                    }
                }
                if (bl5) {
                    lLFirAbstractSessionFactory = new LLFirWasmSessionFactory(this.project);
                } else {
                    boolean bl7;
                    block21: {
                        $this$all$iv = targetPlatform;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                it = (SimplePlatform)element$iv;
                                boolean bl8 = false;
                                if (it instanceof NativePlatform) continue;
                                bl7 = false;
                                break block21;
                            }
                            bl7 = true;
                        }
                    }
                    lLFirAbstractSessionFactory = bl7 ? (LLFirAbstractSessionFactory)new LLFirNativeSessionFactory(this.project) : (LLFirAbstractSessionFactory)new LLFirCommonSessionFactory(this.project);
                }
            }
        }
        return lLFirAbstractSessionFactory;
    }

    public void dispose() {
    }

    private static final ValueReferenceCleaner createWeakValueCache$lambda$0(LLFirSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LLFirSessionCleaner(it.getRequestedDisposableOrNull$low_level_api_fir());
    }

    private static final ValueReferenceCleaner createSoftValueCache$lambda$1(LLFirSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LLFirSessionCleaner(it.getRequestedDisposableOrNull$low_level_api_fir());
    }

    private static final LLFirSession getSession$lambda$2(LLFirSessionCache this$0, KaModule $module, KaLibraryModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createPlatformAwareSessionFactory($module).createBinaryLibrarySession((KaLibraryModule)$module);
    }

    private static final LLFirSession getDanglingFileCachedSession$lambda$3(KaDanglingFileModule $module, LLFirSessionCache this$0, KaModule kaModule, LLFirSession existingSession) {
        Intrinsics.checkNotNullParameter((Object)kaModule, (String)"<unused var>");
        return existingSession instanceof LLFirDanglingFileSession && ((LLFirDanglingFileSession)existingSession).getModificationStamp() == $module.getFile().getModificationStamp() ? existingSession : this$0.createSession($module);
    }

    private static final LLFirSession getCachedSession$lambda$4(Function1 $factory, KaModule $module, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LLFirSession)$factory.invoke((Object)$module);
    }

    private static final LLFirSession getCachedSession$lambda$6$lambda$5(LLFirSession $newSession, KaModule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $newSession;
    }

    public static final /* synthetic */ LLFirSession access$createSession(LLFirSessionCache $this, KaModule module2) {
        return $this.createSession(module2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    @SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,292:1\n30#2,3:293\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion\n*L\n41#1:293,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LLFirSessionCache> serviceClass$iv = LLFirSessionCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (LLFirSessionCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

