/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCallGenerator;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/JvmInvokeDynamic;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "<init>", "()V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "generateBootstrapMethodArg", "", "element", "Lorg/jetbrains/kotlin/ir/expressions/IrVarargElement;", "evalBootstrapArgumentIntrinsicCall", "irCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "evalMethodType", "Lorg/jetbrains/org/objectweb/asm/Type;", "evalMethodHandle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "generateMethodHandle", "irRawFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRawFunctionReference;", "evalOriginalMethodType", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nJvmInvokeDynamic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmInvokeDynamic.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/JvmInvokeDynamic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,124:1\n1563#2:125\n1634#2,3:126\n37#3:129\n36#3,3:130\n*S KotlinDebug\n*F\n+ 1 JvmInvokeDynamic.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/JvmInvokeDynamic\n*L\n39#1:125\n39#1:126,3\n40#1:129\n40#1:130,3\n*E\n"})
public final class JvmInvokeDynamic
extends IntrinsicMethod {
    @NotNull
    public static final JvmInvokeDynamic INSTANCE = new JvmInvokeDynamic();

    private JvmInvokeDynamic() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen, @NotNull BlockInfo data) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)codegen, (String)"codegen");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrExpression irExpression = expression2.getValueArgument(0);
        IrCall irCall = irExpression instanceof IrCall ? (IrCall)irExpression : null;
        if (irCall == null) {
            JvmInvokeDynamic.invoke$fail(expression2, "'dynamicCall' is expected to be a call");
            throw new KotlinNothingValueException();
        }
        IrCall dynamicCall = irCall;
        IrSimpleFunction dynamicCallee = (IrSimpleFunction)dynamicCall.getSymbol().getOwner();
        if (!Intrinsics.areEqual((Object)dynamicCallee.getParent(), (Object)codegen.getContext().getIr().getSymbols().getKotlinJvmInternalInvokeDynamicPackage()) || !Intrinsics.areEqual((Object)dynamicCallee.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getINVOKEDYNAMIC_CALL_TARGET())) {
            JvmInvokeDynamic.invoke$fail(expression2, "Unexpected dynamicCallee: '" + RenderIrElementKt.render$default(dynamicCallee, null, 1, null) + '\'');
            throw new KotlinNothingValueException();
        }
        IrExpression irExpression2 = expression2.getValueArgument(1);
        IrCall irCall2 = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
        if (irCall2 == null) {
            JvmInvokeDynamic.invoke$fail(expression2, "'bootstrapMethodHandle' should be a call");
            throw new KotlinNothingValueException();
        }
        IrCall bootstrapMethodHandleArg = irCall2;
        Handle bootstrapMethodHandle = this.evalMethodHandle(bootstrapMethodHandleArg);
        Object object = expression2.getValueArgument(2);
        IrVararg irVararg = object instanceof IrVararg ? (IrVararg)object : null;
        if (irVararg == null) {
            JvmInvokeDynamic.invoke$fail(expression2, "'bootstrapMethodArgs' is expected to be a vararg");
            throw new KotlinNothingValueException();
        }
        IrVararg bootstrapMethodArgs = irVararg;
        object = bootstrapMethodArgs.getElements();
        boolean $i$f$map = false;
        void var12_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.generateBootstrapMethodArg((IrVarargElement)it, codegen));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] asmBootstrapMethodArgs = thisCollection$iv.toArray(new Object[0]);
        Method dynamicCalleeMethod = codegen.getMethodSignatureMapper().mapAsmMethod(dynamicCallee);
        IrCallGenerator.DefaultCallGenerator dynamicCallGenerator = IrCallGenerator.DefaultCallGenerator.INSTANCE;
        Type[] dynamicCalleeArgumentTypes = dynamicCalleeMethod.getArgumentTypes();
        int n = ((Collection)dynamicCallee.getValueParameters()).size();
        for (int i2 = 0; i2 < n; ++i2) {
            IrExpression dynamicCalleeArgument;
            IrValueParameter dynamicCalleeParameter = dynamicCallee.getValueParameters().get(i2);
            if (dynamicCall.getValueArgument(i2) == null) {
                JvmInvokeDynamic.invoke$fail(expression2, "No argument #" + i2 + " in 'dynamicCall'");
                throw new KotlinNothingValueException();
            }
            Intrinsics.checkNotNull((Object)dynamicCalleeArgumentTypes);
            Type[] typeArray = dynamicCalleeArgumentTypes;
            if (!(0 <= i2 ? i2 < typeArray.length : false)) {
                int it = i2;
                boolean bl = false;
                JvmInvokeDynamic.invoke$fail(expression2, "No argument type #" + i2 + " in dynamic callee: " + dynamicCalleeMethod);
                throw new KotlinNothingValueException();
            }
            Type dynamicCalleeArgumentType = typeArray[i2];
            Intrinsics.checkNotNull((Object)dynamicCalleeArgumentType);
            dynamicCallGenerator.genValueAndPut(dynamicCalleeParameter, dynamicCalleeArgument, dynamicCalleeArgumentType, codegen, data);
        }
        codegen.getMv().invokedynamic(dynamicCalleeMethod.getName(), dynamicCalleeMethod.getDescriptor(), bootstrapMethodHandle, asmBootstrapMethodArgs);
        Type type2 = dynamicCalleeMethod.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getReturnType(...)");
        return new MaterialValue(codegen, type2, expression2.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object generateBootstrapMethodArg(IrVarargElement element, ExpressionCodegen codegen) {
        Object object;
        IrVarargElement irVarargElement = element;
        if (irVarargElement instanceof IrRawFunctionReference) {
            object = this.generateMethodHandle((IrRawFunctionReference)element, codegen);
            return object;
        } else {
            if (irVarargElement instanceof IrCall) {
                object = this.evalBootstrapArgumentIntrinsicCall((IrCall)element, codegen);
                if (object != null) return object;
                throw new AssertionError((Object)("Unexpected callee in bootstrap method argument:\n" + DumpIrTreeKt.dump$default(element, null, 1, null)));
            }
            if (!(irVarargElement instanceof IrConst)) throw new AssertionError((Object)("Unexpected bootstrap method argument:\n" + DumpIrTreeKt.dump$default(element, null, 1, null)));
            IrConstKind irConstKind = ((IrConst)element).getKind();
            if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Byte.INSTANCE)) {
                Object object2 = ((IrConst)element).getValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Byte");
                object = Integer.valueOf(((Byte)object2).byteValue());
                return object;
            } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Short.INSTANCE)) {
                Object object3 = ((IrConst)element).getValue();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Short");
                object = Integer.valueOf(((Short)object3).shortValue());
                return object;
            } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Int.INSTANCE)) {
                Object object4 = ((IrConst)element).getValue();
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.Int");
                object = (Integer)object4;
                return object;
            } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Long.INSTANCE)) {
                Object object5 = ((IrConst)element).getValue();
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.Long");
                object = (Long)object5;
                return object;
            } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Float.INSTANCE)) {
                Object object6 = ((IrConst)element).getValue();
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type kotlin.Float");
                object = (Float)object6;
                return object;
            } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Double.INSTANCE)) {
                Object object7 = ((IrConst)element).getValue();
                Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type kotlin.Double");
                object = (Double)object7;
                return object;
            } else {
                if (!Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.String.INSTANCE)) throw new AssertionError((Object)("Unexpected constant expression in bootstrap method argument:\n" + DumpIrTreeKt.dump$default(element, null, 1, null)));
                Object object8 = ((IrConst)element).getValue();
                Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type kotlin.String");
                object = (String)object8;
            }
        }
        return object;
    }

    private final Object evalBootstrapArgumentIntrinsicCall(IrCall irCall, ExpressionCodegen codegen) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = irCall.getSymbol();
        return Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)codegen.getContext().getIr().getSymbols().getJvmOriginalMethodTypeIntrinsic()) ? this.evalOriginalMethodType(irCall, codegen) : (Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)codegen.getContext().getIr().getSymbols().getJvmMethodType()) ? this.evalMethodType(irCall) : (Intrinsics.areEqual((Object)irSimpleFunctionSymbol, (Object)codegen.getContext().getIr().getSymbols().getJvmMethodHandle()) ? this.evalMethodHandle(irCall) : null));
    }

    private final Type evalMethodType(IrCall irCall) {
        String descriptor = JvmIrUtilsKt.getStringConstArgument(irCall, 0);
        Type type2 = Type.getMethodType((String)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getMethodType(...)");
        return type2;
    }

    private final Handle evalMethodHandle(IrCall irCall) {
        int tag = JvmIrUtilsKt.getIntConstArgument(irCall, 0);
        String owner = JvmIrUtilsKt.getStringConstArgument(irCall, 1);
        String name2 = JvmIrUtilsKt.getStringConstArgument(irCall, 2);
        String descriptor = JvmIrUtilsKt.getStringConstArgument(irCall, 3);
        boolean isInterface = JvmIrUtilsKt.getBooleanConstArgument(irCall, 4);
        return new Handle(tag, owner, name2, descriptor, isInterface);
    }

    private final Handle generateMethodHandle(IrRawFunctionReference irRawFunctionReference, ExpressionCodegen codegen) {
        return codegen.getMethodSignatureMapper().mapToMethodHandle(irRawFunctionReference.getSymbol().getOwner());
    }

    private final Type evalOriginalMethodType(IrCall irCall, ExpressionCodegen codegen) {
        IrExpression irExpression = irCall.getValueArgument(0);
        IrRawFunctionReference irRawFunctionReference = irExpression instanceof IrRawFunctionReference ? (IrRawFunctionReference)irExpression : null;
        if (irRawFunctionReference == null) {
            throw new AssertionError((Object)("Argument in " + ((IrSimpleFunction)irCall.getSymbol().getOwner()).getName() + " call is expected to be a raw function reference:\n" + DumpIrTreeKt.dump$default(irCall, null, 1, null)));
        }
        IrRawFunctionReference irRawFunRef = irRawFunctionReference;
        IrFunction irFun = irRawFunRef.getSymbol().getOwner();
        Method asmMethod = codegen.getMethodSignatureMapper().mapAsmMethod(irFun);
        Type type2 = Type.getMethodType((String)asmMethod.getDescriptor());
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getMethodType(...)");
        return type2;
    }

    private static final Void invoke$fail(IrFunctionAccessExpression $expression, String message) {
        throw new AssertionError((Object)(message + "; expression:\n" + DumpIrTreeKt.dump$default($expression, null, 1, null)));
    }
}

