/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.resolve.jvm.checkers.PolymorphicSignatureCallChecker;

@PhaseDescription(name="PolymorphicSignature")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001%B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\f\u0010!\u001a\u00020\u000f*\u00020 H\u0002J\u0016\u0010\"\u001a\u00020 *\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "isCast", "", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "element", "data", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isPolymorphicCall", "transform", "castReturnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Data", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nPolymorphicSignatureLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolymorphicSignatureLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,156:1\n1563#2:157\n1634#2,3:158\n1878#2,3:165\n238#3,4:161\n*S KotlinDebug\n*F\n+ 1 PolymorphicSignatureLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering\n*L\n123#1:157\n123#1:158,3\n151#1:165,3\n130#1:161,4\n*E\n"})
public final class PolymorphicSignatureLowering
extends IrTransformer<Data>
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public PolymorphicSignatureLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.PolymorphicSignature)) {
            irFile.transformChildren(this, new Data(null));
        }
    }

    private final boolean isCast(IrTypeOperatorCall $this$isCast) {
        return $this$isCast.getOperator() != IrTypeOperator.INSTANCEOF && $this$isCast.getOperator() != IrTypeOperator.NOT_INSTANCEOF;
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        element.transformChildren(this, Data.Companion.getNO_COERCION());
        return element;
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrExpression argument = expression2.getArgument();
        if (this.isCast(expression2)) {
            IrTypeOperatorCall irTypeOperatorCall;
            IrElement result2 = argument.transform((IrElementTransformer)this, new Data(expression2.getTypeOperand()));
            if (argument instanceof IrCall && this.isPolymorphicCall((IrCall)argument)) {
                return result2;
            }
            IrTypeOperatorCall $this$visitTypeOperator_u24lambda_u240 = irTypeOperatorCall = expression2;
            boolean bl = false;
            $this$visitTypeOperator_u24lambda_u240.setArgument((IrExpression)result2);
            return irTypeOperatorCall;
        }
        return super.visitTypeOperator(expression2, data);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        aTry.setTryResult((IrExpression)aTry.getTryResult().transform((IrElementTransformer)this, data));
        TransformKt.transformInPlace(aTry.getCatches(), (IrElementTransformer)this, data);
        IrExpression irExpression = aTry.getFinallyExpression();
        aTry.setFinallyExpression((IrExpression)(irExpression != null ? irExpression.transform((IrElementTransformer)this, Data.Companion.getNO_COERCION()) : null));
        return aTry;
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TransformKt.transformInPlace(expression2.getBranches(), (IrElementTransformer)this, data);
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List<IrStatement> statements = expression2.getStatements();
        int n = statements.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Data newData = i2 == CollectionsKt.getLastIndex(statements) ? data : Data.Companion.getNO_COERCION();
            IrElement irElement = statements.get(i2).transform(this, newData);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
            statements.set(i2, (IrStatement)irElement);
        }
        return expression2;
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.isPolymorphicCall(expression2) ? (IrElement)this.transform(expression2, data.getCoerceToType()) : super.visitCall(expression2, Data.Companion.getNO_COERCION());
    }

    private final boolean isPolymorphicCall(IrCall $this$isPolymorphicCall) {
        return IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isPolymorphicCall.getSymbol().getOwner(), PolymorphicSignatureCallChecker.polymorphicSignatureFqName);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall transform(IrCall $this$transform, IrType castReturnType) {
        IrType irType;
        List list;
        IrExpression it;
        boolean bl;
        IrSimpleFunction function2 = (IrSimpleFunction)$this$transform.getSymbol().getOwner();
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(function2.getValueParameters());
        boolean bl2 = bl = (irValueParameter != null ? irValueParameter.getVarargElementType() : null) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-PolymorphicSignatureLowering$transform$22 = false;
            String $i$a$-assert-PolymorphicSignatureLowering$transform$22 = "@PolymorphicSignature methods should only have a single vararg argument: " + DumpIrTreeKt.dump$default($this$transform, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-PolymorphicSignatureLowering$transform$22);
        }
        Object object = (IrVararg)$this$transform.getValueArgument(0);
        if (object != null && (object = ((IrVararg)object).getElements()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrExpression irExpression;
                IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                IrExpression irExpression2 = it;
                if (irExpression2 instanceof IrExpression) {
                    irExpression = it;
                } else if (irExpression2 instanceof IrSpreadElement) {
                    irExpression = ((IrSpreadElement)((Object)it)).getExpression();
                } else {
                    throw new AssertionError((Object)("unknown IrVarargElement: " + it));
                }
                collection.add(irExpression);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List values2 = list;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
        IrFunctionBuilder $this$transform_u24lambda_u2462 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl4 = false;
        $this$transform_u24lambda_u2462.updateFrom(function2);
        $this$transform_u24lambda_u2462.setName(function2.getName());
        $this$transform_u24lambda_u2462.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getPOLYMORPHIC_SIGNATURE_INSTANTIATION());
        if (IrTypePredicatesKt.isNullableAny(function2.getReturnType())) {
            irType = castReturnType;
            if (irType == null) {
                irType = function2.getReturnType();
            }
        } else {
            irType = function2.getReturnType();
        }
        $this$transform_u24lambda_u2462.setReturnType(irType);
        IrElementBase irElementBase = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        IrSimpleFunction $this$transform_u24lambda_u244 = irElementBase;
        boolean bl5 = false;
        $this$transform_u24lambda_u244.setParent(function2.getParent());
        IrUtilsKt.copyTypeParametersFrom$default($this$transform_u24lambda_u244, function2, null, null, 6, null);
        $this$transform_u24lambda_u244.setDispatchReceiverParameter(function2.getDispatchReceiverParameter());
        $this$transform_u24lambda_u244.setExtensionReceiverParameter(function2.getExtensionReceiverParameter());
        Iterator $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = ((Iterable)values2).iterator();
        int $this$transform_u24lambda_u2462 = 0;
        while ($i$a$-run-DeclarationBuildersKt$buildFun$1$iv22.hasNext()) {
            int i2 = $this$transform_u24lambda_u2462++;
            IrExpression value2 = (IrExpression)$i$a$-run-DeclarationBuildersKt$buildFun$1$iv22.next();
            DeclarationBuildersKt.addValueParameter((IrFunction)$this$transform_u24lambda_u244, "" + '$' + i2, value2.getType(), (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getPOLYMORPHIC_SIGNATURE_INSTANTIATION());
        }
        IrSimpleFunction fakeFunction = irElementBase;
        IrElementBase $this$transform_u24lambda_u245 = irElementBase = BuildersKt.fromSymbolOwner(IrCallImpl.Companion, $this$transform.getStartOffset(), $this$transform.getEndOffset(), fakeFunction.getReturnType(), fakeFunction.getSymbol(), $this$transform.getOrigin(), $this$transform.getSuperQualifierSymbol());
        boolean bl6 = false;
        IrExpressionsKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$transform_u24lambda_u245, $this$transform, 0, 2, null);
        ((IrMemberAccessExpression)$this$transform_u24lambda_u245).setDispatchReceiver($this$transform.getDispatchReceiver());
        ((IrMemberAccessExpression)$this$transform_u24lambda_u245).setExtensionReceiver($this$transform.getExtensionReceiver());
        Iterable $this$forEachIndexed$iv = values2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void p1;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (IrExpression)item$iv;
            int p0 = n;
            boolean bl7 = false;
            ((IrMemberAccessExpression)$this$transform_u24lambda_u245).putValueArgument(p0, (IrExpression)p1);
        }
        ((IrMemberAccessExpression)$this$transform_u24lambda_u245).transformChildren(this, Data.Companion.getNO_COERCION());
        return (IrCall)irElementBase;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data;", "", "coerceToType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getCoerceToType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "Companion", "backend.jvm.lower"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final IrType coerceToType;
        @NotNull
        private static final Data NO_COERCION = new Data(null);

        public Data(@Nullable IrType coerceToType) {
            this.coerceToType = coerceToType;
        }

        @Nullable
        public final IrType getCoerceToType() {
            return this.coerceToType;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data$Companion;", "", "<init>", "()V", "NO_COERCION", "Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data;", "getNO_COERCION", "()Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering$Data;", "backend.jvm.lower"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Data getNO_COERCION() {
                return NO_COERCION;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

