/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.modules.Module;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/cli/common/CliModuleVisibilityManagerImpl;", "Lorg/jetbrains/kotlin/load/kotlin/ModuleVisibilityManager;", "Lcom/intellij/openapi/Disposable;", "enabled", "", "<init>", "(Z)V", "getEnabled", "()Z", "chunk", "", "Lorg/jetbrains/kotlin/modules/Module;", "getChunk", "()Ljava/util/List;", "friendPaths", "", "getFriendPaths", "addModule", "", "module", "addFriendPath", "path", "dispose", "cli-base"})
public final class CliModuleVisibilityManagerImpl
implements ModuleVisibilityManager,
Disposable {
    private final boolean enabled;
    @NotNull
    private final List<Module> chunk;
    @NotNull
    private final List<String> friendPaths;

    public CliModuleVisibilityManagerImpl(boolean enabled) {
        this.enabled = enabled;
        this.chunk = new ArrayList();
        this.friendPaths = new ArrayList();
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public List<Module> getChunk() {
        return this.chunk;
    }

    @NotNull
    public List<String> getFriendPaths() {
        return this.friendPaths;
    }

    @Override
    public void addModule(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.getChunk().add(module2);
    }

    @Override
    public void addFriendPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Collection collection = this.getFriendPaths();
        String string2 = new File(path).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        collection.add(string2);
    }

    public void dispose() {
        this.getChunk().clear();
    }
}

