/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.ConstantArgumentKind;
import org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConstPropertyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,74:1\n54#2:75\n*S KotlinDebug\n*F\n+ 1 FirConstPropertyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker\n*L\n28#1:75\n*E\n"})
public final class FirConstPropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirConstPropertyChecker INSTANCE = new FirConstPropertyChecker();

    private FirConstPropertyChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        KtDiagnosticFactory0 ktDiagnosticFactory0;
        KtSourceElement source;
        ClassKind classKind;
        FirModifier<?> it;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isConst$iv = declaration;
        boolean $i$f$isConst = false;
        if (!$this$isConst$iv.getStatus().isConst()) {
            return;
        }
        if (declaration.isVar()) {
            FirModifier<?> constModifier;
            FirElement firElement = declaration;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.CONST_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"CONST_KEYWORD");
            FirModifier<?> firModifier = constModifier = FirKeywordUtilsKt.getModifier(firElement, ktModifierKeywordToken);
            if (firModifier != null) {
                it = firModifier;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)it.getToken(), (Object)"vars", (DiagnosticContext)context, null, 32, null);
            }
        }
        FirRegularClass firRegularClass = (it = CollectionsKt.lastOrNull(context.getContainingDeclarations())) instanceof FirRegularClass ? (FirRegularClass)((Object)it) : null;
        ClassKind classKind2 = classKind = firRegularClass != null ? firRegularClass.getClassKind() : null;
        if (classKind != ClassKind.OBJECT && context.getContainingDeclarations().size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getCONST_VAL_NOT_TOP_LEVEL_OR_OBJECT(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        FirPropertyAccessor firPropertyAccessor = declaration.getGetter();
        KtSourceElement ktSourceElement = source = firPropertyAccessor != null ? firPropertyAccessor.getSource() : null;
        if (source != null && !(source.getKind() instanceof KtFakeSourceElementKind)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONST_VAL_WITH_GETTER(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        if (declaration.getDelegate() != null) {
            FirExpression firExpression = declaration.getDelegate();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null), FirErrors.INSTANCE.getCONST_VAL_WITH_DELEGATE(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        FirExpression initializer = declaration.getInitializer();
        if (initializer == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getCONST_VAL_WITHOUT_INITIALIZER(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context.getSession(), null, 2, null);
        if (!(type2 instanceof ConeErrorType) && !FirConstChecksKt.canBeUsedForConstVal(type2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getTYPE_CANT_BE_USED_FOR_CONST_VAL(), (Object)FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), (DiagnosticContext)context, null, 16, null);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[FirConstChecksKt.computeConstantExpressionKind(initializer, context.getSession(), true).ordinal()]) {
            case 1: 
            case 2: {
                return;
            }
            case 3: {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getNON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION();
                break;
            }
            default: {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getCONST_VAL_WITH_NON_CONST_INITIALIZER();
            }
        }
        KtDiagnosticFactory0 errorKind = ktDiagnosticFactory0;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)initializer.getSource(), errorKind, (DiagnosticContext)context, null, 8, null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantArgumentKind.values().length];
            try {
                nArray[ConstantArgumentKind.VALID_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.RESOLUTION_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantArgumentKind.NOT_CONST_VAL_IN_CONST_EXPRESSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

