/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransactionKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IrTranslationResultMap;
import org.jetbrains.kotlin.incremental.PackageMetadataMap;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDataProvider;
import org.jetbrains.kotlin.incremental.TranslationResultMap;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.incremental.js.IrTranslationResultValue;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesFqNameMap;
import org.jetbrains.kotlin.incremental.storage.SourceToFqNameMap;
import org.jetbrains.kotlin.incremental.storage.SourceToJsOutputMap;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 E2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001EB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040-H\u0016J\"\u0010.\u001a\u00020+2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u00040-2\u0006\u00105\u001a\u00020\u0004J\u0016\u00106\u001a\u00020+2\u0006\u00107\u001a\u0002082\u0006\u00102\u001a\u000203J\u0018\u00109\u001a\u00020+2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0002H\u0002J\u0010\u0010<\u001a\u00020+2\u0006\u00102\u001a\u000203H\u0016J\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020100J\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020$00J\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020@00J\u0014\u0010A\u001a\u00020+2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001ej\b\u0012\u0004\u0012\u00020\u0004`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R$\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/name/FqName;", "cachesDir", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "protoData", "Lorg/jetbrains/kotlin/incremental/ProtoDataProvider;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "translationResults", "Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "irTranslationResults", "Lorg/jetbrains/kotlin/incremental/IrTranslationResultMap;", "packageMetadata", "Lorg/jetbrains/kotlin/incremental/PackageMetadataMap;", "sourceToJsOutputsMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToJsOutputMap;", "dirtySources", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "headerFile", "getHeaderFile", "()Ljava/io/File;", "value", "", "header", "getHeader", "()[B", "setHeader", "([B)V", "markDirty", "", "removedAndCompiledSources", "", "compare", "translatedFiles", "", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "getOutputsBySource", "sourceFile", "compareAndUpdate", "incrementalResults", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumerImpl;", "registerOutputForFile", "srcFile", "name", "clearCacheForRemovedClasses", "nonDirtyPackageParts", "", "nonDirtyIrParts", "Lorg/jetbrains/kotlin/incremental/js/IrTranslationResultValue;", "updateSourceToOutputMap", "generatedFiles", "", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "Companion", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nIncrementalJsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalJsCache.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,412:1\n1869#2:413\n1563#2:414\n1634#2,3:415\n2423#2,14:418\n1870#2:432\n1869#2,2:434\n1#3:433\n*S KotlinDebug\n*F\n+ 1 IncrementalJsCache.kt\norg/jetbrains/kotlin/incremental/IncrementalJsCache\n*L\n79#1:413\n82#1:414\n82#1:415,3\n82#1:418,14\n79#1:432\n146#1:434,2\n*E\n"})
public class IncrementalJsCache
extends AbstractIncrementalCache<FqName> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtoDataProvider protoData;
    @NotNull
    private final SourceToFqNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesFqNameMap dirtyOutputClassesMap;
    @NotNull
    private final TranslationResultMap translationResults;
    @NotNull
    private final IrTranslationResultMap irTranslationResults;
    @NotNull
    private final PackageMetadataMap packageMetadata;
    @NotNull
    private final SourceToJsOutputMap sourceToJsOutputsMap;
    @NotNull
    private final HashSet<File> dirtySources;
    @NotNull
    private static final String TRANSLATION_RESULT_MAP = "translation-result";
    @NotNull
    private static final String IR_TRANSLATION_RESULT_MAP = "ir-translation-result";
    @NotNull
    private static final String INLINE_FUNCTIONS = "inline-functions";
    @NotNull
    private static final String HEADER_FILE_NAME = "header.meta";
    @NotNull
    private static final String PACKAGE_META_FILE = "packages-meta";
    @NotNull
    private static final String SOURCE_TO_JS_OUTPUT = "source-to-js-output";

    public IncrementalJsCache(@NotNull File cachesDir, @NotNull IncrementalCompilationContext icContext, @NotNull SerializerExtensionProtocol serializerProtocol) {
        Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        Intrinsics.checkNotNullParameter((Object)serializerProtocol, (String)"serializerProtocol");
        super(cachesDir, icContext);
        this.protoData = new ProtoDataProvider(serializerProtocol);
        this.sourceToClassesMap = (SourceToFqNameMap)this.registerMap((BasicMap)new SourceToFqNameMap(this.getStorageFile(AbstractIncrementalCache.getSOURCE_TO_CLASSES()), icContext));
        this.dirtyOutputClassesMap = (DirtyClassesFqNameMap)this.registerMap((BasicMap)new DirtyClassesFqNameMap(this.getStorageFile(AbstractIncrementalCache.getDIRTY_OUTPUT_CLASSES()), icContext));
        this.translationResults = (TranslationResultMap)this.registerMap((BasicMap)new TranslationResultMap(this.getStorageFile(TRANSLATION_RESULT_MAP), this.protoData, icContext));
        this.irTranslationResults = (IrTranslationResultMap)this.registerMap((BasicMap)new IrTranslationResultMap(this.getStorageFile(IR_TRANSLATION_RESULT_MAP), icContext));
        this.packageMetadata = (PackageMetadataMap)this.registerMap((BasicMap)new PackageMetadataMap(this.getStorageFile(PACKAGE_META_FILE), icContext));
        this.sourceToJsOutputsMap = (SourceToJsOutputMap)this.registerMap((BasicMap)new SourceToJsOutputMap(this.getStorageFile(SOURCE_TO_JS_OUTPUT), icContext));
        this.dirtySources = new HashSet();
    }

    @NotNull
    public SourceToFqNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesFqNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getHeaderFile() {
        return new File(this.getCachesDir(), HEADER_FILE_NAME);
    }

    @NotNull
    public final byte[] getHeader() {
        return FilesKt.readBytes((File)this.getHeaderFile());
    }

    public final void setHeader(@NotNull byte[] value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        CompilationTransaction compilationTransaction = this.getIcContext().getTransaction();
        Path path = this.getHeaderFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        CompilationTransactionKt.writeBytes(compilationTransaction, path, value2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void markDirty(@NotNull Collection<? extends File> removedAndCompiledSources) {
        Intrinsics.checkNotNullParameter(removedAndCompiledSources, (String)"removedAndCompiledSources");
        Iterable $this$forEach$iv = removedAndCompiledSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it;
            Object v2;
            void $this$mapTo$iv$iv;
            File sourceFile = (File)element$iv;
            boolean bl = false;
            this.sourceToJsOutputsMap.remove(sourceFile);
            Object object = this.getSourceToClassesMap$kotlin_build_common().get(sourceFile);
            if (object == null) {
                object = SetsKt.emptySet();
            }
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FqName fqName = (FqName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object object2 = FqNamesUtilKt.parentOrNull((FqName)it2);
                if (object2 == null || (object2 = ((FqName)object2).asString()) == null) {
                    object2 = "";
                }
                collection.add(object2);
            }
            Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = minElem$iv;
                } else {
                    String it3 = (String)minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = it3.length();
                    do {
                        Object e$iv = iterator$iv.next();
                        String it4 = (String)e$iv;
                        $i$a$-minByOrNull-IncrementalJsCache$markDirty$1$2 = false;
                        int v$iv = it4.length();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = minElem$iv;
                }
            }
            if ((String)v2 == null) continue;
            boolean bl4 = false;
            this.packageMetadata.remove(it);
        }
        super.markDirty(removedAndCompiledSources);
        this.dirtySources.addAll(removedAndCompiledSources);
    }

    public final void compare(@NotNull Map<File, TranslationResultValue> translatedFiles, @NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter(translatedFiles, (String)"translatedFiles");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        for (Map.Entry<File, TranslationResultValue> entry : translatedFiles.entrySet()) {
            Object object;
            TranslationResultValue data;
            File srcFile;
            block5: {
                block4: {
                    srcFile = entry.getKey();
                    data = entry.getValue();
                    object = (TranslationResultValue)this.translationResults.get(srcFile);
                    if (object == null) break block4;
                    byte[] byArray = ((TranslationResultValue)object).getMetadata();
                    object = byArray;
                    if (byArray == null) break block4;
                    Map<ClassId, ProtoData> it = object;
                    boolean bl = false;
                    Map<ClassId, ProtoData> map = this.protoData.invoke(srcFile, (byte[])it);
                    object = map;
                    if (map != null) break block5;
                }
                object = MapsKt.emptyMap();
            }
            Map<ClassId, ProtoData> oldProtoMap = object;
            Map<ClassId, ProtoData> newProtoMap = this.protoData.invoke(srcFile, data.getMetadata());
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoMap.get(classId), newProtoMap.get(classId), false, null, 12, null);
            }
        }
    }

    @NotNull
    public final Collection<File> getOutputsBySource(@NotNull File sourceFile) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Object object = this.sourceToJsOutputsMap.get(sourceFile);
        if (object == null) {
            object = SetsKt.emptySet();
        }
        return (Collection)object;
    }

    public final void compareAndUpdate(@NotNull IncrementalResultsConsumerImpl incrementalResults, @NotNull ChangesCollector changesCollector) {
        File srcFile;
        Intrinsics.checkNotNullParameter((Object)incrementalResults, (String)"incrementalResults");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Map<File, TranslationResultValue> translatedFiles = incrementalResults.getPackageParts();
        for (Map.Entry<File, TranslationResultValue> entry : translatedFiles.entrySet()) {
            Object object;
            byte[] inlineData;
            byte[] binaryAst;
            byte[] binaryMetadata;
            block8: {
                block7: {
                    srcFile = entry.getKey();
                    TranslationResultValue data = entry.getValue();
                    this.dirtySources.remove(srcFile);
                    binaryMetadata = data.component1();
                    binaryAst = data.component2();
                    inlineData = data.component3();
                    object = (TranslationResultValue)this.translationResults.get(srcFile);
                    if (object == null) break block7;
                    byte[] byArray = ((TranslationResultValue)object).getMetadata();
                    object = byArray;
                    if (byArray == null) break block7;
                    Map<ClassId, ProtoData> it = object;
                    boolean bl = false;
                    Map<ClassId, ProtoData> map = this.protoData.invoke(srcFile, (byte[])it);
                    object = map;
                    if (map != null) break block8;
                }
                object = MapsKt.emptyMap();
            }
            Map<ClassId, ProtoData> oldProtoMap = object;
            Map<ClassId, ProtoData> newProtoMap = this.protoData.invoke(srcFile, binaryMetadata);
            for (Map.Entry<ClassId, ProtoData> entry2 : newProtoMap.entrySet()) {
                ClassId classId = entry2.getKey();
                ProtoData protoData = entry2.getValue();
                this.registerOutputForFile(srcFile, classId.asSingleFqName());
                if (!(protoData instanceof ClassProtoData)) continue;
                AbstractIncrementalCache.addToClassStorage$default(this, (ClassProtoData)protoData, srcFile, false, 4, null);
            }
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoMap.get(classId), newProtoMap.get(classId), false, null, 12, null);
            }
            this.translationResults.put(srcFile, binaryMetadata, binaryAst, inlineData);
        }
        for (Map.Entry<Object, Object> entry : incrementalResults.getPackageMetadata().entrySet()) {
            String packageName2 = (String)entry.getKey();
            byte[] metadata = (byte[])entry.getValue();
            this.packageMetadata.set(packageName2, metadata);
        }
        for (Map.Entry<Object, Object> entry : incrementalResults.getIrFileData().entrySet()) {
            srcFile = (File)entry.getKey();
            IrTranslationResultValue irData = (IrTranslationResultValue)entry.getValue();
            byte[] fileData = irData.component1();
            byte[] types2 = irData.component2();
            byte[] signatures2 = irData.component3();
            byte[] strings2 = irData.component4();
            byte[] declarations2 = irData.component5();
            byte[] bodies2 = irData.component6();
            byte[] fqn = irData.component7();
            byte[] fileMetadata = irData.component8();
            byte[] debugInfos2 = irData.component9();
            this.irTranslationResults.put(srcFile, fileData, types2, signatures2, strings2, declarations2, bodies2, fqn, fileMetadata, debugInfos2);
        }
    }

    private final void registerOutputForFile(File srcFile, FqName name2) {
        this.getSourceToClassesMap$kotlin_build_common().append(srcFile, name2);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(name2);
    }

    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Iterable $this$forEach$iv = this.dirtySources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            this.translationResults.remove(it, changesCollector);
            this.irTranslationResults.remove(it);
        }
        AbstractIncrementalCache.removeAllFromClassStorage$default(this, this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses(), changesCollector, false, 4, null);
        this.dirtySources.clear();
        this.getDirtyOutputClassesMap$kotlin_build_common().clear();
    }

    @NotNull
    public final Map<File, TranslationResultValue> nonDirtyPackageParts() {
        HashMap hashMap;
        HashMap $this$nonDirtyPackageParts_u24lambda_u247 = hashMap = new HashMap();
        boolean bl = false;
        for (File file2 : this.translationResults.getKeys()) {
            if (this.dirtySources.contains(file2)) continue;
            Object VALUE = this.translationResults.get(file2);
            Intrinsics.checkNotNull(VALUE);
            $this$nonDirtyPackageParts_u24lambda_u247.put(file2, VALUE);
        }
        return hashMap;
    }

    @NotNull
    public final Map<String, byte[]> packageMetadata() {
        HashMap hashMap;
        HashMap $this$packageMetadata_u24lambda_u248 = hashMap = new HashMap();
        boolean bl = false;
        for (String fqNameString : this.packageMetadata.keys()) {
            Object VALUE = this.packageMetadata.get(fqNameString);
            Intrinsics.checkNotNull(VALUE);
            $this$packageMetadata_u24lambda_u248.put(fqNameString, VALUE);
        }
        return hashMap;
    }

    @NotNull
    public final Map<File, IrTranslationResultValue> nonDirtyIrParts() {
        HashMap hashMap;
        HashMap $this$nonDirtyIrParts_u24lambda_u249 = hashMap = new HashMap();
        boolean bl = false;
        for (File file2 : this.irTranslationResults.getKeys()) {
            if (this.dirtySources.contains(file2)) continue;
            Object VALUE = this.irTranslationResults.get(file2);
            Intrinsics.checkNotNull(VALUE);
            $this$nonDirtyIrParts_u24lambda_u249.put(file2, VALUE);
        }
        return hashMap;
    }

    public final void updateSourceToOutputMap(@NotNull Iterable<? extends GeneratedFile> generatedFiles) {
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        for (GeneratedFile generatedFile : generatedFiles) {
            for (File source : generatedFile.getSourceFiles()) {
                if (!this.dirtySources.contains(source)) continue;
                this.sourceToJsOutputsMap.append(source, generatedFile.getOutputFile());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache$Companion;", "", "<init>", "()V", "TRANSLATION_RESULT_MAP", "", "IR_TRANSLATION_RESULT_MAP", "INLINE_FUNCTIONS", "HEADER_FILE_NAME", "PACKAGE_META_FILE", "SOURCE_TO_JS_OUTPUT", "hasHeaderFile", "", "cachesDir", "Ljava/io/File;", "kotlin-build-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasHeaderFile(@NotNull File cachesDir) {
            Intrinsics.checkNotNullParameter((Object)cachesDir, (String)"cachesDir");
            return new File(cachesDir, IncrementalJsCache.HEADER_FILE_NAME).exists();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

