/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/DeadCodeElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "getHasChanges", "()Z", "setHasChanges", "(Z)V", "apply", "EliminationVisitor", "js.translator"})
public final class DeadCodeElimination {
    @NotNull
    private final JsStatement root;
    private boolean hasChanges;

    public DeadCodeElimination(@NotNull JsStatement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    public final boolean getHasChanges() {
        return this.hasChanges;
    }

    public final void setHasChanges(boolean bl) {
        this.hasChanges = bl;
    }

    public final boolean apply() {
        new EliminationVisitor().accept((JsNode)this.root);
        return this.hasChanges;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020)H\u0016J \u0010*\u001a\u00020\u00152\b\u0010+\u001a\u0004\u0018\u00010!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0-H\u0002J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020;H\u0016R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/DeadCodeElimination$EliminationVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "<init>", "(Lorg/jetbrains/kotlin/js/inline/clean/DeadCodeElimination;)V", "breakLabels", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getBreakLabels", "()Ljava/util/Set;", "setBreakLabels", "(Ljava/util/Set;)V", "localBreakExists", "", "getLocalBreakExists", "()Z", "setLocalBreakExists", "(Z)V", "canContinue", "getCanContinue", "setCanContinue", "visitBreak", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsBreak;", "visitContinue", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "visitLabel", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "visitStatements", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "visitWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsWhile;", "visitDoWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "visitFor", "Lorg/jetbrains/kotlin/js/backend/ast/JsFor;", "visitForIn", "Lorg/jetbrains/kotlin/js/backend/ast/JsForIn;", "visitLoop", "body", "additionalExitCondition", "Lkotlin/Function0;", "visitIf", "Lorg/jetbrains/kotlin/js/backend/ast/JsIf;", "visitTry", "Lorg/jetbrains/kotlin/js/backend/ast/JsTry;", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "visit", "Lorg/jetbrains/kotlin/js/backend/ast/JsSwitch;", "visitThrow", "Lorg/jetbrains/kotlin/js/backend/ast/JsThrow;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "visitVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "js.translator"})
    @SourceDebugExtension(value={"SMAP\nDeadCodeElimination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeadCodeElimination.kt\norg/jetbrains/kotlin/js/inline/clean/DeadCodeElimination$EliminationVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1869#2,2:214\n*S KotlinDebug\n*F\n+ 1 DeadCodeElimination.kt\norg/jetbrains/kotlin/js/inline/clean/DeadCodeElimination$EliminationVisitor\n*L\n208#1:214,2\n*E\n"})
    public final class EliminationVisitor
    extends RecursiveJsVisitor {
        @NotNull
        private Set<JsName> breakLabels = new LinkedHashSet();
        private boolean localBreakExists;
        private boolean canContinue;

        @NotNull
        public final Set<JsName> getBreakLabels() {
            return this.breakLabels;
        }

        public final void setBreakLabels(@NotNull Set<JsName> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.breakLabels = set;
        }

        public final boolean getLocalBreakExists() {
            return this.localBreakExists;
        }

        public final void setLocalBreakExists(boolean bl) {
            this.localBreakExists = bl;
        }

        public final boolean getCanContinue() {
            return this.canContinue;
        }

        public final void setCanContinue(boolean bl) {
            this.canContinue = bl;
        }

        @Override
        public void visitBreak(@NotNull JsBreak x) {
            JsName name2;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNameRef jsNameRef = x.getLabel();
            JsName jsName = name2 = jsNameRef != null ? jsNameRef.getName() : null;
            if (name2 != null) {
                this.breakLabels.add(name2);
            } else {
                this.localBreakExists = true;
            }
            this.canContinue = false;
        }

        @Override
        public void visitContinue(@NotNull JsContinue x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            this.canContinue = false;
        }

        @Override
        public void visitLabel(@NotNull JsLabel x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            this.accept((JsNode)x.getStatement());
            if (!this.canContinue && this.breakLabels.contains(x.getName())) {
                this.canContinue = true;
            }
            this.breakLabels.remove(x.getName());
        }

        @Override
        public void visitBlock(@NotNull JsBlock x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            this.canContinue = true;
            List<JsStatement> list = x.getStatements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
            this.visitStatements(list);
        }

        private final void visitStatements(List<JsStatement> statements) {
            Iterator iterator2 = ((Iterable)statements).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index2 = n++;
                JsStatement statement = (JsStatement)iterator2.next();
                this.accept((JsNode)statement);
                if (this.canContinue) continue;
                List<JsStatement> removedStatements = statements.subList(index2 + 1, statements.size());
                if (!(!((Collection)removedStatements).isEmpty())) break;
                DeadCodeElimination.this.setHasChanges(true);
                removedStatements.clear();
                break;
            }
        }

        @Override
        public void visitWhile(@NotNull JsWhile x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            new EliminationVisitor().accept((JsNode)x.getCondition());
            this.visitLoop(x.getBody(), (Function0<Boolean>)((Function0)() -> EliminationVisitor.visitWhile$lambda$0(x)));
        }

        @Override
        public void visitDoWhile(@NotNull JsDoWhile x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            this.visitWhile(x);
        }

        @Override
        public void visitFor(@NotNull JsFor x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            new EliminationVisitor().accept((JsNode)x.getCondition());
            new EliminationVisitor().accept((JsNode)x.getInitExpression());
            new EliminationVisitor().accept((JsNode)x.getInitVars());
            new EliminationVisitor().accept((JsNode)x.getIncrementExpression());
            this.visitLoop(x.getBody(), (Function0<Boolean>)((Function0)EliminationVisitor::visitFor$lambda$1));
        }

        @Override
        public void visitForIn(@NotNull JsForIn x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            new EliminationVisitor().accept((JsNode)x.getIterExpression());
            this.visitLoop(x.getBody(), (Function0<Boolean>)((Function0)EliminationVisitor::visitForIn$lambda$2));
        }

        private final void visitLoop(JsStatement body2, Function0<Boolean> additionalExitCondition) {
            boolean localBreakExistsBackup = this.localBreakExists;
            this.localBreakExists = false;
            if (body2 != null) {
                this.accept((JsNode)body2);
            }
            if (!this.canContinue) {
                this.canContinue = (Boolean)additionalExitCondition.invoke() != false || this.localBreakExists;
            }
            this.localBreakExists = localBreakExistsBackup;
        }

        @Override
        public void visitIf(@NotNull JsIf x) {
            JsStatement elseStatement;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            new EliminationVisitor().accept((JsNode)x.getIfExpression());
            boolean result2 = false;
            this.accept((JsNode)x.getThenStatement());
            if (this.canContinue) {
                result2 = true;
            }
            if ((elseStatement = x.getElseStatement()) != null) {
                this.accept((JsNode)x.getElseStatement());
                if (this.canContinue) {
                    result2 = true;
                }
            } else {
                result2 = true;
            }
            this.canContinue = result2;
        }

        @Override
        public void visitTry(@NotNull JsTry x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            boolean result2 = false;
            this.accept((JsNode)x.getTryBlock());
            if (this.canContinue) {
                result2 = true;
            }
            for (JsCatch catchBlock : x.getCatches()) {
                this.accept((JsNode)catchBlock.getBody());
                if (!this.canContinue) continue;
                result2 = true;
            }
            JsBlock finallyBlock = x.getFinallyBlock();
            if (finallyBlock != null) {
                this.accept((JsNode)finallyBlock);
                if (!this.canContinue) {
                    result2 = false;
                }
            }
            this.canContinue = result2;
        }

        @Override
        public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            new EliminationVisitor().accept((JsNode)x.getExpression());
            this.canContinue = true;
        }

        @Override
        public void visit(@NotNull JsSwitch x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            new EliminationVisitor().accept((JsNode)x.getExpression());
            boolean localBreakExistsBackup = this.localBreakExists;
            boolean defaultCanContinue = true;
            boolean allCasesCantContinue = true;
            for (JsSwitchMember caseBlock : x.getCases()) {
                this.canContinue = true;
                List<JsStatement> list = caseBlock.getStatements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                this.visitStatements(list);
                if (!this.canContinue && this.localBreakExists) {
                    this.canContinue = true;
                }
                if (caseBlock instanceof JsDefault) {
                    defaultCanContinue = this.canContinue;
                    continue;
                }
                if (!allCasesCantContinue || !this.canContinue) continue;
                allCasesCantContinue = false;
            }
            this.canContinue = !allCasesCantContinue || defaultCanContinue;
            this.localBreakExists = localBreakExistsBackup;
        }

        @Override
        public void visitThrow(@NotNull JsThrow x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            this.canContinue = false;
        }

        @Override
        public void visitReturn(@NotNull JsReturn x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            this.canContinue = false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitVars(@NotNull JsVars x) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            List<JsVars.JsVar> list = x.getVars();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getVars(...)");
            Iterable iterable = list;
            DeadCodeElimination deadCodeElimination = DeadCodeElimination.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsVars.JsVar it = (JsVars.JsVar)element$iv;
                boolean bl = false;
                deadCodeElimination.new EliminationVisitor().accept((JsNode)it);
            }
            this.canContinue = true;
        }

        private static final boolean visitWhile$lambda$0(JsWhile $x) {
            JsExpression condition = $x.getCondition();
            return !(condition instanceof JsBooleanLiteral) || !((JsBooleanLiteral)condition).getValue();
        }

        private static final boolean visitFor$lambda$1() {
            return true;
        }

        private static final boolean visitForIn$lambda$2() {
            return true;
        }
    }
}

