/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bB!\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0000\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u000bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0019\u001a\u00020\u000bJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0000J\b\u0010\u001f\u001a\u00020\u0003H\u0016J\u0013\u0010 \u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "", "fqName", "", "safe", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;)V", "(Ljava/lang/String;)V", "parent", "shortName", "Lorg/jetbrains/kotlin/name/Name;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqNameUnsafe;Lorg/jetbrains/kotlin/name/Name;)V", "compute", "", "indexOfLastDotWithBackticksSupport", "", "asString", "isSafe", "", "()Z", "toSafe", "isRoot", "child", "name", "shortNameOrSpecial", "pathSegments", "", "startsWith", "segment", "other", "toString", "equals", "hashCode", "Companion", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nFqNameUnsafe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FqNameUnsafe.kt\norg/jetbrains/kotlin/name/FqNameUnsafe\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
public final class FqNameUnsafe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fqName;
    @Nullable
    private transient FqName safe;
    @Nullable
    private transient FqNameUnsafe parent;
    @Nullable
    private transient Name shortName;
    @NotNull
    private static final Name ROOT_NAME;
    @NotNull
    private static final Pattern SPLIT_BY_DOTS;

    public FqNameUnsafe(@NotNull String fqName, @NotNull FqName safe) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)safe, (String)"safe");
        this.fqName = fqName;
        this.safe = safe;
    }

    public FqNameUnsafe(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        this.fqName = fqName;
    }

    private FqNameUnsafe(String fqName, FqNameUnsafe parent2, Name shortName) {
        this.fqName = fqName;
        this.parent = parent2;
        this.shortName = shortName;
    }

    private final void compute() {
        int lastDot = this.indexOfLastDotWithBackticksSupport(this.fqName);
        if (lastDot >= 0) {
            String string2 = this.fqName.substring(lastDot + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this.shortName = Name.guessByFirstCharacter(string2);
            String string3 = this.fqName.substring(0, lastDot);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            this.parent = new FqNameUnsafe(string3);
        } else {
            this.shortName = Name.guessByFirstCharacter(this.fqName);
            this.parent = FqName.ROOT.toUnsafe();
        }
    }

    private final int indexOfLastDotWithBackticksSupport(String fqName) {
        boolean isBacktick = false;
        for (int index2 = fqName.length() - 1; index2 >= 0; --index2) {
            char c = fqName.charAt(index2);
            if (c == '.' && !isBacktick) {
                return index2;
            }
            if (c == '`') {
                isBacktick = !isBacktick;
                continue;
            }
            if (c != '\\') continue;
            --index2;
        }
        return -1;
    }

    @NotNull
    public final String asString() {
        return this.fqName;
    }

    public final boolean isSafe() {
        return this.safe != null || StringsKt.indexOf$default((CharSequence)this.asString(), (char)'<', (int)0, (boolean)false, (int)6, null) < 0;
    }

    @NotNull
    public final FqName toSafe() {
        FqName fqName = this.safe;
        if (fqName == null) {
            FqName fqName2;
            FqName it = fqName2 = new FqName(this);
            boolean bl = false;
            this.safe = it;
            fqName = fqName2;
        }
        return fqName;
    }

    public final boolean isRoot() {
        return ((CharSequence)this.fqName).length() == 0;
    }

    @NotNull
    public final FqNameUnsafe parent() {
        FqNameUnsafe fqNameUnsafe = this.parent;
        if (fqNameUnsafe != null) {
            FqNameUnsafe it = fqNameUnsafe;
            boolean bl = false;
            return it;
        }
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string2 = "root";
            throw new IllegalStateException(string2.toString());
        }
        this.compute();
        FqNameUnsafe fqNameUnsafe2 = this.parent;
        Intrinsics.checkNotNull((Object)fqNameUnsafe2);
        return fqNameUnsafe2;
    }

    @NotNull
    public final FqNameUnsafe child(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string2 = this.isRoot() ? name2.asString() : this.fqName + '.' + name2.asString();
        Intrinsics.checkNotNull((Object)string2);
        String childFqName = string2;
        return new FqNameUnsafe(childFqName, this, name2);
    }

    @NotNull
    public final Name shortName() {
        Name name2 = this.shortName;
        if (name2 != null) {
            Name it = name2;
            boolean bl = false;
            return it;
        }
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string2 = "root";
            throw new IllegalStateException(string2.toString());
        }
        this.compute();
        Name name3 = this.shortName;
        Intrinsics.checkNotNull((Object)name3);
        return name3;
    }

    @NotNull
    public final Name shortNameOrSpecial() {
        return this.isRoot() ? ROOT_NAME : this.shortName();
    }

    @NotNull
    public final List<Name> pathSegments() {
        return FqNameUnsafe.pathSegments$collectSegmentsOf(this);
    }

    public final boolean startsWith(@NotNull Name segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        if (this.isRoot()) {
            return false;
        }
        int firstDot = StringsKt.indexOf$default((CharSequence)this.fqName, (char)'.', (int)0, (boolean)false, (int)6, null);
        int fqNameFirstSegmentLength = firstDot == -1 ? this.fqName.length() : firstDot;
        String string2 = segment.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String segmentAsString = string2;
        return fqNameFirstSegmentLength == segmentAsString.length() && StringsKt.regionMatches$default((String)this.fqName, (int)0, (String)segmentAsString, (int)0, (int)fqNameFirstSegmentLength, (boolean)false, (int)16, null);
    }

    public final boolean startsWith(@NotNull FqNameUnsafe other) {
        int otherLength;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.isRoot()) {
            return false;
        }
        int thisLength = this.fqName.length();
        if (thisLength < (otherLength = other.fqName.length())) {
            return false;
        }
        return (thisLength == otherLength || this.fqName.charAt(otherLength) == '.') && StringsKt.regionMatches$default((String)this.fqName, (int)0, (String)other.fqName, (int)0, (int)otherLength, (boolean)false, (int)16, null);
    }

    @NotNull
    public String toString() {
        String string2;
        if (this.isRoot()) {
            String string3 = ROOT_NAME.asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        } else {
            string2 = this.fqName;
        }
        return string2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FqNameUnsafe)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fqName, (Object)((FqNameUnsafe)other).fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }

    private static final List<Name> pathSegments$collectSegmentsOf(FqNameUnsafe fqName) {
        if (fqName.isRoot()) {
            return new ArrayList();
        }
        List<Name> parentSegments = FqNameUnsafe.pathSegments$collectSegmentsOf(fqName.parent());
        parentSegments.add(fqName.shortName());
        return parentSegments;
    }

    @JvmStatic
    public static final boolean isValid(@Nullable String qualifiedName) {
        return Companion.isValid(qualifiedName);
    }

    @JvmStatic
    @NotNull
    public static final FqNameUnsafe topLevel(@NotNull Name shortName) {
        return Companion.topLevel(shortName);
    }

    public /* synthetic */ FqNameUnsafe(String fqName, FqNameUnsafe parent2, Name shortName, DefaultConstructorMarker $constructor_marker) {
        this(fqName, parent2, shortName);
    }

    static {
        Name name2 = Name.special("<root>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        ROOT_NAME = name2;
        Pattern pattern = Pattern.compile("\\.");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        SPLIT_BY_DOTS = pattern;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/name/FqNameUnsafe$Companion;", "", "<init>", "()V", "ROOT_NAME", "Lorg/jetbrains/kotlin/name/Name;", "SPLIT_BY_DOTS", "Ljava/util/regex/Pattern;", "isValid", "", "qualifiedName", "", "topLevel", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "shortName", "compiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isValid(@Nullable String qualifiedName) {
            return qualifiedName != null && StringsKt.indexOf$default((CharSequence)qualifiedName, (char)'/', (int)0, (boolean)false, (int)6, null) < 0 && StringsKt.indexOf$default((CharSequence)qualifiedName, (char)'*', (int)0, (boolean)false, (int)6, null) < 0;
        }

        @JvmStatic
        @NotNull
        public final FqNameUnsafe topLevel(@NotNull Name shortName) {
            Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
            String string2 = shortName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            return new FqNameUnsafe(string2, FqName.ROOT.toUnsafe(), shortName, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

