/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.FlexibleTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeVariance;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002'(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0012\u001a\u00060\rj\u0002`\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u001c\u0010\u0016\u001a\u00020\u00142\n\u0010\u0017\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\n\u0010\u0017\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002JP\u0010\u001f\u001a\u00020\u0014*\u00020\b2\u0006\u0010 \u001a\u00020\u000f2:\u0010!\u001a6\u0012\u0017\u0012\u00150\rj\u0002`\u000e\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00140\"H\u0002JP\u0010\u001f\u001a\u00020\u0014*\u00020%2\u0006\u0010 \u001a\u00020\u000f2:\u0010!\u001a6\u0012\u0017\u0012\u00150\rj\u0002`\u000e\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00140\"H\u0002J\f\u0010&\u001a\u00020\u000f*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f0\fj\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator;", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "postponedKtPrimitives", "", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "topLevelType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;Ljava/util/List;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;)V", "directions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/Variable;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "Lkotlin/collections/HashMap;", "getDirection", "typeVariable", "setupDirections", "", "topReturnType", "enterToNode", "variable", "direction", "getConstraintDependencies", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$NodeWithDirection;", "isInterestingConstraint", "", "constraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "visitType", "startDirection", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;", "opposite", "ResolveDirection", "NodeWithDirection", "resolution.common"})
@SourceDebugExtension(value={"SMAP\nTypeVariableDirectionCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeVariableDirectionCalculator.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1869#2,2:154\n*S KotlinDebug\n*F\n+ 1 TypeVariableDirectionCalculator.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator\n*L\n116#1:154,2\n*E\n"})
public final class TypeVariableDirectionCalculator {
    @NotNull
    private final VariableFixationFinder.Context c;
    @NotNull
    private final List<PostponedResolvedAtomMarker> postponedKtPrimitives;
    @NotNull
    private final HashMap<VariableWithConstraints, ResolveDirection> directions;

    public TypeVariableDirectionCalculator(@NotNull VariableFixationFinder.Context c, @NotNull List<? extends PostponedResolvedAtomMarker> postponedKtPrimitives, @NotNull KotlinTypeMarker topLevelType) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter(postponedKtPrimitives, (String)"postponedKtPrimitives");
        Intrinsics.checkNotNullParameter((Object)topLevelType, (String)"topLevelType");
        this.c = c;
        this.postponedKtPrimitives = postponedKtPrimitives;
        this.directions = new HashMap();
        this.setupDirections(topLevelType);
    }

    @NotNull
    public final ResolveDirection getDirection(@NotNull VariableWithConstraints typeVariable) {
        Intrinsics.checkNotNullParameter((Object)typeVariable, (String)"typeVariable");
        ResolveDirection resolveDirection = this.directions.getOrDefault(typeVariable, ResolveDirection.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)resolveDirection), (String)"getOrDefault(...)");
        return resolveDirection;
    }

    private final void setupDirections(KotlinTypeMarker topReturnType) {
        this.visitType(topReturnType, ResolveDirection.TO_SUBTYPE, (Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit>)((Function2)(arg_0, arg_1) -> TypeVariableDirectionCalculator.setupDirections$lambda$0(this, arg_0, arg_1)));
        for (PostponedResolvedAtomMarker postponedArgument : this.postponedKtPrimitives) {
            for (KotlinTypeMarker inputType : postponedArgument.getInputTypes()) {
                this.visitType(inputType, ResolveDirection.TO_SUBTYPE, (Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit>)((Function2)(arg_0, arg_1) -> TypeVariableDirectionCalculator.setupDirections$lambda$1(this, arg_0, arg_1)));
            }
        }
    }

    private final void enterToNode(VariableWithConstraints variable, ResolveDirection direction) {
        if (direction == ResolveDirection.UNKNOWN) {
            return;
        }
        ResolveDirection previous = this.directions.get(variable);
        if (previous != null) {
            if (previous != direction) {
                ((Map)this.directions).put(variable, ResolveDirection.UNKNOWN);
            }
            return;
        }
        ((Map)this.directions).put(variable, direction);
        for (NodeWithDirection nodeWithDirection : this.getConstraintDependencies(variable, direction)) {
            VariableWithConstraints otherVariable = nodeWithDirection.component1();
            ResolveDirection otherDirection = nodeWithDirection.component2();
            this.enterToNode(otherVariable, otherDirection);
        }
    }

    private final List<NodeWithDirection> getConstraintDependencies(VariableWithConstraints variable, ResolveDirection direction) {
        SmartList smartList;
        SmartList result2 = smartList = new SmartList();
        boolean bl = false;
        for (Constraint constraint : variable.getConstraints()) {
            if (!this.isInterestingConstraint(direction, constraint)) continue;
            this.visitType(constraint.getType(), direction, (Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit>)((Function2)(arg_0, arg_1) -> TypeVariableDirectionCalculator.getConstraintDependencies$lambda$3$lambda$2(result2, arg_0, arg_1)));
        }
        return smartList;
    }

    private final boolean isInterestingConstraint(ResolveDirection direction, Constraint constraint) {
        return !(direction == ResolveDirection.TO_SUBTYPE && constraint.getKind() == ConstraintKind.UPPER || direction == ResolveDirection.TO_SUPERTYPE && constraint.getKind() == ConstraintKind.LOWER);
    }

    private final void visitType(KotlinTypeMarker $this$visitType, ResolveDirection startDirection, Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit> action) {
        KotlinTypeMarker kotlinTypeMarker = $this$visitType;
        if (kotlinTypeMarker instanceof RigidTypeMarker) {
            this.visitType((RigidTypeMarker)$this$visitType, startDirection, action);
        } else if (kotlinTypeMarker instanceof FlexibleTypeMarker) {
            VariableFixationFinder.Context $this$visitType_u24lambda_u244 = this.c;
            boolean bl = false;
            this.visitType($this$visitType_u24lambda_u244.lowerBound((FlexibleTypeMarker)$this$visitType), startDirection, action);
            this.visitType($this$visitType_u24lambda_u244.upperBound((FlexibleTypeMarker)$this$visitType), startDirection, action);
        } else {
            throw new IllegalStateException("sealed".toString());
        }
    }

    private final void visitType(RigidTypeMarker $this$visitType, ResolveDirection startDirection, Function2<? super VariableWithConstraints, ? super ResolveDirection, Unit> action) {
        VariableFixationFinder.Context $this$visitType_u24lambda_u247 = this.c;
        boolean bl = false;
        TypeConstructorMarker constructor = $this$visitType_u24lambda_u247.typeConstructor($this$visitType);
        if ($this$visitType_u24lambda_u247.isIntersection(constructor)) {
            Iterable $this$forEach$iv = $this$visitType_u24lambda_u247.supertypes(constructor);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinTypeMarker it = (KotlinTypeMarker)element$iv;
                boolean bl2 = false;
                this.visitType(it, startDirection, action);
            }
            return;
        }
        if ($this$visitType_u24lambda_u247.argumentsCount($this$visitType) == 0) {
            VariableWithConstraints variableWithConstraints = this.c.getNotFixedTypeVariables().get(constructor);
            if (variableWithConstraints != null) {
                VariableWithConstraints it = variableWithConstraints;
                boolean bl3 = false;
                action.invoke((Object)it, (Object)startDirection);
            }
            return;
        }
        if ($this$visitType_u24lambda_u247.parametersCount(constructor) != $this$visitType_u24lambda_u247.argumentsCount($this$visitType)) {
            return;
        }
        int n = $this$visitType_u24lambda_u247.parametersCount(constructor);
        for (int index2 = 0; index2 < n; ++index2) {
            KotlinTypeMarker type2;
            ResolveDirection resolveDirection;
            TypeParameterMarker parameter = $this$visitType_u24lambda_u247.getParameter(constructor, index2);
            TypeArgumentMarker argument = $this$visitType_u24lambda_u247.getArgument($this$visitType, index2);
            if ($this$visitType_u24lambda_u247.getType(argument) == null) continue;
            TypeVariance typeVariance = AbstractTypeChecker.INSTANCE.effectiveVariance($this$visitType_u24lambda_u247.getVariance(parameter), $this$visitType_u24lambda_u247.getVariance(argument));
            if (typeVariance == null) {
                typeVariance = TypeVariance.INV;
            }
            TypeVariance variance = typeVariance;
            switch (WhenMappings.$EnumSwitchMapping$0[variance.ordinal()]) {
                case 1: {
                    resolveDirection = ResolveDirection.UNKNOWN;
                    break;
                }
                case 2: {
                    resolveDirection = startDirection;
                    break;
                }
                case 3: {
                    resolveDirection = this.opposite(startDirection);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ResolveDirection innerDirection = resolveDirection;
            this.visitType(type2, innerDirection, action);
        }
    }

    private final ResolveDirection opposite(ResolveDirection $this$opposite) {
        ResolveDirection resolveDirection;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$opposite.ordinal()]) {
            case 1: {
                resolveDirection = ResolveDirection.UNKNOWN;
                break;
            }
            case 2: {
                resolveDirection = ResolveDirection.TO_SUBTYPE;
                break;
            }
            case 3: {
                resolveDirection = ResolveDirection.TO_SUPERTYPE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolveDirection;
    }

    private static final Unit setupDirections$lambda$0(TypeVariableDirectionCalculator this$0, VariableWithConstraints variableWithConstraints, ResolveDirection direction) {
        Intrinsics.checkNotNullParameter((Object)variableWithConstraints, (String)"variableWithConstraints");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this$0.enterToNode(variableWithConstraints, direction);
        return Unit.INSTANCE;
    }

    private static final Unit setupDirections$lambda$1(TypeVariableDirectionCalculator this$0, VariableWithConstraints variableWithConstraints, ResolveDirection direction) {
        Intrinsics.checkNotNullParameter((Object)variableWithConstraints, (String)"variableWithConstraints");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this$0.enterToNode(variableWithConstraints, direction);
        return Unit.INSTANCE;
    }

    private static final Unit getConstraintDependencies$lambda$3$lambda$2(SmartList $result, VariableWithConstraints nodeVariable, ResolveDirection nodeDirection) {
        Intrinsics.checkNotNullParameter((Object)nodeVariable, (String)"nodeVariable");
        Intrinsics.checkNotNullParameter((Object)((Object)nodeDirection), (String)"nodeDirection");
        $result.add(new NodeWithDirection(nodeVariable, nodeDirection));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$NodeWithDirection;", "", "variableWithConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "direction", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;)V", "getVariableWithConstraints", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "getDirection", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "toString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "resolution.common"})
    public static final class NodeWithDirection {
        @NotNull
        private final VariableWithConstraints variableWithConstraints;
        @NotNull
        private final ResolveDirection direction;

        public NodeWithDirection(@NotNull VariableWithConstraints variableWithConstraints, @NotNull ResolveDirection direction) {
            Intrinsics.checkNotNullParameter((Object)variableWithConstraints, (String)"variableWithConstraints");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            this.variableWithConstraints = variableWithConstraints;
            this.direction = direction;
        }

        @NotNull
        public final VariableWithConstraints getVariableWithConstraints() {
            return this.variableWithConstraints;
        }

        @NotNull
        public final ResolveDirection getDirection() {
            return this.direction;
        }

        @NotNull
        public String toString() {
            return this.variableWithConstraints + " to " + (Object)((Object)this.direction);
        }

        @NotNull
        public final VariableWithConstraints component1() {
            return this.variableWithConstraints;
        }

        @NotNull
        public final ResolveDirection component2() {
            return this.direction;
        }

        @NotNull
        public final NodeWithDirection copy(@NotNull VariableWithConstraints variableWithConstraints, @NotNull ResolveDirection direction) {
            Intrinsics.checkNotNullParameter((Object)variableWithConstraints, (String)"variableWithConstraints");
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
            return new NodeWithDirection(variableWithConstraints, direction);
        }

        public static /* synthetic */ NodeWithDirection copy$default(NodeWithDirection nodeWithDirection, VariableWithConstraints variableWithConstraints, ResolveDirection resolveDirection, int n, Object object) {
            if ((n & 1) != 0) {
                variableWithConstraints = nodeWithDirection.variableWithConstraints;
            }
            if ((n & 2) != 0) {
                resolveDirection = nodeWithDirection.direction;
            }
            return nodeWithDirection.copy(variableWithConstraints, resolveDirection);
        }

        public int hashCode() {
            int result2 = this.variableWithConstraints.hashCode();
            result2 = result2 * 31 + this.direction.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NodeWithDirection)) {
                return false;
            }
            NodeWithDirection nodeWithDirection = (NodeWithDirection)other;
            if (!Intrinsics.areEqual((Object)this.variableWithConstraints, (Object)nodeWithDirection.variableWithConstraints)) {
                return false;
            }
            return this.direction == nodeWithDirection.direction;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "", "<init>", "(Ljava/lang/String;I)V", "TO_SUBTYPE", "TO_SUPERTYPE", "UNKNOWN", "resolution.common"})
    public static final class ResolveDirection
    extends Enum<ResolveDirection> {
        public static final /* enum */ ResolveDirection TO_SUBTYPE = new ResolveDirection();
        public static final /* enum */ ResolveDirection TO_SUPERTYPE = new ResolveDirection();
        public static final /* enum */ ResolveDirection UNKNOWN = new ResolveDirection();
        private static final /* synthetic */ ResolveDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ResolveDirection[] values() {
            return (ResolveDirection[])$VALUES.clone();
        }

        public static ResolveDirection valueOf(String value2) {
            return Enum.valueOf(ResolveDirection.class, value2);
        }

        @NotNull
        public static EnumEntries<ResolveDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resolveDirectionArray = new ResolveDirection[]{ResolveDirection.TO_SUBTYPE, ResolveDirection.TO_SUPERTYPE, ResolveDirection.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TypeVariance.values().length];
            try {
                nArray[TypeVariance.INV.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeVariance.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeVariance.IN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ResolveDirection.values().length];
            try {
                nArray[ResolveDirection.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolveDirection.TO_SUPERTYPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolveDirection.TO_SUBTYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

