/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ComposedSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.components.EmptySubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.OldResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tower.ExpressionKotlinCallArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewCallArgumentsKt;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCall;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallImpl;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopesKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.InferenceUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u00ca\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u000f\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0001*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010\u001a\u000e\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001c\u001a\u000e\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u000e\u0010 \u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u000e\u0010!\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u000e\u0010\"\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001e\u001a\u00020\u001f\u001a&\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.\u001a\"\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u0002002\n\u00101\u001a\u0006\u0012\u0002\b\u000302\u001a&\u00103\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.\u001a\u0010\u00104\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0002\u001a(\u00105\u001a\u00020\u00012\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002\u001a(\u00106\u001a\u00020\u00012\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002\u001a\u0016\u00107\u001a\u00020\u00012\u0006\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020.\u001a:\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020:090\u000b2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020@\u001a\f\u0010A\u001a\u00020B*\u00020BH\u0000\u001aD\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\u000b*\b\u0012\u0004\u0012\u00020D0\u000b2\u0006\u00101\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u001a\u0010H\u001a\u0016\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020K\u0012\u0006\u0012\u0004\u0018\u00010K0IH\u0000\u001a&\u0010L\u001a\u00020M*\u00020M2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020D0\u000b2\n\b\u0002\u0010N\u001a\u0004\u0018\u00010OH\u0000\u001a\u0018\u0010P\u001a\u00020Q2\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u00101\u001a\u00020E\u00a8\u0006T"}, d2={"hasUnknownFunctionParameter", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasUnknownReturnType", "replaceReturnTypeForCallable", "given", "replaceReturnTypeByUnknown", "replaceTypeArguments", "Lorg/jetbrains/kotlin/types/SimpleType;", "newArguments", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "getParameterArgumentsOfCallableType", "getReturnTypeForCallable", "hasReturnTypeDependentOnUninferredParams", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "hasInferredReturnType", "filterOutTypeParameters", "upperBounds", "candidateDescriptor", "getErasedReceiverType", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptor", "isOrOverridesSynthesized", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isConventionCall", "call", "Lorg/jetbrains/kotlin/psi/Call;", "isInfixCall", "isSuperOrDelegatingConstructorCall", "isInvokeCallOnVariable", "isInvokeCallOnExpressionWithBothReceivers", "getSuperCallExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "getEffectiveExpectedType", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "getEffectiveExpectedTypeForSingleArgument", "getExpectedType", "arrayAssignmentToVarargInNamedFormInAnnotation", "arrayAssignmentToVarargInNamedFormInFunction", "isArrayOrArrayLiteral", "createResolutionCandidatesForConstructors", "Lorg/jetbrains/kotlin/resolve/calls/tasks/OldResolutionCandidate;", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "lexicalScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "typeWithConstructors", "useKnownTypeSubstitutor", "syntheticScopes", "Lorg/jetbrains/kotlin/resolve/scopes/SyntheticScopes;", "reportOnElement", "Lcom/intellij/psi/PsiElement;", "replaceTypes", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "replace", "Lkotlin/Function2;", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "replaceArguments", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCall;", "newReceiverArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;", "checkForConstructorCallOnFunctionalType", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "frontend"})
@SourceDebugExtension(value={"SMAP\nCallResolverUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallResolverUtil.kt\norg/jetbrains/kotlin/resolve/calls/util/CallResolverUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 IntersectionTypeConstructor.kt\norg/jetbrains/kotlin/types/IntersectionTypeConstructorKt\n+ 5 IntersectionTypeConstructor.kt\norg/jetbrains/kotlin/types/IntersectionTypeConstructorKt$transformComponents$1\n+ 6 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,389:1\n1#2:390\n1#2:442\n1761#3,3:391\n1761#3,3:394\n827#3:397\n855#3,2:398\n1563#3:406\n1634#3,2:407\n1563#3:413\n1634#3,3:414\n1636#3:419\n1563#3:424\n1634#3,3:425\n1740#3,3:429\n1617#3,9:432\n1869#3:441\n1870#3:443\n1626#3:444\n295#3,2:445\n1374#3:447\n1460#3,5:448\n1563#3:453\n1634#3,3:454\n1573#3:458\n1604#3,4:459\n98#4,6:400\n104#4:409\n105#4,2:411\n108#4,2:417\n112#4,4:420\n118#4:428\n99#5:410\n180#6:457\n*S KotlinDebug\n*F\n+ 1 CallResolverUtil.kt\norg/jetbrains/kotlin/resolve/calls/util/CallResolverUtilKt\n*L\n301#1:442\n65#1:391,3\n98#1:394,3\n111#1:397\n111#1:398,2\n134#1:406\n134#1:407,2\n135#1:413\n135#1:414,3\n134#1:419\n135#1:424\n135#1:425,3\n153#1:429,3\n301#1:432,9\n301#1:441\n301#1:443\n301#1:444\n313#1:445,2\n324#1:447\n324#1:448,5\n326#1:453\n326#1:454,3\n341#1:458\n341#1:459,4\n134#1:400,6\n134#1:409\n134#1:411,2\n134#1:417,2\n134#1:420,4\n134#1:428\n134#1:410\n334#1:457\n*E\n"})
public final class CallResolverUtilKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasUnknownFunctionParameter(@NotNull KotlinType type2) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        boolean bl3 = bl2 = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-CallResolverUtilKt$hasUnknownFunctionParameter$22 = false;
            String $i$a$-assert-CallResolverUtilKt$hasUnknownFunctionParameter$22 = "type " + type2 + " is not a function or property";
            throw new AssertionError((Object)$i$a$-assert-CallResolverUtilKt$hasUnknownFunctionParameter$22);
        }
        Iterable $this$any$iv = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            TypeProjection typeProjection = (TypeProjection)element$iv;
            boolean bl4 = false;
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (TypeUtilsKt.contains(kotlinType, (Function1<? super UnwrappedType, Boolean>)((Function1)CallResolverUtilKt::hasUnknownFunctionParameter$lambda$2$lambda$1))) return true;
            KotlinType kotlinType2 = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
            if (ErrorUtils.INSTANCE.containsUninferredTypeVariable(kotlinType2)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean hasUnknownReturnType(@NotNull KotlinType type2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        boolean bl2 = bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "type " + type2 + " is not a function or property";
            throw new AssertionError((Object)string2);
        }
        return ErrorUtils.INSTANCE.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final KotlinType replaceReturnTypeForCallable(@NotNull KotlinType type2, @NotNull KotlinType given) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        boolean bl2 = bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "type " + type2 + " is not a function or property";
            throw new AssertionError((Object)string2);
        }
        ArrayList newArguments2 = Lists.newArrayList();
        newArguments2.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments2.add(new TypeProjectionImpl(Variance.INVARIANT, given));
        Intrinsics.checkNotNull((Object)newArguments2);
        return CallResolverUtilKt.replaceTypeArguments(type2, newArguments2);
    }

    @NotNull
    public static final KotlinType replaceReturnTypeByUnknown(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        SimpleType simpleType = TypeUtils.DONT_CARE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"DONT_CARE");
        return CallResolverUtilKt.replaceReturnTypeForCallable(type2, simpleType);
    }

    private static final SimpleType replaceTypeArguments(KotlinType type2, List<? extends TypeProjection> newArguments2) {
        return KotlinTypeFactory.simpleType$default(type2.getAttributes(), type2.getConstructor(), newArguments2, type2.isMarkedNullable(), null, 16, null);
    }

    private static final List<TypeProjection> getParameterArgumentsOfCallableType(KotlinType type2) {
        return CollectionsKt.dropLast(type2.getArguments(), (int)1);
    }

    @NotNull
    public static final KotlinType getReturnTypeForCallable(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.last(type2.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        return kotlinType;
    }

    private static final boolean hasReturnTypeDependentOnUninferredParams(CallableDescriptor $this$hasReturnTypeDependentOnUninferredParams, ConstraintSystem constraintSystem) {
        boolean bl;
        block4: {
            KotlinType kotlinType = $this$hasReturnTypeDependentOnUninferredParams.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType returnType = kotlinType;
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(constraintSystem, returnType);
            Iterable $this$any$iv = nestedTypeVariables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeVariable it = (TypeVariable)element$iv;
                    boolean bl2 = false;
                    if (!(constraintSystem.getTypeBounds(it).getValue() == null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(@NotNull CallableDescriptor $this$hasInferredReturnType, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$hasInferredReturnType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)constraintSystem, (String)"constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($this$hasInferredReturnType, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KotlinType> filterOutTypeParameters(List<? extends KotlinType> upperBounds, CallableDescriptor candidateDescriptor) {
        void $this$filterNotTo$iv$iv;
        if (upperBounds.size() < 2) {
            return upperBounds;
        }
        Iterable $this$filterNot$iv = upperBounds;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl = false;
            ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
            if (declarationDescriptor instanceof TypeParameterDescriptor && Intrinsics.areEqual((Object)((TypeParameterDescriptor)declarationDescriptor).getContainingDeclaration(), (Object)candidateDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List result2 = (List)destination$iv$iv;
        if (result2.isEmpty()) {
            return upperBounds;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor) {
        TypeConstructor typeConstructor2;
        Intrinsics.checkNotNullParameter((Object)receiverParameterDescriptor, (String)"receiverParameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        KotlinType kotlinType = receiverParameterDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType receiverType = kotlinType;
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor.getTypeParameters()) {
            if (!Intrinsics.areEqual((Object)typeParameterDescriptor.getTypeConstructor(), (Object)receiverType.getConstructor())) continue;
            List<KotlinType> list = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getUpperBounds(...)");
            List<KotlinType> properUpperBounds = CallResolverUtilKt.filterOutTypeParameters(list, descriptor);
            Intrinsics.checkNotNullExpressionValue((Object)TypeIntersector.intersectUpperBounds(typeParameterDescriptor, properUpperBounds), (String)"intersectUpperBounds(...)");
        }
        SmartList<TypeProjectionImpl> fakeTypeArguments = new SmartList<TypeProjectionImpl>();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        TypeConstructor typeConstructor3 = receiverType.getConstructor();
        if (typeConstructor3 instanceof IntersectionTypeConstructor) {
            IntersectionTypeConstructor intersectionTypeConstructor;
            IntersectionTypeConstructor intersectionTypeConstructor2;
            List fakeArguments;
            TypeProjection it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            KotlinType supertype;
            void $this$mapTo$iv$iv$iv;
            IntersectionTypeConstructor $this$transformComponents_u24default$iv = (IntersectionTypeConstructor)typeConstructor3;
            boolean $i$f$transformComponents = false;
            boolean changed$iv = false;
            Iterable $this$map$iv$iv = $this$transformComponents_u24default$iv.getSupertypes();
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                KotlinType kotlinType2;
                void it$iv;
                KotlinType kotlinType3 = (KotlinType)item$iv$iv$iv;
                Collection collection2 = destination$iv$iv$iv;
                boolean bl4 = false;
                void var19_21 = it$iv;
                boolean bl3 = false;
                void it2 = var19_21;
                if (true) {
                    changed$iv = true;
                    supertype = it$iv;
                    boolean bl2 = false;
                    $this$map$iv = supertype.getArguments();
                    $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new TypeProjectionImpl(it.getProjectionKind(), TypeUtils.DONT_CARE));
                    }
                    fakeArguments = (List)destination$iv$iv;
                    kotlinType2 = TypeSubstitutionKt.replace$default(supertype, fakeArguments, null, null, 6, null);
                } else {
                    kotlinType2 = it$iv;
                }
                collection2.add(kotlinType2);
            }
            List newSupertypes$iv = (List)destination$iv$iv$iv;
            if (!changed$iv) {
                intersectionTypeConstructor2 = null;
            } else {
                KotlinType kotlinType4;
                KotlinType kotlinType5 = $this$transformComponents_u24default$iv.getAlternativeType();
                if (kotlinType5 != null) {
                    KotlinType alternative$iv = kotlinType5;
                    boolean bl5 = false;
                    supertype = alternative$iv;
                    boolean bl = false;
                    KotlinType it2 = supertype;
                    if (true) {
                        supertype = alternative$iv;
                        boolean bl2 = false;
                        $this$map$iv = supertype.getArguments();
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (TypeProjection)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            collection.add(new TypeProjectionImpl(it.getProjectionKind(), TypeUtils.DONT_CARE));
                        }
                        fakeArguments = (List)destination$iv$iv;
                        kotlinType4 = TypeSubstitutionKt.replace$default(supertype, fakeArguments, null, null, 6, null);
                    } else {
                        kotlinType4 = alternative$iv;
                    }
                } else {
                    kotlinType4 = null;
                }
                KotlinType updatedAlternative$iv = kotlinType4;
                intersectionTypeConstructor2 = intersectionTypeConstructor = new IntersectionTypeConstructor(newSupertypes$iv).setAlternative(updatedAlternative$iv);
            }
            if (intersectionTypeConstructor2 == null) {
                intersectionTypeConstructor = (IntersectionTypeConstructor)typeConstructor3;
            }
            typeConstructor2 = intersectionTypeConstructor;
        } else {
            typeConstructor2 = typeConstructor3;
        }
        TypeConstructor receiverTypeConstructor = typeConstructor2;
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(receiverType.getAttributes(), receiverTypeConstructor, (List<? extends TypeProjection>)fakeTypeArguments, receiverType.isMarkedNullable(), ErrorUtils.createErrorScope(ErrorScopeKind.ERASED_RECEIVER_TYPE_SCOPE, true, new String[0]));
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (descriptor.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return true;
        }
        if (descriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            boolean bl;
            block5: {
                Collection<? extends CallableMemberDescriptor> collection = descriptor.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getOverriddenDescriptors(...)");
                Iterable $this$all$iv = collection;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CallableMemberDescriptor p0 = (CallableMemberDescriptor)element$iv;
                        boolean bl2 = false;
                        if (CallResolverUtilKt.isOrOverridesSynthesized(p0)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    public static final boolean isConventionCall(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (call instanceof CallTransformer.CallForImplicitInvoke) {
            return true;
        }
        KtElement ktElement = call.getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
        KtElement callElement = ktElement;
        if (callElement instanceof KtArrayAccessExpression || callElement instanceof KtDestructuringDeclarationEntry) {
            return true;
        }
        KtExpression ktExpression = call.getCalleeExpression();
        KtOperationReferenceExpression ktOperationReferenceExpression = ktExpression instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)ktExpression : null;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        return calleeExpression.isConventionOperator();
    }

    public static final boolean isInfixCall(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        KtExpression ktExpression = call.getCalleeExpression();
        KtOperationReferenceExpression ktOperationReferenceExpression = ktExpression instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)ktExpression : null;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
        PsiElement psiElement = operationRefExpression.getParent();
        KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        return binaryExpression.getOperationReference() == operationRefExpression && operationRefExpression.getOperationSignTokenType() == null;
    }

    public static final boolean isSuperOrDelegatingConstructorCall(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        KtExpression it = call.getCalleeExpression();
        boolean bl = false;
        return it instanceof KtConstructorCalleeExpression || it instanceof KtConstructorDelegationReferenceExpression;
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (call.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue dispatchReceiver = call.getDispatchReceiver();
        Intrinsics.checkNotNull((Object)dispatchReceiver, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        KtExpression expression2 = ((ExpressionReceiver)dispatchReceiver).getExpression();
        return expression2 instanceof KtSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (call.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            return false;
        }
        return call.getExplicitReceiver() != null && call.getDispatchReceiver() != null;
    }

    @Nullable
    public static final KtSuperExpression getSuperCallExpression(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Receiver receiver = call.getExplicitReceiver();
        ExpressionReceiver expressionReceiver = receiver instanceof ExpressionReceiver ? (ExpressionReceiver)receiver : null;
        KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        return ktExpression instanceof KtSuperExpression ? (KtSuperExpression)ktExpression : null;
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)resolvedArgument, (String)"resolvedArgument");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        List<ValueArgument> list = resolvedArgument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
        ValueArgument argument = (ValueArgument)CollectionsKt.singleOrNull(list);
        return argument != null ? CallResolverUtilKt.getEffectiveExpectedTypeForSingleArgument(parameterDescriptor, argument, languageVersionSettings, trace) : CallResolverUtilKt.getExpectedType(parameterDescriptor);
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"languageVersionSettings");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        return CallResolverUtilKt.getEffectiveExpectedTypeForSingleArgument(parameterDescriptor, argument, languageVersionSettings, bindingTrace);
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedTypeForSingleArgument(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (argument.getSpreadElement() != null) {
            KotlinType kotlinType;
            if (parameterDescriptor.getVarargElementType() == null) {
                SimpleType simpleType = TypeUtils.DONT_CARE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"DONT_CARE");
                kotlinType = simpleType;
            } else {
                KotlinType kotlinType2 = parameterDescriptor.getType();
                kotlinType = kotlinType2;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
            }
            return kotlinType;
        }
        if (CallResolverUtilKt.arrayAssignmentToVarargInNamedFormInAnnotation(parameterDescriptor, argument, languageVersionSettings, trace) || CallResolverUtilKt.arrayAssignmentToVarargInNamedFormInFunction(parameterDescriptor, argument, languageVersionSettings, trace)) {
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            return kotlinType;
        }
        return CallResolverUtilKt.getExpectedType(parameterDescriptor);
    }

    private static final KotlinType getExpectedType(ValueParameterDescriptor parameterDescriptor) {
        KotlinType kotlinType = parameterDescriptor.getVarargElementType();
        if (kotlinType == null) {
            KotlinType kotlinType2 = parameterDescriptor.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        }
        return kotlinType;
    }

    private static final boolean arrayAssignmentToVarargInNamedFormInAnnotation(ValueParameterDescriptor parameterDescriptor, ValueArgument argument, LanguageVersionSettings languageVersionSettings, BindingTrace trace) {
        boolean isAllowedAssigningSingleElementsToVarargsInNamedForm;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return false;
        }
        boolean bl = isAllowedAssigningSingleElementsToVarargsInNamedForm = !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm);
        if (isAllowedAssigningSingleElementsToVarargsInNamedForm && !CallResolverUtilKt.isArrayOrArrayLiteral(argument, trace)) {
            return false;
        }
        return DescriptorUtilsKt.isParameterOfAnnotation(parameterDescriptor) && argument.isNamed() && ArgumentsUtilsKt.isVararg(parameterDescriptor);
    }

    private static final boolean arrayAssignmentToVarargInNamedFormInFunction(ValueParameterDescriptor parameterDescriptor, ValueArgument argument, LanguageVersionSettings languageVersionSettings, BindingTrace trace) {
        boolean isAllowedAssigningSingleElementsToVarargsInNamedForm;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions)) {
            return false;
        }
        boolean bl = isAllowedAssigningSingleElementsToVarargsInNamedForm = !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm);
        if (isAllowedAssigningSingleElementsToVarargsInNamedForm && !CallResolverUtilKt.isArrayOrArrayLiteral(argument, trace)) {
            return false;
        }
        return argument.isNamed() && ArgumentsUtilsKt.isVararg(parameterDescriptor);
    }

    public static final boolean isArrayOrArrayLiteral(@NotNull ValueArgument argument, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression argumentExpression = ktExpression;
        if (argumentExpression instanceof KtCollectionLiteralExpression) {
            return true;
        }
        KotlinType kotlinType = trace.getType(argumentExpression);
        if (kotlinType == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        return KotlinBuiltIns.isArrayOrPrimitiveArray(type2) || KotlinBuiltIns.isUnsignedArrayType(type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<OldResolutionCandidate<ConstructorDescriptor>> createResolutionCandidatesForConstructors(@NotNull LexicalScope lexicalScope, @NotNull Call call, @NotNull KotlinType typeWithConstructors, boolean useKnownTypeSubstitutor, @NotNull SyntheticScopes syntheticScopes) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        CallableDescriptor it;
        Collection collection;
        DeclarationDescriptor $this$mapNotNullTo$iv$iv;
        Iterable<TypeAliasConstructorDescriptor> destination$iv$iv;
        ClassifierDescriptor classifierDescriptor;
        TypeSubstitutor knownSubstitutor;
        SimpleType simpleType;
        Intrinsics.checkNotNullParameter((Object)lexicalScope, (String)"lexicalScope");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)typeWithConstructors, (String)"typeWithConstructors");
        Intrinsics.checkNotNullParameter((Object)syntheticScopes, (String)"syntheticScopes");
        ClassifierDescriptor classifierDescriptor2 = typeWithConstructors.getConstructor().getDeclarationDescriptor();
        Intrinsics.checkNotNull((Object)classifierDescriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor classWithConstructors = (ClassDescriptor)classifierDescriptor2;
        UnwrappedType unwrappedType = typeWithConstructors.unwrap();
        TypeSubstitutor typeSubstitutor2 = useKnownTypeSubstitutor ? TypeSubstitutor.create((simpleType = unwrappedType instanceof AbbreviatedType ? (AbbreviatedType)unwrappedType : null) != null && (simpleType = simpleType.getAbbreviation()) != null ? (UnwrappedType)simpleType : unwrappedType) : (knownSubstitutor = null);
        TypeAliasDescriptor typeAliasDescriptor = unwrappedType instanceof AbbreviatedType ? ((classifierDescriptor = ((AbbreviatedType)unwrappedType).getAbbreviation().getConstructor().getDeclarationDescriptor()) instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)classifierDescriptor : null) : null;
        Object object = typeAliasDescriptor;
        if (object != null && (object = object.getConstructors()) != null) {
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                TypeAliasConstructorDescriptor it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                TypeAliasConstructorDescriptor p0 = (TypeAliasConstructorDescriptor)element$iv$iv;
                boolean bl2 = false;
                if (p0.getWithDispatchReceiver() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            Collection collection2 = classWithConstructors.getConstructors();
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getConstructors(...)");
        }
        Collection constructors2 = collection;
        if (constructors2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ExplicitReceiverKind receiverKind = null;
        ReceiverValue dispatchReceiver = null;
        if (classWithConstructors.isInner()) {
            Object v8;
            block12: {
                $this$mapNotNullTo$iv$iv = classWithConstructors.getContainingDeclaration();
                Annotated annotated = $this$mapNotNullTo$iv$iv instanceof ClassDescriptor ? (ClassDescriptor)$this$mapNotNullTo$iv$iv : null;
                if (annotated == null || (annotated = annotated.getDefaultType()) == null) {
                    return CollectionsKt.emptyList();
                }
                Annotated outerClassType = annotated;
                Object object2 = knownSubstitutor;
                if (object2 == null || (object2 = ((TypeSubstitutor)object2).substitute((KotlinType)outerClassType, Variance.INVARIANT)) == null) {
                    object2 = (KotlinType)outerClassType;
                }
                Object substitutedOuterClassType = object2;
                Iterable $this$firstOrNull$iv = ScopeUtilsKt.getImplicitReceiversHierarchy(lexicalScope);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (ReceiverParameterDescriptor)element$iv;
                    boolean bl = false;
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(it.getType(), (KotlinType)substitutedOuterClassType)) continue;
                    v8 = element$iv;
                    break block12;
                }
                v8 = null;
            }
            ReceiverParameterDescriptor receiverParameterDescriptor = v8;
            if (receiverParameterDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
            receiverKind = ExplicitReceiverKind.DISPATCH_RECEIVER;
            dispatchReceiver = receiver.getValue();
        } else {
            receiverKind = ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            dispatchReceiver = null;
        }
        Iterable $this$flatMap$iv = constructors2;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ConstructorDescriptor)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            list$iv$iv = SyntheticScopesKt.collectSyntheticConstructors(syntheticScopes, (ConstructorDescriptor)it);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List syntheticConstructors = (List)destination$iv$iv2;
        Iterable $this$map$iv = CollectionsKt.plus((Collection)constructors2, (Iterable)syntheticConstructors);
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ConstructorDescriptor)item$iv$iv;
            Collection collection3 = destination$iv$iv2;
            boolean bl = false;
            collection3.add(OldResolutionCandidate.create(call, it, dispatchReceiver, receiverKind, knownSubstitutor));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final PsiElement reportOnElement(@NotNull PsiElement $this$reportOnElement) {
        PsiElement psiElement;
        KtConstructorDelegationCall ktConstructorDelegationCall;
        Intrinsics.checkNotNullParameter((Object)$this$reportOnElement, (String)"<this>");
        KtConstructorDelegationCall ktConstructorDelegationCall2 = ktConstructorDelegationCall = $this$reportOnElement instanceof KtConstructorDelegationCall ? (KtConstructorDelegationCall)$this$reportOnElement : null;
        if (ktConstructorDelegationCall != null) {
            KtConstructorDelegationCall ktConstructorDelegationCall3;
            KtConstructorDelegationCall ktConstructorDelegationCall4;
            KtConstructorDelegationCall it = ktConstructorDelegationCall4 = ktConstructorDelegationCall;
            boolean bl = false;
            KtConstructorDelegationCall ktConstructorDelegationCall5 = ktConstructorDelegationCall3 = ((KtConstructorDelegationCall)$this$reportOnElement).isImplicit() ? ktConstructorDelegationCall4 : null;
            if (ktConstructorDelegationCall3 != null) {
                KtConstructorDelegationCall it2 = ktConstructorDelegationCall3;
                boolean bl2 = false;
                PsiElement $this$getStrictParentOfType$iv = $this$reportOnElement;
                boolean $i$f$getStrictParentOfType = false;
                PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtSecondaryConstructor.class, (boolean)true);
                Intrinsics.checkNotNull((Object)psiElement2);
                KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)psiElement2;
                if (ktSecondaryConstructor != null) {
                    psiElement = ktSecondaryConstructor;
                    return psiElement;
                }
            }
        }
        psiElement = $this$reportOnElement;
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinCallArgument> replaceTypes(@NotNull List<? extends KotlinCallArgument> $this$replaceTypes, @NotNull BasicCallResolutionContext context, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull Function2<? super Integer, ? super UnwrappedType, ? extends UnwrappedType> replace) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$replaceTypes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkNotNullParameter(replace, (String)"replace");
        Iterable $this$mapIndexed$iv = $this$replaceTypes;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            KotlinCallArgument kotlinCallArgument;
            void argument;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KotlinCallArgument kotlinCallArgument2 = (KotlinCallArgument)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(argument instanceof SimpleKotlinCallArgument)) {
                kotlinCallArgument = argument;
            } else if (NewCallArgumentsKt.getPsiExpression((KotlinCallArgument)argument) == null) {
                kotlinCallArgument = argument;
            } else {
                void i2;
                NewTypeSubstitutor argumentSubstitutor;
                NewTypeSubstitutor newTypeSubstitutor;
                if (argument instanceof SubKotlinCallArgument) {
                    TypeSubstitutorMarker typeSubstitutorMarker = InferenceUtilsKt.buildNotFixedVariablesToPossibleResultType(((SubKotlinCallArgument)argument).getCallResult().getConstraintSystem(), resolutionCallbacks);
                    Intrinsics.checkNotNull((Object)typeSubstitutorMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor");
                    NewTypeSubstitutor notFixedVariablesSubstitutor = (NewTypeSubstitutor)typeSubstitutorMarker;
                    TypeSubstitutorMarker typeSubstitutorMarker2 = ((SubKotlinCallArgument)argument).getCallResult().getConstraintSystem().getBuilder().buildCurrentSubstitutor();
                    Intrinsics.checkNotNull((Object)typeSubstitutorMarker2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor");
                    NewTypeSubstitutor fixedVariablesSubstitutor = (NewTypeSubstitutor)typeSubstitutorMarker2;
                    newTypeSubstitutor = new ComposedSubstitutor(notFixedVariablesSubstitutor, fixedVariablesSubstitutor);
                } else {
                    newTypeSubstitutor = argumentSubstitutor = (NewTypeSubstitutor)EmptySubstitutor.INSTANCE;
                }
                if ((UnwrappedType)replace.invoke((Object)((int)i2), (Object)argumentSubstitutor.safeSubstitute(((SimpleKotlinCallArgument)argument).getReceiver().getReceiverValue().getType().unwrap())) == null) {
                    kotlinCallArgument = argument;
                } else {
                    KtExpression psiExpression;
                    UnwrappedType newType;
                    ValueArgument valueArgument = NewCallArgumentsKt.getPsiCallArgument((KotlinCallArgument)argument).getValueArgument();
                    DataFlowInfo dataFlowInfo = NewCallArgumentsKt.getPsiCallArgument((KotlinCallArgument)argument).getDataFlowInfoBeforeThisArgument();
                    DataFlowInfo dataFlowInfo2 = NewCallArgumentsKt.getPsiCallArgument((KotlinCallArgument)argument).getDataFlowInfoAfterThisArgument();
                    KotlinType kotlinType = newType;
                    BindingContext bindingContext = context.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                    kotlinCallArgument = new ExpressionKotlinCallArgumentImpl(valueArgument, dataFlowInfo, dataFlowInfo2, new ReceiverValueWithSmartCastInfo(ExpressionReceiver.Companion.create(psiExpression, kotlinType, bindingContext), SetsKt.emptySet(), true, null, 8, null));
                }
            }
            collection.add(kotlinCallArgument);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final PSIKotlinCall replaceArguments(@NotNull PSIKotlinCall $this$replaceArguments, @NotNull List<? extends KotlinCallArgument> newArguments2, @Nullable ReceiverKotlinCallArgument newReceiverArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter(newArguments2, (String)"newArguments");
        return new PSIKotlinCallImpl($this$replaceArguments.getCallKind(), $this$replaceArguments.getPsiCall(), $this$replaceArguments.getTracingStrategy(), newReceiverArgument, $this$replaceArguments.getDispatchReceiverForInvokeExtension(), $this$replaceArguments.getName(), $this$replaceArguments.getTypeArguments(), newArguments2, $this$replaceArguments.getExternalArgument(), $this$replaceArguments.getStartingDataFlowInfo(), $this$replaceArguments.getResultDataFlowInfo(), $this$replaceArguments.getDataFlowInfoForArguments(), $this$replaceArguments.isForImplicitInvoke());
    }

    public static /* synthetic */ PSIKotlinCall replaceArguments$default(PSIKotlinCall pSIKotlinCall, List list, ReceiverKotlinCallArgument receiverKotlinCallArgument, int n, Object object) {
        if ((n & 2) != 0) {
            receiverKotlinCallArgument = null;
        }
        return CallResolverUtilKt.replaceArguments(pSIKotlinCall, list, receiverKotlinCallArgument);
    }

    public static final void checkForConstructorCallOnFunctionalType(@Nullable KtTypeReference typeReference, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtTypeReference ktTypeReference = typeReference;
        if ((ktTypeReference != null ? ktTypeReference.getTypeElement() : null) instanceof KtFunctionType) {
            DiagnosticFactory0<PsiElement> diagnosticFactory0;
            boolean bl = context.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitConstructorCallOnFunctionalSupertype);
            if (bl) {
                diagnosticFactory0 = Errors.NO_CONSTRUCTOR;
            } else if (!bl) {
                diagnosticFactory0 = Errors.NO_CONSTRUCTOR_WARNING;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            DiagnosticFactory0<PsiElement> factory2 = diagnosticFactory0;
            BindingTrace bindingTrace = context.trace;
            Call call = context.call;
            Intrinsics.checkNotNullExpressionValue((Object)call, (String)"call");
            bindingTrace.report(factory2.on((PsiElement)CallUtilKt.getValueArgumentListOrElement(call)));
        }
    }

    private static final boolean hasUnknownFunctionParameter$lambda$2$lambda$1(UnwrappedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeUtils.isDontCarePlaceholder(it);
    }
}

