/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.LLFirModuleDataKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOriginKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousInitializerSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDanglingModifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0014\u0010\b\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J$\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/LLContainingClassCalculator;", "", "<init>", "()V", "getContainingClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "canHaveContainingClassSymbol", "", "computeContainingClass", "psi", "Lcom/intellij/psi/PsiElement;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLContainingClassCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLContainingClassCalculator.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/LLContainingClassCalculator\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 LowLevelFirApiFacade.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/api/LowLevelFirApiFacadeKt\n*L\n1#1,155:1\n91#2:156\n63#3,6:157\n*S KotlinDebug\n*F\n+ 1 LLContainingClassCalculator.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/LLContainingClassCalculator\n*L\n140#1:156\n153#1:157,6\n*E\n"})
public final class LLContainingClassCalculator {
    @NotNull
    public static final LLContainingClassCalculator INSTANCE = new LLContainingClassCalculator();

    private LLContainingClassCalculator() {
    }

    @Nullable
    public final FirClassLikeSymbol<?> getContainingClassSymbol(@NotNull FirBasedSymbol<?> symbol) {
        ConeClassLikeLookupTag containingClassLookupTag;
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        if (!FirDeclarationOriginKt.isLazyResolvable(symbol.getOrigin())) {
            return null;
        }
        if (symbol instanceof FirAnonymousInitializerSymbol) {
            FirBasedSymbol<?> firBasedSymbol = ((FirAnonymousInitializerSymbol)symbol).getContainingDeclarationSymbol();
            return firBasedSymbol instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)firBasedSymbol : null;
        }
        if (!this.canHaveContainingClassSymbol(symbol)) {
            return null;
        }
        FirBasedSymbol<?> firBasedSymbol = symbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag = firBasedSymbol instanceof FirCallableSymbol ? ClassMembersKt.containingClassLookupTag((FirCallableSymbol)symbol) : (firBasedSymbol instanceof FirClassLikeSymbol ? ClassMembersKt.getContainingClassLookupTag((FirClassLikeSymbol)symbol) : (containingClassLookupTag = firBasedSymbol instanceof FirDanglingModifierSymbol ? ClassMembersKt.containingClassLookupTag((FirDanglingModifierSymbol)symbol) : null));
        if (containingClassLookupTag instanceof ConeClassLikeLookupTagWithFixedSymbol) {
            return ((ConeClassLikeLookupTagWithFixedSymbol)containingClassLookupTag).getSymbol();
        }
        KtSourceElement ktSourceElement = symbol.getSource();
        KtPsiSourceElement ktPsiSourceElement = ktSourceElement instanceof KtPsiSourceElement ? (KtPsiSourceElement)ktSourceElement : null;
        if (ktPsiSourceElement == null) {
            return null;
        }
        KtPsiSourceElement source = ktPsiSourceElement;
        KtSourceElementKind kind = source.getKind();
        if (kind instanceof KtFakeSourceElementKind) {
            if (symbol instanceof FirConstructorSymbol && Intrinsics.areEqual((Object)kind, (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) {
                return this.computeContainingClass(symbol, source.getPsi());
            }
            if (symbol instanceof FirPropertyAccessorSymbol) {
                if (Intrinsics.areEqual((Object)kind, (Object)KtFakeSourceElementKind.DefaultAccessor.INSTANCE)) {
                    PsiElement containingProperty = source.getPsi();
                    return containingProperty instanceof KtProperty || containingProperty instanceof KtParameter ? this.computeContainingClass(symbol, KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)containingProperty)) : null;
                }
                if (Intrinsics.areEqual((Object)kind, (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                    KtProperty containingProperty;
                    PsiElement psiElement = source.getPsi();
                    KtProperty ktProperty = containingProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
                    return this.computeContainingClass(symbol, ktProperty != null ? KtPsiUtilKt.getContainingClassOrObject(ktProperty) : null);
                }
                if (Intrinsics.areEqual((Object)kind, (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                    KtParameter containingParameter;
                    PsiElement psiElement = source.getPsi();
                    KtParameter ktParameter = containingParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
                    return this.computeContainingClass(symbol, ktParameter != null ? KtPsiUtilKt.getContainingClassOrObject(ktParameter) : null);
                }
            }
            if (symbol instanceof FirPropertySymbol && Intrinsics.areEqual((Object)kind, (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                KtParameter containingParameter;
                PsiElement psiElement = source.getPsi();
                KtParameter ktParameter = containingParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
                return this.computeContainingClass(symbol, ktParameter != null ? KtPsiUtilKt.getContainingClassOrObject(ktParameter) : null);
            }
            if (Intrinsics.areEqual((Object)kind, (Object)KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
                return this.computeContainingClass(symbol, source.getPsi());
            }
            if (Intrinsics.areEqual((Object)kind, (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) {
                PsiElement psi = source.getPsi();
                KtClassOrObject containingClass = psi instanceof KtClassOrObject ? (KtClassOrObject)psi : (psi instanceof KtParameter ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)psi) : (psi instanceof KtPrimaryConstructor ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)psi) : null));
                return this.computeContainingClass(symbol, containingClass);
            }
            if (symbol instanceof FirDanglingModifierSymbol && Intrinsics.areEqual((Object)kind, (Object)KtFakeSourceElementKind.DanglingModifierList.INSTANCE)) {
                KtClassBody body;
                KtModifierList modifierList2;
                PsiElement psi = source.getPsi();
                KtModifierList ktModifierList = modifierList2 = psi instanceof KtModifierList ? (KtModifierList)psi : null;
                PsiElement psiElement = ktModifierList != null ? ktModifierList.getParent() : null;
                KtClassBody ktClassBody = body = psiElement instanceof KtClassBody ? (KtClassBody)psiElement : null;
                return this.computeContainingClass(symbol, (PsiElement)(ktClassBody != null ? ktClassBody.getParent() : null));
            }
        } else {
            if (symbol instanceof FirClassLikeSymbol) {
                KtClassOrObject selfClass;
                PsiElement psiElement = source.getPsi();
                KtClassOrObject ktClassOrObject = selfClass = psiElement instanceof KtClassOrObject ? (KtClassOrObject)psiElement : null;
                return this.computeContainingClass(symbol, ktClassOrObject != null ? KtPsiUtilKt.getContainingClassOrObject(ktClassOrObject) : null);
            }
            if (symbol instanceof FirCallableSymbol) {
                FirClassLikeSymbol<?> firClassLikeSymbol;
                PsiElement selfCallable = source.getPsi();
                PsiElement psiElement = selfCallable;
                if (psiElement instanceof KtCallableDeclaration || psiElement instanceof KtEnumEntry) {
                    firClassLikeSymbol = this.computeContainingClass(symbol, KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)selfCallable));
                } else if (psiElement instanceof KtPropertyAccessor) {
                    KtProperty ktProperty = ((KtPropertyAccessor)selfCallable).getProperty();
                    Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
                    KtProperty containingProperty = ktProperty;
                    firClassLikeSymbol = this.computeContainingClass(symbol, KtPsiUtilKt.getContainingClassOrObject(containingProperty));
                } else {
                    firClassLikeSymbol = null;
                }
                return firClassLikeSymbol;
            }
        }
        return null;
    }

    private final boolean canHaveContainingClassSymbol(FirBasedSymbol<?> symbol) {
        boolean bl;
        FirBasedSymbol<?> firBasedSymbol = symbol;
        if (firBasedSymbol instanceof FirValueParameterSymbol || firBasedSymbol instanceof FirAnonymousFunctionSymbol) {
            bl = false;
        } else if (firBasedSymbol instanceof FirPropertySymbol) {
            bl = !((FirPropertySymbol)symbol).isLocal();
        } else if (firBasedSymbol instanceof FirNamedFunctionSymbol) {
            FirFunctionSymbol $this$isLocal$iv = (FirFunctionSymbol)symbol;
            boolean $i$f$isLocal = false;
            bl = !Intrinsics.areEqual((Object)$this$isLocal$iv.getRawStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE);
        } else {
            bl = firBasedSymbol instanceof FirClassLikeSymbol ? ((FirClassLikeSymbol)symbol).getClassId().isNestedClass() : firBasedSymbol instanceof FirCallableSymbol || firBasedSymbol instanceof FirDanglingModifierSymbol;
        }
        return bl;
    }

    private final FirClassLikeSymbol<?> computeContainingClass(FirBasedSymbol<?> symbol, PsiElement psi) {
        if (!(psi instanceof KtClassOrObject)) {
            return null;
        }
        KaModule module2 = LLFirModuleDataKt.getLlFirModuleData(symbol).getKtModule();
        LLFirResolveSession resolveSession = LowLevelFirApiFacadeKt.getFirResolveSession(module2, module2.getProject());
        KtDeclaration $this$resolveToFirSymbolOfTypeSafe_u24default$iv = (KtDeclaration)psi;
        FirResolvePhase phase$iv = FirResolvePhase.RAW_FIR;
        boolean $i$f$resolveToFirSymbolOfTypeSafe = false;
        FirBasedSymbol<?> firBasedSymbol = LowLevelFirApiFacadeKt.resolveToFirSymbol($this$resolveToFirSymbolOfTypeSafe_u24default$iv, resolveSession, phase$iv);
        if (!(firBasedSymbol instanceof FirClassLikeSymbol)) {
            firBasedSymbol = null;
        }
        return (FirClassLikeSymbol)((FirBasedSymbol)((FirClassLikeSymbol)firBasedSymbol));
    }
}

