/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.localfs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.localfs.KotlinLocalFileSystem;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0016J\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001f\u001a\u00020\fH\u0016JL\u0010 \u001a\u0004\u0018\u0001H!\"\u0004\b\u0000\u0010!\"\u000e\b\u0001\u0010\"*\b\u0012\u0004\u0012\u0002H\"0#*\b\u0012\u0004\u0012\u0002H!0\u00122\u0006\u0010$\u001a\u0002H\"2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u0002H\"0&H\u0082\b\u00a2\u0006\u0002\u0010'J\"\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020-H\u0016J\b\u00102\u001a\u00020-H\u0016J\"\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u000f2\b\u00107\u001a\u0004\u0018\u000108H\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020-H\u0016J\b\u0010<\u001a\u00020\u000fH\u0016J\u0013\u0010=\u001a\u00020\u000f2\b\u0010>\u001a\u0004\u0018\u00010+H\u0096\u0002J\b\u0010?\u001a\u00020@H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/cli/common/localfs/KotlinLocalVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Ljava/io/File;", "_fileSystem", "Lorg/jetbrains/kotlin/cli/common/localfs/KotlinLocalFileSystem;", "parent", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/cli/common/localfs/KotlinLocalFileSystem;Lorg/jetbrains/kotlin/cli/common/localfs/KotlinLocalVirtualFile;)V", "getFile", "()Ljava/io/File;", "_name", "", "_parent", "_isDirectory", "", "Ljava/lang/Boolean;", "_children", "", "[Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getPath", "isWritable", "isDirectory", "isValid", "getParent", "getChildren", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "findChild", "name", "binarySearchBy", "T", "K", "", "key", "selector", "Lkotlin/Function1;", "([Ljava/lang/Object;Ljava/lang/Comparable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "", "newTimeStamp", "contentsToByteArray", "", "getTimeStamp", "getLength", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "getInputStream", "Ljava/io/InputStream;", "getModificationStamp", "isInLocalFileSystem", "equals", "other", "hashCode", "", "cli-base"})
@SourceDebugExtension(value={"SMAP\nKotlinLocalVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLocalVirtualFile.kt\norg/jetbrains/kotlin/cli/common/localfs/KotlinLocalVirtualFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,151:1\n83#1,18:162\n1#2:152\n11228#3:153\n11563#3,3:154\n1056#4:157\n37#5:158\n36#5,3:159\n*S KotlinDebug\n*F\n+ 1 KotlinLocalVirtualFile.kt\norg/jetbrains/kotlin/cli/common/localfs/KotlinLocalVirtualFile\n*L\n74#1:162,18\n67#1:153\n67#1:154,3\n68#1:157\n69#1:158\n69#1:159,3\n*E\n"})
public final class KotlinLocalVirtualFile
extends VirtualFile {
    @NotNull
    private final File file;
    @NotNull
    private final KotlinLocalFileSystem _fileSystem;
    @Nullable
    private String _name;
    @Nullable
    private KotlinLocalVirtualFile _parent;
    @Nullable
    private Boolean _isDirectory;
    @Nullable
    private VirtualFile[] _children;

    public KotlinLocalVirtualFile(@NotNull File file, @NotNull KotlinLocalFileSystem _fileSystem, @Nullable KotlinLocalVirtualFile parent2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)_fileSystem), (String)"_fileSystem");
        this.file = file;
        this._fileSystem = _fileSystem;
        this._parent = parent2;
    }

    public /* synthetic */ KotlinLocalVirtualFile(File file, KotlinLocalFileSystem kotlinLocalFileSystem, KotlinLocalVirtualFile kotlinLocalVirtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            kotlinLocalVirtualFile = null;
        }
        this(file, kotlinLocalFileSystem, kotlinLocalVirtualFile);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public String getName() {
        String string;
        String string2 = this._name;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return it;
        }
        String it = string = this.file.getName();
        boolean bl = false;
        this._name = it;
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"also(...)");
        return string3;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return (VirtualFileSystem)this._fileSystem;
    }

    @NotNull
    public String getPath() {
        String string = FileUtil.toSystemIndependentName((String)this.file.getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        boolean bl;
        Boolean bl2 = this._isDirectory;
        if (bl2 != null) {
            boolean it = bl2;
            boolean bl3 = false;
            return it;
        }
        boolean it = bl = this.file.isDirectory();
        boolean bl4 = false;
        this._isDirectory = it;
        return bl;
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public VirtualFile getParent() {
        KotlinLocalVirtualFile kotlinLocalVirtualFile;
        KotlinLocalVirtualFile kotlinLocalVirtualFile2 = this._parent;
        if (kotlinLocalVirtualFile2 != null) {
            KotlinLocalVirtualFile it = kotlinLocalVirtualFile2;
            boolean bl = false;
            return it;
        }
        File file = this.file.getParentFile();
        if (file == null) {
            return null;
        }
        File parentFile = file;
        KotlinLocalVirtualFile it = kotlinLocalVirtualFile = new KotlinLocalVirtualFile(parentFile, this._fileSystem, null, 4, null);
        boolean bl = false;
        this._parent = it;
        return kotlinLocalVirtualFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VirtualFile[] getChildren() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File[] fileChildren;
        VirtualFile[] virtualFileArray = this._children;
        if (virtualFileArray != null) {
            VirtualFile[] it = virtualFileArray;
            boolean bl = false;
            return it;
        }
        File[] fileArray = this.file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        File[] fileArray2 = fileChildren = fileArray;
        KotlinLocalVirtualFile kotlinLocalVirtualFile = this;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_13 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new KotlinLocalVirtualFile((File)it, this._fileSystem, this));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KotlinLocalVirtualFile it = (KotlinLocalVirtualFile)((Object)a);
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (KotlinLocalVirtualFile)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        kotlinLocalVirtualFile._children = thisCollection$iv.toArray(new VirtualFile[0]);
        Intrinsics.checkNotNull((Object)this._children);
        return this._children;
    }

    @Nullable
    public VirtualFile findChild(@NotNull String name2) {
        VirtualFile virtualFile;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            KotlinLocalVirtualFile kotlinLocalVirtualFile = this;
            VirtualFile[] $this$binarySearchBy$iv = this.getChildren();
            boolean $i$f$binarySearchBy = false;
            int low$iv = 0;
            int high$iv = $this$binarySearchBy$iv.length - 1;
            while (low$iv <= high$iv) {
                VirtualFile midVal$iv;
                int mid$iv = low$iv + high$iv >>> 1;
                VirtualFile it = midVal$iv = $this$binarySearchBy$iv[mid$iv];
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                int cmp$iv = ComparisonsKt.compareValues((Comparable)((Comparable)((Object)string)), (Comparable)((Comparable)((Object)name2)));
                if (cmp$iv < 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                if (cmp$iv > 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                virtualFile = midVal$iv;
                break block3;
            }
            virtualFile = null;
        }
        return virtualFile;
    }

    private final <T, K extends Comparable<? super K>> T binarySearchBy(T[] $this$binarySearchBy, K key, Function1<? super T, ? extends K> selector) {
        boolean $i$f$binarySearchBy = false;
        int low = 0;
        int high = $this$binarySearchBy.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = $this$binarySearchBy[mid];
            int cmp = ComparisonsKt.compareValues((Comparable)((Comparable)selector.invoke(midVal)), key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = FileUtil.loadFileBytes((File)this.file);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"loadFileBytes(...)");
        return byArray;
    }

    public long getTimeStamp() {
        return this.file.lastModified();
    }

    public long getLength() {
        return this.file.length();
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM((InputStream)new BufferedInputStream(new FileInputStream(this.file)), (VirtualFile)this);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStreamSkippingBOM(...)");
        return inputStream;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public boolean isInLocalFileSystem() {
        return true;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cli.common.localfs.KotlinLocalVirtualFile");
        KotlinLocalVirtualFile cfr_ignored_0 = (KotlinLocalVirtualFile)((Object)other);
        return Intrinsics.areEqual((Object)this.file, (Object)((KotlinLocalVirtualFile)((Object)other)).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

