/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAbstractSuperCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAbstractSuperCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAbstractSuperCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAbstractSuperCallChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n96#2,3:63\n101#2:67\n96#3:66\n41#4:68\n14#4:69\n14#4:72\n295#5,2:70\n*S KotlinDebug\n*F\n+ 1 FirAbstractSuperCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAbstractSuperCallChecker\n*L\n33#1:63,3\n33#1:67\n33#1:66\n42#1:68\n43#1:69\n50#1:72\n47#1:70,2\n*E\n"})
public final class FirAbstractSuperCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirAbstractSuperCallChecker INSTANCE = new FirAbstractSuperCallChecker();

    private FirAbstractSuperCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        Object it;
        FirElement firElement;
        block17: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (FirHelpersKt.explicitReceiverIsNotSuperReference(expression2)) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirClass)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirClass)firDeclaration)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block17;
            }
            firElement = null;
        }
        FirClass firClass = (FirClass)firElement;
        if (firClass == null) {
            return;
        }
        FirClass closestClass = firClass;
        if (closestClass.getClassKind() == ClassKind.CLASS) {
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol<?> declarationSymbol = firCallableSymbol;
            Object object = ClassMembersKt.containingClassLookupTag(declarationSymbol);
            if (object == null || (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, context2.getSession())) == null) {
                return;
            }
            Object containingClassSymbol = object;
            FirBasedSymbol $this$isAbstract$iv = (FirClassLikeSymbol)containingClassSymbol;
            boolean $i$f$isAbstract = false;
            if (((FirClassLikeSymbol)$this$isAbstract$iv).getResolvedStatus().getModality() == Modality.ABSTRACT) {
                $this$isAbstract$iv = declarationSymbol;
                $i$f$isAbstract = false;
                if (((FirCallableSymbol)$this$isAbstract$iv).getResolvedStatus().getModality() == Modality.ABSTRACT) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getABSTRACT_SUPER_CALL(), null, 8, null);
                }
                if (declarationSymbol instanceof FirIntersectionCallableSymbol) {
                    boolean bl;
                    FirCallableSymbol symbolFromBaseClass;
                    Object v6;
                    block18: {
                        Iterable $this$firstOrNull$iv = ((FirIntersectionCallableSymbol)((Object)declarationSymbol)).getIntersections();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (FirCallableSymbol)element$iv;
                            boolean bl2 = false;
                            Object object2 = ClassMembersKt.containingClassLookupTag(it);
                            if (!((object2 != null && (object2 = ToSymbolUtilsKt.toSymbol((ConeClassLikeLookupTag)object2, context2.getSession())) != null ? FirHelpersKt.getClassKind(object2) : null) != ClassKind.INTERFACE)) continue;
                            v6 = element$iv;
                            break block18;
                        }
                        v6 = null;
                    }
                    FirCallableSymbol firCallableSymbol2 = symbolFromBaseClass = (FirCallableSymbol)v6;
                    if (firCallableSymbol2 != null) {
                        FirCallableSymbol $this$isAbstract$iv2 = firCallableSymbol2;
                        boolean $i$f$isAbstract2 = false;
                        bl = $this$isAbstract$iv2.getResolvedStatus().getModality() == Modality.ABSTRACT;
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidSuperDelegationToAbstractFakeOverride)) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getABSTRACT_SUPER_CALL(), null, 8, null);
                        } else {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getABSTRACT_SUPER_CALL_WARNING(), null, 8, null);
                        }
                    }
                }
            }
        }
    }
}

