/*
 * Decompiled with CFR 0.152.
 */
package org.jline.widget;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jline.keymap.KeyMap;
import org.jline.reader.Binding;
import org.jline.reader.Buffer;
import org.jline.reader.LineReader;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.Widget;
import org.jline.utils.AttributedString;
import org.jline.utils.Status;

public abstract class Widgets {
    public static final String TAILTIP_TOGGLE = "tailtip-toggle";
    public static final String TAILTIP_PANE = "tailtip-window";
    public static final String AUTOPAIR_TOGGLE = "autopair-toggle";
    public static final String AUTOSUGGEST_TOGGLE = "autosuggest-toggle";
    protected static final String AP_INSERT = "_autopair-insert";
    protected static final String AP_BACKWARD_DELETE_CHAR = "_autopair-backward-delete-char";
    protected static final String TT_ACCEPT_LINE = "_tailtip-accept-line";
    protected final LineReader reader;

    public Widgets(LineReader reader) {
        this.reader = reader;
    }

    public void addWidget(String name2, Widget widget) {
        this.reader.getWidgets().put(name2, this.namedWidget(name2, widget));
    }

    private Widget namedWidget(final String name2, final Widget widget) {
        return new Widget(){

            public String toString() {
                return name2;
            }

            @Override
            public boolean apply() {
                return widget.apply();
            }
        };
    }

    public void callWidget(String name2) {
        if (!name2.startsWith("_") && !name2.endsWith("-toggle")) {
            name2 = "." + name2;
        }
        this.reader.callWidget(name2);
    }

    public void executeWidget(String name2) {
        Binding ref = this.getKeyMap().getBoundKeys().get(KeyMap.alt(KeyMap.ctrl('X')));
        this.getKeyMap().bind((Binding)new Reference(name2), (CharSequence)KeyMap.alt(KeyMap.ctrl('X')));
        this.reader.runMacro(KeyMap.alt(KeyMap.ctrl('X')));
        if (ref != null) {
            this.getKeyMap().bind(ref, (CharSequence)KeyMap.alt(KeyMap.ctrl('X')));
        }
    }

    public void aliasWidget(String orig, String alias) {
        this.reader.getWidgets().put(alias, this.widget(orig));
    }

    public String getWidget(String name2) {
        return this.widget(name2).toString();
    }

    public boolean existsWidget(String name2) {
        try {
            this.widget(name2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Widget widget(String name2) {
        Widget out = name2.startsWith(".") ? this.reader.getBuiltinWidgets().get(name2.substring(1)) : this.reader.getWidgets().get(name2);
        if (out == null) {
            throw new InvalidParameterException("widget: no such widget " + name2);
        }
        return out;
    }

    public Parser parser() {
        return this.reader.getParser();
    }

    public KeyMap<Binding> getKeyMap() {
        return this.reader.getKeyMaps().get("main");
    }

    public Buffer buffer() {
        return this.reader.getBuffer();
    }

    public void replaceBuffer(Buffer buffer) {
        this.reader.getBuffer().copyFrom(buffer);
    }

    public List<String> args() {
        return this.reader.getParser().parse(this.buffer().toString(), 0, Parser.ParseContext.COMPLETE).words();
    }

    public String prevChar() {
        return String.valueOf((char)this.reader.getBuffer().prevChar());
    }

    public String currChar() {
        return String.valueOf((char)this.reader.getBuffer().currChar());
    }

    public String lastBinding() {
        return this.reader.getLastBinding();
    }

    public void putString(String string) {
        this.reader.getBuffer().write(string);
    }

    public String tailTip() {
        return this.reader.getTailTip();
    }

    public void setTailTip(String tailTip) {
        this.reader.setTailTip(tailTip);
    }

    public void setErrorPattern(Pattern errorPattern) {
        this.reader.getHighlighter().setErrorPattern(errorPattern);
    }

    public void setErrorIndex(int errorIndex) {
        this.reader.getHighlighter().setErrorIndex(errorIndex);
    }

    public void clearTailTip() {
        this.reader.setTailTip("");
    }

    public void setSuggestionType(LineReader.SuggestionType type) {
        this.reader.setAutosuggestion(type);
    }

    public void addDescription(List<AttributedString> desc) {
        Status.getStatus(this.reader.getTerminal()).update(desc);
    }

    public void clearDescription() {
        this.initDescription(0);
    }

    public void initDescription(int size) {
        Status status2 = Status.getStatus(this.reader.getTerminal(), false);
        if (size > 0) {
            if (status2 == null) {
                status2 = Status.getStatus(this.reader.getTerminal());
            }
            status2.setBorder(true);
            ArrayList<AttributedString> as = new ArrayList<AttributedString>();
            for (int i2 = 0; i2 < size; ++i2) {
                as.add(new AttributedString(""));
            }
            this.addDescription(as);
        } else if (status2 != null) {
            if (size < 0) {
                status2.update(null);
            } else {
                status2.clear();
            }
        }
    }

    public void destroyDescription() {
        this.initDescription(-1);
    }
}

