/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithArgs;
import org.jetbrains.kotlin.analysis.decompiler.stub.AnnotationWithTarget;
import org.jetbrains.kotlin.analysis.decompiler.stub.CallableClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.psi.stubs.elements.KtPrimaryConstructorElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtSecondaryConstructorElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinConstructorStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J \u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/ConstructorClsStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/CallableClsStubBuilder;", "parent", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "outerContext", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "protoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "constructorProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;", "<init>", "(Lcom/intellij/psi/stubs/StubElement;Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;)V", "receiverType", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "getReceiverType", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "receiverAnnotations", "", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/AnnotationWithTarget;", "getReceiverAnnotations", "()Ljava/util/List;", "returnType", "getReturnType", "contextReceiverTypes", "getContextReceiverTypes", "createValueParameterList", "", "createModifierListStub", "doCreateCallableStub", "decompiler-to-stubs"})
final class ConstructorClsStubBuilder
extends CallableClsStubBuilder {
    @NotNull
    private final ProtoBuf.Constructor constructorProto;

    public ConstructorClsStubBuilder(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull ProtoBuf.Constructor constructorProto) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)outerContext, (String)"outerContext");
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"protoContainer");
        Intrinsics.checkNotNullParameter((Object)constructorProto, (String)"constructorProto");
        super(parent2, outerContext, protoContainer, CollectionsKt.emptyList());
        this.constructorProto = constructorProto;
    }

    @Override
    @Nullable
    public ProtoBuf.Type getReceiverType() {
        return null;
    }

    @Override
    @NotNull
    public List<AnnotationWithTarget> getReceiverAnnotations() {
        return CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public ProtoBuf.Type getReturnType() {
        return null;
    }

    @Override
    @NotNull
    public List<ProtoBuf.Type> getContextReceiverTypes() {
        return CollectionsKt.emptyList();
    }

    @Override
    public void createValueParameterList() {
        TypeClsStubBuilder typeClsStubBuilder = this.getTypeStubBuilder();
        StubElement<? extends PsiElement> stubElement = this.getCallableStub();
        MessageLite messageLite = this.constructorProto;
        List<ProtoBuf.ValueParameter> list = this.constructorProto.getValueParameterList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameterList(...)");
        TypeClsStubBuilder.createValueParameterListStub$default(typeClsStubBuilder, stubElement, messageLite, list, this.getProtoContainer(), null, 16, null);
    }

    @Override
    public void createModifierListStub() {
        int flags = this.constructorProto.getFlags();
        KotlinModifierListStubImpl modifierListStubImpl = this.createModifierListStubForCallableDeclaration(flags, CollectionsKt.listOf((Object)FlagsKt.getVISIBILITY()), Flags.HAS_MUST_USE_RETURN_VALUE_CTOR);
        if (!Flags.HAS_ANNOTATIONS.get(flags).booleanValue()) {
            return;
        }
        List<AnnotationWithArgs> annotationIds = this.getC().getComponents().getAnnotationLoader().loadCallableAnnotations(this.getProtoContainer(), this.constructorProto, AnnotatedCallableKind.FUNCTION);
        ClsStubBuildingKt.createAnnotationStubs(annotationIds, modifierListStubImpl);
    }

    @Override
    @NotNull
    public StubElement<? extends PsiElement> doCreateCallableStub(@NotNull StubElement<? extends PsiElement> parent2) {
        StubElement stubElement;
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        ProtoContainer protoContainer = this.getProtoContainer();
        Intrinsics.checkNotNull((Object)protoContainer, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.serialization.deserialization.ProtoContainer.Class");
        StringRef name2 = ClsStubBuildingKt.ref(((ProtoContainer.Class)protoContainer).getClassId().getShortClassName());
        if (Flags.IS_SECONDARY.get(this.constructorProto.getFlags()).booleanValue()) {
            KtSecondaryConstructorElementType ktSecondaryConstructorElementType = KtStubElementTypes.SECONDARY_CONSTRUCTOR;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)ktSecondaryConstructorElementType), (String)"SECONDARY_CONSTRUCTOR");
            stubElement = (StubElement)new KotlinConstructorStubImpl(parent2, ktSecondaryConstructorElementType, name2, true, false, false);
        } else {
            KtPrimaryConstructorElementType ktPrimaryConstructorElementType = KtStubElementTypes.PRIMARY_CONSTRUCTOR;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)ktPrimaryConstructorElementType), (String)"PRIMARY_CONSTRUCTOR");
            stubElement = (StubElement)new KotlinConstructorStubImpl(parent2, ktPrimaryConstructorElementType, name2, false, false, false);
        }
        return stubElement;
    }
}

