/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.SuperCallReceiverValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0015\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001cR\u0013\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DeprecatedCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "isSuperCall", "", "PROPERTY_SET_OPERATIONS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "shouldCheckPropertyGetter", "expression", "shouldCheckPropertyGetter$frontend", "frontend"})
@SourceDebugExtension(value={"SMAP\nDeprecatedCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/DeprecatedCallChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class DeprecatedCallChecker
implements CallChecker {
    @NotNull
    public static final DeprecatedCallChecker INSTANCE = new DeprecatedCallChecker();
    @NotNull
    private static final TokenSet PROPERTY_SET_OPERATIONS;

    private DeprecatedCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        this.check((CallableDescriptor)obj, context2.getTrace(), reportOn, context2.getLanguageVersionSettings(), context2.getDeprecationResolver(), resolvedCall2.getDispatchReceiver() instanceof SuperCallReceiverValue);
    }

    private final void check(CallableDescriptor targetDescriptor, BindingTrace trace, PsiElement element, LanguageVersionSettings languageVersionSettings, DeprecationResolver deprecationResolver, boolean isSuperCall) {
        block5: {
            block4: {
                if (targetDescriptor instanceof FakeCallableDescriptorForObject) {
                    return;
                }
                List deprecations = CollectionsKt.toMutableList((Collection)deprecationResolver.getDeprecations(targetDescriptor));
                if (targetDescriptor instanceof PropertySetterDescriptor) {
                    Collection collection = deprecations;
                    PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)targetDescriptor).getCorrespondingProperty();
                    Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"getCorrespondingProperty(...)");
                    CollectionsKt.removeAll((Collection)collection, (Iterable)deprecationResolver.getDeprecations(propertyDescriptor));
                }
                if (!(!((Collection)deprecations).isEmpty())) break block4;
                for (DescriptorBasedDeprecationInfo deprecation : deprecations) {
                    FqName targetFqNameIfAny = DescriptorUtilsKt.fqNameOrNull(targetDescriptor);
                    trace.report(DeprecationUtilKt.createDeprecationDiagnostic(element, deprecation, languageVersionSettings, isSuperCall && CollectionsKt.contains((Iterable)DeprecationResolver.Companion.getKOTLIN_LIST_FIRST_LAST(), (Object)targetFqNameIfAny)));
                }
                break block5;
            }
            if (!(targetDescriptor instanceof PropertyDescriptor) || !this.shouldCheckPropertyGetter$frontend(element)) break block5;
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)targetDescriptor).getGetter();
            if (propertyGetterDescriptor != null) {
                PropertyGetterDescriptor it = propertyGetterDescriptor;
                boolean bl = false;
                INSTANCE.check(it, trace, element, languageVersionSettings, deprecationResolver, false);
            }
        }
    }

    public final boolean shouldCheckPropertyGetter$frontend(@NotNull PsiElement expression2) {
        KtUnaryExpression unaryExpression;
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtBinaryExpression binaryExpression = (KtBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtBinaryExpression.class);
        if (binaryExpression != null) {
            KtExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual((Object)left, (Object)expression2) && PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            KtReferenceExpression[] referenceExpressions = (KtReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)left), KtReferenceExpression.class);
            if (referenceExpressions != null) {
                for (KtReferenceExpression expr : referenceExpressions) {
                    if (!Intrinsics.areEqual((Object)expr, (Object)expression2) || !PROPERTY_SET_OPERATIONS.contains(binaryExpression.getOperationToken())) continue;
                    return false;
                }
            }
        }
        if (PROPERTY_SET_OPERATIONS.contains((ktExpression = (unaryExpression = (KtUnaryExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtUnaryExpression.class))) != null && (ktExpression = ((KtUnaryExpression)ktExpression).getOperationReference()) != null ? ktExpression.getReferencedNameElementType() : null)) {
            return false;
        }
        KtCallableReferenceExpression callableExpression = (KtCallableReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, KtCallableReferenceExpression.class);
        return callableExpression == null || !Intrinsics.areEqual((Object)callableExpression.getCallableReference(), (Object)expression2);
    }

    static {
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.addSpread((Object)KtTokens.ALL_ASSIGNMENTS.getTypes());
        spreadBuilder.add((Object)KtTokens.PLUSPLUS);
        spreadBuilder.add((Object)KtTokens.MINUSMINUS);
        TokenSet tokenSet = TokenSet.create((IElementType[])((IElementType[])spreadBuilder.toArray((Object[])new IElementType[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        PROPERTY_SET_OPERATIONS = tokenSet;
    }
}

