/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.jvm.impl.PathUtilKt;
import kotlin.script.experimental.jvm.util.ClassLoaderResourceRootFIlePathCalculator;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a2\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a2\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a2\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0001H\u0000\u001a\f\u0010#\u001a\u00020\u0001*\u00020$H\u0002\u001aE\u0010%\u001a\u00020\u0011*\u00020&2\u0006\u0010\u0014\u001a\u00020\u00012\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010(\"\u00020\u00012\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016\u00a2\u0006\u0002\u0010)\u001a\f\u0010*\u001a\u00020\u0001*\u00020\u0001H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0014\u0010\n\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0014\u0010\f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0014\u0010\u000e\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006+"}, d2={"pathElementPattern", "", "getPathElementPattern", "()Ljava/lang/String;", "pathSeparatorChars", "", "getPathSeparatorChars", "()[C", "pathSeparatorPattern", "getPathSeparatorPattern", "patternCharsToEscape", "getPatternCharsToEscape", "specialPatternChars", "getSpecialPatternChars", "wildcardChars", "getWildcardChars", "forAllMatchingFilesInDirectory", "", "baseDir", "Ljava/io/File;", "namePattern", "body", "Lkotlin/Function2;", "Ljava/io/InputStream;", "forAllMatchingFilesInJar", "jarFile", "nameRegex", "Lkotlin/text/Regex;", "forAllMatchingFilesInJarFile", "Ljava/util/jar/JarFile;", "forAllMatchingFilesInJarStream", "jarInputStream", "Ljava/util/jar/JarInputStream;", "namePatternToRegex", "pattern", "escape", "", "forAllMatchingFiles", "Ljava/lang/ClassLoader;", "keyResourcePaths", "", "(Ljava/lang/ClassLoader;Ljava/lang/String;[Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "toUniversalSeparator", "kotlin-scripting-jvm"})
@SourceDebugExtension(value={"SMAP\njvmClassLoaderUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jvmClassLoaderUtil.kt\nkotlin/script/experimental/jvm/util/JvmClassLoaderUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,148:1\n1#2:149\n1313#3,2:150\n1313#3,2:152\n12383#4,2:154\n*S KotlinDebug\n*F\n+ 1 jvmClassLoaderUtil.kt\nkotlin/script/experimental/jvm/util/JvmClassLoaderUtilKt\n*L\n81#1:150,2\n110#1:152,2\n56#1:154,2\n*E\n"})
public final class JvmClassLoaderUtilKt {
    @NotNull
    private static final char[] wildcardChars;
    @NotNull
    private static final char[] patternCharsToEscape;
    @NotNull
    private static final char[] pathSeparatorChars;
    @NotNull
    private static final String pathElementPattern;
    @NotNull
    private static final String pathSeparatorPattern;
    @NotNull
    private static final char[] specialPatternChars;

    public static final void forAllMatchingFiles(@NotNull ClassLoader $this$forAllMatchingFiles, @NotNull String namePattern, @NotNull String[] keyResourcePaths, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$forAllMatchingFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter((Object)keyResourcePaths, (String)"keyResourcePaths");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        HashSet<File> processedDirs = new HashSet<File>();
        HashSet<URL> processedJars = new HashSet<URL>();
        Regex nameRegex = JvmClassLoaderUtilKt.namePatternToRegex(namePattern);
        if (keyResourcePaths.length == 0) {
            String[] stringArray2 = new String[]{"", "META-INF/MANIFEST.MF"};
            stringArray = stringArray2;
        } else {
            stringArray = keyResourcePaths;
        }
        JvmClassLoaderUtilKt.forAllMatchingFiles$iterateResources($this$forAllMatchingFiles, processedJars, processedDirs, namePattern, body2, nameRegex, stringArray);
    }

    @NotNull
    public static final char[] getWildcardChars() {
        return wildcardChars;
    }

    @NotNull
    public static final char[] getPatternCharsToEscape() {
        return patternCharsToEscape;
    }

    private static final String escape(char $this$escape) {
        return ($this$escape == '\\' || ArraysKt.contains((char[])patternCharsToEscape, (char)$this$escape) ? "\\" : "") + $this$escape;
    }

    @NotNull
    public static final char[] getPathSeparatorChars() {
        return pathSeparatorChars;
    }

    @NotNull
    public static final String getPathElementPattern() {
        return pathElementPattern;
    }

    @NotNull
    public static final String getPathSeparatorPattern() {
        return pathSeparatorPattern;
    }

    @NotNull
    public static final char[] getSpecialPatternChars() {
        return specialPatternChars;
    }

    @NotNull
    public static final String toUniversalSeparator(@NotNull String $this$toUniversalSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$toUniversalSeparator, (String)"<this>");
        return File.separatorChar == '/' ? $this$toUniversalSeparator : StringsKt.replace$default((String)$this$toUniversalSeparator, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void forAllMatchingFilesInDirectory(@NotNull File baseDir, @NotNull String namePattern, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)namePattern, (String)"namePattern");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        int patternStart = StringsKt.indexOfAny$default((CharSequence)namePattern, (char[])wildcardChars, (int)0, (boolean)false, (int)6, null);
        if (patternStart < 0) {
            File file2;
            File it = file2 = FilesKt.resolve((File)baseDir, (String)namePattern);
            boolean bl = false;
            File file3 = it.exists() && it.isFile() ? file2 : null;
            if (file3 != null) {
                File file4 = file3;
                boolean bl2 = false;
                String string2 = FilesKt.relativeToOrSelf((File)file4, (File)baseDir).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.relativeToOrSelf(baseDir).path");
                body2.invoke((Object)JvmClassLoaderUtilKt.toUniversalSeparator(string2), (Object)new FileInputStream(file4));
            }
        } else {
            File root;
            File file5;
            int patternDirStart = StringsKt.lastIndexOfAny$default((CharSequence)namePattern, (char[])pathSeparatorChars, (int)patternStart, (boolean)false, (int)4, null);
            if (patternDirStart <= 0) {
                file5 = baseDir;
            } else {
                String string3 = namePattern.substring(0, patternDirStart);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                file5 = root = FilesKt.resolve((File)baseDir, (String)string3);
            }
            if (root.exists() && root.isDirectory()) {
                void $this$forEach$iv;
                String string4 = namePattern.substring(patternDirStart + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                Regex re = JvmClassLoaderUtilKt.namePatternToRegex(string4);
                Sequence bl2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)root)), (Function1)((Function1)new Function1<File, Boolean>(re, root){
                    final /* synthetic */ Regex $re;
                    final /* synthetic */ File $root;
                    {
                        this.$re = $re;
                        this.$root = $root;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String string2 = FilesKt.relativeToOrSelf((File)it, (File)this.$root).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.relativeToOrSelf(root).path");
                        return this.$re.matches((CharSequence)string2);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file6 = (File)element$iv;
                    boolean bl = false;
                    String string5 = FilesKt.relativeToOrSelf((File)file6, (File)baseDir).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"file.relativeToOrSelf(baseDir).path");
                    body2.invoke((Object)JvmClassLoaderUtilKt.toUniversalSeparator(string5), (Object)new FileInputStream(file6));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJarStream(@NotNull JarInputStream jarInputStream, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        JarEntry entry;
        Intrinsics.checkNotNullParameter((Object)jarInputStream, (String)"jarInputStream");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        do {
            if ((entry = jarInputStream.getNextJarEntry()) == null) continue;
            try {
                if (entry.isDirectory()) continue;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                if (!nameRegex.matches((CharSequence)string2)) continue;
                String string3 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                body2.invoke((Object)string3, (Object)jarInputStream);
            }
            finally {
                jarInputStream.closeEntry();
            }
        } while (entry != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJar(@NotNull File jarFile, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        Closeable closeable = new JarInputStream(new FileInputStream(jarFile));
        Throwable throwable = null;
        try {
            JarInputStream it = (JarInputStream)closeable;
            boolean bl = false;
            JvmClassLoaderUtilKt.forAllMatchingFilesInJarStream(it, nameRegex, body2);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJarFile(@NotNull JarFile jarFile, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body2) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        Enumeration<JarEntry> enumeration = jarFile.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
        Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JarEntry entry = (JarEntry)element$iv;
            boolean bl = false;
            if (entry.isDirectory()) continue;
            String string2 = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
            if (!nameRegex.matches((CharSequence)string2)) continue;
            Closeable closeable = jarFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl2 = false;
                String string3 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"entry.name");
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
                body2.invoke((Object)string3, (Object)stream);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public static final Regex namePatternToRegex(@NotNull String pattern) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        StringBuilder $this$namePatternToRegex_u24lambda_u2411 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        int current = 0;
        while (current < pattern.length()) {
            int nextIndex = StringsKt.indexOfAny$default((CharSequence)pattern, (char[])specialPatternChars, (int)current, (boolean)false, (int)4, null);
            int next = nextIndex < 0 ? pattern.length() : nextIndex;
            String string2 = pattern.substring(current, next);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$namePatternToRegex_u24lambda_u2411.append(string2);
            current = next + 1;
            if (next >= pattern.length()) break;
            if (ArraysKt.contains((char[])pathSeparatorChars, (char)pattern.charAt(next))) {
                $this$namePatternToRegex_u24lambda_u2411.append(pathSeparatorPattern);
                continue;
            }
            if (pattern.charAt(next) == '?') {
                $this$namePatternToRegex_u24lambda_u2411.append('.');
                continue;
            }
            if (pattern.charAt(next) == '*' && next + 1 < pattern.length() && pattern.charAt(next + 1) == '*') {
                $this$namePatternToRegex_u24lambda_u2411.append(".*");
                ++current;
                continue;
            }
            if (pattern.charAt(next) == '*') {
                $this$namePatternToRegex_u24lambda_u2411.append(pathElementPattern);
                continue;
            }
            $this$namePatternToRegex_u24lambda_u2411.append('\\');
            $this$namePatternToRegex_u24lambda_u2411.append(pattern.charAt(next));
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        String string4 = string3;
        return new Regex(string4);
    }

    private static final void forAllMatchingFiles$iterateResources(ClassLoader $this_forAllMatchingFiles, HashSet<URL> processedJars, HashSet<File> processedDirs, String $namePattern, Function2<? super String, ? super InputStream, Unit> $body, Regex nameRegex, String[] keyResourcePaths) {
        for (String keyResourcePath : keyResourcePaths) {
            ClassLoaderResourceRootFIlePathCalculator resourceRootCalc = new ClassLoaderResourceRootFIlePathCalculator(keyResourcePath);
            Enumeration<URL> enumeration = $this_forAllMatchingFiles.getResources(keyResourcePath);
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(keyResourcePath)");
            Iterator iterator2 = CollectionsKt.iterator(enumeration);
            while (iterator2.hasNext()) {
                File rootDir;
                File file2;
                URL url = (URL)iterator2.next();
                if (Intrinsics.areEqual((Object)url.getProtocol(), (Object)"jar")) {
                    JarFile jarFile;
                    JarFile jarFile2;
                    JarURLConnection jarConnection;
                    URLConnection uRLConnection = url.openConnection();
                    JarURLConnection jarURLConnection = jarConnection = uRLConnection instanceof JarURLConnection ? (JarURLConnection)uRLConnection : null;
                    URL jarUrl = jarURLConnection != null ? jarURLConnection.getJarFileURL() : null;
                    if (jarUrl == null || processedJars.contains(jarUrl)) continue;
                    processedJars.add(jarUrl);
                    try {
                        jarFile2 = jarConnection.getJarFile();
                    }
                    catch (IOException _) {
                        jarFile2 = null;
                    }
                    if ((jarFile = jarFile2) == null) continue;
                    JarFile it = jarFile;
                    boolean bl = false;
                    JvmClassLoaderUtilKt.forAllMatchingFilesInJarFile(it, nameRegex, $body);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
                if (PathUtilKt.toFileOrNull(url) != null) {
                    File it;
                    boolean bl = false;
                    file2 = resourceRootCalc.invoke(it);
                } else {
                    file2 = null;
                }
                if ((rootDir = file2) == null || !rootDir.isDirectory() || processedDirs.contains(rootDir)) continue;
                processedDirs.add(rootDir);
                JvmClassLoaderUtilKt.forAllMatchingFilesInDirectory(rootDir, $namePattern, $body);
            }
        }
    }

    static {
        boolean bl;
        Object it;
        char[] cArray;
        block2: {
            boolean bl2;
            char[] cArray2 = "*?".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            wildcardChars = cArray2;
            char[] cArray3 = ".*?+()[]^${}|".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"this as java.lang.String).toCharArray()");
            cArray = cArray3;
            it = cArray;
            boolean bl3 = false;
            char[] $this$all$iv = wildcardChars;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int j = 0; j < n; ++j) {
                char element$iv;
                char wc = element$iv = $this$all$iv[j];
                boolean bl4 = false;
                if (ArraysKt.contains((char[])it, (char)wc)) continue;
                bl2 = false;
                break block2;
            }
            bl2 = bl = true;
        }
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        patternCharsToEscape = cArray;
        it = "/";
        boolean bl5 = false;
        char[] cArray4 = ((String)(File.separatorChar == '/' ? it : (String)it + File.separator)).toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray4, (String)"this as java.lang.String).toCharArray()");
        pathSeparatorChars = cArray4;
        pathElementPattern = File.separatorChar == '/' ? "[^/]*" : "[^/" + JvmClassLoaderUtilKt.escape(File.separatorChar) + "]*";
        pathSeparatorPattern = File.separatorChar == '/' ? "/" : "[/" + JvmClassLoaderUtilKt.escape(File.separatorChar) + ']';
        specialPatternChars = ArraysKt.plus((char[])patternCharsToEscape, (char[])pathSeparatorChars);
    }
}

