/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.io.URLUtil;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInDecompiler;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationIndex;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticDeclarationProviderFactory;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002,-B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\"\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020(0\u0005H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "jarFileSystem", "Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;)V", "builtInDecompiler", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinBuiltInDecompiler;", "index", "Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationIndex;", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "addToClassMap", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "addToFacadeFileMap", "file", "addToFunctionMap", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "addToPropertyMap", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "addToScriptMap", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "addToTypeAliasMap", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "createDeclarationProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "createKtFileStub", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "loadBuiltIns", "KtClassFileViewProvider", "KtDeclarationRecorder", "analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nKotlinStaticDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStaticDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1855#2:287\n1855#2,2:288\n1856#2:290\n1855#2,2:291\n1855#2:293\n1856#2:295\n1855#2,2:296\n1#3:294\n*S KotlinDebug\n*F\n+ 1 KotlinStaticDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory\n*L\n257#1:287\n271#1:288,2\n257#1:290\n276#1:291,2\n122#1:293\n122#1:295\n248#1:296,2\n*E\n"})
public final class KotlinStaticDeclarationProviderFactory
extends KotlinDeclarationProviderFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final CoreJarFileSystem jarFileSystem;
    @NotNull
    private final KotlinStaticDeclarationIndex index;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final KotlinBuiltInDecompiler builtInDecompiler;

    public KotlinStaticDeclarationProviderFactory(@NotNull Project project, @NotNull Collection<? extends KtFile> files2, @NotNull CoreJarFileSystem jarFileSystem) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Intrinsics.checkNotNullParameter((Object)jarFileSystem, (String)"jarFileSystem");
        this.project = project;
        this.jarFileSystem = jarFileSystem;
        this.index = new KotlinStaticDeclarationIndex();
        PsiManager psiManager2 = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(project)");
        this.psiManager = psiManager2;
        this.builtInDecompiler = new KotlinBuiltInDecompiler();
        KtDeclarationRecorder recorder2 = new KtDeclarationRecorder();
        if (Boolean.parseBoolean(System.getProperty("lint.use.fir.uast", "false"))) {
            $this$forEach$iv = this.loadBuiltIns();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinFileStubImpl ktFileStub = (KotlinFileStubImpl)element$iv;
                boolean bl = false;
                PsiFile psiFile = ktFileStub.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"ktFileStub.psi");
                KtFile ktFile = (KtFile)psiFile;
                this.addToFacadeFileMap(ktFile);
                List<String> partNames = ktFileStub.getFacadePartSimpleNames();
                if (partNames != null) {
                    FqName packageFqName = ktFileStub.getPackageFqName();
                    for (String partName : partNames) {
                        FqName multiFileClassPartFqName;
                        Intrinsics.checkNotNullExpressionValue((Object)packageFqName.child(Name.identifier(partName)), (String)"packageFqName.child(Name.identifier(partName))");
                        this.index.getMultiFileClassPartMap$analysis_api_providers().computeIfAbsent(multiFileClassPartFqName, arg_0 -> KotlinStaticDeclarationProviderFactory.lambda$16$lambda$14(1.1.INSTANCE, arg_0)).add(ktFile);
                    }
                }
                List list2 = ktFileStub.getChildrenStubs();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ktFileStub.childrenStubs");
                Iterable $this$forEach$iv2 = list2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    StubElement p0 = (StubElement)element$iv2;
                    boolean bl2 = false;
                    KotlinStaticDeclarationProviderFactory._init_$indexStub(this, p0);
                }
            }
        }
        $this$forEach$iv = files2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile it = (KtFile)element$iv;
            boolean bl = false;
            it.accept(recorder2);
        }
    }

    public /* synthetic */ KotlinStaticDeclarationProviderFactory(Project project, Collection collection, CoreJarFileSystem coreJarFileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            coreJarFileSystem = new CoreJarFileSystem();
        }
        this(project, collection, coreJarFileSystem);
    }

    private final Collection<KotlinFileStubImpl> loadBuiltIns() {
        List list2;
        ClassLoader classLoader2 = this.getClass().getClassLoader();
        List $this$loadBuiltIns_u24lambda_u245 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = StandardClassIds.INSTANCE.getBuiltInsPackages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinFileStubImpl file2;
            FileContent fileContent;
            VirtualFile vf;
            Pair it;
            URL uRL;
            FqName builtInPackageFqName = (FqName)element$iv;
            boolean bl2 = false;
            String resourcePath = BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(builtInPackageFqName);
            URL uRL2 = uRL = classLoader2.getResource(resourcePath);
            if (uRL2 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"getResource(resourcePath)");
            URL resourceUrl = uRL;
            boolean bl3 = false;
            if (URLUtil.splitJarUrl((String)resourceUrl.getPath()) == null) continue;
            boolean bl4 = false;
            String jarPath = (String)it.first;
            String builtInFile = (String)it.second;
            String pathToQuery = jarPath + "!/" + builtInFile;
            if (this.jarFileSystem.findFileByPath(pathToQuery) == null) continue;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)FileContentImpl.createByFile((VirtualFile)vf, (Project)this.project), (String)"createByFile(vf, project)");
            if (this.createKtFileStub(this.psiManager, this.builtInDecompiler, fileContent) == null) continue;
            boolean bl6 = false;
            $this$loadBuiltIns_u24lambda_u245.add(file2);
        }
        return CollectionsKt.build((List)list2);
    }

    private final KotlinFileStubImpl createKtFileStub(PsiManager psiManager2, KotlinBuiltInDecompiler builtInDecompiler, FileContent fileContent) {
        Object object = builtInDecompiler.getStubBuilder().buildFileStub(fileContent);
        KotlinFileStubImpl kotlinFileStubImpl = object instanceof KotlinFileStubImpl ? (KotlinFileStubImpl)object : null;
        if (kotlinFileStubImpl == null) {
            return null;
        }
        KotlinFileStubImpl ktFileStub = kotlinFileStubImpl;
        VirtualFile virtualFile = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"fileContent.file");
        object = new KtClassFileViewProvider(psiManager2, virtualFile);
        KtFile fakeFile2 = new KtFile(ktFileStub, (KtClassFileViewProvider)((Object)object)){
            final /* synthetic */ KotlinFileStubImpl $ktFileStub;
            {
                this.$ktFileStub = $ktFileStub;
                super((FileViewProvider)$super_call_param$1, true);
            }

            @NotNull
            public KotlinFileStubImpl getStub() {
                return this.$ktFileStub;
            }

            public boolean isPhysical() {
                return false;
            }
        };
        ktFileStub.setPsi((PsiFile)fakeFile2);
        return ktFileStub;
    }

    private final void addToFacadeFileMap(KtFile file2) {
        if (!file2.hasTopLevelCallables()) {
            return;
        }
        this.index.getFacadeFileMap$analysis_api_providers().computeIfAbsent(file2.getPackageFqName(), arg_0 -> KotlinStaticDeclarationProviderFactory.addToFacadeFileMap$lambda$6(addToFacadeFileMap.1.INSTANCE, arg_0)).add(file2);
    }

    private final void addToScriptMap(KtScript script) {
        this.index.getScriptMap$analysis_api_providers().computeIfAbsent(script.getFqName(), arg_0 -> KotlinStaticDeclarationProviderFactory.addToScriptMap$lambda$7(addToScriptMap.1.INSTANCE, arg_0)).add(script);
    }

    private final void addToClassMap(KtClassOrObject classOrObject) {
        block0: {
            ClassId classId = classOrObject.getClassId();
            if (classId == null) break block0;
            ClassId classId2 = classId;
            boolean bl = false;
            this.index.getClassMap$analysis_api_providers().computeIfAbsent(classId2.getPackageFqName(), arg_0 -> KotlinStaticDeclarationProviderFactory.addToClassMap$lambda$9$lambda$8(addToClassMap.1.1.INSTANCE, arg_0)).add(classOrObject);
        }
    }

    private final void addToTypeAliasMap(KtTypeAlias typeAlias) {
        block0: {
            ClassId classId = typeAlias.getClassId();
            if (classId == null) break block0;
            ClassId classId2 = classId;
            boolean bl = false;
            this.index.getTypeAliasMap$analysis_api_providers().computeIfAbsent(classId2.getPackageFqName(), arg_0 -> KotlinStaticDeclarationProviderFactory.addToTypeAliasMap$lambda$11$lambda$10(addToTypeAliasMap.1.1.INSTANCE, arg_0)).add(typeAlias);
        }
    }

    private final void addToFunctionMap(KtNamedFunction function2) {
        if (!function2.isTopLevel()) {
            return;
        }
        PsiElement psiElement = function2.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
        this.index.getTopLevelFunctionMap$analysis_api_providers().computeIfAbsent(packageFqName, arg_0 -> KotlinStaticDeclarationProviderFactory.addToFunctionMap$lambda$12(addToFunctionMap.1.INSTANCE, arg_0)).add(function2);
    }

    private final void addToPropertyMap(KtProperty property) {
        if (!property.isTopLevel()) {
            return;
        }
        PsiElement psiElement = property.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
        this.index.getTopLevelPropertyMap$analysis_api_providers().computeIfAbsent(packageFqName, arg_0 -> KotlinStaticDeclarationProviderFactory.addToPropertyMap$lambda$13(addToPropertyMap.1.INSTANCE, arg_0)).add(property);
    }

    @Override
    @NotNull
    public KotlinDeclarationProvider createDeclarationProvider(@NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        return new KotlinStaticDeclarationProvider(this.index, searchScope);
    }

    private static final Set addToFacadeFileMap$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToScriptMap$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToClassMap$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToTypeAliasMap$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToFunctionMap$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToPropertyMap$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final void _init_$indexStub(KotlinStaticDeclarationProviderFactory this$0, StubElement<?> stub) {
        StubElement<?> stubElement = stub;
        if (stubElement instanceof KotlinClassStubImpl) {
            PsiElement psiElement = ((KotlinClassStubImpl)stub).getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"stub.psi");
            this$0.addToClassMap((KtClassOrObject)psiElement);
            List list2 = ((KotlinClassStubImpl)stub).getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"stub.childrenStubs");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StubElement p0 = (StubElement)element$iv;
                boolean bl = false;
                KotlinStaticDeclarationProviderFactory._init_$indexStub(this$0, p0);
            }
        } else if (stubElement instanceof KotlinTypeAliasStubImpl) {
            PsiElement psiElement = ((KotlinTypeAliasStubImpl)stub).getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"stub.psi");
            this$0.addToTypeAliasMap((KtTypeAlias)psiElement);
        } else if (stubElement instanceof KotlinFunctionStubImpl) {
            PsiElement psiElement = ((KotlinFunctionStubImpl)stub).getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"stub.psi");
            this$0.addToFunctionMap((KtNamedFunction)psiElement);
        } else if (stubElement instanceof KotlinPropertyStubImpl) {
            PsiElement psiElement = ((KotlinPropertyStubImpl)stub).getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"stub.psi");
            this$0.addToPropertyMap((KtProperty)psiElement);
        }
    }

    private static final Set lambda$16$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory$KtClassFileViewProvider;", "Lcom/intellij/psi/SingleRootFileViewProvider;", "psiManager", "Lcom/intellij/psi/PsiManager;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;)V", "analysis-api-providers"})
    private static final class KtClassFileViewProvider
    extends SingleRootFileViewProvider {
        public KtClassFileViewProvider(@NotNull PsiManager psiManager2, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)psiManager2, (String)"psiManager");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            super(psiManager2, virtualFile, true, (Language)KotlinLanguage.INSTANCE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory$KtDeclarationRecorder;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "(Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory;)V", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitElement", "element", "Lcom/intellij/psi/PsiElement;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "analysis-api-providers"})
    @SourceDebugExtension(value={"SMAP\nKotlinStaticDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStaticDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticDeclarationProviderFactory$KtDeclarationRecorder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1#2:287\n*E\n"})
    private final class KtDeclarationRecorder
    extends KtVisitorVoid {
        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren((PsiElementVisitor)this);
        }

        @Override
        public void visitKtFile(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KotlinStaticDeclarationProviderFactory.this.addToFacadeFileMap(file2);
            KtScript ktScript = file2.getScript();
            if (ktScript != null) {
                KtScript ktScript2 = ktScript;
                KotlinStaticDeclarationProviderFactory kotlinStaticDeclarationProviderFactory = KotlinStaticDeclarationProviderFactory.this;
                KtScript it = ktScript2;
                boolean bl = false;
                kotlinStaticDeclarationProviderFactory.addToScriptMap(it);
            }
            super.visitKtFile(file2);
        }

        @Override
        public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            KotlinStaticDeclarationProviderFactory.this.addToClassMap(classOrObject);
            super.visitClassOrObject(classOrObject);
        }

        @Override
        public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            KotlinStaticDeclarationProviderFactory.this.addToTypeAliasMap(typeAlias);
            super.visitTypeAlias(typeAlias);
        }

        @Override
        public void visitNamedFunction(@NotNull KtNamedFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            KotlinStaticDeclarationProviderFactory.this.addToFunctionMap(function2);
            super.visitNamedFunction(function2);
        }

        @Override
        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            KotlinStaticDeclarationProviderFactory.this.addToPropertyMap(property);
            super.visitProperty(property);
        }
    }
}

