/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;

public class XmlMessageRenderer
implements MessageRenderer {
    @Override
    public String renderPreamble() {
        return "<MESSAGES>";
    }

    @Override
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageSourceLocation location) {
        if (severity == null) {
            XmlMessageRenderer.$$$reportNull$$$0(0);
        }
        if (message2 == null) {
            XmlMessageRenderer.$$$reportNull$$$0(1);
        }
        StringBuilder out = new StringBuilder();
        String tagName = severity.getPresentableName();
        out.append("<").append(tagName);
        if (location != null) {
            out.append(" path=\"").append(XmlMessageRenderer.e(location.getPath())).append("\"");
            out.append(" line=\"").append(location.getLine()).append("\"");
            out.append(" column=\"").append(location.getColumn()).append("\"");
        }
        out.append(">");
        out.append(XmlMessageRenderer.e(message2));
        out.append("</").append(tagName).append(">\n");
        return out.toString();
    }

    private static String e(String str) {
        return StringUtil.escapeXmlEntities((String)str);
    }

    @Override
    public String renderUsage(@NotNull String usage) {
        if (usage == null) {
            XmlMessageRenderer.$$$reportNull$$$0(2);
        }
        return this.render(CompilerMessageSeverity.STRONG_WARNING, usage, null);
    }

    @Override
    public String renderConclusion() {
        return "</MESSAGES>";
    }

    @Override
    public String getName() {
        return "XML";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/XmlMessageRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "renderUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

