/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirSyntheticFunctionInterfaceProviderBase;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindService;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.ArrayMapAccessor;
import org.jetbrains.kotlin.util.TypeRegistry;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u001aF\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u0012\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00140\u00152\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u0002H\u0014\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0013\u0018\u00010\u00150\u0017H\u0086\b\u00f8\u0001\u0000\u001a\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0016\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a$\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0\u0019*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0014\u0010#\u001a\u0004\u0018\u00010$*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001a,\u0010%\u001a\u0004\u0018\u0001H\u0014\"\u000e\b\u0000\u0010\u0014\u0018\u0001*\u0006\u0012\u0002\b\u00030&*\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0086\b\u00a2\u0006\u0002\u0010)\u001a*\u0010*\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010+\u001a\u00020\r\u001a\u001b\u0010*\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010,\u001a\u00020\u001eH\u0082\b\u001a\u0018\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010.*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001f\u0010\u0002\u001a\u00020\u0003*\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"\u001f\u0010\t\u001a\u00020\u0003*\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006/"}, d2={"DEPENDENCIES_SYMBOL_PROVIDER_QUALIFIED_KEY", "", "dependenciesSymbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getDependenciesSymbolProvider", "(Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "dependenciesSymbolProvider$delegate", "Lorg/jetbrains/kotlin/util/ArrayMapAccessor;", "symbolProvider", "getSymbolProvider", "symbolProvider$delegate", "isNameForFunctionClass", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "flatMapToNullableSet", "", "R", "T", "", "transform", "Lkotlin/Function1;", "getClassDeclaredConstructors", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "getClassDeclaredFunctionSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getClassDeclaredMemberScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "getClassDeclaredPropertySymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "getRegularClassSymbolByClassId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getSymbolByTypeRef", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "mayHaveTopLevelClassifier", "mayBeFunctionClass", "shortClassName", "toSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "providers"})
@SourceDebugExtension(value={"SMAP\nFirSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 4 FirSession.kt\norg/jetbrains/kotlin/fir/FirSession$Companion\n*L\n1#1,161:1\n142#1:171\n142#1:172\n1446#2,5:162\n24#3,4:167\n24#4:173\n28#4:174\n*S KotlinDebug\n*F\n+ 1 FirSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProviderKt\n*L\n132#1:171\n134#1:172\n85#1:162,5\n108#1:167,4\n154#1:173\n158#1:174\n*E\n"})
public final class FirSymbolProviderKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ArrayMapAccessor symbolProvider$delegate;
    @NotNull
    public static final String DEPENDENCIES_SYMBOL_PROVIDER_QUALIFIED_KEY = "org.jetbrains.kotlin.fir.resolve.providers.FirDependenciesSymbolProvider";
    @NotNull
    private static final ArrayMapAccessor dependenciesSymbolProvider$delegate;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T, R> Set<R> flatMapToNullableSet(@NotNull Iterable<? extends T> $this$flatMapToNullableSet, @NotNull Function1<? super T, ? extends Iterable<? extends R>> transform2) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter($this$flatMapToNullableSet, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        boolean $i$f$flatMapToNullableSet = false;
        Iterable<? extends T> iterable = $this$flatMapToNullableSet;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv.iterator();
        while (iterator2.hasNext()) {
            Iterable list$iv;
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            if ((Iterable)transform2.invoke(it) == null) {
                return null;
            }
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)destination$iv;
    }

    private static final FirScope getClassDeclaredMemberScope(FirSymbolProvider $this$getClassDeclaredMemberScope, ClassId classId) {
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$getClassDeclaredMemberScope.getClassLikeSymbolByClassId(classId);
        FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol classSymbol2 = firRegularClassSymbol;
        return FirDeclaredMemberScopeProviderKt.declaredMemberScope($this$getClassDeclaredMemberScope.getSession(), (FirClass)classSymbol2.getFir());
    }

    @NotNull
    public static final List<FirConstructorSymbol> getClassDeclaredConstructors(@NotNull FirSymbolProvider $this$getClassDeclaredConstructors, @NotNull ClassId classId) {
        FirScope classMemberScope;
        Intrinsics.checkNotNullParameter((Object)$this$getClassDeclaredConstructors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirScope firScope2 = classMemberScope = FirSymbolProviderKt.getClassDeclaredMemberScope($this$getClassDeclaredConstructors, classId);
        List list2 = firScope2 != null ? FirScopeKt.getDeclaredConstructors(firScope2) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public static final List<FirNamedFunctionSymbol> getClassDeclaredFunctionSymbols(@NotNull FirSymbolProvider $this$getClassDeclaredFunctionSymbols, @NotNull ClassId classId, @NotNull Name name2) {
        FirScope classMemberScope;
        Intrinsics.checkNotNullParameter((Object)$this$getClassDeclaredFunctionSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        FirScope firScope2 = classMemberScope = FirSymbolProviderKt.getClassDeclaredMemberScope($this$getClassDeclaredFunctionSymbols, classId);
        List list2 = firScope2 != null ? FirScopeKt.getFunctions(firScope2, name2) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public static final List<FirVariableSymbol<?>> getClassDeclaredPropertySymbols(@NotNull FirSymbolProvider $this$getClassDeclaredPropertySymbols, @NotNull ClassId classId, @NotNull Name name2) {
        FirScope classMemberScope;
        Intrinsics.checkNotNullParameter((Object)$this$getClassDeclaredPropertySymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        FirScope firScope2 = classMemberScope = FirSymbolProviderKt.getClassDeclaredMemberScope($this$getClassDeclaredPropertySymbols, classId);
        List list2 = firScope2 != null ? FirScopeKt.getProperties(firScope2, name2) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public static final /* synthetic */ <T extends FirBasedSymbol<?>> T getSymbolByTypeRef(FirSymbolProvider $this$getSymbolByTypeRef, FirTypeRef typeRef) {
        Intrinsics.checkNotNullParameter((Object)$this$getSymbolByTypeRef, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        boolean $i$f$getSymbolByTypeRef = false;
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeSimpleKotlinType)) {
            coneKotlinType = null;
        }
        ConeSimpleKotlinType coneSimpleKotlinType = (ConeSimpleKotlinType)((ConeKotlinType)((ConeSimpleKotlinType)coneKotlinType));
        ConeSimpleKotlinType coneSimpleKotlinType2 = coneSimpleKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType(coneSimpleKotlinType, $this$getSymbolByTypeRef.getSession()) : null;
        Object object = coneSimpleKotlinType2 instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)coneSimpleKotlinType2 : null;
        if (object == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
            return null;
        }
        Object lookupTag2 = object;
        FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag($this$getSymbolByTypeRef, (ConeClassifierLookupTag)lookupTag2);
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)firClassifierSymbol;
    }

    @Nullable
    public static final FirRegularClassSymbol getRegularClassSymbolByClassId(@NotNull FirSymbolProvider $this$getRegularClassSymbolByClassId, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)$this$getRegularClassSymbolByClassId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$getRegularClassSymbolByClassId.getClassLikeSymbolByClassId(classId);
        return firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean mayHaveTopLevelClassifier(@NotNull Set<String> $this$mayHaveTopLevelClassifier, @NotNull ClassId classId, @NotNull FirSession session2, boolean mayBeFunctionClass) {
        Intrinsics.checkNotNullParameter($this$mayHaveTopLevelClassifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (mayBeFunctionClass && FirSymbolProviderKt.isNameForFunctionClass(classId, session2)) {
            return true;
        }
        if (classId.getOuterClassId() == null) {
            void $this$mayHaveTopLevelClassifier$iv;
            Set<String> set = $this$mayHaveTopLevelClassifier;
            Name name2 = classId.getShortClassName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classId.shortClassName");
            Name shortClassName$iv = name2;
            boolean $i$f$mayHaveTopLevelClassifier = false;
            if (!($this$mayHaveTopLevelClassifier$iv.contains(shortClassName$iv.asString()) || shortClassName$iv.isSpecial())) {
                return false;
            }
        } else {
            Set<String> $this$mayHaveTopLevelClassifier$iv = $this$mayHaveTopLevelClassifier;
            Name name3 = classId.getOutermostClassId().getShortClassName();
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"classId.outermostClassId.shortClassName");
            Name shortClassName$iv = name3;
            boolean $i$f$mayHaveTopLevelClassifier = false;
            if (!($this$mayHaveTopLevelClassifier$iv.contains(shortClassName$iv.asString()) || shortClassName$iv.isSpecial())) {
                return false;
            }
        }
        return true;
    }

    public static /* synthetic */ boolean mayHaveTopLevelClassifier$default(Set set, ClassId classId, FirSession firSession, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return FirSymbolProviderKt.mayHaveTopLevelClassifier(set, classId, firSession, bl);
    }

    private static final boolean mayHaveTopLevelClassifier(Set<String> $this$mayHaveTopLevelClassifier, Name shortClassName) {
        boolean $i$f$mayHaveTopLevelClassifier = false;
        return $this$mayHaveTopLevelClassifier.contains(shortClassName.asString()) || shortClassName.isSpecial();
    }

    private static final boolean isNameForFunctionClass(ClassId classId, FirSession session2) {
        if (!FirSyntheticFunctionInterfaceProviderBase.Companion.mayBeSyntheticFunctionClassName(classId)) {
            return false;
        }
        FirFunctionTypeKindService firFunctionTypeKindService = FirFunctionTypeKindServiceKt.getFunctionTypeService(session2);
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
        String string2 = classId.getShortClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.shortClassName.asString()");
        return firFunctionTypeKindService.getKindByClassNamePrefix(fqName2, string2) != null;
    }

    @Nullable
    public static final FirClassifierSymbol<?> toSymbol(@NotNull ClassId $this$toSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirSymbolProviderKt.getSymbolProvider(session2).getClassLikeSymbolByClassId($this$toSymbol);
    }

    @NotNull
    public static final FirSymbolProvider getSymbolProvider(@NotNull FirSession $this$symbolProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$symbolProvider, (String)"<this>");
        return (FirSymbolProvider)symbolProvider$delegate.getValue($this$symbolProvider, $$delegatedProperties[0]);
    }

    @NotNull
    public static final FirSymbolProvider getDependenciesSymbolProvider(@NotNull FirSession $this$dependenciesSymbolProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$dependenciesSymbolProvider, (String)"<this>");
        return (FirSymbolProvider)dependenciesSymbolProvider$delegate.getValue($this$dependenciesSymbolProvider, $$delegatedProperties[1]);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Reflection.getOrCreateKotlinPackage(FirSymbolProviderKt.class, (String)"providers"), "symbolProvider", "getSymbolProvider(Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;"))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Reflection.getOrCreateKotlinPackage(FirSymbolProviderKt.class, (String)"providers"), "dependenciesSymbolProvider", "getDependenciesSymbolProvider(Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;")))};
        $$delegatedProperties = kPropertyArray;
        FirSession.Companion this_$iv = FirSession.Companion;
        boolean $i$f$sessionComponentAccessor = false;
        symbolProvider$delegate = TypeRegistry.generateAccessor$default((TypeRegistry)this_$iv, Reflection.getOrCreateKotlinClass(FirSymbolProvider.class), null, 2, null);
        this_$iv = FirSession.Companion;
        String id$iv = DEPENDENCIES_SYMBOL_PROVIDER_QUALIFIED_KEY;
        boolean $i$f$sessionComponentAccessor2 = false;
        dependenciesSymbolProvider$delegate = TypeRegistry.generateAccessor$default((TypeRegistry)this_$iv, id$iv, null, 2, null);
    }
}

