/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl.messages;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.messages.DiagnosticMessageHolder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0007H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R6\u0010\u0003\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/messages/IdeDiagnosticMessageHolder;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/messages/DiagnosticMessageHolder;", "()V", "diagnostics", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "Lkotlin/collections/ArrayList;", "renderMessage", "report", "", "diagnostic", "file", "Lcom/intellij/psi/PsiFile;", "render", "kotlin-scripting-compiler"})
public final class IdeDiagnosticMessageHolder
implements DiagnosticMessageHolder {
    @NotNull
    private final ArrayList<Pair<Diagnostic, String>> diagnostics = new ArrayList();

    @Override
    public void report(@NotNull Diagnostic diagnostic, @NotNull PsiFile file2, @NotNull String render2) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)render2, (String)"render");
        this.diagnostics.add((Pair<Diagnostic, String>)new Pair((Object)diagnostic, (Object)render2));
    }

    @Override
    @NotNull
    public String renderMessage() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document errorReport = docBuilder.newDocument();
        Element rootElement = errorReport.createElement("report");
        errorReport.appendChild(rootElement);
        for (Pair<Diagnostic, String> pair : this.diagnostics) {
            TextRange errorRange;
            Diagnostic diagnostic = (Diagnostic)pair.component1();
            String message2 = (String)pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)DiagnosticUtils.firstRange(diagnostic.getTextRanges()), (String)"firstRange(diagnostic.textRanges)");
            Element reportEntry = errorReport.createElement("reportEntry");
            reportEntry.setAttribute("severity", diagnostic.getSeverity().toString());
            reportEntry.setAttribute("rangeStart", String.valueOf(errorRange.getStartOffset()));
            reportEntry.setAttribute("rangeEnd", String.valueOf(errorRange.getEndOffset()));
            reportEntry.appendChild(errorReport.createTextNode(StringUtil.escapeXmlEntities((String)message2)));
            rootElement.appendChild(reportEntry);
        }
        DOMImplementation dOMImplementation = errorReport.getImplementation();
        Intrinsics.checkNotNull((Object)dOMImplementation, (String)"null cannot be cast to non-null type org.w3c.dom.ls.DOMImplementationLS");
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)dOMImplementation);
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        String string2 = lsSerializer.writeToString(errorReport);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lsSerializer.writeToString(errorReport)");
        return string2;
    }
}

