/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationWithFile;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLFirClassWithSpecificMembersResolveTarget;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileElementFactoryKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.NonReanalyzableClassDeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.NonReanalyzableNonClassDeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ReanalyzableFunctionStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ReanalyzablePropertyStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootScriptStructureElement;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory;", "", "()V", "createFileStructureElement", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "lazyResolveClassWithGeneratedMembers", "", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nFileElementFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileElementFactory.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1747#2,3:169\n*S KotlinDebug\n*F\n+ 1 FileElementFactory.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory\n*L\n38#1:169,3\n*E\n"})
public final class FileElementFactory {
    @NotNull
    public static final FileElementFactory INSTANCE = new FileElementFactory();

    private FileElementFactory() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final FileStructureElement createFileStructureElement(@NotNull FirDeclaration firDeclaration, @NotNull KtDeclaration ktDeclaration2, @NotNull FirFile firFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
        FileStructureElement fileStructureElement;
        block11: {
            block12: {
                boolean bl;
                block10: {
                    Intrinsics.checkNotNullParameter((Object)firDeclaration, (String)"firDeclaration");
                    Intrinsics.checkNotNullParameter((Object)ktDeclaration2, (String)"ktDeclaration");
                    Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
                    Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
                    if (ktDeclaration2 instanceof KtNamedFunction && FileElementFactoryKt.access$isReanalyzableContainer((KtNamedFunction)ktDeclaration2)) {
                        fileStructureElement = new ReanalyzableFunctionStructureElement(firFile, (KtNamedFunction)ktDeclaration2, ((FirSimpleFunction)firDeclaration).getSymbol(), ((KtNamedFunction)ktDeclaration2).getModificationStamp(), moduleComponents);
                        return fileStructureElement;
                    }
                    if (!(ktDeclaration2 instanceof KtProperty)) break block11;
                    if (FileElementFactoryKt.access$isReanalyzableContainer((KtProperty)ktDeclaration2)) break block12;
                    List<KtPropertyAccessor> list2 = ((KtProperty)ktDeclaration2).getAccessors();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"getAccessors(...)");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtPropertyAccessor it = (KtPropertyAccessor)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!FileElementFactoryKt.access$isReanalyzableContainer(it)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block11;
            }
            fileStructureElement = new ReanalyzablePropertyStructureElement(firFile, (KtProperty)ktDeclaration2, ((FirProperty)firDeclaration).getSymbol(), ((KtProperty)ktDeclaration2).getModificationStamp(), moduleComponents);
            return fileStructureElement;
        }
        if (ktDeclaration2 instanceof KtClassOrObject && !(ktDeclaration2 instanceof KtEnumEntry)) {
            this.lazyResolveClassWithGeneratedMembers((FirRegularClass)firDeclaration, moduleComponents);
            fileStructureElement = new NonReanalyzableClassDeclarationStructureElement(firFile, (FirRegularClass)firDeclaration, (KtClassOrObject)ktDeclaration2, moduleComponents);
            return fileStructureElement;
        }
        if (ktDeclaration2 instanceof KtScript) {
            fileStructureElement = new RootScriptStructureElement(firFile, (FirScript)firDeclaration, (KtScript)ktDeclaration2, moduleComponents);
            return fileStructureElement;
        }
        fileStructureElement = new NonReanalyzableNonClassDeclarationStructureElement(firFile, firDeclaration, ktDeclaration2, moduleComponents);
        return fileStructureElement;
    }

    private final void lazyResolveClassWithGeneratedMembers(FirRegularClass firClass, LLFirModuleResolveComponents moduleComponents) {
        List list2;
        List $this$lazyResolveClassWithGeneratedMembers_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (FirDeclaration member2 : firClass.getDeclarations()) {
            if (member2 instanceof FirSimpleFunction) {
                KtSourceElement ktSourceElement = member2.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u241.add(member2);
                    continue;
                }
            }
            if (member2 instanceof FirPrimaryConstructor) {
                KtSourceElement ktSourceElement = member2.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u241.add(member2);
                    continue;
                }
            }
            if (member2 instanceof FirProperty) {
                KtSourceElement ktSourceElement = member2.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u241.add(member2);
                    continue;
                }
            }
            if (member2 instanceof FirField) {
                KtSourceElement ktSourceElement = member2.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ClassDelegationField.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u241.add(member2);
                    continue;
                }
            }
            if (!(member2 instanceof FirDanglingModifierList)) continue;
            $this$lazyResolveClassWithGeneratedMembers_u24lambda_u241.add(member2);
        }
        List classMembersToResolve = CollectionsKt.build((List)list2);
        FirDesignationWithFile firClassDesignation = FirDesignationKt.collectDesignationWithFile(firClass);
        LLFirClassWithSpecificMembersResolveTarget designationWithMembers = new LLFirClassWithSpecificMembersResolveTarget(firClassDesignation.getFirFile(), firClassDesignation.getPath(), firClass, classMembersToResolve);
        moduleComponents.getFirModuleLazyDeclarationResolver().lazyResolveTarget(designationWithMembers, FirResolvePhase.BODY_RESOLVE, null);
    }
}

