/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.transformers;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLFirResolveTarget;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.LLFirLockProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.LLFirPhaseUpdater;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirDeclarationDesignationUtilsKt;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirResolveContextCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J2\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH&J\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/transformers/LLFirLazyResolver;", "", "resolverPhase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "(Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "getResolverPhase", "()Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "checkFunctionParametersAreResolved", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "checkIsResolved", "designation", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/targets/LLFirResolveTarget;", "target", "Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;", "checkNestedDeclarationsAreResolved", "checkPropertyAccessorsAreResolved", "checkPropertyBackingFieldIsResolved", "checkScriptDependentDeclaration", "checkTypeParametersAreResolved", "phaseSpecificCheckIsResolved", "resolve", "lockProvider", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/LLFirLockProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "towerDataContextCollector", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirResolveContextCollector;", "updatePhaseForDeclarationInternals", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirLazyResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirLazyResolver.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/transformers/LLFirLazyResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 declarationUtils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/DeclarationUtilsKt\n*L\n1#1,103:1\n1#2:104\n238#3,5:105\n*S KotlinDebug\n*F\n+ 1 LLFirLazyResolver.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/transformers/LLFirLazyResolver\n*L\n100#1:105,5\n*E\n"})
public abstract class LLFirLazyResolver {
    @NotNull
    private final FirResolvePhase resolverPhase;

    public LLFirLazyResolver(@NotNull FirResolvePhase resolverPhase) {
        Intrinsics.checkNotNullParameter((Object)((Object)resolverPhase), (String)"resolverPhase");
        this.resolverPhase = resolverPhase;
    }

    @NotNull
    public final FirResolvePhase getResolverPhase() {
        return this.resolverPhase;
    }

    public abstract void resolve(@NotNull LLFirResolveTarget var1, @NotNull LLFirLockProvider var2, @NotNull FirSession var3, @NotNull ScopeSession var4, @Nullable FirResolveContextCollector var5);

    public final void checkIsResolved(@NotNull FirElementWithResolveState target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        FirDeclarationDesignationUtilsKt.checkPhase(target, this.resolverPhase);
        this.phaseSpecificCheckIsResolved(target);
        this.checkNestedDeclarationsAreResolved(target);
    }

    protected void phaseSpecificCheckIsResolved(@NotNull FirElementWithResolveState target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
    }

    public final void updatePhaseForDeclarationInternals(@NotNull FirElementWithResolveState target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        LLFirPhaseUpdater.INSTANCE.updateDeclarationInternalsPhase(target, this.resolverPhase, this.resolverPhase == FirResolvePhase.BODY_RESOLVE);
    }

    public final void checkIsResolved(@NotNull LLFirResolveTarget designation2) {
        Intrinsics.checkNotNullParameter((Object)designation2, (String)"designation");
        designation2.forEachTarget((Function1<? super FirElementWithResolveState, Unit>)((Function1)new Function1<FirElementWithResolveState, Unit>((Object)this){

            public final void invoke(@NotNull FirElementWithResolveState p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LLFirLazyResolver)this.receiver).checkIsResolved(p0);
            }

            @NotNull
            public final String getSignature() {
                return "checkIsResolved(Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;)V";
            }

            @NotNull
            public final String getName() {
                return "checkIsResolved";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(LLFirLazyResolver.class);
            }
        }));
    }

    private final void checkNestedDeclarationsAreResolved(FirElementWithResolveState target) {
        if (!(target instanceof FirDeclaration)) {
            return;
        }
        this.checkFunctionParametersAreResolved((FirDeclaration)target);
        this.checkPropertyAccessorsAreResolved((FirDeclaration)target);
        this.checkPropertyBackingFieldIsResolved((FirDeclaration)target);
        this.checkTypeParametersAreResolved((FirDeclaration)target);
        this.checkScriptDependentDeclaration((FirDeclaration)target);
    }

    private final void checkPropertyAccessorsAreResolved(FirDeclaration declaration) {
        block2: {
            FirPropertyAccessor it;
            if (!(declaration instanceof FirProperty)) break block2;
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration).getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                this.checkIsResolved(it);
            }
            FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration).getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl = false;
                this.checkIsResolved(it);
            }
        }
    }

    private final void checkPropertyBackingFieldIsResolved(FirDeclaration declaration) {
        block1: {
            if (!(declaration instanceof FirProperty)) break block1;
            FirBackingField firBackingField = ((FirProperty)declaration).getBackingField();
            if (firBackingField != null) {
                FirBackingField it = firBackingField;
                boolean bl = false;
                this.checkIsResolved(it);
            }
        }
    }

    private final void checkFunctionParametersAreResolved(FirDeclaration declaration) {
        if (declaration instanceof FirFunction) {
            for (FirValueParameter parameter2 : ((FirFunction)declaration).getValueParameters()) {
                this.checkIsResolved(parameter2);
            }
        }
    }

    private final void checkTypeParametersAreResolved(FirDeclaration declaration) {
        if (declaration instanceof FirTypeParameterRefsOwner) {
            for (FirTypeParameterRef parameter2 : ((FirTypeParameterRefsOwner)((Object)declaration)).getTypeParameters()) {
                if (!(parameter2 instanceof FirTypeParameter)) continue;
                this.checkIsResolved((FirElementWithResolveState)((Object)parameter2));
            }
        }
    }

    private final void checkScriptDependentDeclaration(FirDeclaration declaration) {
        if (!(declaration instanceof FirScript)) {
            return;
        }
        FirScript $this$forEachDependentDeclaration$iv = (FirScript)declaration;
        boolean $i$f$forEachDependentDeclaration = false;
        for (FirStatement statement$iv : $this$forEachDependentDeclaration$iv.getStatements()) {
            if (!(statement$iv instanceof FirDeclaration) || !DeclarationUtilsKt.isScriptDependentDeclaration(statement$iv)) continue;
            FirElementWithResolveState p0 = (FirElementWithResolveState)((Object)statement$iv);
            boolean bl = false;
            this.checkIsResolved(p0);
        }
    }
}

