/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u001fB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering$Data;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "apiVersion", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isApiVersionIsAtLeast", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isInInlineFunInKotlinRuntime", "currentFunction", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "data", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Data", "backend.jvm.lower"})
public final class ApiVersionIsAtLeastEvaluationLowering
implements FileLoweringPass,
IrElementTransformer<Data> {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final MavenComparableVersion apiVersion;

    public ApiVersionIsAtLeastEvaluationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.apiVersion = this.context.getState().getLanguageVersionSettings().getApiVersion().getVersion();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept(this, new Data(null, false));
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, Data.copy$default(data2, null, data2.isInsideInlinedBlock() || expression2 instanceof IrInlinedFunctionBlock, 1, null));
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, Data.copy$default(data2, declaration, false, 2, null));
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (!data2.isInsideInlinedBlock() || !this.isApiVersionIsAtLeast(expression2.getSymbol().getOwner()) || this.isInInlineFunInKotlinRuntime(data2.getCurrentFunction())) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall(this, expression2, data2);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        Integer n = JvmIrUtilsKt.getIntConstArgumentOrNull(expression2, 0);
        if (n == null) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall(this, expression2, data2);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        int epic = n;
        Integer n2 = JvmIrUtilsKt.getIntConstArgumentOrNull(expression2, 1);
        if (n2 == null) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall(this, expression2, data2);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        int major = n2;
        Integer n3 = JvmIrUtilsKt.getIntConstArgumentOrNull(expression2, 2);
        if (n3 == null) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall(this, expression2, data2);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        int minor = n3;
        IrFunction currentFunction = data2.getCurrentFunction();
        if (!(currentFunction != null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        JvmIrBuilder builder2 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, currentFunction.getSymbol(), 0, 0, 6, null);
        MavenComparableVersion versionArgument = new MavenComparableVersion("" + epic + '.' + major + '.' + minor);
        return this.apiVersion.compareTo(versionArgument) >= 0 ? (IrExpression)ExpressionHelpersKt.irTrue(builder2) : (IrExpression)ExpressionHelpersKt.irFalse(builder2);
    }

    private final boolean isInInlineFunInKotlinRuntime(IrFunction currentFunction) {
        return currentFunction != null && currentFunction.isInline() && IrUtilsKt.getPackageFragment(currentFunction).getPackageFqName().startsWith(StandardNames.BUILT_INS_PACKAGE_NAME);
    }

    private final boolean isApiVersionIsAtLeast(IrFunction $this$isApiVersionIsAtLeast) {
        return Intrinsics.areEqual((Object)$this$isApiVersionIsAtLeast.getName().asString(), (Object)"apiVersionIsAtLeast") && Intrinsics.areEqual((Object)IrUtilsKt.getPackageFragment($this$isApiVersionIsAtLeast).getPackageFqName(), (Object)StandardNames.KOTLIN_INTERNAL_FQ_NAME) && IrUtilsKt.isFacadeClass($this$isApiVersionIsAtLeast.getParent()) && $this$isApiVersionIsAtLeast.getValueParameters().size() == 3 && IrTypePredicatesKt.isInt($this$isApiVersionIsAtLeast.getValueParameters().get(0).getType()) && IrTypePredicatesKt.isInt($this$isApiVersionIsAtLeast.getValueParameters().get(1).getType()) && IrTypePredicatesKt.isInt($this$isApiVersionIsAtLeast.getValueParameters().get(2).getType()) && $this$isApiVersionIsAtLeast.getDispatchReceiverParameter() == null && $this$isApiVersionIsAtLeast.getExtensionReceiverParameter() == null;
    }

    @Override
    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull Data data2) {
        return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering$Data;", "", "currentFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isInsideInlinedBlock", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Z)V", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "backend.jvm.lower"})
    public static final class Data {
        @Nullable
        private final IrFunction currentFunction;
        private final boolean isInsideInlinedBlock;

        public Data(@Nullable IrFunction currentFunction, boolean isInsideInlinedBlock) {
            this.currentFunction = currentFunction;
            this.isInsideInlinedBlock = isInsideInlinedBlock;
        }

        @Nullable
        public final IrFunction getCurrentFunction() {
            return this.currentFunction;
        }

        public final boolean isInsideInlinedBlock() {
            return this.isInsideInlinedBlock;
        }

        @Nullable
        public final IrFunction component1() {
            return this.currentFunction;
        }

        public final boolean component2() {
            return this.isInsideInlinedBlock;
        }

        @NotNull
        public final Data copy(@Nullable IrFunction currentFunction, boolean isInsideInlinedBlock) {
            return new Data(currentFunction, isInsideInlinedBlock);
        }

        public static /* synthetic */ Data copy$default(Data data2, IrFunction irFunction2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                irFunction2 = data2.currentFunction;
            }
            if ((n & 2) != 0) {
                bl = data2.isInsideInlinedBlock;
            }
            return data2.copy(irFunction2, bl);
        }

        @NotNull
        public String toString() {
            return "Data(currentFunction=" + this.currentFunction + ", isInsideInlinedBlock=" + this.isInsideInlinedBlock + ')';
        }

        public int hashCode() {
            int result2 = this.currentFunction == null ? 0 : this.currentFunction.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isInsideInlinedBlock);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (!Intrinsics.areEqual((Object)this.currentFunction, (Object)data2.currentFunction)) {
                return false;
            }
            return this.isInsideInlinedBlock == data2.isInsideInlinedBlock;
        }
    }
}

