/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0001\u001a \u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011*\u00020 2\u0006\u0010\u0013\u001a\u00020\u0015H\u0002\u001a\u0013\u0010!\u001a\u0004\u0018\u00010\u0003*\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\"\u001a\u000e\u0010#\u001a\u0004\u0018\u00010\u0001*\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0001*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\r*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006$"}, d2={"ARGFILE_ARGUMENT", "", "BACKSLASH", "", "DOUBLE_QUOTE", "EXPERIMENTAL_ARGFILE_ARGUMENT", "SINGLE_QUOTE", "argfilePath", "getArgfilePath", "(Ljava/lang/String;)Ljava/lang/String;", "deprecatedArgfilePath", "getDeprecatedArgfilePath", "isArgfileArgument", "", "(Ljava/lang/String;)Z", "isDeprecatedArgfileArgument", "preprocessCommandLineArguments", "", "args", "errors", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;", "readArgumentsFromArgFile", "content", "consumeRestOfQuotedSequence", "", "Ljava/io/Reader;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "quote", "expand", "Ljava/io/File;", "nextChar", "(Ljava/io/Reader;)Ljava/lang/Character;", "parseNextArgument", "cli-common"})
@SourceDebugExtension(value={"SMAP\npreprocessCommandLineArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 preprocessCommandLineArguments.kt\norg/jetbrains/kotlin/cli/common/arguments/PreprocessCommandLineArgumentsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1360#2:106\n1446#2,5:107\n1#3:112\n*S KotlinDebug\n*F\n+ 1 preprocessCommandLineArguments.kt\norg/jetbrains/kotlin/cli/common/arguments/PreprocessCommandLineArgumentsKt\n*L\n27#1:106\n27#1:107,5\n*E\n"})
public final class PreprocessCommandLineArgumentsKt {
    @NotNull
    public static final String ARGFILE_ARGUMENT = "@";
    @NotNull
    private static final String EXPERIMENTAL_ARGFILE_ARGUMENT = "-Xargfile=";
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char BACKSLASH = '\\';

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> preprocessCommandLineArguments(@NotNull List<String> args, @NotNull Lazy<ArgumentParseErrors> errors2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(errors2, (String)"errors");
        Iterable $this$flatMap$iv = args;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<String> list2;
            String arg = (String)element$iv$iv;
            boolean bl = false;
            if (PreprocessCommandLineArgumentsKt.isArgfileArgument(arg)) {
                list2 = PreprocessCommandLineArgumentsKt.expand(new File(PreprocessCommandLineArgumentsKt.getArgfilePath(arg)), (ArgumentParseErrors)errors2.getValue());
            } else if (PreprocessCommandLineArgumentsKt.isDeprecatedArgfileArgument(arg)) {
                ((ArgumentParseErrors)errors2.getValue()).getDeprecatedArguments().put(EXPERIMENTAL_ARGFILE_ARGUMENT, ARGFILE_ARGUMENT);
                list2 = PreprocessCommandLineArgumentsKt.expand(new File(PreprocessCommandLineArgumentsKt.getDeprecatedArgfilePath(arg)), (ArgumentParseErrors)errors2.getValue());
            } else {
                list2 = CollectionsKt.listOf((Object)arg);
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<String> readArgumentsFromArgFile(@NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        StringReader reader = new StringReader(content2);
        return SequencesKt.toList((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<String>(reader){
            final /* synthetic */ StringReader $reader;
            {
                this.$reader = $reader;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return PreprocessCommandLineArgumentsKt.access$parseNextArgument(this.$reader);
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> expand(File $this$expand, ArgumentParseErrors errors2) {
        Object object;
        try {
            List list2;
            object = $this$expand;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                list2 = SequencesKt.toList((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<String>(it){
                    final /* synthetic */ BufferedReader $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final String invoke() {
                        return PreprocessCommandLineArgumentsKt.access$parseNextArgument(this.$it);
                    }
                })));
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = list2;
        }
        catch (FileNotFoundException e) {
            ((Collection)errors2.getArgfileErrors()).add("Argfile not found: " + $this$expand.getAbsolutePath());
            object = CollectionsKt.emptyList();
        }
        catch (IOException e) {
            ((Collection)errors2.getArgfileErrors()).add("Error while reading argfile: " + e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final String parseNextArgument(Reader $this$parseNextArgument) {
        String string2;
        StringBuilder sb = new StringBuilder();
        Character r = PreprocessCommandLineArgumentsKt.nextChar($this$parseNextArgument);
        while (r != null && CharsKt.isWhitespace((char)r.charValue())) {
            r = PreprocessCommandLineArgumentsKt.nextChar($this$parseNextArgument);
        }
        while (r != null && !CharsKt.isWhitespace((char)r.charValue())) {
            block6: {
                block5: {
                    char c = '\"';
                    if (r.charValue() == c) break block5;
                    c = '\'';
                    if (r.charValue() != c) break block6;
                }
                PreprocessCommandLineArgumentsKt.consumeRestOfQuotedSequence($this$parseNextArgument, sb, r.charValue());
                return sb.toString();
            }
            sb.append(r.charValue());
            r = PreprocessCommandLineArgumentsKt.nextChar($this$parseNextArgument);
        }
        String it = string2 = sb.toString();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return ((CharSequence)it).length() > 0 ? string2 : null;
    }

    private static final void consumeRestOfQuotedSequence(Reader $this$consumeRestOfQuotedSequence, StringBuilder sb, char quote) {
        Character ch = PreprocessCommandLineArgumentsKt.nextChar($this$consumeRestOfQuotedSequence);
        while (ch != null) {
            char c = quote;
            if (ch.charValue() == c) break;
            c = '\\';
            if (ch.charValue() == c) {
                Character c2 = PreprocessCommandLineArgumentsKt.nextChar($this$consumeRestOfQuotedSequence);
                if (c2 != null) {
                    char it = c2.charValue();
                    boolean bl = false;
                    sb.append(it);
                }
            } else {
                sb.append(ch.charValue());
            }
            ch = PreprocessCommandLineArgumentsKt.nextChar($this$consumeRestOfQuotedSequence);
        }
    }

    private static final Character nextChar(Reader $this$nextChar) {
        Integer n = $this$nextChar.read();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == -1) ? n : null;
        return n2 != null ? Character.valueOf((char)n2.intValue()) : null;
    }

    private static final String getArgfilePath(String $this$argfilePath) {
        return StringsKt.removePrefix((String)$this$argfilePath, (CharSequence)ARGFILE_ARGUMENT);
    }

    private static final boolean isArgfileArgument(String $this$isArgfileArgument) {
        return StringsKt.startsWith$default((String)$this$isArgfileArgument, (String)ARGFILE_ARGUMENT, (boolean)false, (int)2, null);
    }

    private static final String getDeprecatedArgfilePath(String $this$deprecatedArgfilePath) {
        return StringsKt.removePrefix((String)$this$deprecatedArgfilePath, (CharSequence)EXPERIMENTAL_ARGFILE_ARGUMENT);
    }

    private static final boolean isDeprecatedArgfileArgument(String $this$isDeprecatedArgfileArgument) {
        return StringsKt.startsWith$default((String)$this$isDeprecatedArgfileArgument, (String)EXPERIMENTAL_ARGFILE_ARGUMENT, (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ String access$parseNextArgument(Reader $receiver) {
        return PreprocessCommandLineArgumentsKt.parseNextArgument($receiver);
    }
}

