/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVisibilityQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClassLikeSymbol", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "checkers"})
public final class FirVisibilityQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirVisibilityQualifierChecker INSTANCE = new FirVisibilityQualifierChecker();

    private FirVisibilityQualifierChecker() {
    }

    @Override
    public void check(@NotNull FirResolvedQualifier expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirClassLikeSymbol<?> firClassLikeSymbol = expression2.getSymbol();
        if (firClassLikeSymbol == null) {
            return;
        }
        this.checkClassLikeSymbol(firClassLikeSymbol, expression2, context, reporter2);
    }

    private final void checkClassLikeSymbol(FirClassLikeSymbol<?> symbol2, FirResolvedQualifier expression2, CheckerContext context, DiagnosticReporter reporter2) {
        block5: {
            Object object;
            Object it;
            FirFile firFile = context.getContainingFile();
            if (firFile == null) {
                return;
            }
            FirFile firFile2 = firFile;
            FirClassLikeDeclaration firClassLikeDeclaration = (FirClassLikeDeclaration)symbol2.getFir();
            KtSourceElement ktSourceElement = expression2.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitReceiver.INSTANCE) && !FirVisibilityCheckerKt.getVisibilityChecker(context.getSession()).isClassLikeVisible(firClassLikeDeclaration, context.getSession(), firFile2, context.getContainingDeclarations())) {
                if (!(expression2 instanceof FirErrorResolvedQualifier) || !(((FirErrorResolvedQualifier)expression2).getDiagnostic() instanceof ConeVisibilityError)) {
                    reporter2.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)symbol2, expression2.getSource()), context);
                }
                return;
            }
            if (firClassLikeDeclaration instanceof FirTypeAlias) {
                Object object2 = FirDeclarationUtilKt.getExpandedConeType((FirTypeAlias)firClassLikeDeclaration);
                if (object2 != null && (object2 = TypeUtilsKt.toSymbol((ConeClassLikeType)object2, context.getSession())) != null) {
                    it = object2;
                    boolean bl = false;
                    INSTANCE.checkClassLikeSymbol((FirClassLikeSymbol<?>)it, expression2, context, reporter2);
                }
            }
            if ((object = FirVisibilityCheckerKt.getOwnerLookupTag((FirBasedSymbol)symbol2)) == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context.getSession())) == null) break block5;
            it = object;
            boolean bl = false;
            INSTANCE.checkClassLikeSymbol((FirClassLikeSymbol<?>)it, expression2, context, reporter2);
        }
    }
}

