/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsNativeRttiChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkGetClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "checkTypeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsNativeRttiChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsNativeRttiChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsNativeRttiChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,64:1\n46#2:65\n48#2:66\n*S KotlinDebug\n*F\n+ 1 FirJsNativeRttiChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsNativeRttiChecker\n*L\n30#1:65\n51#1:66\n*E\n"})
public final class FirJsNativeRttiChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirJsNativeRttiChecker INSTANCE = new FirJsNativeRttiChecker();

    private FirJsNativeRttiChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirStatement firStatement = expression2;
        if (firStatement instanceof FirGetClassCall) {
            this.checkGetClassCall((FirGetClassCall)expression2, context, reporter2);
        } else if (firStatement instanceof FirTypeOperatorCall) {
            this.checkTypeOperatorCall((FirTypeOperatorCall)expression2, context, reporter2);
        }
    }

    private final void checkGetClassCall(FirGetClassCall expression2, CheckerContext context, DiagnosticReporter reporter2) {
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(expression2.getArgument().getTypeRef(), context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declarationToCheck = firRegularClassSymbol;
        FirCall $this$arguments$iv = expression2;
        boolean $i$f$getArguments = false;
        if (!(CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments()) instanceof FirResolvedQualifier)) {
            return;
        }
        if (FirJsHelpersKt.isNativeInterface((FirBasedSymbol)declarationToCheck, context)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_INTERFACE_AS_CLASS_LITERAL(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkTypeOperatorCall(FirTypeOperatorCall expression2, CheckerContext context, DiagnosticReporter reporter2) {
        FirTypeRef targetTypeRef = expression2.getConversionTypeRef();
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(targetTypeRef, context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declarationToCheck = firRegularClassSymbol;
        if (!FirJsHelpersKt.isNativeInterface((FirBasedSymbol)declarationToCheck, context)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                FirCall $this$argument$iv = expression2;
                boolean $i$f$getArgument = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getUNCHECKED_CAST_TO_EXTERNAL_INTERFACE(), (Object)FirTypeUtilsKt.getConeType(((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments())).getTypeRef()), (Object)FirTypeUtilsKt.getConeType(targetTypeRef), (DiagnosticContext)context, null, 32, null);
                break;
            }
            case 3: 
            case 4: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getCANNOT_CHECK_FOR_EXTERNAL_INTERFACE(), (Object)FirTypeUtilsKt.getConeType(targetTypeRef), (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.AS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.IS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

