/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator$isSetterVisible$;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ*\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J*\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002Jr\u0010\u0014\u001a\u00020\u00042\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00162\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\t2.\u0010\u0019\u001a*\u0012\u0004\u0012\u00020\r\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00040\u001aH\u0002J&\u0010\u001b\u001a\u00020\u0004*\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J8\u0010\u001e\u001a\u00020\u0004*\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallableReferenceTranslator;", "", "()V", "bindIfNecessary", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "receiver", "isSetterVisible", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translate", "expression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "translateForFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "translateForProperty", "translateForPropertyAccessor", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isSetter", "translator", "Lkotlin/Function4;", "wrapFunctionCallableRef", "name", "", "wrapPropertyCallableRef", "getter", "setter", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCallableReferenceTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableReferenceTranslator.kt\norg/jetbrains/kotlin/js/translate/reference/CallableReferenceTranslator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,316:1\n1#2:317\n473#3:318\n*S KotlinDebug\n*F\n+ 1 CallableReferenceTranslator.kt\norg/jetbrains/kotlin/js/translate/reference/CallableReferenceTranslator\n*L\n230#1:318\n*E\n"})
public final class CallableReferenceTranslator {
    @NotNull
    public static final CallableReferenceTranslator INSTANCE = new CallableReferenceTranslator();

    private CallableReferenceTranslator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final JsExpression translate(@NotNull KtCallableReferenceExpression expression2, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        CallableDescriptor callableDescriptor;
        JsExpression receiver;
        JsExpression jsExpression2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
        KtElement ktElement = ktSimpleNameExpression;
        BindingContext bindingContext = context.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> referencedFunction = CallUtilKt.getResolvedCallWithAssert(ktElement, bindingContext);
        CallableDescriptor descriptor2 = referencedFunction.getResultingDescriptor();
        ReceiverValue extensionReceiver = referencedFunction.getExtensionReceiver();
        ReceiverValue dispatchReceiver = referencedFunction.getDispatchReceiver();
        boolean bl2 = bl = dispatchReceiver == null || extensionReceiver == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Cannot generate reference with both receivers: " + descriptor2;
            throw new AssertionError((Object)string2);
        }
        ReceiverValue receiverValue = dispatchReceiver;
        if (receiverValue == null) {
            receiverValue = extensionReceiver;
        }
        if (receiverValue != null) {
            ReceiverValue it = receiverValue;
            boolean bl4 = false;
            ReceiverValue receiverValue2 = it;
            if (receiverValue2 instanceof TransientReceiver) {
                jsExpression2 = null;
            } else if (receiverValue2 instanceof ImplicitClassReceiver ? true : receiverValue2 instanceof ExtensionReceiver) {
                jsExpression2 = context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver(it));
            } else {
                if (!(receiverValue2 instanceof ExpressionReceiver)) throw new UnsupportedOperationException("Unsupported receiver value: " + it);
                jsExpression2 = Translation.translateAsExpression(((ExpressionReceiver)it).getExpression(), context);
            }
        } else {
            jsExpression2 = receiver = null;
        }
        if ((callableDescriptor = descriptor2) instanceof PropertyDescriptor) {
            jsExpression = this.translateForProperty((PropertyDescriptor)descriptor2, context, expression2, receiver);
            return jsExpression;
        } else {
            if (!(callableDescriptor instanceof FunctionDescriptor)) throw new IllegalArgumentException("Expected property or function: " + descriptor2 + ", expression=" + expression2.getText());
            jsExpression = this.translateForFunction((FunctionDescriptor)descriptor2, context, expression2, receiver);
        }
        return jsExpression;
    }

    private final JsExpression translateForFunction(FunctionDescriptor descriptor2, TranslationContext context, KtCallableReferenceExpression expression2, JsExpression receiver) {
        Collection collection;
        JsNameRef jsNameRef;
        Object object;
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
        KtExpression ktExpression = ktSimpleNameExpression;
        BindingContext bindingContext = context.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext(...)");
        ResolvedCall<? extends FunctionDescriptor> realResolvedCall = CallUtilKt.getFunctionResolvedCallWithAssert(ktExpression, bindingContext);
        Object v = context.bindingContext().get(BindingContext.FUNCTION, expression2);
        Intrinsics.checkNotNull(v);
        SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)v;
        int receivers = receiver == null && (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null) ? 1 : 0;
        int fakeArgCount = functionDescriptor.getValueParameters().size() - receivers;
        Project project = expression2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtCallExpression fakeExpression = CodegenUtil.constructFakeFunctionCall(project, fakeArgCount);
        List<KtValueArgument> list2 = fakeExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValueArguments(...)");
        List<KtValueArgument> fakeArguments = list2;
        Call call2 = CallMaker.makeCall(fakeExpression, null, null, fakeExpression, fakeArguments);
        Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"makeCall(...)");
        Call fakeCall = call2;
        DelegatingResolvedCall<FunctionDescriptor> fakeResolvedCall2 = new DelegatingResolvedCall<FunctionDescriptor>(realResolvedCall, descriptor2, fakeArgCount, functionDescriptor, receivers, fakeArguments, fakeCall, receiver){
            @NotNull
            private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArgumentMap;
            @NotNull
            private final List<ResolvedValueArgument> valueArgumentList;
            final /* synthetic */ FunctionDescriptor $descriptor;
            final /* synthetic */ Call $fakeCall;
            final /* synthetic */ JsExpression $receiver;
            {
                Map map;
                this.$descriptor = $descriptor;
                this.$fakeCall = $fakeCall;
                this.$receiver = $receiver;
                super($realResolvedCall);
                Map map2 = map = (Map)new LinkedHashMap<K, V>();
                translateForFunction.fakeResolvedCall.1 var18_11 = this;
                boolean bl = false;
                int i2 = 0;
                for (ValueParameterDescriptor parameter2 : $descriptor.getValueParameters()) {
                    ResolvedValueArgument resolvedValueArgument;
                    ValueParameterDescriptor valueParameterDescriptor;
                    void var15_16;
                    void argumentMap;
                    if (parameter2.getVarargElementType() != null) {
                        if (i2 == $fakeArgCount) {
                            var15_16 = argumentMap;
                            Intrinsics.checkNotNull((Object)parameter2);
                            valueParameterDescriptor = parameter2;
                            resolvedValueArgument = ArgumentsUtilsKt.hasDefaultValue(parameter2) ? (ResolvedValueArgument)DefaultValueArgument.DEFAULT : (ResolvedValueArgument)new VarargValueArgument();
                            Intrinsics.checkNotNull((Object)resolvedValueArgument);
                            var15_16.put(valueParameterDescriptor, resolvedValueArgument);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)$functionDescriptor.getValueParameters().get($receivers + i2).getType(), (Object)parameter2.getVarargElementType())) {
                            Intrinsics.checkNotNull((Object)parameter2);
                            argumentMap.put(parameter2, new VarargValueArgument($fakeArguments.subList(i2, $fakeArgCount)));
                            i2 = $fakeArgCount;
                            continue;
                        }
                    }
                    if (i2 < $fakeArgCount) {
                        Intrinsics.checkNotNull((Object)parameter2);
                        argumentMap.put(parameter2, new ExpressionValueArgument($fakeArguments.get(i2++)));
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)parameter2);
                    boolean bl2 = ArgumentsUtilsKt.hasDefaultValue(parameter2);
                    if (_Assertions.ENABLED && !bl2) {
                        boolean bl3 = false;
                        String string2 = "Parameter should be either vararg or expression or default: " + parameter2 + " (reference in: " + $functionDescriptor.getContainingDeclaration() + ')';
                        throw new AssertionError((Object)string2);
                    }
                    var15_16 = argumentMap;
                    valueParameterDescriptor = parameter2;
                    Intrinsics.checkNotNullExpressionValue((Object)DefaultValueArgument.DEFAULT, (String)"DEFAULT");
                    var15_16.put(valueParameterDescriptor, resolvedValueArgument);
                }
                var18_11.valueArgumentMap = map;
                this.valueArgumentList = CollectionsKt.toList((Iterable)this.valueArgumentMap.values());
            }

            @NotNull
            public final Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArgumentMap() {
                return this.valueArgumentMap;
            }

            @NotNull
            public final List<ResolvedValueArgument> getValueArgumentList() {
                return this.valueArgumentList;
            }

            @NotNull
            public Call getCall() {
                return this.$fakeCall;
            }

            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                return this.valueArgumentList;
            }

            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                return this.valueArgumentMap;
            }

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                if (this.$receiver != null) {
                    return DescriptorUtilsKt.isExtension(this.$descriptor) ? ExplicitReceiverKind.EXTENSION_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
                }
                ExplicitReceiverKind explicitReceiverKind = super.getExplicitReceiverKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)explicitReceiverKind), (String)"getExplicitReceiverKind(...)");
                return explicitReceiverKind;
            }
        };
        JsFunction function2 = new JsFunction(context.scope(), new JsBlock(), "");
        function2.setSource(expression2);
        if (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null || receiver != null) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
            JsName paramName = jsName;
            List<JsParameter> list3 = function2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getParameters(...)");
            object = list3;
            object.add(new JsParameter(paramName));
            jsNameRef = paramName.makeRef();
        } else {
            jsNameRef = null;
        }
        JsNameRef receiverParam = jsNameRef;
        Map aliases2 = new LinkedHashMap();
        object = fakeCall.getValueArguments().iterator();
        int n = 0;
        while (object.hasNext()) {
            JsNameRef paramRef;
            JsName paramName;
            int index2 = n++;
            ValueArgument valueArg = (ValueArgument)object.next();
            Intrinsics.checkNotNullExpressionValue((Object)JsScope.declareTemporaryName(functionDescriptor.getValueParameters().get(index2).getName().asString()), (String)"declareTemporaryName(...)");
            List<JsParameter> list4 = function2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getParameters(...)");
            collection = list4;
            collection.add(new JsParameter(paramName));
            Intrinsics.checkNotNullExpressionValue((Object)paramName.makeRef(), (String)"makeRef(...)");
            MetadataProperties.setType(paramRef, context.getCurrentModule().getBuiltIns().getAnyType());
            KtExpression ktExpression2 = valueArg.getArgumentExpression();
            Intrinsics.checkNotNull((Object)ktExpression2);
            aliases2.put(ktExpression2, paramRef);
        }
        TranslationContext functionContext = null;
        TranslationContext translationContext = context.innerBlock(function2.getBody()).innerContextWithAliasesForExpressions(aliases2).inner(descriptor2);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"inner(...)");
        functionContext = translationContext;
        ValueParameterDescriptor valueParameterDescriptor = functionContext.getContinuationParameterDescriptor();
        if (valueParameterDescriptor != null) {
            ValueParameterDescriptor continuationDescriptor = valueParameterDescriptor;
            boolean bl = false;
            List<JsParameter> list5 = function2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list5, (String)"getParameters(...)");
            collection = list5;
            collection.add(new JsParameter(context.getNameForDescriptor(continuationDescriptor)));
            TranslationContext translationContext2 = functionContext.innerContextWithDescriptorsAliased(MapsKt.mapOf((Pair)TuplesKt.to((Object)continuationDescriptor, (Object)JsAstUtils.stateMachineReceiver())));
            Intrinsics.checkNotNullExpressionValue((Object)translationContext2, (String)"innerContextWithDescriptorsAliased(...)");
            functionContext = translationContext2;
        }
        if (descriptor2.isSuspend()) {
            UtilsKt.fillCoroutineMetadata(function2, functionContext, functionDescriptor, false);
        }
        JsExpression invocation = CallTranslator.translate(functionContext, (ResolvedCall<? extends FunctionDescriptor>)fakeResolvedCall2, receiverParam);
        List<JsStatement> list6 = function2.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list6, (String)"getStatements(...)");
        Collection collection2 = list6;
        collection2.add(new JsReturn(TranslationUtils.coerce(context, invocation, context.getCurrentModule().getBuiltIns().getAnyType())));
        JsExpression rawCallableRef = this.bindIfNecessary(function2, receiver);
        return this.wrapFunctionCallableRef(context, receiver, expression2.getCallableReference().getReferencedName(), rawCallableRef);
    }

    private final JsExpression translateForProperty(PropertyDescriptor descriptor2, TranslationContext context, KtCallableReferenceExpression expression2, JsExpression receiver) {
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
        KtExpression ktExpression = ktSimpleNameExpression;
        BindingContext bindingContext = context.bindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"bindingContext(...)");
        ResolvedCall<? extends PropertyDescriptor> realCall = CallUtilKt.getPropertyResolvedCallWithAssert(ktExpression, bindingContext);
        DelegatingResolvedCall<PropertyDescriptor> call2 = new DelegatingResolvedCall<PropertyDescriptor>(realCall, receiver, descriptor2){
            final /* synthetic */ JsExpression $receiver;
            final /* synthetic */ PropertyDescriptor $descriptor;
            {
                this.$receiver = $receiver;
                this.$descriptor = $descriptor;
                super($realCall);
            }

            @NotNull
            public ExplicitReceiverKind getExplicitReceiverKind() {
                if (this.$receiver != null) {
                    return DescriptorUtilsKt.isExtension(this.$descriptor) ? ExplicitReceiverKind.EXTENSION_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
                }
                ExplicitReceiverKind explicitReceiverKind = super.getExplicitReceiverKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)explicitReceiverKind), (String)"getExplicitReceiverKind(...)");
                return explicitReceiverKind;
            }
        };
        JsExpression getter2 = this.translateForPropertyAccessor((ResolvedCall<? extends PropertyDescriptor>)call2, expression2, descriptor2, context, receiver, false, (Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function4)translateForProperty.getter.1.INSTANCE));
        JsExpression setter2 = this.isSetterVisible(descriptor2, context) ? this.translateForPropertyAccessor((ResolvedCall<? extends PropertyDescriptor>)call2, expression2, descriptor2, context, receiver, true, (Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression>)((Function4)new Function4<TranslationContext, ResolvedCall<? extends VariableDescriptor>, JsExpression, JsExpression, JsExpression>((Object)CallTranslator.INSTANCE){

            @NotNull
            public final JsExpression invoke(@NotNull TranslationContext p0, @NotNull ResolvedCall<? extends VariableDescriptor> p1, @NotNull JsExpression p2, @Nullable JsExpression p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return ((CallTranslator)this.receiver).translateSet(p0, p1, p2, p3);
            }

            @NotNull
            public final String getSignature() {
                return "translateSet(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;";
            }

            @NotNull
            public final String getName() {
                return "translateSet";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(CallTranslator.class);
            }
        })) : null;
        return this.wrapPropertyCallableRef(context, receiver, descriptor2, expression2.getCallableReference().getReferencedName(), getter2, setter2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSetterVisible(PropertyDescriptor descriptor2, TranslationContext context) {
        void $this$filterIsInstance$iv;
        PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
        if (propertySetterDescriptor == null) {
            return false;
        }
        PropertySetterDescriptor setter2 = propertySetterDescriptor;
        if (!Intrinsics.areEqual((Object)setter2.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            return true;
        }
        ClassDescriptor classDescriptor2 = context.getClassDescriptor();
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor classDescriptor3 = classDescriptor2;
        Sequence sequence2 = SequencesKt.generateSequence((Object)classDescriptor3, (Function1)isSetterVisible.outerClasses.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isSetterVisible$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence outerClasses2 = sequence3;
        return SequencesKt.contains((Sequence)outerClasses2, (Object)descriptor2.getContainingDeclaration());
    }

    private final JsExpression translateForPropertyAccessor(ResolvedCall<? extends PropertyDescriptor> call2, KtExpression expression2, PropertyDescriptor descriptor2, TranslationContext context, JsExpression receiver, boolean isSetter, Function4<? super TranslationContext, ? super ResolvedCall<? extends PropertyDescriptor>, ? super JsExpression, ? super JsExpression, ? extends JsExpression> translator) {
        JsExpression jsExpression;
        Collection collection;
        JsNameRef receiverParam;
        JsNameRef jsNameRef;
        Object object;
        JsFunction accessorFunction = new JsFunction(context.scope(), new JsBlock(), "");
        accessorFunction.setSource(expression2);
        TranslationContext translationContext = context.innerBlock(accessorFunction.getBody());
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"innerBlock(...)");
        TranslationContext accessorContext = translationContext;
        if (descriptor2.getDispatchReceiverParameter() != null || descriptor2.getExtensionReceiverParameter() != null) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
            JsName name2 = jsName;
            List<JsParameter> list2 = accessorFunction.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
            object = list2;
            object.add(new JsParameter(name2));
            jsNameRef = name2.makeRef();
        } else {
            jsNameRef = receiverParam = null;
        }
        if (isSetter) {
            JsName jsName = JsScope.declareTemporaryName("value");
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(...)");
            JsName name3 = jsName;
            List<JsParameter> list3 = accessorFunction.getParameters();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getParameters(...)");
            collection = list3;
            collection.add(new JsParameter(name3));
            object = name3.makeRef();
            Intrinsics.checkNotNull((Object)object);
            jsExpression = (JsExpression)object;
        } else {
            jsExpression = new JsNullLiteral();
        }
        JsExpression valueParam = jsExpression;
        JsExpression accessorResult = (JsExpression)translator.invoke((Object)accessorContext, call2, (Object)valueParam, receiverParam);
        List<JsStatement> list4 = accessorFunction.getBody().getStatements();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"getStatements(...)");
        collection = list4;
        collection.add(isSetter ? accessorResult.makeStmt() : (JsStatement)new JsReturn(accessorResult));
        PsiElement psiElement = UtilsKt.getFinalElement((PsiElement)expression2);
        accessorFunction.getBody().setSource(psiElement instanceof LeafPsiElement ? (LeafPsiElement)psiElement : null);
        return this.bindIfNecessary(accessorFunction, receiver);
    }

    private final JsExpression bindIfNecessary(JsFunction function2, JsExpression receiver) {
        JsExpression jsExpression;
        if (receiver != null) {
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsNullLiteral(), receiver};
            jsExpression = new JsInvocation((JsExpression)new JsNameRef("bind", (JsExpression)function2), jsExpressionArray);
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }

    private final JsExpression wrapPropertyCallableRef(TranslationContext $this$wrapPropertyCallableRef, JsExpression receiver, PropertyDescriptor descriptor2, String name2, JsExpression getter2, JsExpression setter2) {
        int argCount;
        int n = argCount = descriptor2.getContainingDeclaration() instanceof ClassDescriptor || descriptor2.getExtensionReceiverParameter() != null ? 1 : 0;
        if (receiver != null) {
            --argCount;
        }
        JsStringLiteral nameLiteral = new JsStringLiteral(name2);
        JsIntLiteral argCountLiteral = new JsIntLiteral(argCount);
        JsExpression jsExpression = $this$wrapPropertyCallableRef.getReferenceToIntrinsic("getPropertyCallableRef");
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getReferenceToIntrinsic(...)");
        JsExpression invokeFun = jsExpression;
        JsExpression[] jsExpressionArray = new JsExpression[]{nameLiteral, argCountLiteral, getter2};
        JsInvocation invocation = new JsInvocation(invokeFun, jsExpressionArray);
        if (setter2 != null) {
            List<JsExpression> list2 = invocation.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getArguments(...)");
            ((Collection)list2).add(setter2);
        }
        MetadataProperties.setCallableReferenceReceiver(invocation, receiver);
        return invocation;
    }

    private final JsExpression wrapFunctionCallableRef(TranslationContext $this$wrapFunctionCallableRef, JsExpression receiver, String name2, JsExpression function2) {
        JsStringLiteral nameLiteral = new JsStringLiteral(name2);
        JsExpression jsExpression = $this$wrapFunctionCallableRef.getReferenceToIntrinsic("getCallableRef");
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getReferenceToIntrinsic(...)");
        JsExpression invokeFun = jsExpression;
        MetadataProperties.setSideEffects(invokeFun, SideEffectKind.PURE);
        JsExpression[] jsExpressionArray = new JsExpression[]{nameLiteral, function2};
        JsInvocation invocation = new JsInvocation(invokeFun, jsExpressionArray);
        MetadataProperties.setCallableReference(invocation, true);
        MetadataProperties.setSideEffects(invocation, SideEffectKind.PURE);
        MetadataProperties.setCallableReferenceReceiver(invocation, receiver);
        return invocation;
    }
}

