/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.utils;

import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.descriptors.Fe10AnalysisContext;
import org.jetbrains.kotlin.analysis.api.descriptors.Fe10AnalysisFacade;
import org.jetbrains.kotlin.analysis.api.descriptors.utils.InlineDelegatedPropertyAccessorsAnalyzer;
import org.jetbrains.kotlin.analysis.api.descriptors.utils.InlineFunctionsCollector;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/utils/InlineFunctionAnalyzer;", "", "analysisContext", "Lorg/jetbrains/kotlin/analysis/api/descriptors/Fe10AnalysisContext;", "analyzeOnlyReifiedInlineFunctions", "", "(Lorg/jetbrains/kotlin/analysis/api/descriptors/Fe10AnalysisContext;Z)V", "analyzedElements", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "inlineFunctionsWithBody", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "allFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "analyze", "", "element", "inlineObjectDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "analysis-api-fe10"})
@SourceDebugExtension(value={"SMAP\nInlineFunctionAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineFunctionAnalyzer.kt\norg/jetbrains/kotlin/analysis/api/descriptors/utils/InlineFunctionAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1618#2,3:119\n1853#2,2:122\n*S KotlinDebug\n*F\n+ 1 InlineFunctionAnalyzer.kt\norg/jetbrains/kotlin/analysis/api/descriptors/utils/InlineFunctionAnalyzer\n*L\n98#1:119,3\n106#1:122,2\n*E\n"})
public final class InlineFunctionAnalyzer {
    @NotNull
    private final Fe10AnalysisContext analysisContext;
    private final boolean analyzeOnlyReifiedInlineFunctions;
    @NotNull
    private final Set<KtElement> analyzedElements;
    @NotNull
    private final Set<KtDeclarationWithBody> inlineFunctionsWithBody;

    public InlineFunctionAnalyzer(@NotNull Fe10AnalysisContext analysisContext, boolean analyzeOnlyReifiedInlineFunctions) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        this.analysisContext = analysisContext;
        this.analyzeOnlyReifiedInlineFunctions = analyzeOnlyReifiedInlineFunctions;
        this.analyzedElements = new LinkedHashSet();
        this.inlineFunctionsWithBody = new LinkedHashSet();
    }

    public final void analyze(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        HashSet<KtDeclarationWithBody> nextInlineFunctions = new HashSet<KtDeclarationWithBody>();
        InlineFunctionsCollector collector2 = new InlineFunctionsCollector(project2, this.analyzeOnlyReifiedInlineFunctions, (Function1<? super KtDeclarationWithBody, Unit>)((Function1)new Function1<KtDeclarationWithBody, Unit>(this, nextInlineFunctions){
            final /* synthetic */ InlineFunctionAnalyzer this$0;
            final /* synthetic */ HashSet<KtDeclarationWithBody> $nextInlineFunctions;
            {
                this.this$0 = $receiver;
                this.$nextInlineFunctions = $nextInlineFunctions;
                super(1);
            }

            public final void invoke(KtDeclarationWithBody declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                if (!InlineFunctionAnalyzer.access$getAnalyzedElements$p(this.this$0).contains(declaration)) {
                    this.$nextInlineFunctions.add(declaration);
                }
            }
        }));
        InlineDelegatedPropertyAccessorsAnalyzer propertyAccessor = new InlineDelegatedPropertyAccessorsAnalyzer(this.analysisContext, collector2);
        element.accept(new KtTreeVisitorVoid(this, collector2, propertyAccessor){
            final /* synthetic */ InlineFunctionAnalyzer this$0;
            final /* synthetic */ InlineFunctionsCollector $collector;
            final /* synthetic */ InlineDelegatedPropertyAccessorsAnalyzer $propertyAccessor;
            {
                this.this$0 = $receiver;
                this.$collector = $collector;
                this.$propertyAccessor = $propertyAccessor;
            }

            public void visitExpression(KtExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                BindingContext bindingContext = Fe10AnalysisFacade.analyze$default((Fe10AnalysisFacade)InlineFunctionAnalyzer.access$getAnalysisContext$p(this.this$0), expression2, null, 2, null);
                Call call2 = (Call)bindingContext.get(BindingContext.CALL, expression2);
                if (call2 == null) {
                    return;
                }
                Call call3 = call2;
                ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext.get(BindingContext.RESOLVED_CALL, call3);
                this.$collector.checkResolveCall(resolvedCall2);
            }

            public void visitDestructuringDeclaration(KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                BindingContext bindingContext = Fe10AnalysisFacade.analyze$default((Fe10AnalysisFacade)InlineFunctionAnalyzer.access$getAnalysisContext$p(this.this$0), destructuringDeclaration, null, 2, null);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                    this.$collector.checkResolveCall(resolvedCall2);
                }
            }

            public void visitForExpression(KtForExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitForExpression(expression2);
                BindingContext bindingContext = Fe10AnalysisFacade.analyze$default((Fe10AnalysisFacade)InlineFunctionAnalyzer.access$getAnalysisContext$p(this.this$0), expression2, null, 2, null);
                this.$collector.checkResolveCall((ResolvedCall)bindingContext.get(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, expression2.getLoopRange()));
                this.$collector.checkResolveCall((ResolvedCall)bindingContext.get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
                this.$collector.checkResolveCall((ResolvedCall)bindingContext.get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
            }

            public void visitProperty(KtProperty property) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                super.visitProperty(property);
                this.$propertyAccessor.visitProperty(property);
            }
        });
        this.analyzedElements.add(element);
        if (!((Collection)nextInlineFunctions).isEmpty()) {
            for (KtDeclarationWithBody inlineFunction : nextInlineFunctions) {
                if (inlineFunction.getBodyExpression() == null) continue;
                Intrinsics.checkNotNull((Object)inlineFunction);
                this.inlineFunctionsWithBody.add(inlineFunction);
                this.analyze(inlineFunction);
            }
            this.analyzedElements.addAll((Collection<KtElement>)nextInlineFunctions);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtFile> allFiles() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.analyzedElements;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KtElement ktElement = (KtElement)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getContainingKtFile());
        }
        return CollectionsKt.toList((Iterable)((Iterable)var2_2));
    }

    @NotNull
    public final Set<KtObjectDeclaration> inlineObjectDeclarations() {
        Set results = new LinkedHashSet();
        Iterable $this$forEach$iv = this.inlineFunctionsWithBody;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression ktExpression;
            KtDeclarationWithBody inlineFunction = (KtDeclarationWithBody)element$iv;
            boolean bl = false;
            if (inlineFunction.getBodyExpression() == null) continue;
            Intrinsics.checkNotNull((Object)ktExpression);
            KtExpression body2 = ktExpression;
            body2.accept(new KtTreeVisitorVoid(results){
                final /* synthetic */ Set<KtObjectDeclaration> $results;
                {
                    this.$results = $results;
                }

                public void visitObjectLiteralExpression(KtObjectLiteralExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    super.visitObjectLiteralExpression(expression2);
                    KtObjectDeclaration ktObjectDeclaration = expression2.getObjectDeclaration();
                    Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"getObjectDeclaration(...)");
                    this.$results.add(ktObjectDeclaration);
                }
            });
        }
        return results;
    }

    public static final /* synthetic */ Set access$getAnalyzedElements$p(InlineFunctionAnalyzer $this) {
        return $this.analyzedElements;
    }

    public static final /* synthetic */ Fe10AnalysisContext access$getAnalysisContext$p(InlineFunctionAnalyzer $this) {
        return $this.analysisContext;
    }
}

