/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.compile;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.analysis.api.compile.CodeFragmentCapturedValue;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compile.CodeFragmentCapturedId;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compile.CodeFragmentCapturedSymbol;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compile.CodeFragmentScopeProviderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0002J\u001c\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001c\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030(H\u0002J\u0010\u0010)\u001a\u00020'2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u0010H\u0002J\u0014\u0010,\u001a\u00020'2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0010\u0010-\u001a\u00020'2\u0006\u0010#\u001a\u00020$H\u0016R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u001c\u0010\u001b\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001d\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedValueVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitorVoid;", "resolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "selfSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;Ljava/util/Set;)V", "assignmentLhs", "", "collectedFiles", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectedMappings", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedId;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedSymbol;", "files", "", "getFiles", "()Ljava/util/List;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "values", "getValues", "isMutated", "", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "findCommonParentContextAware", "Lcom/intellij/psi/PsiElement;", "callSite", "declarationSite", "isCrossingInlineBounds", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "symbol", "processCall", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "processElement", "register", "mapping", "registerFile", "visitElement", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentCapturedValueAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentCapturedValueAnalyzer.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedValueVisitor\n+ 2 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,295:1\n46#2,4:296\n82#3:300\n62#3:301\n28#3:302\n*S KotlinDebug\n*F\n+ 1 CodeFragmentCapturedValueAnalyzer.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compile/CodeFragmentCapturedValueVisitor\n*L\n139#1:296,4\n209#1:300\n244#1:301\n272#1:302\n*E\n"})
final class CodeFragmentCapturedValueVisitor
extends FirDefaultVisitorVoid {
    @NotNull
    private final LLFirResolveSession resolveSession;
    @NotNull
    private final Set<FirBasedSymbol<?>> selfSymbols;
    @NotNull
    private final LinkedHashMap<CodeFragmentCapturedId, CodeFragmentCapturedSymbol> collectedMappings;
    @NotNull
    private final LinkedHashSet<KtFile> collectedFiles;
    @NotNull
    private final List<FirBasedSymbol<?>> assignmentLhs;

    public CodeFragmentCapturedValueVisitor(@NotNull LLFirResolveSession resolveSession, @NotNull Set<? extends FirBasedSymbol<?>> selfSymbols) {
        Intrinsics.checkNotNullParameter((Object)resolveSession, (String)"resolveSession");
        Intrinsics.checkNotNullParameter(selfSymbols, (String)"selfSymbols");
        this.resolveSession = resolveSession;
        this.selfSymbols = selfSymbols;
        this.collectedMappings = new LinkedHashMap();
        this.collectedFiles = new LinkedHashSet();
        this.assignmentLhs = new ArrayList();
    }

    @NotNull
    public final List<CodeFragmentCapturedSymbol> getValues() {
        Collection<CodeFragmentCapturedSymbol> collection = this.collectedMappings.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @NotNull
    public final List<KtFile> getFiles() {
        return CollectionsKt.toList((Iterable)this.collectedFiles);
    }

    private final FirSession getSession() {
        return this.resolveSession.getUseSiteFirSession();
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        FirCallableSymbol<?> lhs;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.processElement(element);
        FirPureAbstractElement firPureAbstractElement = element instanceof FirVariableAssignment ? (FirVariableAssignment)element : null;
        FirCallableSymbol<?> firCallableSymbol = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getLValue()) != null ? ReferenceUtilsKt.toResolvedCallableSymbol((FirExpression)firPureAbstractElement, this.getSession()) : (lhs = null);
        if (lhs != null) {
            this.assignmentLhs.add(lhs);
        }
        element.acceptChildren(this);
        if (lhs != null && !Intrinsics.areEqual((Object)CollectionsKt.removeLast(this.assignmentLhs), lhs)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private final void processElement(FirElement element) {
        FirCallableSymbol symbol2;
        FirElement firElement;
        FirClassifierSymbol<?> symbol3;
        if (element instanceof FirExpression && (symbol3 = TypeUtilsKt.toSymbol(FirTypeUtilsKt.getResolvedType((FirExpression)element), this.getSession())) != null) {
            this.registerFile((FirBasedSymbol)symbol3);
        }
        if ((firElement = element) instanceof FirSuperReference) {
            FirRegularClassSymbol symbol4;
            FirTypeRef firTypeRef = ((FirSuperReference)element).getSuperTypeRef();
            FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
            FirRegularClassSymbol firRegularClassSymbol = symbol4 = firResolvedTypeRef != null ? FirHelpersKt.toRegularClassSymbol(firResolvedTypeRef, this.getSession()) : null;
            if (symbol4 != null && !this.selfSymbols.contains(symbol4)) {
                boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element, symbol4);
                CodeFragmentCapturedValue.SuperClass capturedValue = new CodeFragmentCapturedValue.SuperClass(symbol4.getClassId(), isCrossingInlineBounds);
                this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol4, ((FirSuperReference)element).getSuperTypeRef(), 0, 8, null));
            }
        } else if (firElement instanceof FirThisReference) {
            int contextReceiverNumber = ((FirThisReference)element).getContextReceiverNumber();
            FirBasedSymbol<?> symbol5 = ((FirThisReference)element).getBoundSymbol();
            if (symbol5 != null && !this.selfSymbols.contains(symbol5)) {
                FirBasedSymbol<?> firBasedSymbol = symbol5;
                if (firBasedSymbol instanceof FirClassSymbol) {
                    if (((FirClassSymbol)symbol5).getClassKind() != ClassKind.OBJECT) {
                        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
                        boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element, symbol5);
                        CodeFragmentCapturedValue.ContainingClass capturedValue = new CodeFragmentCapturedValue.ContainingClass(((FirClassSymbol)symbol5).getClassId(), isCrossingInlineBounds);
                        boolean $i$f$buildResolvedTypeRef = false;
                        FirResolvedTypeRefBuilder $this$processElement_u24lambda_u240 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                        boolean bl = false;
                        $this$processElement_u24lambda_u240.setType(ScopeUtilsKt.defaultType((FirClassSymbol)symbol5));
                        FirResolvedTypeRef typeRef = firResolvedTypeRefBuilder.build();
                        this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol5, typeRef, contextReceiverNumber));
                    }
                } else if (firBasedSymbol instanceof FirFunctionSymbol ? true : firBasedSymbol instanceof FirPropertySymbol) {
                    if (!(symbol5 instanceof FirCallableSymbol)) {
                        String capturedValue = "Failed requirement.";
                        throw new IllegalArgumentException(capturedValue.toString());
                    }
                    if (contextReceiverNumber >= 0) {
                        FirContextReceiver contextReceiver2 = ((FirCallableSymbol)symbol5).getResolvedContextReceivers().get(contextReceiverNumber);
                        Name labelName = UtilsKt.getLabelName(contextReceiver2);
                        if (labelName != null) {
                            boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element, symbol5);
                            CodeFragmentCapturedValue.ContextReceiver capturedValue = new CodeFragmentCapturedValue.ContextReceiver(contextReceiverNumber, labelName, isCrossingInlineBounds);
                            this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol5, contextReceiver2.getTypeRef(), contextReceiverNumber));
                        }
                    } else {
                        Object object;
                        String string2 = ((FirThisReference)element).getLabelName();
                        if (string2 == null && ((object = symbol5 instanceof FirAnonymousFunctionSymbol ? (FirAnonymousFunctionSymbol)symbol5 : null) != null && (object = ((FirAnonymousFunctionSymbol)object).getLabel()) != null ? ((FirLabel)object).getName() : (string2 = null)) == null) {
                            String string3 = ((FirCallableSymbol)symbol5).getName().asString();
                            string2 = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                        }
                        String labelName = string2;
                        FirPureAbstractElement firPureAbstractElement = ((FirCallableSymbol)symbol5).getReceiverParameter();
                        if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getTypeRef()) == null) {
                            throw new IllegalStateException("Receiver parameter not found".toString());
                        }
                        FirPureAbstractElement typeRef = firPureAbstractElement;
                        boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element, symbol5);
                        CodeFragmentCapturedValue.ExtensionReceiver capturedValue = new CodeFragmentCapturedValue.ExtensionReceiver(labelName, isCrossingInlineBounds);
                        this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol5, (FirTypeRef)typeRef, contextReceiverNumber));
                    }
                }
            }
        } else if (firElement instanceof FirResolvable && (symbol2 = FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirResolvable)element).getCalleeReference(), false, 1, null)) != null && !this.selfSymbols.contains(symbol2)) {
            this.processCall(element, symbol2);
        }
    }

    private final void processCall(FirElement element, FirCallableSymbol<?> symbol2) {
        FirCallableSymbol<?> firCallableSymbol = symbol2;
        if (firCallableSymbol instanceof FirValueParameterSymbol) {
            boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element, (FirBasedSymbol)symbol2);
            CodeFragmentCapturedValue.Local capturedValue = new CodeFragmentCapturedValue.Local(symbol2.getName(), this.isMutated((FirBasedSymbol)symbol2), isCrossingInlineBounds);
            this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol2, symbol2.getResolvedReturnTypeRef(), 0, 8, null));
        } else if (firCallableSymbol instanceof FirPropertySymbol) {
            if (((FirPropertySymbol)symbol2).isLocal()) {
                boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element, (FirBasedSymbol)symbol2);
                CodeFragmentCapturedValue capturedValue = Intrinsics.areEqual((Object)CodeFragmentScopeProviderKt.getForeignValueMarker((FirProperty)((FirPropertySymbol)symbol2).getFir()), (Object)true) ? (CodeFragmentCapturedValue)new CodeFragmentCapturedValue.ForeignValue(symbol2.getName(), isCrossingInlineBounds) : (((FirPropertySymbol)symbol2).getHasDelegate() ? (CodeFragmentCapturedValue)new CodeFragmentCapturedValue.LocalDelegate(symbol2.getName(), this.isMutated((FirBasedSymbol)symbol2), isCrossingInlineBounds) : (CodeFragmentCapturedValue)new CodeFragmentCapturedValue.Local(symbol2.getName(), this.isMutated((FirBasedSymbol)symbol2), isCrossingInlineBounds));
                this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol2, symbol2.getResolvedReturnTypeRef(), 0, 8, null));
            } else {
                FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)symbol2, FirResolvePhase.BODY_RESOLVE);
            }
        } else if (firCallableSymbol instanceof FirBackingFieldSymbol) {
            Name propertyName = ((FirBackingFieldSymbol)symbol2).getPropertySymbol().getName();
            boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element, (FirBasedSymbol)symbol2);
            CodeFragmentCapturedValue.BackingField capturedValue = new CodeFragmentCapturedValue.BackingField(propertyName, this.isMutated((FirBasedSymbol)symbol2), isCrossingInlineBounds);
            this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol2, symbol2.getResolvedReturnTypeRef(), 0, 8, null));
        } else if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
            FirNamedFunctionSymbol $this$isLocal$iv = (FirNamedFunctionSymbol)symbol2;
            boolean $i$f$isLocal = false;
            if (Intrinsics.areEqual((Object)$this$isLocal$iv.getRawStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) {
                this.registerFile((FirBasedSymbol)symbol2);
            }
        }
        if (Intrinsics.areEqual((Object)symbol2.getCallableId(), (Object)StandardClassIds.Callables.INSTANCE.getCoroutineContext())) {
            boolean isCrossingInlineBounds = this.isCrossingInlineBounds(element, (FirBasedSymbol)symbol2);
            CodeFragmentCapturedValue.CoroutineContext capturedValue = new CodeFragmentCapturedValue.CoroutineContext(isCrossingInlineBounds);
            this.register(new CodeFragmentCapturedSymbol(capturedValue, symbol2, symbol2.getResolvedReturnTypeRef(), 0, 8, null));
        }
    }

    private final void register(CodeFragmentCapturedSymbol mapping2) {
        CodeFragmentCapturedId id = new CodeFragmentCapturedId(mapping2.getSymbol(), mapping2.getContextReceiverNumber());
        CodeFragmentCapturedSymbol previousMapping = this.collectedMappings.get(id);
        if (previousMapping != null) {
            CodeFragmentCapturedValue previousValue = previousMapping.getValue();
            CodeFragmentCapturedValue newValue = mapping2.getValue();
            if (!Intrinsics.areEqual(previousValue.getClass(), newValue.getClass())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (previousValue.isMutated() || !newValue.isMutated()) {
                return;
            }
        }
        ((Map)this.collectedMappings).put(id, mapping2);
        this.registerFile(mapping2.getSymbol());
    }

    private final void registerFile(FirBasedSymbol<?> symbol2) {
        boolean needsRegistration;
        boolean bl;
        FirBasedSymbol<?> firBasedSymbol = symbol2;
        if (firBasedSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)symbol2;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getClassId().isLocal();
        } else {
            bl = firBasedSymbol instanceof FirAnonymousObjectSymbol ? true : (needsRegistration = firBasedSymbol instanceof FirNamedFunctionSymbol ? ((FirNamedFunctionSymbol)symbol2).getCallableId().isLocal() : false);
        }
        if (!needsRegistration) {
            return;
        }
        KtFile ktFile = org.jetbrains.kotlin.analysis.low.level.api.fir.util.UtilsKt.getContainingKtFileIfAny(symbol2.getFir());
        if (ktFile == null) {
            return;
        }
        KtFile file2 = ktFile;
        if (!file2.isCompiled()) {
            this.collectedFiles.add(file2);
        }
    }

    private final boolean isCrossingInlineBounds(FirElement element, FirBasedSymbol<?> symbol2) {
        PsiElement elementInBetween;
        KtSourceElement ktSourceElement = element.getSource();
        if (ktSourceElement == null || (ktSourceElement = KtSourceElementKt.getPsi(ktSourceElement)) == null) {
            return false;
        }
        KtSourceElement callSite = ktSourceElement;
        KtSourceElement ktSourceElement2 = ((FirDeclaration)symbol2.getFir()).getSource();
        if (ktSourceElement2 == null || (ktSourceElement2 = KtSourceElementKt.getPsi(ktSourceElement2)) == null) {
            return false;
        }
        KtSourceElement declarationSite = ktSourceElement2;
        PsiElement psiElement = this.findCommonParentContextAware((PsiElement)callSite, (PsiElement)declarationSite);
        if (psiElement == null) {
            return false;
        }
        PsiElement commonParent2 = psiElement;
        Iterator iterator2 = DeclarationUtilsKt.getParentsCodeFragmentAware((PsiElement)callSite).iterator();
        while (iterator2.hasNext() && (elementInBetween = (PsiElement)iterator2.next()) != commonParent2) {
            FirBasedSymbol symbolInBetween;
            if (!(elementInBetween instanceof KtFunction) || !((symbolInBetween = LowLevelFirApiFacadeKt.resolveToFirSymbol$default((KtDeclaration)elementInBetween, this.resolveSession, null, 2, null)) instanceof FirCallableSymbol)) continue;
            FirCallableSymbol $this$isInline$iv = (FirCallableSymbol)symbolInBetween;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getRawStatus().isInline()) continue;
            return true;
        }
        return false;
    }

    private final PsiElement findCommonParentContextAware(PsiElement callSite, PsiElement declarationSite) {
        PsiElement directParent = PsiTreeUtil.findCommonParent((PsiElement)callSite, (PsiElement)declarationSite);
        if (directParent != null) {
            return directParent;
        }
        PsiFile psiFile = callSite.getContainingFile();
        KtCodeFragment ktCodeFragment = psiFile instanceof KtCodeFragment ? (KtCodeFragment)psiFile : null;
        if (ktCodeFragment == null) {
            return null;
        }
        KtCodeFragment codeFragment = ktCodeFragment;
        PsiElement psiElement = codeFragment.getContext();
        if (psiElement == null) {
            return null;
        }
        PsiElement codeFragmentContext = psiElement;
        return PsiTreeUtil.findCommonParent((PsiElement)codeFragmentContext, (PsiElement)declarationSite);
    }

    private final boolean isMutated(FirBasedSymbol<?> $this$isMutated) {
        return Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(this.assignmentLhs), $this$isMutated);
    }
}

