/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtVariableLikeSymbol;
import org.jetbrains.kotlin.analysis.providers.KotlinPsiDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinPsiDeclarationProviderKt;
import org.jetbrains.kotlin.analysis.providers.PsiDeclarationAndKtSymbolEqualityChecker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0004*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0004*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/DecompiledPsiDeclarationProvider;", "", "()V", "providePsiForClass", "Lcom/intellij/psi/PsiElement;", "classLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "providePsiForEnumEntry", "enumEntrySymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtEnumEntrySymbol;", "providePsiForProperty", "variableLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtVariableLikeSymbol;", "findPsi", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "ktSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "providePsiForConstructor", "constructorSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtConstructorSymbol;", "providePsiForFunction", "functionLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "symbol-light-classes"})
@SourceDebugExtension(value={"SMAP\nDecompiledPsiDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecompiledPsiDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/DecompiledPsiDeclarationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n288#2,2:103\n*S KotlinDebug\n*F\n+ 1 DecompiledPsiDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/providers/DecompiledPsiDeclarationProvider\n*L\n68#1:103,2\n*E\n"})
public final class DecompiledPsiDeclarationProvider {
    @NotNull
    public static final DecompiledPsiDeclarationProvider INSTANCE = new DecompiledPsiDeclarationProvider();

    private DecompiledPsiDeclarationProvider() {
    }

    @Nullable
    public final PsiElement findPsi(@NotNull KtAnalysisSession $this$findPsi, @NotNull KtSymbol ktSymbol, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$findPsi, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ktSymbol, (String)"ktSymbol");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtSymbol ktSymbol2 = ktSymbol;
        return ktSymbol2 instanceof KtConstructorSymbol ? this.providePsiForConstructor($this$findPsi, (KtConstructorSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtFunctionLikeSymbol ? this.providePsiForFunction($this$findPsi, (KtFunctionLikeSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtEnumEntrySymbol ? this.providePsiForEnumEntry((KtEnumEntrySymbol)ktSymbol, project) : (ktSymbol2 instanceof KtVariableLikeSymbol ? this.providePsiForProperty((KtVariableLikeSymbol)ktSymbol, project) : (ktSymbol2 instanceof KtClassLikeSymbol ? this.providePsiForClass((KtClassLikeSymbol)ktSymbol, project) : null))));
    }

    private final PsiElement providePsiForConstructor(KtAnalysisSession $this$providePsiForConstructor, KtConstructorSymbol constructorSymbol, Project project) {
        Object object;
        block3: {
            PsiClass psiClass;
            Object[] objectArray;
            ClassId classId = constructorSymbol.getContainingClassIdIfNonLocal();
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(constructorSymbol, project));
            if (kotlinPsiDeclarationProvider == null || (objectArray = kotlinPsiDeclarationProvider.getClassesByClassId(classId2)) == null || (psiClass = (PsiClass)CollectionsKt.firstOrNull((Iterable)((Iterable)objectArray))) == null) {
                return null;
            }
            PsiClass psiClass2 = psiClass;
            PsiMethod[] psiMethodArray = psiClass2.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
            for (Object object2 : (Object[])psiMethodArray) {
                PsiMethod psiMethod = (PsiMethod)object2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)psiMethod);
                if (!PsiDeclarationAndKtSymbolEqualityChecker.INSTANCE.representsTheSameDeclaration($this$providePsiForConstructor, psiMethod, constructorSymbol)) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    private final PsiElement providePsiForFunction(KtAnalysisSession $this$providePsiForFunction, KtFunctionLikeSymbol functionLikeSymbol, Project project) {
        PsiMethod psiMethod;
        CallableId callableId = functionLikeSymbol.getCallableIdIfNonLocal();
        if (callableId != null) {
            Collection<PsiMethod> candidates2;
            CallableId it = callableId;
            boolean bl = false;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(functionLikeSymbol, project));
            Collection<PsiMethod> collection = candidates2 = kotlinPsiDeclarationProvider != null ? kotlinPsiDeclarationProvider.getFunctions(it) : null;
            boolean bl2 = collection != null ? collection.size() == 1 : false;
            if (bl2) {
                psiMethod = (PsiMethod)CollectionsKt.single((Iterable)candidates2);
            } else {
                Collection<PsiMethod> collection2 = candidates2;
                if (collection2 != null) {
                    Object v5;
                    block7: {
                        Iterable iterable = collection2;
                        for (Object t : iterable) {
                            PsiMethod psiMethod2 = (PsiMethod)t;
                            boolean bl3 = false;
                            if (!PsiDeclarationAndKtSymbolEqualityChecker.INSTANCE.representsTheSameDeclaration($this$providePsiForFunction, psiMethod2, functionLikeSymbol)) continue;
                            v5 = t;
                            break block7;
                        }
                        v5 = null;
                    }
                    psiMethod = v5;
                } else {
                    psiMethod = null;
                }
            }
        } else {
            psiMethod = null;
        }
        return (PsiElement)psiMethod;
    }

    private final PsiElement providePsiForProperty(KtVariableLikeSymbol variableLikeSymbol, Project project) {
        Object object;
        block6: {
            block4: {
                PsiMember candidates2;
                block7: {
                    Object v4;
                    block3: {
                        block5: {
                            CallableId callableId = variableLikeSymbol.getCallableIdIfNonLocal();
                            if (callableId == null) break block4;
                            CallableId it = callableId;
                            boolean bl = false;
                            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(variableLikeSymbol, project));
                            PsiMember psiMember = candidates2 = kotlinPsiDeclarationProvider != null ? kotlinPsiDeclarationProvider.getProperties(it) : null;
                            boolean bl2 = psiMember != null ? psiMember.size() == 1 : false;
                            if (!bl2) break block5;
                            object = (PsiMember)CollectionsKt.single((Iterable)((Iterable)candidates2));
                            break block6;
                        }
                        object = candidates2;
                        if (object == null) break block7;
                        Iterable $this$firstOrNull$iv = (Iterable)object;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PsiMember psiMember = (PsiMember)element$iv;
                            boolean bl = false;
                            if (!(psiMember instanceof PsiField)) continue;
                            v4 = element$iv;
                            break block3;
                        }
                        v4 = null;
                    }
                    if ((object = (PsiMember)v4) != null) break block6;
                }
                PsiMember psiMember = candidates2;
                object = psiMember != null ? (PsiMember)CollectionsKt.firstOrNull((Iterable)((Iterable)psiMember)) : null;
                break block6;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    private final PsiElement providePsiForClass(KtClassLikeSymbol classLikeSymbol, Project project) {
        PsiClass psiClass;
        ClassId classId = classLikeSymbol.getClassIdIfNonLocal();
        if (classId != null) {
            Collection<PsiClass> collection;
            ClassId it = classId;
            boolean bl = false;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, INSTANCE.scope(classLikeSymbol, project));
            psiClass = kotlinPsiDeclarationProvider != null && (collection = kotlinPsiDeclarationProvider.getClassesByClassId(it)) != null ? (PsiClass)CollectionsKt.firstOrNull((Iterable)collection) : null;
        } else {
            psiClass = null;
        }
        return (PsiElement)psiClass;
    }

    private final PsiElement providePsiForEnumEntry(KtEnumEntrySymbol enumEntrySymbol, Project project) {
        Object object;
        block3: {
            PsiClass psiClass;
            Object[] objectArray;
            ClassId classId = enumEntrySymbol.getContainingEnumClassIdIfNonLocal();
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            KotlinPsiDeclarationProvider kotlinPsiDeclarationProvider = KotlinPsiDeclarationProviderKt.createPsiDeclarationProvider(project, this.scope(enumEntrySymbol, project));
            if (kotlinPsiDeclarationProvider == null || (objectArray = kotlinPsiDeclarationProvider.getClassesByClassId(classId2)) == null || (psiClass = (PsiClass)CollectionsKt.firstOrNull((Iterable)((Iterable)objectArray))) == null) {
                return null;
            }
            PsiClass psiClass2 = psiClass;
            PsiField[] psiFieldArray = psiClass2.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
            for (Object object2 : (Object[])psiFieldArray) {
                PsiField it = (PsiField)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)enumEntrySymbol.getName().asString())) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        return (PsiElement)object;
    }

    private final GlobalSearchScope scope(KtSymbol $this$scope, Project project) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return globalSearchScope;
    }
}

