/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/cli/common/messages/CompilerLoggerAdapter;", "Lorg/jetbrains/kotlin/util/Logger;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "treatWarningsAsErrors", "", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Z)V", "error", "", "message", "", "fatal", "", "log", "warning", "cli"})
final class CompilerLoggerAdapter
implements Logger {
    @NotNull
    private final MessageCollector messageCollector;
    private final boolean treatWarningsAsErrors;

    public CompilerLoggerAdapter(@NotNull MessageCollector messageCollector2, boolean treatWarningsAsErrors) {
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        this.messageCollector = messageCollector2;
        this.treatWarningsAsErrors = treatWarningsAsErrors;
    }

    @Override
    public void log(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.messageCollector.report(CompilerMessageSeverity.LOGGING, message2, null);
    }

    @Override
    public void warning(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.messageCollector.report(this.treatWarningsAsErrors ? CompilerMessageSeverity.ERROR : CompilerMessageSeverity.STRONG_WARNING, message2, null);
    }

    @Override
    public void error(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.messageCollector.report(CompilerMessageSeverity.ERROR, message2, null);
    }

    @Override
    @Deprecated(message="Invocation of fatal() may cause severe side effects such as throwing an exception or even terminating the current JVM process (check various implementations of this function for details). The code that uses Logger.fatal() sometimes expects a particular kind of side effect. This is an undesirable design. And it's definitely not a responsibility of Logger to influence the execution flow of the program.", replaceWith=@ReplaceWith(expression="error(message)", imports={}))
    @NotNull
    public Void fatal(@NotNull String message2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.error(message2);
            MessageCollector messageCollector2 = this.messageCollector;
            GroupingMessageCollector groupingMessageCollector = messageCollector2 instanceof GroupingMessageCollector ? (GroupingMessageCollector)messageCollector2 : null;
            if (groupingMessageCollector == null) break block0;
            groupingMessageCollector.flush();
        }
        throw new CompilationErrorException();
    }
}

