/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmAbiStability;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0000\u001a\u00020\u0001H\u0002\u001a$\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u0012\u0010\u0011\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0015\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0016\u001a\u00020\r*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001a\n\u0010\u0017\u001a\u00020\u000b*\u00020\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u001ag\u0010\u0019\u001a\u00020\u000b\"\b\b\u0000\u0010\u001a*\u00020\u001b*\u00020\u00022\b\u0010\u001c\u001a\u0004\u0018\u0001H\u001a2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u00100\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u00100\u001e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u00020\u00100\u001e2\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010!\u001a\u001c\u0010\u0019\u001a\u00020\u000b*\u00020\u00022\b\u0010\u001c\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u0013\u001a,\u0010#\u001a\u00020\u000b*\u00020\u00022\u0006\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\t2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0002\u001a\u0012\u0010)\u001a\u00020\r*\u00020*2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010+\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006,"}, d2={"messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getMessageCollector", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getJavaVersion", "", "parseBackendThreads", "stringValue", "", "addModularRootIfNotNull", "", "isModularJava", "", "moduleName", "file", "Ljava/io/File;", "configureAdvancedJvmOptions", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "configureContentRootsFromClassPath", "configureJavaModulesContentRoots", "configureJdkHome", "configureJdkHomeFromSystemProperty", "configureKlibPaths", "configureStandardLibs", "PathProvider", "", "paths", "stdlibPath", "Lkotlin/Function1;", "scriptRuntimePath", "reflectPath", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;)V", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "handleClosureGenerationSchemeArgument", "flag", "value", "key", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "Lorg/jetbrains/kotlin/config/JvmClosureGenerationScheme;", "registerJavacIfNeeded", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "setupJvmSpecificArguments", "cli"})
@SourceDebugExtension(value={"SMAP\njvmArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jvmArguments.kt\norg/jetbrains/kotlin/cli/jvm/JvmArgumentsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n11047#2:357\n11382#2,3:358\n11047#2:361\n11382#2,3:362\n817#3:365\n845#3,2:366\n*S KotlinDebug\n*F\n+ 1 jvmArguments.kt\norg/jetbrains/kotlin/cli/jvm/JvmArgumentsKt\n*L\n261#1:357\n261#1:358,3\n299#1:361\n299#1:362,3\n348#1:365\n348#1:366,2\n*E\n"})
public final class JvmArgumentsKt {
    public static final void setupJvmSpecificArguments(@NotNull CompilerConfiguration $this$setupJvmSpecificArguments, @NotNull K2JVMCompilerArguments arguments2) {
        String stringConcat;
        String jvmTargetValue;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$setupJvmSpecificArguments, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.INCLUDE_RUNTIME, arguments2.getIncludeRuntime());
        $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.NO_REFLECT, arguments2.getNoReflect());
        Object[] objectArray = arguments2.getFriendPaths();
        $this$setupJvmSpecificArguments.putIfNotNull(JVMConfigurationKeys.FRIEND_PATHS, objectArray != null ? ArraysKt.asList((Object[])objectArray) : null);
        String releaseTargetArg = arguments2.getJdkRelease();
        String jvmTargetArg = arguments2.getJvmTarget();
        if (releaseTargetArg != null) {
            Integer value2;
            string2 = releaseTargetArg;
            Integer n = Intrinsics.areEqual((Object)string2, (Object)"1.6") ? Integer.valueOf(6) : (value2 = Intrinsics.areEqual((Object)string2, (Object)"1.8") ? Integer.valueOf(8) : StringsKt.toIntOrNull((String)releaseTargetArg));
            if (value2 == null || value2 < 6) {
                MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown JDK release version: " + releaseTargetArg, null, 4, null);
            } else {
                int n2 = JvmArgumentsKt.getJavaVersion();
                if (value2 != n2 || arguments2.getJdkHome() != null) {
                    $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.JDK_RELEASE, value2);
                }
                if (jvmTargetArg != null && !Intrinsics.areEqual((Object)jvmTargetArg, (Object)releaseTargetArg)) {
                    MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "'-Xjdk-release=" + releaseTargetArg + "' option conflicts with '-jvm-target " + jvmTargetArg + "'. Please remove the '-jvm-target' option", null, 4, null);
                }
            }
        }
        String string3 = Intrinsics.areEqual((Object)(string2 = releaseTargetArg), (Object)"6") ? "1.6" : (Intrinsics.areEqual((Object)string2, (Object)"8") ? "1.8" : (jvmTargetValue = string2 == null ? jvmTargetArg : releaseTargetArg));
        if (jvmTargetValue != null) {
            JvmTarget jvmTarget = JvmTarget.Companion.fromString(jvmTargetValue);
            if (jvmTarget != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget);
                if (jvmTarget == JvmTarget.JVM_1_6) {
                    MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "JVM target 1.6 is no longer supported. Please migrate to JVM target 1.8 or above", null, 4, null);
                }
            } else {
                MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown JVM target version: " + jvmTargetValue + "\nSupported versions: " + ArraysKt.joinToString$default((Object[])JvmTarget.values(), null, null, null, (int)0, null, (Function1)setupJvmSpecificArguments.1.INSTANCE, (int)31, null), null, 4, null);
            }
        }
        JvmDefaultMode jvmDefaultMode2 = CommonConfigurationKeysKt.getLanguageVersionSettings($this$setupJvmSpecificArguments).getFlag(JvmAnalysisFlags.getJvmDefaultMode());
        JvmTarget jvmTarget = $this$setupJvmSpecificArguments.get(JVMConfigurationKeys.JVM_TARGET);
        if (jvmTarget == null) {
            jvmTarget = JvmTarget.DEFAULT;
        }
        JvmTarget jvmTarget2 = jvmTarget;
        Intrinsics.checkNotNull((Object)jvmTarget2);
        JvmTarget jvmTarget3 = jvmTarget2;
        if (jvmDefaultMode2 == JvmDefaultMode.ENABLE || jvmDefaultMode2 == JvmDefaultMode.ENABLE_WITH_DEFAULT_IMPLS) {
            MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.WARNING, "'-Xjvm-default=" + jvmDefaultMode2.getDescription() + "' is deprecated, please use '-Xjvm-default=all|all-compatibility'", null, 4, null);
        }
        if ((stringConcat = arguments2.getStringConcat()) != null) {
            JvmStringConcat runtimeStringConcat = JvmStringConcat.Companion.fromString(stringConcat);
            if (runtimeStringConcat != null) {
                $this$setupJvmSpecificArguments.put(JVMConfigurationKeys.STRING_CONCAT, runtimeStringConcat);
                if (jvmTarget3.getMajorVersion() < JvmTarget.JVM_9.getMajorVersion() && runtimeStringConcat != JvmStringConcat.INLINE) {
                    MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.WARNING, "`-Xstring-concat=" + stringConcat + "` does nothing with JVM target `" + jvmTarget3.getDescription() + "`.", null, 4, null);
                }
            } else {
                MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$setupJvmSpecificArguments), CompilerMessageSeverity.ERROR, "Unknown `-Xstring-concat` mode: " + stringConcat + "\nSupported modes: " + ArraysKt.joinToString$default((Object[])JvmStringConcat.values(), null, null, null, (int)0, null, (Function1)setupJvmSpecificArguments.2.INSTANCE, (int)31, null), null, 4, null);
            }
        }
        String string4 = arguments2.getSamConversions();
        CompilerConfigurationKey<JvmClosureGenerationScheme> compilerConfigurationKey = JVMConfigurationKeys.SAM_CONVERSIONS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey, (String)"SAM_CONVERSIONS");
        JvmArgumentsKt.handleClosureGenerationSchemeArgument($this$setupJvmSpecificArguments, "-Xsam-conversions", string4, compilerConfigurationKey);
        String string5 = arguments2.getLambdas();
        CompilerConfigurationKey<JvmClosureGenerationScheme> compilerConfigurationKey2 = JVMConfigurationKeys.LAMBDAS;
        Intrinsics.checkNotNullExpressionValue(compilerConfigurationKey2, (String)"LAMBDAS");
        JvmArgumentsKt.handleClosureGenerationSchemeArgument($this$setupJvmSpecificArguments, "-Xlambdas", string5, compilerConfigurationKey2);
        Object[] objectArray2 = arguments2.getAdditionalJavaModules();
        $this$setupJvmSpecificArguments.addAll(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, objectArray2 != null ? ArraysKt.asList((Object[])objectArray2) : null);
    }

    private static final void handleClosureGenerationSchemeArgument(CompilerConfiguration $this$handleClosureGenerationSchemeArgument, String flag, String value2, CompilerConfigurationKey<JvmClosureGenerationScheme> key) {
        if (value2 == null) {
            return;
        }
        JvmClosureGenerationScheme parsedValue = JvmClosureGenerationScheme.Companion.fromString(value2);
        if (parsedValue != null) {
            $this$handleClosureGenerationSchemeArgument.put(key, parsedValue);
        } else {
            MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$handleClosureGenerationSchemeArgument), CompilerMessageSeverity.ERROR, "Unknown `" + flag + "` argument: " + value2 + "\n.Supported arguments: " + ArraysKt.joinToString$default((Object[])JvmClosureGenerationScheme.values(), null, null, null, (int)0, null, (Function1)handleClosureGenerationSchemeArgument.1.INSTANCE, (int)31, null), null, 4, null);
        }
    }

    public static final boolean configureJdkHome(@NotNull CompilerConfiguration $this$configureJdkHome, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter((Object)$this$configureJdkHome, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        if (arguments2.getNoJdk()) {
            $this$configureJdkHome.put(JVMConfigurationKeys.NO_JDK, true);
            if (arguments2.getJdkHome() != null) {
                MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.STRONG_WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", null, 4, null);
            }
            return true;
        }
        if (arguments2.getJdkHome() != null) {
            String string2 = arguments2.getJdkHome();
            Intrinsics.checkNotNull((Object)string2);
            File jdkHome2 = new File(string2);
            if (!jdkHome2.exists()) {
                MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.ERROR, "JDK home directory does not exist: " + jdkHome2, null, 4, null);
                return false;
            }
            MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHome), CompilerMessageSeverity.LOGGING, "Using JDK home directory " + jdkHome2, null, 4, null);
            $this$configureJdkHome.put(JVMConfigurationKeys.JDK_HOME, jdkHome2);
        } else {
            JvmArgumentsKt.configureJdkHomeFromSystemProperty($this$configureJdkHome);
        }
        return true;
    }

    public static final void configureJdkHomeFromSystemProperty(@NotNull CompilerConfiguration $this$configureJdkHomeFromSystemProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$configureJdkHomeFromSystemProperty, (String)"<this>");
        File javaHome = new File(System.getProperty("java.home"));
        MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureJdkHomeFromSystemProperty), CompilerMessageSeverity.LOGGING, "Using JDK home inferred from java.home: " + javaHome, null, 4, null);
        $this$configureJdkHomeFromSystemProperty.put(JVMConfigurationKeys.JDK_HOME, javaHome);
    }

    public static final void configureJavaModulesContentRoots(@NotNull CompilerConfiguration $this$configureJavaModulesContentRoots, @NotNull K2JVMCompilerArguments arguments2) {
        List list2;
        List list3;
        Intrinsics.checkNotNullParameter((Object)$this$configureJavaModulesContentRoots, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        String string2 = arguments2.getJavaModulePath();
        if (string2 != null) {
            char[] cArray = new char[]{File.pathSeparatorChar};
            list3 = StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        for (String modularRoot : list2) {
            $this$configureJavaModulesContentRoots.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(new File(modularRoot)));
        }
    }

    public static final void configureContentRootsFromClassPath(@NotNull CompilerConfiguration $this$configureContentRootsFromClassPath, @NotNull K2JVMCompilerArguments arguments2) {
        List list2;
        List list3;
        Intrinsics.checkNotNullParameter((Object)$this$configureContentRootsFromClassPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        String string2 = arguments2.getClasspath();
        if (string2 != null) {
            char[] cArray = new char[]{File.pathSeparatorChar};
            list3 = StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        for (String path : list2) {
            $this$configureContentRootsFromClassPath.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(new File(path)));
        }
    }

    public static final void configureStandardLibs(@NotNull CompilerConfiguration $this$configureStandardLibs, @Nullable KotlinPaths paths, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter((Object)$this$configureStandardLibs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        JvmArgumentsKt.configureStandardLibs($this$configureStandardLibs, paths, (Function1)configureStandardLibs.1.INSTANCE, (Function1)configureStandardLibs.2.INSTANCE, (Function1)configureStandardLibs.3.INSTANCE, arguments2);
    }

    public static final <PathProvider> void configureStandardLibs(@NotNull CompilerConfiguration $this$configureStandardLibs, @Nullable PathProvider paths, @NotNull Function1<? super PathProvider, ? extends File> stdlibPath, @NotNull Function1<? super PathProvider, ? extends File> scriptRuntimePath, @NotNull Function1<? super PathProvider, ? extends File> reflectPath, @NotNull K2JVMCompilerArguments arguments2) {
        boolean isModularJava;
        Intrinsics.checkNotNullParameter((Object)$this$configureStandardLibs, (String)"<this>");
        Intrinsics.checkNotNullParameter(stdlibPath, (String)"stdlibPath");
        Intrinsics.checkNotNullParameter(scriptRuntimePath, (String)"scriptRuntimePath");
        Intrinsics.checkNotNullParameter(reflectPath, (String)"reflectPath");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        Integer jdkRelease = $this$configureStandardLibs.get(JVMConfigurationKeys.JDK_RELEASE);
        boolean bl = isModularJava = JvmArgumentsKt.isModularJava($this$configureStandardLibs) && (jdkRelease == null || jdkRelease >= 9);
        if (!arguments2.getNoStdlib()) {
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths, "kotlin.stdlib", "kotlin-stdlib.jar", stdlibPath, "'-no-stdlib'");
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths, "kotlin.script.runtime", "kotlin-script-runtime.jar", scriptRuntimePath, "'-no-stdlib'");
        }
        if (!arguments2.getNoReflect() && !arguments2.getNoStdlib()) {
            JvmArgumentsKt.configureStandardLibs$addRoot($this$configureStandardLibs, isModularJava, paths, "kotlin.reflect", "kotlin-reflect.jar", reflectPath, "'-no-reflect' or '-no-stdlib'");
        }
    }

    public static final boolean isModularJava(@NotNull CompilerConfiguration $this$isModularJava) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isModularJava, (String)"<this>");
        File file2 = $this$isModularJava.get(JVMConfigurationKeys.JDK_HOME);
        if (file2 != null) {
            File it = file2;
            boolean bl2 = false;
            bl = CoreJrtFileSystem.Companion.isModularJdk(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final void addModularRootIfNotNull(@NotNull CompilerConfiguration $this$addModularRootIfNotNull, boolean isModularJava, @NotNull String moduleName, @Nullable File file2) {
        Intrinsics.checkNotNullParameter((Object)$this$addModularRootIfNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        if (file2 != null) {
            if (isModularJava) {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(file2));
                $this$addModularRootIfNotNull.add(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, moduleName);
            } else {
                $this$addModularRootIfNotNull.add(CLIConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(file2));
            }
        }
    }

    public static final boolean registerJavacIfNeeded(@NotNull KotlinCoreEnvironment $this$registerJavacIfNeeded, @NotNull K2JVMCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerJavacIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        if (arguments2.getUseJavac()) {
            $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, true);
            if (arguments2.getCompileJava()) {
                $this$registerJavacIfNeeded.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, true);
            }
            return KotlinCoreEnvironment.registerJavac$default($this$registerJavacIfNeeded, null, null, arguments2.getJavacArguments(), null, null, 27, null);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureAdvancedJvmOptions(@NotNull CompilerConfiguration $this$configureAdvancedJvmOptions, @NotNull K2JVMCompilerArguments arguments2) {
        int nThreadsRaw;
        int nThreads;
        JVMAssertionsMode jVMAssertionsMode;
        Collection<String> collection;
        int n;
        Collection destination$iv$iv;
        MessageCollector messageCollector2;
        CompilerMessageSeverity compilerMessageSeverity;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)$this$configureAdvancedJvmOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.PARAMETERS_METADATA, arguments2.getJavaParameters());
        boolean useOldBackend = arguments2.getUseOldBackend();
        boolean useIR2 = arguments2.getUseK2() || CommonConfigurationKeysKt.getLanguageVersionSettings($this$configureAdvancedJvmOptions).getLanguageVersion().getUsesK2() || !useOldBackend;
        MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.LOGGING, "Using " + (useIR2 ? "JVM IR" : "old JVM") + " backend", null, 4, null);
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.IR, useIR2);
        JvmAbiStability abiStability = JvmAbiStability.Companion.fromStringOrNull(arguments2.getAbiStability());
        if (arguments2.getAbiStability() != null) {
            if (abiStability == null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                JvmAbiStability[] jvmAbiStabilityArray = JvmAbiStability.values();
                stringBuilder2 = new StringBuilder().append("Unknown ABI stability mode: ").append(arguments2.getAbiStability()).append(", supported modes: ");
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                messageCollector2 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
                boolean $i$f$map = false;
                void var7_11 = $this$map$iv;
                destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                n = ((void)$this$mapTo$iv$iv).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var13_21 = item$iv$iv = $this$mapTo$iv$iv[j];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getDescription());
                }
                collection = (List)destination$iv$iv;
                MessageCollector.report$default(messageCollector2, compilerMessageSeverity, stringBuilder2.append(collection).toString(), null, 4, null);
            } else if (!useIR2 && abiStability == JvmAbiStability.UNSTABLE) {
                MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.ERROR, "-Xabi-stability=unstable is not supported in the old JVM backend", null, 4, null);
            } else {
                $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ABI_STABILITY, abiStability);
            }
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DO_NOT_CLEAR_BINDING_CONTEXT, arguments2.getDoNotClearBindingContext());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments2.getNoCallAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_RECEIVER_ASSERTIONS, arguments2.getNoReceiverAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments2.getNoParamAssertions());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments2.getNoOptimize());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS, arguments2.getEmitJvmTypeAnnotations());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_OPTIMIZED_CALLABLE_REFERENCES, arguments2.getNoOptimizedCallableReferences());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_KOTLIN_NOTHING_VALUE_EXCEPTION, arguments2.getNoKotlinNothingValueException());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_RESET_JAR_TIMESTAMPS, arguments2.getNoResetJarTimestamps());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_UNIFIED_NULL_CHECKS, arguments2.getNoUnifiedNullChecks());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_SOURCE_DEBUG_EXTENSION, arguments2.getNoSourceDebugExtension());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.SERIALIZE_IR, JvmSerializeIrMode.Companion.fromString(arguments2.getSerializeIr()));
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.VALIDATE_IR, arguments2.getValidateIr());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.VALIDATE_BYTECODE, arguments2.getValidateBytecode());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.LINK_VIA_SIGNATURES, arguments2.getLinkViaSignatures());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ENABLE_DEBUG_MODE, arguments2.getEnableDebugMode());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.NO_NEW_JAVA_ANNOTATION_TARGETS, arguments2.getNoNewJavaAnnotationTargets());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.OLD_INNER_CLASSES_LOGIC, arguments2.getOldInnerClassesLogic());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ENABLE_IR_INLINER, arguments2.getEnableIrInliner());
        JVMAssertionsMode assertionsMode = JVMAssertionsMode.Companion.fromStringOrNull(arguments2.getAssertionsMode());
        if (assertionsMode == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            JVMAssertionsMode[] $i$f$map = JVMAssertionsMode.values();
            stringBuilder2 = new StringBuilder().append("Unknown assertions mode: ").append(arguments2.getAssertionsMode()).append(", supported modes: ");
            compilerMessageSeverity = CompilerMessageSeverity.ERROR;
            messageCollector2 = JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions);
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (n = 0; n < n2; ++n) {
                void it;
                void item$iv$iv;
                void bl = item$iv$iv = $this$mapTo$iv$iv[n];
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getDescription());
            }
            collection = (List)destination$iv$iv2;
            MessageCollector.report$default(messageCollector2, compilerMessageSeverity, stringBuilder2.append(collection).toString(), null, 4, null);
        }
        if ((jVMAssertionsMode = assertionsMode) == null) {
            jVMAssertionsMode = JVMAssertionsMode.DEFAULT;
        }
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ASSERTIONS_MODE, jVMAssertionsMode);
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_TYPE_TABLE, arguments2.getUseTypeTable());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, arguments2.getUseOldClassFilesReading());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_FAST_JAR_FILE_SYSTEM, arguments2.getUseFastJarFileSystem());
        if (arguments2.getUseOldClassFilesReading()) {
            MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using the old java class files reading implementation", null, 4, null);
        }
        if (arguments2.getUseFastJarFileSystem()) {
            MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using fast Jar FS implementation", null, 4, null);
        }
        $this$configureAdvancedJvmOptions.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
        $this$configureAdvancedJvmOptions.put(CLIConfigurationKeys.RENDER_DIAGNOSTIC_INTERNAL_NAME, arguments2.getRenderInternalDiagnosticNames());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME, arguments2.getUseOldInlineClassesManglingScheme());
        $this$configureAdvancedJvmOptions.put(JVMConfigurationKeys.ENABLE_JVM_PREVIEW, arguments2.getEnableJvmPreview());
        if (arguments2.getEnableJvmPreview()) {
            MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.INFO, "Using preview Java language features", null, 4, null);
        }
        int n3 = nThreads = (nThreadsRaw = JvmArgumentsKt.parseBackendThreads(arguments2.getBackendThreads(), JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions))) == 0 ? Runtime.getRuntime().availableProcessors() : nThreadsRaw;
        if (nThreads > 1) {
            MessageCollector.report$default(JvmArgumentsKt.getMessageCollector($this$configureAdvancedJvmOptions), CompilerMessageSeverity.LOGGING, "Running backend in parallel with " + nThreads + " threads", null, 4, null);
        }
        $this$configureAdvancedJvmOptions.put(CommonConfigurationKeys.PARALLEL_BACKEND_THREADS, nThreads);
    }

    private static final int parseBackendThreads(String stringValue, MessageCollector messageCollector2) {
        Integer value2 = StringsKt.toIntOrNull((String)stringValue);
        if (value2 == null) {
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Cannot parse -Xbackend-threads value: \"" + stringValue + "\". Please use an integer number", null, 4, null);
            return 1;
        }
        if (value2 < 0) {
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "-Xbackend-threads value cannot be negative", null, 4, null);
            return 1;
        }
        return value2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureKlibPaths(@NotNull CompilerConfiguration $this$configureKlibPaths, @NotNull K2JVMCompilerArguments arguments2) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)$this$configureKlibPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        String string2 = arguments2.getKlibLibraries();
        if (string2 == null) {
            return;
        }
        String libraries = string2;
        Object object = libraries;
        String string3 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathSeparator");
        String string4 = string3;
        string4 = new Regex(string4);
        int n = 0;
        object = string4.split((CharSequence)object, n);
        CompilerConfigurationKey<List<String>> compilerConfigurationKey = JVMConfigurationKeys.KLIB_PATHS;
        CompilerConfiguration compilerConfiguration = $this$configureKlibPaths;
        boolean $i$f$filterNot = false;
        void var5_7 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)p0).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        compilerConfiguration.put(compilerConfigurationKey, list2);
    }

    private static final MessageCollector getMessageCollector(CompilerConfiguration $this$messageCollector) {
        MessageCollector messageCollector2 = $this$messageCollector.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector2, (String)"getNotNull(...)");
        return messageCollector2;
    }

    private static final int getJavaVersion() {
        Object object = System.getProperty("java.specification.version");
        return object != null && (object = StringsKt.substringAfter$default((String)object, (char)'.', null, (int)2, null)) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 6;
    }

    private static final <PathProvider> void configureStandardLibs$addRoot(CompilerConfiguration $this_configureStandardLibs, boolean isModularJava, PathProvider $paths, String moduleName, String libraryName2, Function1<? super PathProvider, ? extends File> getLibrary, String noLibraryArgument) {
        JvmArgumentsKt.addModularRootIfNotNull($this_configureStandardLibs, isModularJava, moduleName, UtilsKt.getLibraryFromHome($paths, getLibrary, libraryName2, JvmArgumentsKt.getMessageCollector($this_configureStandardLibs), noLibraryArgument));
    }
}

