/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.modules;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtVirtualFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "()V", "roots", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtVirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "clearRoots", "", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "getProtocol", "refresh", "asynchronous", "", "refreshAndFindFileByPath", "Companion", "cli-base"})
public final class CoreJrtFileSystem
extends DeprecatedVirtualFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, CoreJrtVirtualFile> roots;
    @NotNull
    private static final ConcurrentMap<String, FileSystem> globalJrtFsCache;

    public CoreJrtFileSystem() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> CoreJrtFileSystem.roots$lambda$0((Function1)new Function1<String, CoreJrtVirtualFile>(this){
            final /* synthetic */ CoreJrtFileSystem this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final CoreJrtVirtualFile invoke(String jdkHomePath) {
                FileSystem fileSystem = (FileSystem)CoreJrtFileSystem.access$getGlobalJrtFsCache$cp().get(jdkHomePath);
                if (fileSystem == null) {
                    return null;
                }
                FileSystem fileSystem2 = fileSystem;
                Intrinsics.checkNotNull((Object)jdkHomePath);
                Path path = fileSystem2.getPath("", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
                return new CoreJrtVirtualFile(this.this$0, jdkHomePath, path, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.roots = concurrentMap;
    }

    @NotNull
    public String getProtocol() {
        return "jrt";
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Pair<String, String> pair = Companion.splitPath(path);
        String jdkHomePath = (String)pair.component1();
        String pathInImage = (String)pair.component2();
        CoreJrtVirtualFile coreJrtVirtualFile = (CoreJrtVirtualFile)((Object)this.roots.get(jdkHomePath));
        if (coreJrtVirtualFile == null) {
            return null;
        }
        CoreJrtVirtualFile root = coreJrtVirtualFile;
        if (((CharSequence)pathInImage).length() == 0) {
            return root;
        }
        return root.findFileByRelativePath(pathInImage);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    public final void clearRoots() {
        this.roots.clear();
    }

    private static final CoreJrtVirtualFile roots$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CoreJrtVirtualFile)((Object)$tmp0.invoke(p0));
    }

    private static final FileSystem globalJrtFsCache$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileSystem)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ConcurrentMap access$getGlobalJrtFsCache$cp() {
        return globalJrtFsCache;
    }

    static {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> CoreJrtFileSystem.globalJrtFsCache$lambda$1(Companion.globalJrtFsCache.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        globalJrtFsCache = concurrentMap;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u0005R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$Companion;", "", "()V", "globalJrtFsCache", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Ljava/nio/file/FileSystem;", "Lorg/jetbrains/annotations/NotNull;", "isModularJdk", "", "jdkHome", "Ljava/io/File;", "loadJrtFsJar", "splitPath", "Lkotlin/Pair;", "path", "cli-base"})
    @SourceDebugExtension(value={"SMAP\nCoreJrtFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreJrtFileSystem.kt\norg/jetbrains/kotlin/cli/jvm/modules/CoreJrtFileSystem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final File loadJrtFsJar(File jdkHome2) {
            File file2;
            File p0 = file2 = new File(jdkHome2, "lib/jrt-fs.jar");
            boolean bl = false;
            return p0.exists() ? file2 : null;
        }

        public final boolean isModularJdk(@NotNull File jdkHome2) {
            Intrinsics.checkNotNullParameter((Object)jdkHome2, (String)"jdkHome");
            return this.loadJrtFsJar(jdkHome2) != null;
        }

        @NotNull
        public final Pair<String, String> splitPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            int separator = StringsKt.indexOf$default((CharSequence)path, (String)"!/", (int)0, (boolean)false, (int)6, null);
            if (separator < 0) {
                throw new IllegalArgumentException("Path in CoreJrtFileSystem must contain a separator: " + path);
            }
            String string2 = path.substring(0, separator);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String localPath = string2;
            String string3 = path.substring(separator + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String pathInJar = string3;
            return new Pair((Object)localPath, (Object)pathInJar);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ File access$loadJrtFsJar(Companion $this, File jdkHome2) {
            return $this.loadJrtFsJar(jdkHome2);
        }
    }
}

