/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/TraceBasedCollector;", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "callContext", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;)V", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "mainCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "mainCallReportTarget", "reportedErrors", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "addFallbackErrorIfNecessary", "", "badDescription", "message", "", "reportOn", "Lorg/jetbrains/kotlin/psi/KtElement;", "contractNotAllowed", "flushDiagnostics", "hasErrors", "", "unsupportedFeature", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
@SourceDebugExtension(value={"SMAP\nContractParsingDiagnosticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractParsingDiagnosticsCollector.kt\norg/jetbrains/kotlin/contracts/parsing/TraceBasedCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1853#2,2:72\n*S KotlinDebug\n*F\n+ 1 ContractParsingDiagnosticsCollector.kt\norg/jetbrains/kotlin/contracts/parsing/TraceBasedCollector\n*L\n66#1:72,2\n*E\n"})
public final class TraceBasedCollector
implements ContractParsingDiagnosticsCollector {
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final List<Diagnostic> reportedErrors;
    @NotNull
    private final KtExpression mainCallReportTarget;

    public TraceBasedCollector(@NotNull BindingTrace bindingTrace, @NotNull KtExpression mainCall) {
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter((Object)mainCall, (String)"mainCall");
        this.bindingTrace = bindingTrace;
        this.reportedErrors = new ArrayList();
        KtExpression ktExpression = mainCall instanceof KtCallExpression ? (KtCallExpression)mainCall : null;
        if (ktExpression == null || (ktExpression = ktExpression.getCalleeExpression()) == null) {
            ktExpression = mainCall;
        }
        this.mainCallReportTarget = ktExpression;
    }

    public TraceBasedCollector(@NotNull ContractCallContext callContext) {
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        this(callContext.getTrace(), callContext.getContractCallExpression());
    }

    @Override
    public void contractNotAllowed(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        ((Collection)this.reportedErrors).add(Errors.CONTRACT_NOT_ALLOWED.on((KtElement)((PsiElement)this.mainCallReportTarget), message2));
    }

    @Override
    public void badDescription(@NotNull String message2, @NotNull KtElement reportOn) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        ((Collection)this.reportedErrors).add(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)reportOn), message2));
    }

    @Override
    public void unsupportedFeature(@NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        ((Collection)this.reportedErrors).add(Errors.UNSUPPORTED_FEATURE.on((PsiElement)this.mainCallReportTarget, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.AllowContractsForCustomFunctions), (Object)languageVersionSettings2)));
    }

    @Override
    public void addFallbackErrorIfNecessary() {
        if (this.reportedErrors.isEmpty()) {
            ((Collection)this.reportedErrors).add(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)this.mainCallReportTarget), "Error in contract description"));
        }
    }

    @Override
    public void flushDiagnostics() {
        Iterable $this$forEach$iv = this.reportedErrors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Diagnostic it = (Diagnostic)element$iv;
            boolean bl = false;
            this.bindingTrace.report(it);
        }
    }

    @Override
    public boolean hasErrors() {
        return !((Collection)this.reportedErrors).isEmpty();
    }
}

