/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J,\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J>\u0010\u001b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001c*\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001e2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"H\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkParameterBounds", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkSupertypes", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "findVisibilityExposure", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "visitedTypes", "", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExposedVisibilityDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,265:1\n28#2:266\n28#2:271\n28#2:272\n28#2:273\n49#2:274\n28#2:276\n28#2:277\n28#2:278\n22#3,4:267\n1#4:275\n45#5:279\n45#5:280\n*S KotlinDebug\n*F\n+ 1 FirExposedVisibilityDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker\n*L\n48#1:266\n73#1:271\n93#1:272\n112#1:273\n113#1:274\n156#1:276\n181#1:277\n206#1:278\n54#1:267,4\n236#1:279\n237#1:280\n*E\n"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirAnonymousFunction) {
            return;
        }
        if (firDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration, reporter2, context2);
        } else if (firDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration, reporter2, context2);
        } else if (firDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)declaration, reporter2, context2);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration, reporter2, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        this.checkSupertypes(declaration, reporter2, context2);
        this.checkParameterBounds(declaration, reporter2, context2);
    }

    private final void checkSupertypes(FirRegularClass declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        Object object = $this$effectiveVisibility$iv.getStatus();
        Object object2 = object instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object : null;
        if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
            object2 = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = object2), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes2 = declaration.getSuperTypeRefs();
        boolean isInterface = declaration.getClassKind() == ClassKind.INTERFACE;
        object = supertypes2.iterator();
        while (object.hasNext()) {
            Pair pair;
            FirRegularClassSymbol classSymbol2;
            boolean superIsInterface;
            ConeClassLikeType supertype2;
            FirTypeRef supertypeRef;
            FirTypeRef $this$coneTypeSafe$iv = supertypeRef = (FirTypeRef)object.next();
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null || TypeUtilsKt.toRegularClassSymbol(supertype2, context2.getSession()) == null || (superIsInterface = classSymbol2.getClassKind() == ClassKind.INTERFACE) != isInterface || FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, supertype2, context2, (EffectiveVisibility)classVisibility, null, 4, null) == null) continue;
            FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
            KtSourceElement ktSourceElement = supertypeRef.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = declaration.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)ktSourceElement, isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), classVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
        }
    }

    private final void checkParameterBounds(FirRegularClass declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        Object classVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(classVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        for (FirTypeParameterRef parameter2 : declaration.getTypeParameters()) {
            for (FirResolvedTypeRef bound2 : parameter2.getSymbol().getResolvedBounds()) {
                Pair pair;
                if (FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(bound2), context2, (EffectiveVisibility)classVisibility, null, 4, null) == null) continue;
                FirBasedSymbol restricting = (FirBasedSymbol)pair.component1();
                EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)bound2.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), classVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        Object typeAliasVisibility;
        ConeClassLikeType expandedType2 = FirDeclarationUtilKt.getExpandedConeType(declaration);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(typeAliasVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        ConeClassLikeType coneClassLikeType = expandedType2;
        if (coneClassLikeType == null || (coneClassLikeType = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, coneClassLikeType, context2, (EffectiveVisibility)typeAliasVisibility, null, 4, null)) == null) {
            return;
        }
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType;
        FirBasedSymbol restricting = (FirBasedSymbol)coneClassLikeType2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)coneClassLikeType2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), typeAliasVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    private final void checkFunction(FirFunction declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        boolean isNonLocal;
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Object functionVisibility = null;
        Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration");
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = functionVisibility = (EffectiveVisibility)EffectiveVisibility.Local.INSTANCE;
        }
        if (declaration instanceof FirConstructor) {
            FirMemberDeclaration $this$isFromSealedClass$iv = declaration;
            boolean $i$f$isFromSealedClass = false;
            if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                functionVisibility = EffectiveVisibility.PrivateInClass.INSTANCE;
            }
        }
        boolean bl = isNonLocal = !Intrinsics.areEqual((Object)functionVisibility, (Object)EffectiveVisibility.Local.INSTANCE);
        if (!(declaration instanceof FirPropertyAccessor)) {
            EffectiveVisibility restrictingVisibility;
            if (isNonLocal && !(declaration instanceof FirConstructor)) {
                Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility, null, 4, null);
                if (pair != null) {
                    Pair pair2 = pair;
                    boolean bl2 = false;
                    FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
                    restrictingVisibility = (EffectiveVisibility)pair2.component2();
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), functionVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
                }
            }
            for (FirValueParameter valueParameter2 : declaration.getValueParameters()) {
                Object propertyVisibility;
                FirProperty property;
                boolean exposureFound = false;
                if (isNonLocal) {
                    if (FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(valueParameter2.getReturnTypeRef()), context2, (EffectiveVisibility)functionVisibility, null, 4, null) != null) {
                        boolean bl3 = false;
                        FirBasedSymbol restricting = (FirBasedSymbol)restrictingVisibility.component1();
                        EffectiveVisibility restrictingVisibility2 = (EffectiveVisibility)restrictingVisibility.component2();
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), functionVisibility, (Object)restricting, (Object)restrictingVisibility2, (DiagnosticContext)context2, null, 64, null);
                        exposureFound = true;
                    }
                }
                if (exposureFound || ClassMembersKt.getCorrespondingProperty(valueParameter2) == null || property.isLocal()) continue;
                FirMemberDeclaration $this$effectiveVisibility$iv2 = property;
                boolean $i$f$getEffectiveVisibility2 = false;
                FirDeclarationStatus firDeclarationStatus2 = $this$effectiveVisibility$iv2.getStatus();
                Object object2 = firDeclarationStatus2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus2 : null;
                if (object2 == null || (object2 = object2.getEffectiveVisibility()) == null) {
                    object2 = EffectiveVisibility.Local.INSTANCE;
                }
                if (Intrinsics.areEqual((Object)(propertyVisibility = object2), (Object)EffectiveVisibility.Local.INSTANCE)) continue;
                Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(property.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, null, 4, null);
                if (pair == null) continue;
                firDeclarationStatus2 = pair;
                boolean bl4 = false;
                FirBasedSymbol restricting = (FirBasedSymbol)firDeclarationStatus2.component1();
                EffectiveVisibility restrictingVisibility3 = (EffectiveVisibility)firDeclarationStatus2.component2();
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility3, (DiagnosticContext)context2, null, 64, null);
            }
        }
        if (isNonLocal) {
            FirReceiverParameter firReceiverParameter = declaration.getReceiverParameter();
            this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration : null, reporter2, context2);
        }
    }

    private final void checkProperty(FirProperty declaration, DiagnosticReporter reporter2, CheckerContext context2) {
        Object propertyVisibility;
        if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor(declaration), (Object)true)) {
            return;
        }
        if (declaration.isLocal()) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(propertyVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()), context2, (EffectiveVisibility)propertyVisibility, null, 4, null);
        if (pair != null) {
            firDeclarationStatus = pair;
            boolean bl = false;
            FirBasedSymbol restricting = (FirBasedSymbol)firDeclarationStatus.component1();
            EffectiveVisibility restrictingVisibility = (EffectiveVisibility)firDeclarationStatus.component2();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE(), propertyVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
        }
        FirReceiverParameter firReceiverParameter = declaration.getReceiverParameter();
        this.checkMemberReceiver(firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null, declaration, reporter2, context2);
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableDeclaration memberDeclaration, DiagnosticReporter reporter2, CheckerContext context2) {
        Object memberVisibility;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(memberVisibility = object), (Object)EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        Pair pair = FirExposedVisibilityDeclarationChecker.findVisibilityExposure$default(this, receiverParameterType, context2, (EffectiveVisibility)memberVisibility, null, 4, null);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        FirBasedSymbol restricting = (FirBasedSymbol)pair2.component1();
        EffectiveVisibility restrictingVisibility = (EffectiveVisibility)pair2.component2();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), memberVisibility, (Object)restricting, (Object)restrictingVisibility, (DiagnosticContext)context2, null, 64, null);
    }

    private final Pair<FirBasedSymbol<?>, EffectiveVisibility> findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, EffectiveVisibility base2, Set<ConeKotlinType> visitedTypes) {
        EffectiveVisibility effectiveVisibility;
        EffectiveVisibility effectiveVisibility2;
        boolean $i$f$getEffectiveVisibility;
        FirClassLikeSymbol<?> $this$effectiveVisibility$iv;
        Object object;
        ConeClassLikeType coneClassLikeType;
        if (!visitedTypes.add($this$findVisibilityExposure)) {
            return null;
        }
        ConeKotlinType coneKotlinType = $this$findVisibilityExposure;
        if (coneKotlinType instanceof ConeClassLikeType) {
            coneClassLikeType = (ConeClassLikeType)$this$findVisibilityExposure;
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = ((ConeFlexibleType)$this$findVisibilityExposure).getLowerBound();
            coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
            if (coneClassLikeType == null) {
                return null;
            }
        } else {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol2 = firClassLikeSymbol;
        object = classSymbol2;
        if (object instanceof FirRegularClassSymbol) {
            $this$effectiveVisibility$iv = classSymbol2;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else if (object instanceof FirTypeAliasSymbol) {
            $this$effectiveVisibility$iv = classSymbol2;
            $i$f$getEffectiveVisibility = false;
            effectiveVisibility2 = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
        } else {
            effectiveVisibility2 = effectiveVisibility = null;
        }
        if (effectiveVisibility != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[effectiveVisibility.relation(base2, TypeComponentsKt.getTypeContext(context2.getSession())).ordinal()]) {
                case 1: 
                case 2: {
                    return TuplesKt.to(classSymbol2, (Object)effectiveVisibility);
                }
            }
        }
        object = type2.getTypeArguments();
        int n = ((ConeTypeProjection[])object).length;
        for (int j = 0; j < n; ++j) {
            Pair<FirBasedSymbol<?>, EffectiveVisibility> pair;
            block19: {
                Pair<FirBasedSymbol<?>, EffectiveVisibility> pair2;
                List<FirResolvedTypeRef> list2;
                FirTypeParameterSymbol firTypeParameterSymbol;
                List<FirTypeParameterSymbol> list3;
                Object it;
                Object object2;
                int index2 = j;
                ConeTypeProjection it2 = object[j];
                ConeTypeProjection coneTypeProjection = it2;
                if (coneTypeProjection instanceof ConeClassLikeType) {
                    object2 = this.findVisibilityExposure((ConeKotlinType)it2, context2, base2, visitedTypes);
                    if (object2 == null) continue;
                    it = object2;
                    boolean bl = false;
                    return it;
                }
                if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                    object2 = this.findVisibilityExposure(((ConeKotlinTypeProjection)it2).getType(), context2, base2, visitedTypes);
                    if (object2 == null) continue;
                    it = object2;
                    boolean bl = false;
                    return it;
                }
                if (!(coneTypeProjection instanceof ConeStarProjection) || (object2 = TypeUtilsKt.toRegularClassSymbol(type2, context2.getSession())) == null || (list3 = ((FirClassLikeSymbol)object2).getTypeParameterSymbols()) == null || (firTypeParameterSymbol = (FirTypeParameterSymbol)CollectionsKt.getOrNull(list3, (int)index2)) == null || (list2 = firTypeParameterSymbol.getResolvedBounds()) == null) continue;
                for (Pair<FirBasedSymbol<?>, EffectiveVisibility> it3 : (Iterable)list2) {
                    boolean bl = false;
                    if ((it3 = INSTANCE.findVisibilityExposure(it3.getType(), context2, base2, visitedTypes)) == null) continue;
                    pair2 = it3;
                    break block19;
                }
                pair2 = pair = null;
            }
            if (pair == null) continue;
            Pair<FirBasedSymbol<?>, EffectiveVisibility> it = pair;
            boolean bl = false;
            return it;
        }
        return null;
    }

    static /* synthetic */ Pair findVisibilityExposure$default(FirExposedVisibilityDeclarationChecker firExposedVisibilityDeclarationChecker, ConeKotlinType coneKotlinType, CheckerContext checkerContext, EffectiveVisibility effectiveVisibility, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        return firExposedVisibilityDeclarationChecker.findVisibilityExposure(coneKotlinType, checkerContext, effectiveVisibility, set);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            try {
                nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

