/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirMissingDependencyStorageKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ*\u0010\u0003\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker;", "", "()V", "checkSuperTypes", "", "declaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "classifierType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "ForDeclarations", "ForQualifiedAccessExpressions", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencySupertypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencySupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,105:1\n26#2:106\n26#2:107\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencySupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker\n*L\n96#1:106\n97#1:107\n*E\n"})
public final class FirMissingDependencySupertypeChecker {
    @NotNull
    public static final FirMissingDependencySupertypeChecker INSTANCE = new FirMissingDependencySupertypeChecker();

    private FirMissingDependencySupertypeChecker() {
    }

    public final boolean checkSuperTypes(@Nullable ConeKotlinType classifierType, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConeKotlinType coneKotlinType = classifierType;
        return this.checkSuperTypes((FirBasedSymbol)(coneKotlinType != null ? org.jetbrains.kotlin.fir.types.TypeUtilsKt.toSymbol(coneKotlinType, context2.getSession()) : null), source, reporter2, context2);
    }

    public final boolean checkSuperTypes(@Nullable FirBasedSymbol<?> declaration, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration instanceof FirClassSymbol)) {
            return false;
        }
        Set<ConeKotlinType> missingSuperTypes = FirMissingDependencyStorageKt.getMissingDependencyStorage(context2.getSession()).getMissingSuperTypes((FirClassSymbol)declaration);
        for (ConeKotlinType superType2 : missingSuperTypes) {
            boolean $i$f$emptyArray = false;
            $i$f$emptyArray = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS(), (Object)org.jetbrains.kotlin.fir.types.TypeUtilsKt.withNullability$default(org.jetbrains.kotlin.fir.types.TypeUtilsKt.withArguments(superType2, new ConeTypeProjection[0]), ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null), (Object)TypeConstructionUtilsKt.constructType$default((FirClassLikeSymbol)declaration, new ConeTypeProjection[0], false, null, 4, null), (DiagnosticContext)context2, null, 32, null);
        }
        return !((Collection)missingSuperTypes).isEmpty();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker$ForDeclarations;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    public static final class ForDeclarations
    extends FirDeclarationChecker<FirDeclaration> {
        @NotNull
        public static final ForDeclarations INSTANCE = new ForDeclarations();

        private ForDeclarations() {
            super(MppCheckerKind.Common);
        }

        @Override
        public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            if (declaration instanceof FirClass) {
                INSTANCE.checkSuperTypes((FirBasedSymbol)((FirClass)declaration).getSymbol(), declaration.getSource(), reporter2, context2);
            }
            if (declaration instanceof FirTypeParameterRefsOwner) {
                for (FirTypeParameterRef typeParameter2 : ((FirTypeParameterRefsOwner)((Object)declaration)).getTypeParameters()) {
                    for (ConeClassLikeType upperBound : TypeUtilsKt.collectUpperBounds(FirNestedClassifierScopeKt.toConeType(typeParameter2))) {
                        INSTANCE.checkSuperTypes(upperBound, typeParameter2.getSource(), reporter2, context2);
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencySupertypeChecker$ForQualifiedAccessExpressions;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    public static final class ForQualifiedAccessExpressions
    extends FirExpressionChecker<FirQualifiedAccessExpression> {
        @NotNull
        public static final ForQualifiedAccessExpressions INSTANCE = new ForQualifiedAccessExpressions();

        private ForQualifiedAccessExpressions() {
            super(MppCheckerKind.Common);
        }

        @Override
        public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
            boolean unresolvedLazySupertypesByDefault;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            KtSourceElement source = expression2.getSource();
            FirCallableSymbol symbol2 = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
            if (symbol2 == null) {
                ConeSimpleKotlinType coneSimpleKotlinType;
                ConeSimpleKotlinType coneSimpleKotlinType2;
                ConeKotlinType coneKotlinType;
                FirExpression firExpression2 = expression2.getExplicitReceiver();
                ConeSimpleKotlinType receiverType2 = firExpression2 != null && (coneKotlinType = FirTypeUtilsKt.getResolvedType(firExpression2)) != null && (coneSimpleKotlinType2 = ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType)) != null && (coneSimpleKotlinType = ConeTypeUtilsKt.originalIfDefinitelyNotNullable(coneSimpleKotlinType2)) != null ? TypeExpansionUtilsKt.fullyExpandedType(coneSimpleKotlinType, context2.getSession()) : null;
                INSTANCE.checkSuperTypes(receiverType2, source, reporter2, context2);
                return;
            }
            boolean missingSupertype = INSTANCE.checkSuperTypes(symbol2.getDispatchReceiverType(), source, reporter2, context2);
            boolean eagerChecksAllowed = context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getExtendedCompilerChecks());
            boolean bl = unresolvedLazySupertypesByDefault = symbol2 instanceof FirConstructorSymbol || symbol2 instanceof FirAnonymousFunctionSymbol;
            if (eagerChecksAllowed || !unresolvedLazySupertypesByDefault && !missingSupertype) {
                ConeClassLikeLookupTag coneClassLikeLookupTag = FirVisibilityCheckerKt.getOwnerLookupTag(symbol2);
                INSTANCE.checkSuperTypes((FirBasedSymbol)(coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession()) : null), source, reporter2, context2);
                FirResolvedTypeRef firResolvedTypeRef = symbol2.getResolvedReceiverTypeRef();
                INSTANCE.checkSuperTypes(firResolvedTypeRef != null ? FirTypeUtilsKt.getConeTypeOrNull(firResolvedTypeRef) : null, source, reporter2, context2);
            }
        }
    }
}

