/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u000eH\u0002J\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkArgumentAndReport", "typeArgument", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isExplicit", "", "isArray", "cannotBeReified", "isReifiedTypeParameterOrFromKotlinArray", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReifiedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n13291#2,2:101\n*S KotlinDebug\n*F\n+ 1 FirReifiedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReifiedChecker\n*L\n75#1:101,2\n*E\n"})
public final class FirReifiedChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirReifiedChecker INSTANCE = new FirReifiedChecker();

    private FirReifiedChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirReference calleeReference = expression2.getCalleeReference();
        List<FirTypeProjection> typeArguments = expression2.getTypeArguments();
        Object object = FirReferenceUtilsKt.toResolvedCallableSymbol$default(calleeReference, false, 1, null);
        if (object == null || (object = ((FirCallableSymbol)object).getTypeParameterSymbols()) == null) {
            return;
        }
        Object typeParameters2 = object;
        int count = Math.min(typeArguments.size(), typeParameters2.size());
        for (int index2 = 0; index2 < count; ++index2) {
            ConeKotlinType typeArgument;
            FirTypeParameterSymbol typeParameter2;
            FirTypeProjection typeArgumentProjection = typeArguments.get(index2);
            KtSourceElement ktSourceElement = typeArgumentProjection.getSource();
            if (ktSourceElement == null && (ktSourceElement = calleeReference.getSource()) == null) continue;
            KtSourceElement source = ktSourceElement;
            if (ConeTypeProjectionKt.getType(FirTypeUtilsKt.toConeTypeProjection(typeArgumentProjection)) == null || !this.isReifiedTypeParameterOrFromKotlinArray(typeParameter2 = (FirTypeParameterSymbol)typeParameters2.get(index2))) continue;
            KtSourceElement ktSourceElement2 = typeArgumentProjection.getSource();
            this.checkArgumentAndReport(typeArgument, source, Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE), false, context2, reporter2);
        }
    }

    private final boolean isReifiedTypeParameterOrFromKotlinArray(FirTypeParameterSymbol $this$isReifiedTypeParameterOrFromKotlinArray) {
        FirBasedSymbol<?> containingDeclaration2 = $this$isReifiedTypeParameterOrFromKotlinArray.getContainingDeclarationSymbol();
        return $this$isReifiedTypeParameterOrFromKotlinArray.isReified() || containingDeclaration2 instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)containingDeclaration2).getClassId(), (Object)StandardClassIds.INSTANCE.getArray());
    }

    private final boolean cannotBeReified(ConeKotlinType $this$cannotBeReified) {
        ConeKotlinType coneKotlinType = $this$cannotBeReified;
        return coneKotlinType instanceof ConeCapturedType ? true : (coneKotlinType instanceof ConeDynamicType ? true : ConeBuiltinTypeUtilsKt.isNothing($this$cannotBeReified) || ConeBuiltinTypeUtilsKt.isNullableNothing($this$cannotBeReified));
    }

    private final void checkArgumentAndReport(ConeKotlinType typeArgument, KtSourceElement source, boolean isExplicit, boolean isArray, CheckerContext context2, DiagnosticReporter reporter2) {
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(typeArgument, context2.getSession());
        if (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(fullyExpandedType2), (Object)StandardClassIds.INSTANCE.getArray())) {
            ConeTypeProjection[] $this$forEach$iv = fullyExpandedType2.getTypeArguments();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                ConeTypeProjection element$iv;
                ConeTypeProjection it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                if (!(it instanceof ConeKotlinType)) continue;
                INSTANCE.checkArgumentAndReport((ConeKotlinType)it, source, isExplicit, true, context2, reporter2);
            }
            return;
        }
        if (typeArgument instanceof ConeTypeParameterType) {
            FirTypeParameterSymbol symbol2 = ((ConeTypeParameterType)typeArgument).getLookupTag().getTypeParameterSymbol();
            if (!symbol2.isReified()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, isArray ? (KtDiagnosticFactory1)KtDiagnosticReportHelpersKt.chooseFactory((KtDiagnosticFactoryForDeprecation)FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED_ARRAY(), context2) : FirErrors.INSTANCE.getTYPE_PARAMETER_AS_REIFIED(), (Object)symbol2, (DiagnosticContext)context2, null, 16, null);
            }
        } else if (typeArgument instanceof ConeDefinitelyNotNullType && isExplicit) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEFINITELY_NON_NULLABLE_AS_REIFIED(), (DiagnosticContext)context2, null, 8, null);
        } else if (this.cannotBeReified(typeArgument)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREIFIED_TYPE_FORBIDDEN_SUBSTITUTION(), (Object)typeArgument, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

