/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.declaration.FirWebCommonExternalChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmExternalChecker;", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker;", "()V", "additionalCheck", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "hasExternalLikeAnnotations", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isDefinedExternallyCallableId", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "isNativeOrEffectivelyExternal", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "reportExternalEnum", "checkers.wasm"})
@SourceDebugExtension(value={"SMAP\nFirWasmExternalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWasmExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmExternalChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,56:1\n43#2:57\n44#2:58\n46#2:59\n48#2:60\n*S KotlinDebug\n*F\n+ 1 FirWasmExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/declaration/FirWasmExternalChecker\n*L\n31#1:57\n34#1:58\n37#1:59\n43#1:60\n*E\n"})
public final class FirWasmExternalChecker
extends FirWebCommonExternalChecker {
    @NotNull
    public static final FirWasmExternalChecker INSTANCE = new FirWasmExternalChecker();

    private FirWasmExternalChecker() {
    }

    @Override
    public boolean isNativeOrEffectivelyExternal(@NotNull FirBasedSymbol<?> symbol2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirWebCommonHelpersKt.isEffectivelyExternal(symbol2, session2);
    }

    @Override
    public void reportExternalEnum(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)"enum class", (DiagnosticContext)context2, null, 16, null);
    }

    @Override
    public void additionalCheck(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (declaration instanceof FirFunction) {
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirWebCommonErrors.INSTANCE.getINLINE_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
            }
            FirMemberDeclaration $this$isTailRec$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isTailRec = false;
            if ($this$isTailRec$iv.getStatus().isTailRec()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)"tailrec function", (DiagnosticContext)context2, null, 16, null);
            }
            FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isSuspend = false;
            if ($this$isSuspend$iv.getStatus().isSuspend()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)"suspend function", (DiagnosticContext)context2, null, 16, null);
            }
        }
        if (declaration instanceof FirProperty) {
            FirMemberDeclaration $this$isLateInit$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirWebCommonErrors.INSTANCE.getWRONG_EXTERNAL_DECLARATION(), (Object)"lateinit property", (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    @Override
    public boolean isDefinedExternallyCallableId(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        return Intrinsics.areEqual((Object)callableId, (Object)WebCommonStandardClassIds.Callables.JsDefinedExternally);
    }

    @Override
    public boolean hasExternalLikeAnnotations(@NotNull FirDeclaration declaration, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return false;
    }
}

