/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtPsiSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingFromLineStartOffsets;
import org.jetbrains.kotlin.backend.common.CommonBackendErrors;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.backend.CodeFragmentConversionData;
import org.jetbrains.kotlin.fir.backend.CodeFragmentUtilsKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltIns;
import org.jetbrains.kotlin.fir.backend.Fir2IrClassifierStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrCommonMemberStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponentsStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrFakeOverrideStrategy;
import org.jetbrains.kotlin.fir.backend.Fir2IrIrGeneratedDeclarationsRegistrar;
import org.jetbrains.kotlin.fir.backend.Fir2IrResult;
import org.jetbrains.kotlin.fir.backend.Fir2IrSpecialSymbolProvider;
import org.jetbrains.kotlin.fir.backend.Fir2IrSymbolsMappingForLazyClasses;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisitor;
import org.jetbrains.kotlin.fir.backend.FirProviderWithGeneratedFiles;
import org.jetbrains.kotlin.fir.backend.InjectedValue;
import org.jetbrains.kotlin.fir.backend.IrBuiltInsOverFir;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DataClassMembersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.DelegatedMemberGenerator;
import org.jetbrains.kotlin.fir.backend.generators.FakeOverrideGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGeneratorKt;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrClassifiersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyDeclarationsGenerator;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.descriptors.FirModuleDescriptor;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.java.FirJavaElementFinder;
import org.jetbrains.kotlin.fir.java.FirJavaElementFinderKt;
import org.jetbrains.kotlin.fir.lazy.Fir2IrLazyClass;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.signaturer.FirBasedSignatureComposer;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.ir.AbstractIrFileEntry;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.overrides.IrFakeOverrideBuilder;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorPublicSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionPublicSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u0000 \u00b2\u00012\u00020\u0001:\u0002\u00b2\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001J\u0014\u0010\u0083\u0001\u001a\u00030\u0080\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\u0017\u0010\u0086\u0001\u001a\u00030\u0080\u00012\r\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020`0DJ\u001a\u0010\u0088\u0001\u001a\t\u0012\u0005\u0012\u00030\u0089\u00010D2\b\u0010\u008a\u0001\u001a\u00030\u0082\u0001H\u0002J\u001c\u0010\u008b\u0001\u001a\u00030\u0080\u00012\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\b\u0010\u008a\u0001\u001a\u00030\u0082\u0001J\u0014\u0010\u008e\u0001\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u008f\u0001H\u0002J\u0014\u0010\u0090\u0001\u001a\u00030\u0080\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J$\u0010\u0091\u0001\u001a\u00030\u0082\u00012\b\u0010\u0081\u0001\u001a\u00030\u008f\u00012\b\u0010\u008a\u0001\u001a\u00030\u0082\u0001H\u0000\u00a2\u0006\u0003\b\u0092\u0001J\u001e\u0010\u0093\u0001\u001a\u00030\u0082\u00012\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\b\u0010\u008a\u0001\u001a\u00030\u0082\u0001H\u0002J\u0014\u0010\u0096\u0001\u001a\u00030\u0080\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0002J\u001c\u0010\u0097\u0001\u001a\u00030\u0082\u00012\b\u0010\u0081\u0001\u001a\u00030\u008f\u00012\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001J\u001c\u0010\u009a\u0001\u001a\u00030\u0082\u00012\b\u0010\u0081\u0001\u001a\u00030\u008f\u00012\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001JD\u0010\u009b\u0001\u001a\u00030\u0080\u00012\b\u0010\u009c\u0001\u001a\u00030\u0089\u00012\n\u0010\u009d\u0001\u001a\u0005\u0018\u00010\u008f\u00012\b\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0018\u0010\u009e\u0001\u001a\u0013\u0012\u0005\u0012\u00030\u00a0\u0001\u0012\u0005\u0012\u00030\u00a1\u0001\u0018\u00010\u009f\u0001H\u0002J\u0014\u0010\u00a2\u0001\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u008f\u0001H\u0002J\u001e\u0010\u00a3\u0001\u001a\u00030\u0082\u00012\b\u0010\u0081\u0001\u001a\u00030\u008f\u00012\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0002J\u001e\u0010\u00a4\u0001\u001a\u00030\u0080\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0002J\u001e\u0010\u00a7\u0001\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u008f\u00012\b\u0010\u008a\u0001\u001a\u00030\u0082\u0001H\u0002J.\u0010\u00a8\u0001\u001a\u00030\u0080\u00012\u000e\u0010\u00a9\u0001\u001a\t\u0012\u0005\u0012\u00030\u0085\u00010D2\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u00012\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u0001H\u0002J\"\u0010\u00ae\u0001\u001a\n\u0012\u0005\u0012\u00030\u0089\u00010\u00af\u00012\u000f\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u00030\u0089\u00010\u00af\u0001H\u0002J\u001b\u0010\u00b0\u0001\u001a\u0005\u0018\u00010\u00a0\u0001*\u00030\u00a1\u00012\b\u0010\u00b1\u0001\u001a\u00030\u008f\u0001H\u0002R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020%X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0012\u0010+\u001a\u00020,X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0012\u0010/\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0012\u00103\u001a\u000204X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0012\u00107\u001a\u000208X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0012\u0010;\u001a\u00020<X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0012\u0010?\u001a\u00020@X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020E0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010F\u001a\u00020GX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0012\u0010J\u001a\u00020KX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0018\u0010N\u001a\b\u0012\u0004\u0012\u00020O0DX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bP\u0010QR\u0012\u0010R\u001a\u00020SX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR\u0012\u0010V\u001a\u00020WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bX\u0010YR\u0012\u0010Z\u001a\u00020[X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010^\u001a\b\u0012\u0004\u0012\u00020`0_X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010a\u001a\u00020bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bc\u0010dR\u0012\u0010e\u001a\u00020fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bg\u0010hR\u0012\u0010i\u001a\u00020jX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bk\u0010lR\u0012\u0010m\u001a\u00020nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bo\u0010pR\u0012\u0010q\u001a\u00020rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bs\u0010tR\u0012\u0010u\u001a\u00020vX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bw\u0010xR\u0012\u0010y\u001a\u00020zX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b{\u0010|R\u000e\u0010}\u001a\u00020~X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b3\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "moduleDescriptor", "Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;", "components", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "(Lorg/jetbrains/kotlin/fir/descriptors/FirModuleDescriptor;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "getAnnotationsFromPluginRegistrar", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "builtIns", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltIns;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "callablesGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "getCallablesGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "classifierStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "classifiersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "getClassifiersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "configuration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "delegatedMemberGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "getDelegatedMemberGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/DelegatedMemberGenerator;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/ir/overrides/IrFakeOverrideBuilder;", "fakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "getFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGenerator;", "firProvider", "Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "getFirProvider", "()Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "generatorExtensions", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "irBuiltIns", "Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irProviders", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lazyDeclarationsGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "getLazyDeclarationsGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "manglers", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents$Manglers;", "getManglers", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents$Manglers;", "postponedDeclarationsForFakeOverridesBinding", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "signatureComposer", "Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "getSignatureComposer", "()Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "symbolsMappingForLazyClasses", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "getSymbolsMappingForLazyClasses", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "wereSourcesFakeOverridesBound", "", "bindFakeOverridesInClass", "", "klass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "bindFakeOverridesInFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "bindFakeOverridesOrPostpone", "declarations", "delegatedMembers", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "irClass", "processAnonymousObjectHeaders", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "processClassAndNestedClassHeaders", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "processClassHeaders", "processClassMembers", "processClassMembers$fir2ir", "processCodeFragmentMembers", "codeFragment", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "processFileAndClassMembers", "processLocalClassAndNestedClasses", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "processLocalClassAndNestedClassesOnTheFly", "processMemberDeclaration", "declaration", "containingClass", "delegateFieldToPropertyMap", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "processNestedClassHeaders", "registerClassAndNestedClasses", "registerFileAndClasses", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "registerNestedClasses", "runSourcesConversion", "allFirFiles", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrModuleFragmentImpl;", "fir2irVisitor", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisitor;", "syntheticPropertiesLast", "", "findCorrespondingDelegateProperty", "owner", "Companion", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 Fir2IrConversionScope.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 7 Fir2IrDeclarationStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage\n+ 8 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,753:1\n160#2,4:754\n70#3,7:758\n70#3,7:765\n1#4:772\n1#4:789\n1853#5,2:773\n764#5:776\n855#5,2:777\n1601#5,9:779\n1853#5:788\n1854#5:790\n1610#5:791\n1043#5:792\n1853#5,2:793\n1853#5,2:795\n1853#5,2:797\n1853#5,2:799\n798#5,11:807\n54#6:775\n54#6:801\n1413#7,4:802\n39#8:806\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter\n*L\n109#1:754,4\n141#1:758,7\n149#1:765,7\n404#1:789\n193#1:773,2\n402#1:776\n402#1:777,2\n404#1:779,9\n404#1:788\n404#1:790\n404#1:791\n413#1:792\n437#1:793,2\n443#1:795,2\n468#1:797,2\n474#1:799,2\n613#1:807,11\n253#1:775\n510#1:801\n521#1:802,4\n567#1:806\n*E\n"})
public final class Fir2IrConverter
implements Fir2IrComponents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirModuleDescriptor moduleDescriptor;
    @NotNull
    private final Fir2IrComponents components;
    @NotNull
    private final Fir2IrConversionScope conversionScope;
    @NotNull
    private final List<FirDeclarationGenerationExtension> generatorExtensions;
    private boolean wereSourcesFakeOverridesBound;
    @NotNull
    private final List<IrDeclaration> postponedDeclarationsForFakeOverridesBinding;

    public Fir2IrConverter(@NotNull FirModuleDescriptor moduleDescriptor, @NotNull Fir2IrComponents components2, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        this.moduleDescriptor = moduleDescriptor;
        this.components = components2;
        this.conversionScope = conversionScope;
        this.generatorExtensions = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.getSession()));
        this.postponedDeclarationsForFakeOverridesBinding = new ArrayList();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.components.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public Fir2IrIrGeneratedDeclarationsRegistrar getAnnotationsFromPluginRegistrar() {
        return this.components.getAnnotationsFromPluginRegistrar();
    }

    @Override
    @NotNull
    public Fir2IrBuiltIns getBuiltIns() {
        return this.components.getBuiltIns();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.components.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrCallableDeclarationsGenerator getCallablesGenerator() {
        return this.components.getCallablesGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.components.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrClassifiersGenerator getClassifiersGenerator() {
        return this.components.getClassifiersGenerator();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.components.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.components.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.components.getDeclarationStorage();
    }

    @Override
    @NotNull
    public DelegatedMemberGenerator getDelegatedMemberGenerator() {
        return this.components.getDelegatedMemberGenerator();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.components.getExtensions();
    }

    @Override
    @NotNull
    public IrFakeOverrideBuilder getFakeOverrideBuilder() {
        return this.components.getFakeOverrideBuilder();
    }

    @Override
    @NotNull
    public FakeOverrideGenerator getFakeOverrideGenerator() {
        return this.components.getFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public FirProviderWithGeneratedFiles getFirProvider() {
        return this.components.getFirProvider();
    }

    @Override
    @NotNull
    public IrBuiltInsOverFir getIrBuiltIns() {
        return this.components.getIrBuiltIns();
    }

    @Override
    @NotNull
    public IrFactory getIrFactory() {
        return this.components.getIrFactory();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.components.getIrProviders();
    }

    @Override
    @NotNull
    public Fir2IrLazyDeclarationsGenerator getLazyDeclarationsGenerator() {
        return this.components.getLazyDeclarationsGenerator();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.components.getLock();
    }

    @Override
    @NotNull
    public Fir2IrComponents.Manglers getManglers() {
        return this.components.getManglers();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.components.getScopeSession();
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.components.getSession();
    }

    @Override
    @NotNull
    public FirBasedSignatureComposer getSignatureComposer() {
        return this.components.getSignatureComposer();
    }

    @Override
    @NotNull
    public SymbolTable getSymbolTable() {
        return this.components.getSymbolTable();
    }

    @Override
    @NotNull
    public Fir2IrSymbolsMappingForLazyClasses getSymbolsMappingForLazyClasses() {
        return this.components.getSymbolsMappingForLazyClasses();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.components.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.components.getVisibilityConverter();
    }

    private final void runSourcesConversion(List<? extends FirFile> allFirFiles, IrModuleFragmentImpl irModuleFragment, Fir2IrVisitor fir2irVisitor) {
        for (FirFile firFile : allFirFiles) {
            this.registerFileAndClasses(firFile, irModuleFragment);
        }
        for (FirFile firFile : allFirFiles) {
            this.processClassHeaders(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.processFileAndClassMembers(firFile);
        }
        for (FirFile firFile : allFirFiles) {
            this.bindFakeOverridesInFile(firFile);
        }
        this.wereSourcesFakeOverridesBound = true;
        this.getFakeOverrideGenerator().bindOverriddenSymbols(this.postponedDeclarationsForFakeOverridesBinding);
        this.postponedDeclarationsForFakeOverridesBinding.clear();
        this.getClassifierStorage().processMembersOfClassesCreatedOnTheFly();
        this.getDelegatedMemberGenerator().generateBodies();
        for (FirFile firFile : allFirFiles) {
            boolean $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl = false;
                IrElement irElement = (IrElement)firFile.accept(fir2irVisitor, null);
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(firFile.getModuleData().getSession()).handleExceptionOnFileAnalysis(firFile, throwable$iv);
                throw null;
            }
        }
        if (!this.getConfiguration().getUseIrFakeOverrideBuilder() && FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.components.getSession()).supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            this.getDeclarationStorage().generateUnboundFakeOverrides$fir2ir();
        }
        if (this.getConfiguration().getAllowNonCachedDeclarations()) {
            this.getDeclarationStorage().fillUnboundSymbols$fir2ir();
        }
    }

    public final void bindFakeOverridesOrPostpone(@NotNull List<? extends IrDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        if (this.wereSourcesFakeOverridesBound) {
            this.getFakeOverrideGenerator().bindOverriddenSymbols(declarations2);
        } else {
            CollectionsKt.addAll((Collection)this.postponedDeclarationsForFakeOverridesBinding, (Iterable)declarations2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IrClass processLocalClassAndNestedClassesOnTheFly(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClass irClass = this.registerClassAndNestedClasses(klass, parent2);
        Fir2IrConversionScope this_$iv = this.conversionScope;
        boolean $i$f$withContainingFirClass = false;
        ((Collection)this_$iv.getContainingFirClassStack()).add(klass);
        try {
            boolean bl = false;
            this.processClassAndNestedClassHeaders(klass);
        }
        finally {
            this_$iv.getContainingFirClassStack().remove(this_$iv.getContainingFirClassStack().size() - 1);
        }
        return irClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final IrClass processLocalClassAndNestedClasses(@NotNull FirClass klass, @NotNull IrDeclarationParent parent2) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClass irClass = this.registerClassAndNestedClasses(klass, parent2);
        Fir2IrConversionScope this_$iv = this.conversionScope;
        boolean $i$f$withContainingFirClass = false;
        ((Collection)this_$iv.getContainingFirClassStack()).add(klass);
        try {
            boolean bl = false;
            this.processClassAndNestedClassHeaders(klass);
            this.processClassMembers$fir2ir(klass, irClass);
            this.bindFakeOverridesInClass(irClass);
        }
        finally {
            this_$iv.getContainingFirClassStack().remove(this_$iv.getContainingFirClassStack().size() - 1);
        }
        return irClass;
    }

    private final void registerFileAndClasses(FirFile file2, IrModuleFragment moduleFragment) {
        AbstractIrFileEntry abstractIrFileEntry;
        FirDeclarationOrigin firDeclarationOrigin = file2.getOrigin();
        if (Intrinsics.areEqual((Object)firDeclarationOrigin, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            PsiElement psiElement = UtilsKt.getPsi(file2);
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                abstractIrFileEntry = new PsiIrFileEntry((PsiFile)((KtFile)it));
            } else {
                KtSourceFileLinesMapping linesMapping = file2.getSourceFileLinesMapping();
                if (linesMapping instanceof KtSourceFileLinesMappingFromLineStartOffsets) {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, ((KtSourceFileLinesMappingFromLineStartOffsets)linesMapping).getLineStartOffsets(), linesMapping.getLastOffset());
                } else if (linesMapping instanceof KtPsiSourceFileLinesMapping) {
                    abstractIrFileEntry = new PsiIrFileEntry(((KtPsiSourceFileLinesMapping)linesMapping).getPsiFile());
                } else {
                    Object object = file2.getSourceFile();
                    if (object == null || (object = object.getPath()) == null) {
                        KtSourceFile ktSourceFile = file2.getSourceFile();
                        object = ktSourceFile != null ? ktSourceFile.getName() : file2.getName();
                    }
                    abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl((String)object, null, 0, 6, null);
                }
            }
        } else if (firDeclarationOrigin instanceof FirDeclarationOrigin.Synthetic) {
            abstractIrFileEntry = new NaiveSourceBasedFileEntryImpl(file2.getName(), null, 0, 6, null);
        } else {
            throw new IllegalStateException(("Unsupported file origin: " + file2.getOrigin()).toString());
        }
        AbstractIrFileEntry fileEntry = abstractIrFileEntry;
        IrFileImpl irFile = new IrFileImpl((IrFileEntry)fileEntry, (PackageFragmentDescriptor)CollectionsKt.first(this.moduleDescriptor.getPackage(UtilsKt.getPackageFqName(file2)).getFragments()), moduleFragment);
        this.getDeclarationStorage().registerFile(file2, irFile);
        for (FirDeclaration declaration : file2.getDeclarations()) {
            FirDeclaration firDeclaration = declaration;
            if (firDeclaration instanceof FirRegularClass) {
                this.registerClassAndNestedClasses((FirClass)declaration, irFile);
                continue;
            }
            if (!(firDeclaration instanceof FirCodeFragment)) continue;
            this.getClassifierStorage().createAndCacheCodeFragmentClass((FirCodeFragment)declaration, irFile);
        }
        ((Collection)moduleFragment.getFiles()).add(irFile);
    }

    private final void processClassHeaders(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        Iterable $this$forEach$iv = file2.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            FirDeclaration firDeclaration = it;
            if (firDeclaration instanceof FirRegularClass) {
                this.processClassAndNestedClassHeaders((FirClass)it);
                continue;
            }
            if (!(firDeclaration instanceof FirTypeAlias)) continue;
            this.getClassifierStorage().createAndCacheIrTypeAlias((FirTypeAlias)it, irFile);
        }
        irFile.getDeclarations().clear();
    }

    private final void processFileAndClassMembers(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (FirDeclaration declaration : file2.getDeclarations()) {
            this.processMemberDeclaration(declaration, null, irFile, null);
        }
    }

    public final void processAnonymousObjectHeaders(@NotNull FirAnonymousObject anonymousObject, @NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.registerNestedClasses(anonymousObject, irClass);
        this.processNestedClassHeaders(anonymousObject);
        irClass.getDeclarations().clear();
    }

    @NotNull
    public final IrClass processClassMembers$fir2ir(@NotNull FirClass klass, @NotNull IrClass irClass) {
        IrConstructor irConstructor2;
        List list2;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        List $this$processClassMembers_u24lambda_u245 = list2 = (List)new ArrayList();
        boolean bl = false;
        $this$processClassMembers_u24lambda_u245.addAll((Collection)klass.getDeclarations());
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$processClassMembers_u24lambda_u245.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedMembers((FirRegularClass)klass, this.getSession()));
            $this$processClassMembers_u24lambda_u245.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession()));
        }
        List allDeclarations2 = list2;
        irClass.getDeclarations().addAll((Collection<IrDeclaration>)this.getClassifierStorage().getFieldsWithContextReceiversForClass(irClass, klass));
        FirConstructorSymbol firConstructorSymbol2 = DeclarationUtilsKt.primaryConstructorIfAny(klass, this.getSession());
        if (firConstructorSymbol2 != null) {
            FirConstructorSymbol it = firConstructorSymbol2;
            boolean bl2 = false;
            FirClassLikeDeclaration $this$isLocal$iv = klass;
            boolean $i$f$isLocal = false;
            irConstructor2 = Fir2IrDeclarationStorage.createAndCacheIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)it.getFir(), (Function0)new Function0<IrClass>(irClass){
                final /* synthetic */ IrClass $irClass;
                {
                    this.$irClass = $irClass;
                    super(0);
                }

                public final IrClass invoke() {
                    return this.$irClass;
                }
            }, null, $this$isLocal$iv.getSymbol().getClassId().isLocal(), 4, null);
        } else {
            irConstructor2 = null;
        }
        IrConstructor irConstructor3 = irConstructor2;
        MultiMap delegateFieldToPropertyMap = new MultiMap();
        for (FirDeclaration declaration : this.syntheticPropertiesLast(allDeclarations2)) {
            this.processMemberDeclaration(declaration, klass, irClass, (MultiMap<FirProperty, FirField>)delegateFieldToPropertyMap);
        }
        CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)this.delegatedMembers(irClass));
        if (klass instanceof FirRegularClass && irConstructor3 != null && (irClass.isValue() || irClass.isData())) {
            this.getDeclarationStorage().enterScope(irConstructor3.getSymbol());
            DataClassMembersGenerator dataClassMembersGenerator = new DataClassMembersGenerator(this.components);
            if (IrDeclarationsKt.isSingleFieldValueClass(irClass)) {
                CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)dataClassMembersGenerator.generateSingleFieldValueClassMembers((FirRegularClass)klass, irClass));
            }
            if (IrDeclarationsKt.isMultiFieldValueClass(irClass)) {
                CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)dataClassMembersGenerator.generateMultiFieldValueClassMembers((FirRegularClass)klass, irClass));
            }
            if (irClass.isData()) {
                CollectionsKt.addAll((Collection)allDeclarations2, (Iterable)dataClassMembersGenerator.generateDataClassMembers((FirRegularClass)klass, irClass));
            }
            this.getDeclarationStorage().leaveScope(irConstructor3.getSymbol());
        }
        if (!this.getConfiguration().getUseIrFakeOverrideBuilder()) {
            this.getFakeOverrideGenerator().computeFakeOverrides(klass, irClass, allDeclarations2);
        }
        return irClass;
    }

    private final IrClass processCodeFragmentMembers(FirCodeFragment codeFragment, IrClass irClass) {
        CodeFragmentConversionData conversionData = CodeFragmentUtilsKt.getConversionData(codeFragment);
        this.getDeclarationStorage().enterScope(irClass.getSymbol());
        IdSignature idSignature = irClass.getSymbol().getSignature();
        Intrinsics.checkNotNull((Object)idSignature);
        IdSignature signature = idSignature;
        this.getSymbolTable().declareConstructor(signature, (Function0<? extends IrConstructorSymbol>)((Function0)new Function0<IrConstructorSymbol>(signature){
            final /* synthetic */ IdSignature $signature;
            {
                this.$signature = $signature;
                super(0);
            }

            public final IrConstructorSymbol invoke() {
                return new IrConstructorPublicSymbolImpl(this.$signature, null, 2, null);
            }
        }), (Function1<? super IrConstructorSymbol, ? extends IrConstructor>)((Function1)new Function1<IrConstructorSymbol, IrConstructor>(this, irClass){
            final /* synthetic */ Fir2IrConverter this$0;
            final /* synthetic */ IrClass $irClass;
            {
                this.this$0 = $receiver;
                this.$irClass = $irClass;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final IrConstructor invoke(IrConstructorSymbol irSymbol2) {
                void $this$invoke_u24lambda_u241_u24lambda_u240;
                IrBlockBody irBlockBody;
                Intrinsics.checkNotNullParameter((Object)irSymbol2, (String)"irSymbol");
                Object object = this.this$0.getIrFactory();
                Object object2 = IrDeclarationOrigin.Companion.getDEFINED();
                Object object3 = Name.special("<init>");
                DescriptorVisibility descriptorVisibility = this.$irClass.getVisibility();
                IrSimpleType irSimpleType = IrUtilsKt.getDefaultType(this.$irClass);
                IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)object2;
                Intrinsics.checkNotNull((Object)object3);
                object = IrFactory.DefaultImpls.createConstructor$default((IrFactory)object, -1, -1, irDeclarationOrigin, (Name)object3, descriptorVisibility, false, false, irSimpleType, irSymbol2, true, false, null, 2048, null);
                object2 = this.$irClass;
                object3 = this.this$0;
                Object $this$invoke_u24lambda_u241 = object;
                boolean bl = false;
                Fir2IrCallableDeclarationsGeneratorKt.setParent((IrDeclaration)$this$invoke_u24lambda_u241, (IrDeclarationParent)object2);
                Fir2IrCallableDeclarationsGeneratorKt.addDeclarationToParent((IrDeclaration)$this$invoke_u24lambda_u241, (IrDeclarationParent)object2);
                FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(((Fir2IrConverter)object3).getSession().getBuiltinTypes().getAnyType(), ((Fir2IrConverter)object3).getSession());
                Intrinsics.checkNotNull((Object)firRegularClassSymbol);
                FirConstructorSymbol firConstructorSymbol2 = DeclarationUtilsKt.primaryConstructorIfAny((FirClass)firRegularClassSymbol.getFir(), ((Fir2IrConverter)object3).getSession());
                Intrinsics.checkNotNull((Object)firConstructorSymbol2);
                FirConstructorSymbol firAnyConstructor = firConstructorSymbol2;
                IrConstructorSymbol irAnyConstructor = Fir2IrDeclarationStorage.getIrConstructorSymbol$default(((Fir2IrConverter)object3).getDeclarationStorage(), firAnyConstructor, false, 2, null);
                IrBlockBody irBlockBody2 = irBlockBody = ((Fir2IrConverter)object3).getIrFactory().createBlockBody(-1, -1);
                Object object4 = $this$invoke_u24lambda_u241;
                boolean bl2 = false;
                ((Collection)$this$invoke_u24lambda_u241_u24lambda_u240.getStatements()).add(new IrDelegatingConstructorCallImpl(-1, -1, ((Fir2IrConverter)object3).getIrBuiltIns().getUnitType(), irAnyConstructor, 0, 0));
                ((IrFunction)object4).setBody(irBlockBody);
                return object;
            }
        }));
        this.getSymbolTable().declareSimpleFunction(signature, (Function0<? extends IrSimpleFunctionSymbol>)((Function0)new Function0<IrSimpleFunctionSymbol>(signature){
            final /* synthetic */ IdSignature $signature;
            {
                this.$signature = $signature;
                super(0);
            }

            public final IrSimpleFunctionSymbol invoke() {
                return new IrSimpleFunctionPublicSymbolImpl(this.$signature, null, 2, null);
            }
        }), (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(codeFragment, this, conversionData, irClass){
            final /* synthetic */ FirCodeFragment $codeFragment;
            final /* synthetic */ Fir2IrConverter this$0;
            final /* synthetic */ CodeFragmentConversionData $conversionData;
            final /* synthetic */ IrClass $irClass;
            {
                this.$codeFragment = $codeFragment;
                this.this$0 = $receiver;
                this.$conversionData = $conversionData;
                this.$irClass = $irClass;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final IrSimpleFunction invoke(IrSimpleFunctionSymbol irSymbol2) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)irSymbol2, (String)"irSymbol");
                FirStatement lastStatement = (FirStatement)CollectionsKt.lastOrNull(this.$codeFragment.getBlock().getStatements());
                Object object = lastStatement instanceof FirExpression ? (FirExpression)lastStatement : null;
                if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null || (object = Fir2IrTypeConverterKt.toIrType$default((ConeKotlinType)object, this.this$0.getTypeConverter(), null, 2, null)) == null) {
                    object = this.this$0.getIrBuiltIns().getUnitType();
                }
                Object returnType2 = object;
                IrFactory irFactory = this.this$0.getIrFactory();
                IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getDEFINED();
                Name name2 = this.$conversionData.getMethodName();
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PUBLIC");
                IrSimpleFunction irSimpleFunction = irFactory.createSimpleFunction(-1, -1, irDeclarationOrigin, name2, descriptorVisibility, false, false, (IrType)returnType2, Modality.FINAL, irSymbol2, false, false, false, false, false, null, false);
                IrClass irClass = this.$irClass;
                CodeFragmentConversionData codeFragmentConversionData = this.$conversionData;
                Fir2IrConverter fir2IrConverter = this.this$0;
                IrSimpleFunction $this$invoke_u24lambda_u242 = irSimpleFunction;
                boolean bl = false;
                Fir2IrCallableDeclarationsGeneratorKt.setParent($this$invoke_u24lambda_u242, irClass);
                Fir2IrCallableDeclarationsGeneratorKt.addDeclarationToParent($this$invoke_u24lambda_u242, irClass);
                Iterable iterable = codeFragmentConversionData.getInjectedValues();
                IrSimpleFunction irSimpleFunction2 = $this$invoke_u24lambda_u242;
                boolean $i$f$mapIndexed = false;
                void var13_13 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    IrValueParameter irValueParameter;
                    void index2;
                    void injectedValue;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    InjectedValue injectedValue2 = (InjectedValue)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    boolean isMutated = injectedValue.isMutated();
                    IrFactory irFactory2 = fir2IrConverter.getIrFactory();
                    IrDeclarationOrigin irDeclarationOrigin2 = isMutated ? IrDeclarationOrigin.Companion.getSHARED_VARIABLE_IN_EVALUATOR_FRAGMENT() : IrDeclarationOrigin.Companion.getDEFINED();
                    Name name3 = Name.identifier("" + 'p' + (int)index2);
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
                    IrValueParameter $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240 = irValueParameter = irFactory2.createValueParameter(-1, -1, irDeclarationOrigin2, name3, Fir2IrTypeConverterKt.toIrType$default(injectedValue.getTypeRef(), fir2IrConverter.getTypeConverter(), null, 2, null), isMutated, injectedValue.getIrParameterSymbol(), (int)index2, null, false, false, false);
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u242_u24lambda_u241_u24lambda_u240.setParent($this$invoke_u24lambda_u242);
                    collection.add(irValueParameter);
                }
                irSimpleFunction2.setValueParameters((List)destination$iv$iv);
                return irSimpleFunction;
            }
        }));
        this.getDeclarationStorage().leaveScope(irClass.getSymbol());
        return irClass;
    }

    private final void bindFakeOverridesInFile(FirFile file2) {
        IrFile irFile = this.getDeclarationStorage().getIrFile(file2);
        for (IrDeclaration irDeclaration2 : irFile.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    public final void bindFakeOverridesInClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!(!(klass instanceof Fir2IrLazyClass))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.getFakeOverrideGenerator().bindOverriddenSymbols(klass.getDeclarations());
        this.getDelegatedMemberGenerator().bindDelegatedMembersOverriddenSymbols(klass);
        for (IrDeclaration irDeclaration2 : klass.getDeclarations()) {
            if (!(irDeclaration2 instanceof IrClass)) continue;
            this.bindFakeOverridesInClass((IrClass)irDeclaration2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirDeclaration> delegatedMembers(IrClass irClass) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = irClass.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDELEGATED_MEMBER())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.components.getDeclarationStorage().originalDeclarationForDelegated(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<FirDeclaration> syntheticPropertiesLast(Iterable<? extends FirDeclaration> declarations2) {
        Iterable<? extends FirDeclaration> $this$sortedBy$iv = declarations2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl;
                boolean bl2;
                FirDeclaration it = (FirDeclaration)a;
                boolean bl3 = false;
                FirDeclaration $this$isSynthetic$iv = it;
                boolean $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl2 = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl2 = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                it = (FirDeclaration)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl3 = false;
                $this$isSynthetic$iv = it;
                $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                    bl = false;
                } else {
                    KtSourceElement ktSourceElement = it.getSource();
                    bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ClassDelegationField);
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(bl));
            }
        });
    }

    private final IrClass registerClassAndNestedClasses(FirClass klass, IrDeclarationParent parent2) {
        Object object;
        Object object2;
        IrClass irClass = this.getClassifierStorage().getCachedIrClass(klass);
        if (irClass != null) {
            object2 = irClass;
            IrClass $this$registerClassAndNestedClasses_u24lambda_u2410 = object2;
            boolean bl = false;
            $this$registerClassAndNestedClasses_u24lambda_u2410.setParent(parent2);
            object = object2;
        } else {
            object2 = klass;
            if (object2 instanceof FirRegularClass) {
                object = Fir2IrClassifierStorage.createAndCacheIrClass$default(this.getClassifierStorage(), (FirRegularClass)klass, parent2, null, 4, null);
            } else if (object2 instanceof FirAnonymousObject) {
                object = Fir2IrClassifierStorage.createAndCacheAnonymousObject$default(this.getClassifierStorage(), (FirAnonymousObject)klass, null, null, parent2, 6, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object irClass2 = object;
        this.registerNestedClasses(klass, (IrClass)irClass2);
        return irClass2;
    }

    private final void registerNestedClasses(FirClass klass, IrClass irClass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.registerClassAndNestedClasses((FirClass)it, irClass);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.registerClassAndNestedClasses((FirClass)it, irClass);
            }
        }
    }

    private final void processClassAndNestedClassHeaders(FirClass klass) {
        Fir2IrClassifiersGenerator.processClassHeader$default(this.getClassifiersGenerator(), klass, null, 2, null);
        this.processNestedClassHeaders(klass);
        IrClass irClass = this.getClassifierStorage().getCachedIrClass(klass);
        Intrinsics.checkNotNull((Object)irClass);
        IrClass irClass2 = irClass;
        irClass2.getDeclarations().clear();
    }

    private final void processNestedClassHeaders(FirClass klass) {
        FirDeclaration it;
        Iterable $this$forEach$iv = klass.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirRegularClass)) continue;
            this.processClassAndNestedClassHeaders((FirClass)it);
        }
        if (klass instanceof FirRegularClass && !((Collection)this.generatorExtensions).isEmpty()) {
            $this$forEach$iv = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)klass, this.getSession());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirClassLikeDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirRegularClass)) continue;
                this.processClassAndNestedClassHeaders((FirClass)it);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void processMemberDeclaration(FirDeclaration declaration, FirClass containingClass, IrDeclarationParent parent, MultiMap<FirProperty, FirField> delegateFieldToPropertyMap) {
        if (containingClass == null) ** GOTO lbl-1000
        if (!(containingClass instanceof FirRegularClass)) ** GOTO lbl-1000
        $this$isLocal$iv = containingClass;
        $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isInLocalClass = v0;
        var6_5 = declaration;
        if (var6_5 instanceof FirRegularClass) {
            v1 = this.getClassifierStorage().getCachedIrClass((FirClass)declaration);
            Intrinsics.checkNotNull((Object)v1);
            irClass = v1;
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irClass);
            this.processClassMembers$fir2ir((FirClass)declaration, irClass);
        } else if (var6_5 instanceof FirScript) {
            if (!(parent instanceof IrFile)) {
                var8_13 = "Failed requirement.";
                throw new IllegalArgumentException(var8_13.toString());
            }
            irScript = this.getDeclarationStorage().createIrScript((FirScript)declaration);
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irScript);
            var8_14 = this.getDeclarationStorage();
            symbol$iv = irScript.getSymbol();
            $i$f$withScope = false;
            this_$iv.enterScope(symbol$iv);
            $i$a$-withScope-Fir2IrConverter$processMemberDeclaration$1 = false;
            irScript.setParent(parent);
            for (FirDeclaration scriptDeclaration : ((FirScript)declaration).getDeclarations()) {
                var14_29 = scriptDeclaration;
                if (var14_29 instanceof FirRegularClass) {
                    Fir2IrConverter.access$registerClassAndNestedClasses(this, (FirClass)scriptDeclaration, irScript);
                    Fir2IrConverter.access$processClassAndNestedClassHeaders(this, (FirClass)scriptDeclaration);
                    continue;
                }
                if (!(var14_29 instanceof FirTypeAlias)) continue;
                this.getClassifierStorage().createAndCacheIrTypeAlias((FirTypeAlias)scriptDeclaration, irScript);
            }
            for (FirDeclaration scriptDeclaration : ((FirScript)declaration).getDeclarations()) {
                if (scriptDeclaration instanceof FirAnonymousInitializer) continue;
                Fir2IrConverter.access$processMemberDeclaration(this, scriptDeclaration, null, irScript, null);
            }
            this_$iv.leaveScope(symbol$iv);
        } else if (var6_5 instanceof FirSimpleFunction) {
            Fir2IrDeclarationStorage.createAndCacheIrFunction$default(this.getDeclarationStorage(), (FirFunction)declaration, parent, null, isInLocalClass, null, false, 52, null);
        } else if (var6_5 instanceof FirProperty) {
            if (containingClass == null || !UtilsKt.isEnumEntries((FirVariable)declaration, containingClass) || FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()).supportsFeature(LanguageFeature.EnumEntries)) {
                irProperty = Fir2IrDeclarationStorage.createAndCacheIrProperty$default(this.getDeclarationStorage(), (FirProperty)declaration, parent, null, null, false, 28, null);
                v2 = delegateFieldToPropertyMap;
                if (v2 != null && (v2 = v2.remove((Object)declaration)) != null) {
                    delegateFields = v2;
                    $i$a$-let-Fir2IrConverter$processMemberDeclaration$2 = false;
                    v3 = irProperty.getBackingField();
                    Intrinsics.checkNotNull((Object)v3);
                    backingField = v3;
                    var13_28 = delegateFields.iterator();
                    while (var13_28.hasNext()) {
                        delegateField = (FirField)var13_28.next();
                        v4 = this.getDeclarationStorage();
                        Intrinsics.checkNotNull((Object)delegateField);
                        v4.recordDelegateFieldMappedToBackingField(delegateField, backingField.getSymbol());
                        v5 = this.getDelegatedMemberGenerator();
                        v6 = containingClass;
                        Intrinsics.checkNotNull((Object)v6);
                        Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                        v5.generateWithBodiesIfNeeded(delegateField, backingField, v6, (IrClass)parent);
                    }
                }
            }
        } else if (var6_5 instanceof FirField) {
            $this$isSynthetic$iv = declaration;
            $i$f$isSynthetic = false;
            if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) {
                throw new IllegalStateException(("Unexpected non-synthetic field: " + Reflection.getOrCreateKotlinClass(declaration.getClass())).toString());
            }
            if (containingClass == null) {
                $this$isSynthetic$iv = "Required value was null.";
                throw new IllegalArgumentException($this$isSynthetic$iv.toString());
            }
            if (delegateFieldToPropertyMap == null) {
                $this$isSynthetic$iv = "Required value was null.";
                throw new IllegalArgumentException($this$isSynthetic$iv.toString());
            }
            if (!(parent instanceof IrClass)) {
                $i$f$isSynthetic = "Failed requirement.";
                throw new IllegalArgumentException($i$f$isSynthetic.toString());
            }
            correspondingClassProperty = this.findCorrespondingDelegateProperty((FirField)declaration, containingClass);
            if (correspondingClassProperty == null) {
                irField = this.getDeclarationStorage().createDelegateIrField$fir2ir((FirField)declaration, (IrClass)parent);
                this.getDelegatedMemberGenerator().generateWithBodiesIfNeeded((FirField)declaration, irField, containingClass, (IrClass)parent);
            } else {
                delegateFieldToPropertyMap.putValue((Object)correspondingClassProperty, (Object)declaration);
            }
        } else if (var6_5 instanceof FirConstructor) {
            if (!((FirConstructor)declaration).isPrimary()) {
                Fir2IrDeclarationStorage.createAndCacheIrConstructor$default(this.getDeclarationStorage(), (FirConstructor)declaration, (Function0)new Function0<IrClass>(parent){
                    final /* synthetic */ IrDeclarationParent $parent;
                    {
                        this.$parent = $parent;
                        super(0);
                    }

                    public final IrClass invoke() {
                        IrDeclarationParent irDeclarationParent = this.$parent;
                        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                        return (IrClass)irDeclarationParent;
                    }
                }, null, isInLocalClass, 4, null);
            }
        } else if (var6_5 instanceof FirEnumEntry) {
            v7 = this.getClassifierStorage();
            v8 = (FirEnumEntry)declaration;
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            Fir2IrClassifierStorage.getOrCreateIrEnumEntry$default(v7, v8, (IrClass)parent, null, 4, null);
        } else if (var6_5 instanceof FirAnonymousInitializer) {
            v9 = this.getDeclarationStorage();
            v10 = (FirAnonymousInitializer)declaration;
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            v9.createIrAnonymousInitializer(v10, (IrClass)parent);
        } else if (var6_5 instanceof FirTypeAlias) {
            v11 = this.getClassifierStorage().getCachedTypeAlias$fir2ir((FirTypeAlias)declaration);
            if (v11 != null) {
                irTypeAlias = v11;
                $i$a$-let-Fir2IrConverter$processMemberDeclaration$4 = false;
                Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, irTypeAlias);
            }
        } else if (var6_5 instanceof FirCodeFragment) {
            v12 = this.getClassifierStorage().getCachedIrCodeFragment((FirCodeFragment)declaration);
            Intrinsics.checkNotNull((Object)v12);
            codeFragmentClass = v12;
            this.processCodeFragmentMembers((FirCodeFragment)declaration, codeFragmentClass);
            Fir2IrConverter.processMemberDeclaration$addDeclarationToParentIfNeeded(parent, codeFragmentClass);
        } else {
            throw new IllegalStateException(("Unexpected member: " + Reflection.getOrCreateKotlinClass(declaration.getClass())).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirProperty findCorrespondingDelegateProperty(FirField $this$findCorrespondingDelegateProperty, FirClass owner) {
        Object v1;
        block5: {
            void $this$filterIsInstanceTo$iv$iv;
            FirExpression initializer2 = $this$findCorrespondingDelegateProperty.getInitializer();
            if (!(initializer2 instanceof FirQualifiedAccessExpression)) {
                return null;
            }
            if (((FirQualifiedAccessExpression)initializer2).getExplicitReceiver() != null) {
                return null;
            }
            FirValueParameterSymbol firValueParameterSymbol = FirReferenceUtilsKt.toResolvedValueParameterSymbol$default(((FirQualifiedAccessExpression)initializer2).getCalleeReference(), false, 1, null);
            if (firValueParameterSymbol == null) {
                return null;
            }
            FirValueParameterSymbol resolvedSymbol = firValueParameterSymbol;
            Iterable $this$filterIsInstance$iv = owner.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                FirProperty it = (FirProperty)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)DeclarationAttributesKt.getCorrespondingValueParameterFromPrimaryConstructor(it), (Object)resolvedSymbol)) continue;
                v1 = e;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    private static final void processMemberDeclaration$addDeclarationToParentIfNeeded(IrDeclarationParent $parent, IrDeclaration irDeclaration2) {
        IrDeclarationParent irDeclarationParent = $parent;
        if (irDeclarationParent instanceof IrFile) {
            ((Collection)((IrFile)$parent).getDeclarations()).add(irDeclaration2);
        } else if (irDeclarationParent instanceof IrClass) {
            ((Collection)((IrClass)$parent).getDeclarations()).add(irDeclaration2);
        }
    }

    public static final /* synthetic */ IrClass access$registerClassAndNestedClasses(Fir2IrConverter $this, FirClass klass, IrDeclarationParent parent2) {
        return $this.registerClassAndNestedClasses(klass, parent2);
    }

    public static final /* synthetic */ void access$processClassAndNestedClassHeaders(Fir2IrConverter $this, FirClass klass) {
        $this.processClassAndNestedClassHeaders(klass);
    }

    public static final /* synthetic */ void access$processMemberDeclaration(Fir2IrConverter $this, FirDeclaration declaration, FirClass containingClass, IrDeclarationParent parent2, MultiMap delegateFieldToPropertyMap) {
        $this.processMemberDeclaration(declaration, containingClass, parent2, (MultiMap<FirProperty, FirField>)delegateFieldToPropertyMap);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0082\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fJ\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\"\u0010(\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0\n0)2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010+\u001a\u0004\u0018\u00010**\u00020,2\u0006\u0010&\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion;", "", "()V", "createIrModuleFragment", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrResult;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "firFiles", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fir2IrExtensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "fir2IrConfiguration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "specialSymbolProvider", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSpecialSymbolProvider;", "kotlinBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "commonMemberStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;", "initializedIrBuiltIns", "Lorg/jetbrains/kotlin/fir/backend/IrBuiltInsOverFir;", "typeContextProvider", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "evaluateConstants", "", "irModuleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "friendModulesMap", "", "", "evaluate", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "fir2ir"})
    @SourceDebugExtension(value={"SMAP\nFir2IrConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,753:1\n1853#2,2:754\n1547#2:757\n1618#2,3:758\n1177#2,2:761\n1251#2,4:763\n1853#2,2:767\n1#3:756\n*S KotlinDebug\n*F\n+ 1 Fir2IrConverter.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConverter$Companion\n*L\n640#1:754,2\n697#1:757\n697#1:758,3\n698#1:761,2\n698#1:763,4\n738#1:767,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void evaluateConstants(@NotNull IrModuleFragment irModuleFragment, @NotNull Fir2IrComponents components2) {
            FirModuleDescriptor firModuleDescriptor;
            Intrinsics.checkNotNullParameter((Object)irModuleFragment, (String)"irModuleFragment");
            Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
            Fir2IrConfiguration fir2IrConfiguration = components2.getConfiguration();
            ModuleDescriptor moduleDescriptor = irModuleFragment.getDescriptor();
            FirModuleDescriptor firModuleDescriptor2 = firModuleDescriptor = moduleDescriptor instanceof FirModuleDescriptor ? (FirModuleDescriptor)moduleDescriptor : null;
            TargetPlatform targetPlatform = firModuleDescriptor2 != null ? firModuleDescriptor2.getPlatform() : null;
            Object object = firModuleDescriptor;
            if (object == null || (object = ((FirModuleDescriptor)object).getSession()) == null || (object = FirLanguageSettingsComponentKt.getLanguageVersionSettings((FirSession)object)) == null) {
                return;
            }
            Object languageVersionSettings2 = object;
            boolean intrinsicConstEvaluation = languageVersionSettings2.supportsFeature(LanguageFeature.IntrinsicConstEvaluation);
            IrInterpreterConfiguration configuration2 = new IrInterpreterConfiguration(targetPlatform, 0, 0, false, true, false, 46, null);
            IrInterpreter interpreter2 = new IrInterpreter(new IrInterpreterEnvironment(irModuleFragment.getIrBuiltins(), configuration2), null, 2, null);
            EvaluationMode mode = intrinsicConstEvaluation ? EvaluationMode.ONLY_INTRINSIC_CONST : EvaluationMode.ONLY_BUILTINS;
            FirJavaElementFinder firJavaElementFinder = FirJavaElementFinderKt.getJavaElementFinder(components2.getSession());
            if (firJavaElementFinder != null) {
                firJavaElementFinder.setPropertyEvaluator((Function1<? super FirProperty, String>)((Function1)new Function1<FirProperty, String>(components2, interpreter2, mode){
                    final /* synthetic */ Fir2IrComponents $components;
                    final /* synthetic */ IrInterpreter $interpreter;
                    final /* synthetic */ EvaluationMode $mode;
                    {
                        this.$components = $components;
                        this.$interpreter = $interpreter;
                        this.$mode = $mode;
                        super(1);
                    }

                    public final String invoke(FirProperty it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.access$evaluate(Fir2IrConverter.Companion, it, this.$components, this.$interpreter, this.$mode);
                    }
                }));
            }
            KtDiagnosticReporterWithImplicitIrBasedContext ktDiagnosticReporter = new KtDiagnosticReporterWithImplicitIrBasedContext(fir2IrConfiguration.getDiagnosticReporter(), (LanguageVersionSettings)languageVersionSettings2);
            Iterable $this$forEach$iv = irModuleFragment.getFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrFile it = (IrFile)element$iv;
                boolean bl = false;
                IrConstTransformerKt.transformConst$default((IrElement)it, (IrFile)it, (IrInterpreter)interpreter2, (EvaluationMode)mode, (EvaluatedConstTracker)fir2IrConfiguration.getEvaluatedConstTracker(), (InlineConstTracker)fir2IrConfiguration.getInlineConstTracker(), null, (Function3)((Function3)new Function3<IrFile, IrElement, IrErrorExpression, Unit>(ktDiagnosticReporter){
                    final /* synthetic */ KtDiagnosticReporterWithImplicitIrBasedContext $ktDiagnosticReporter;
                    {
                        this.$ktDiagnosticReporter = $ktDiagnosticReporter;
                        super(3);
                    }

                    public final void invoke(IrFile irFile, IrElement element, IrErrorExpression error) {
                        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        this.$ktDiagnosticReporter.at(IrUtilsKt.sourceElement(element), element, irFile).report(CommonBackendErrors.INSTANCE.getEVALUATION_ERROR(), error.getDescription());
                    }
                }), (boolean)false, (int)160, null);
            }
        }

        private final String evaluate(FirProperty $this$evaluate, Fir2IrComponents components2, IrInterpreter interpreter2, EvaluationMode mode) {
            IrProperty irProperty;
            Object object = Fir2IrDeclarationStorage.getCachedIrPropertySymbol$default(components2.getDeclarationStorage(), $this$evaluate, null, null, 4, null);
            if (object == null || (irProperty = (IrProperty)object.getOwner()) == null) {
                return null;
            }
            IrProperty irProperty2 = irProperty;
            object = org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$tryToGetConst(irProperty2);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                return org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$asString(it);
            }
            IrFile irFile = IrUtilsKt.getFileOrNull(irProperty2);
            if (irFile == null) {
                return null;
            }
            IrFile irFile2 = irFile;
            IrElement evaluated = IrConstTransformerKt.transformConst$default((IrElement)irProperty2, (IrFile)irFile2, (IrInterpreter)interpreter2, (EvaluationMode)mode, (EvaluatedConstTracker)components2.getConfiguration().getEvaluatedConstTracker(), (InlineConstTracker)components2.getConfiguration().getInlineConstTracker(), null, null, (boolean)false, (int)224, null);
            IrElementBase irElementBase = evaluated instanceof IrProperty ? (IrProperty)evaluated : null;
            return irElementBase != null && (irElementBase = org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$tryToGetConst(irElementBase)) != null ? org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.evaluate$asString(irElementBase) : null;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, List<String>> friendModulesMap(FirSession session2) {
            void $this$associateTo$iv$iv;
            void $this$mapTo$iv$iv;
            Set set;
            FirModuleData moduleData = FirModuleDataKt.getModuleData(session2);
            Set $this$friendModulesMap_u24lambda_u242 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$collectDependsOnRecursive(moduleData, $this$friendModulesMap_u24lambda_u242);
            Set dependsOnTransitive = SetsKt.build((Set)set);
            Iterable $this$map$iv = CollectionsKt.plus((Collection)moduleData.getFriendDependencies(), (Iterable)dependsOnTransitive);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirModuleData firModuleData = (FirModuleData)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$friendsMapName((FirModuleData)it));
            }
            List friendNames = (List)destination$iv$iv;
            Iterable $this$associate$iv = dependsOnTransitive;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                FirModuleData it = (FirModuleData)element$iv$iv;
                boolean bl3 = false;
                Pair pair = TuplesKt.to((Object)org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$friendsMapName(it), (Object)friendNames);
                map.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv2;
        }

        @NotNull
        public final Fir2IrResult createIrModuleFragment(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirFile> firFiles2, @NotNull Fir2IrExtensions fir2IrExtensions, @NotNull Fir2IrConfiguration fir2IrConfiguration, @NotNull KotlinMangler.IrMangler irMangler, @NotNull IrFactory irFactory, @NotNull Fir2IrVisibilityConverter visibilityConverter, @NotNull Fir2IrSpecialSymbolProvider specialSymbolProvider, @NotNull KotlinBuiltIns kotlinBuiltIns, @NotNull Fir2IrCommonMemberStorage commonMemberStorage, @Nullable IrBuiltInsOverFir initializedIrBuiltIns, @NotNull Function1<? super IrBuiltIns, ? extends IrTypeSystemContext> typeContextProvider) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
            Intrinsics.checkNotNullParameter(firFiles2, (String)"firFiles");
            Intrinsics.checkNotNullParameter((Object)fir2IrExtensions, (String)"fir2IrExtensions");
            Intrinsics.checkNotNullParameter((Object)fir2IrConfiguration, (String)"fir2IrConfiguration");
            Intrinsics.checkNotNullParameter((Object)irMangler, (String)"irMangler");
            Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
            Intrinsics.checkNotNullParameter((Object)visibilityConverter, (String)"visibilityConverter");
            Intrinsics.checkNotNullParameter((Object)specialSymbolProvider, (String)"specialSymbolProvider");
            Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"kotlinBuiltIns");
            Intrinsics.checkNotNullParameter((Object)commonMemberStorage, (String)"commonMemberStorage");
            Intrinsics.checkNotNullParameter(typeContextProvider, (String)"typeContextProvider");
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver(session2).disableLazyResolveContractChecks();
            FirModuleDescriptor moduleDescriptor = FirModuleDescriptor.Companion.createSourceModuleDescriptor(session2, kotlinBuiltIns);
            Fir2IrComponentsStorage components2 = new Fir2IrComponentsStorage(session2, scopeSession, irFactory, fir2IrExtensions, fir2IrConfiguration, visibilityConverter, (Function1<? super IrBuiltIns, IrFakeOverrideBuilder>)((Function1)new Function1<IrBuiltIns, IrFakeOverrideBuilder>(typeContextProvider, session2, commonMemberStorage, irMangler, fir2IrExtensions){
                final /* synthetic */ Function1<IrBuiltIns, IrTypeSystemContext> $typeContextProvider;
                final /* synthetic */ FirSession $session;
                final /* synthetic */ Fir2IrCommonMemberStorage $commonMemberStorage;
                final /* synthetic */ KotlinMangler.IrMangler $irMangler;
                final /* synthetic */ Fir2IrExtensions $fir2IrExtensions;
                {
                    this.$typeContextProvider = $typeContextProvider;
                    this.$session = $session;
                    this.$commonMemberStorage = $commonMemberStorage;
                    this.$irMangler = $irMangler;
                    this.$fir2IrExtensions = $fir2IrExtensions;
                    super(1);
                }

                public final IrFakeOverrideBuilder invoke(IrBuiltIns irBuiltins) {
                    Intrinsics.checkNotNullParameter((Object)irBuiltins, (String)"irBuiltins");
                    return new IrFakeOverrideBuilder((IrTypeSystemContext)this.$typeContextProvider.invoke((Object)irBuiltins), new Fir2IrFakeOverrideStrategy(org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.access$friendModulesMap(Fir2IrConverter.Companion, this.$session), this.$commonMemberStorage.getSymbolTable(), this.$irMangler), this.$fir2IrExtensions.getExternalOverridabilityConditions());
                }
            }), moduleDescriptor, commonMemberStorage, irMangler, specialSymbolProvider, initializedIrBuiltIns);
            fir2IrExtensions.registerDeclarations(commonMemberStorage.getSymbolTable());
            IrModuleFragmentImpl irModuleFragment = new IrModuleFragmentImpl(moduleDescriptor, components2.getIrBuiltIns(), null, 4, null);
            List $this$createIrModuleFragment_u24lambda_u246 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$createIrModuleFragment_u24lambda_u246.addAll((Collection)firFiles2);
            List<FirFile> generatedFiles = ConversionUtilsKt.createFilesWithGeneratedDeclarations(session2);
            $this$createIrModuleFragment_u24lambda_u246.addAll((Collection)generatedFiles);
            Iterable $this$forEach$iv = generatedFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirFile it = (FirFile)element$iv;
                boolean bl2 = false;
                components2.getFirProvider().recordFile(it);
            }
            List allFirFiles = CollectionsKt.build((List)list2);
            components2.getConverter().runSourcesConversion(allFirFiles, irModuleFragment, components2.getFir2IrVisitor());
            commonMemberStorage.registerFirProvider(FirModuleDataKt.getModuleData(session2), components2.getFirProvider());
            return new Fir2IrResult(irModuleFragment, components2, moduleDescriptor);
        }

        private static final IrConst<?> evaluate$tryToGetConst(IrProperty $this$evaluate_u24tryToGetConst) {
            IrElementBase irElementBase = $this$evaluate_u24tryToGetConst.getBackingField();
            IrExpression irExpression = irElementBase != null && (irElementBase = ((IrField)irElementBase).getInitializer()) != null ? ((IrExpressionBody)irElementBase).getExpression() : null;
            return irExpression instanceof IrConst ? (IrConst)irExpression : null;
        }

        private static final String evaluate$asString(IrConst<?> $this$evaluate_u24asString) {
            Object constVal = $this$evaluate_u24asString.getValue();
            return constVal instanceof Character ? String.valueOf((int)((Character)constVal).charValue()) : (constVal instanceof String ? "" + '\"' + constVal + '\"' : String.valueOf(constVal));
        }

        private static final String friendModulesMap$friendsMapName(FirModuleData $this$friendModulesMap_u24friendsMapName) {
            String string2 = $this$friendModulesMap_u24friendsMapName.getName().asStringStripSpecialMarkers();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringStripSpecialMarkers(...)");
            return string2;
        }

        private static final void friendModulesMap$collectDependsOnRecursive(FirModuleData $this$friendModulesMap_u24collectDependsOnRecursive, Set<FirModuleData> set) {
            if (!set.add($this$friendModulesMap_u24collectDependsOnRecursive)) {
                return;
            }
            for (FirModuleData dep : $this$friendModulesMap_u24collectDependsOnRecursive.getDependsOnDependencies()) {
                org.jetbrains.kotlin.fir.backend.Fir2IrConverter$Companion.friendModulesMap$collectDependsOnRecursive(dep, set);
            }
        }

        public static final /* synthetic */ String access$evaluate(Companion $this, FirProperty $receiver, Fir2IrComponents components2, IrInterpreter interpreter2, EvaluationMode mode) {
            return $this.evaluate($receiver, components2, interpreter2, mode);
        }

        public static final /* synthetic */ Map access$friendModulesMap(Companion $this, FirSession session2) {
            return $this.friendModulesMap(session2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

